/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.explain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.neuralsearch.processor.explain.DocIdAtSearchShard;
import org.opensearch.neuralsearch.processor.explain.ExplainableTechnique;
import org.opensearch.neuralsearch.processor.explain.ExplanationDetails;

public class ExplanationUtils {
    public static Map<DocIdAtSearchShard, ExplanationDetails> getDocIdAtQueryForNormalization(Map<DocIdAtSearchShard, List<Float>> normalizedScores, ExplainableTechnique technique) {
        HashMap<DocIdAtSearchShard, ExplanationDetails> explain = new HashMap<DocIdAtSearchShard, ExplanationDetails>();
        for (Map.Entry<DocIdAtSearchShard, List<Float>> entry : normalizedScores.entrySet()) {
            List<Float> normScores = normalizedScores.get(entry.getKey());
            ArrayList<Pair<Float, String>> explanations = new ArrayList<Pair<Float, String>>();
            for (float score : normScores) {
                String description = String.format(Locale.ROOT, "%s normalization of:", technique.describe());
                explanations.add((Pair<Float, String>)Pair.of((Object)Float.valueOf(score), (Object)description));
            }
            explain.put(entry.getKey(), new ExplanationDetails(explanations));
        }
        return explain;
    }

    public static String describeCombinationTechnique(String techniqueName, List<Float> weights) {
        if (Objects.isNull(techniqueName)) {
            throw new IllegalArgumentException("combination technique name cannot be null");
        }
        return Optional.ofNullable(weights).filter(w -> !w.isEmpty()).map(w -> String.format(Locale.ROOT, "%s, weights %s", techniqueName, weights)).orElse(String.format(Locale.ROOT, "%s", techniqueName));
    }
}

