/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBConfigurationController;
import org.jkiss.dbeaver.utils.ContentUtils;

public class LocalConfigurationController
implements DBConfigurationController {
    protected final Path configFolder;
    private Path legacyConfigFolder;

    public LocalConfigurationController(Path configFolder) {
        this.configFolder = configFolder;
    }

    public void setLegacyConfigFolder(Path legacyConfigFolder) {
        this.legacyConfigFolder = legacyConfigFolder;
    }

    public String loadConfigurationFile(@NotNull String filePath) throws DBException {
        Path localPath = this.configFolder.resolve(filePath);
        if (!localPath.normalize().startsWith(this.configFolder)) {
            throw new DBException("Invalid configuration path");
        }
        if (!Files.exists(localPath, new LinkOption[0])) {
            if (this.legacyConfigFolder != null) {
                localPath = this.legacyConfigFolder.resolve(filePath);
            }
            if (!Files.exists(localPath, new LinkOption[0])) {
                return null;
            }
        }
        try {
            return Files.readString(localPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new DBException("Error reading configuration file '" + filePath + "'", (Throwable)e);
        }
    }

    public void saveConfigurationFile(@NotNull String filePath, @NotNull String data) throws DBException {
        Path localPath = this.configFolder.resolve(filePath);
        if (!localPath.normalize().startsWith(this.configFolder)) {
            throw new DBException("Invalid configuration path '" + String.valueOf(localPath) + "'");
        }
        try {
            Path localFolder = localPath.getParent();
            if (!Files.exists(localFolder, new LinkOption[0])) {
                Files.createDirectories(localFolder, new FileAttribute[0]);
            }
            if (Files.exists(localPath, new LinkOption[0])) {
                ContentUtils.makeFileBackup((Path)localPath);
            }
            Files.writeString(localPath, (CharSequence)data, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new DBException("Error writing configuration file '" + filePath + "'", (Throwable)e);
        }
    }
}

