"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const publicgalleryapi_1 = require("@vscode/vsce/out/publicgalleryapi");
const GalleryInterfaces_1 = require("azure-devops-node-api/interfaces/GalleryInterfaces");
const __1 = require("../");
const constants_1 = require("./constants");
const download_1 = require("./download");
const endpoints_1 = require("./endpoints");
const openGalleryApi = new publicgalleryapi_1.PublicGalleryAPI(`${(0, endpoints_1.getMarketplaceEndpoint)()}/vscode`, "3.0-preview.1");
openGalleryApi.client["_allowRetries"] = true;
openGalleryApi.client["_maxRetries"] = 5;
openGalleryApi.post = (url, data, additionalHeaders) => openGalleryApi.client.post(`${openGalleryApi.baseUrl}${url}`, data, additionalHeaders);
const flags = [GalleryInterfaces_1.ExtensionQueryFlags.IncludeFiles, GalleryInterfaces_1.ExtensionQueryFlags.IncludeLatestVersionOnly];
const extension = {
    id: "ms-python.python",
};
jest.setTimeout(20000);
describe("Open VSX e2e", () => {
    it("downloads an extension archive, its signature and public key from Open VSX and verifies the archive", async () => {
        const [ovsxExtension] = await Promise.allSettled([openGalleryApi.getExtension(extension.id, flags)]);
        if (ovsxExtension.status === "fulfilled") {
            const vsixUrl = ovsxExtension.value.versions[0].files.find((file) => file.assetType === "Microsoft.VisualStudio.Services.VSIXPackage");
            const vsixSignature = ovsxExtension.value.versions[0].files.find((file) => file.assetType === "Microsoft.VisualStudio.Services.VsixSignature");
            expect(vsixUrl).toBeDefined();
            expect(vsixSignature).toBeDefined();
            const packageLocation = await (0, download_1.download)(vsixUrl.source, { filename: constants_1.EXTENSION_PACKAGE_NAME });
            const signatureLocation = await (0, download_1.download)(vsixSignature.source, { filename: constants_1.SIGNED_ARCHIVE_NAME });
            console.time("verify");
            const verificationResult = await (0, __1.verify)(packageLocation, signatureLocation, true, {
                verifySignatureManifest: false, // todo(ft): change after next open-vsx.org release
            });
            console.timeEnd("verify");
            expect(verificationResult).toBe(true);
        }
        expect(ovsxExtension.status).toBe("fulfilled");
    });
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/072586267e68ece9a47aa43f8c108e0dcbf44622/node_modules/node-ovsx-sign/lib/utils/ovsx-e2e.test.js.map