"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseShellCheckDirective = parseShellCheckDirective;
const DIRECTIVE_TYPES = ['enable', 'disable', 'source', 'source-path', 'shell'];
const DIRECTIVE_REG_EXP = /^(#\s*shellcheck\s+)([^#]*)/;
function parseShellCheckDirective(line) {
    const match = line.match(DIRECTIVE_REG_EXP);
    if (!match) {
        return [];
    }
    const commands = match[2]
        .split(' ')
        .map((command) => command.trim())
        .filter((command) => command !== '');
    const directives = [];
    for (const command of commands) {
        const [typeKey, directiveValue] = command.split('=');
        const type = DIRECTIVE_TYPES.includes(typeKey)
            ? typeKey
            : null;
        if (!type || !directiveValue) {
            continue;
        }
        if (type === 'source-path' || type === 'source') {
            directives.push({
                type,
                path: directiveValue,
            });
        }
        else if (type === 'shell') {
            directives.push({
                type,
                shell: directiveValue,
            });
            continue;
        }
        else if (type === 'enable' || type === 'disable') {
            const rules = [];
            for (const arg of directiveValue.split(',')) {
                const ruleRangeMatch = arg.match(/^SC(\d*)-SC(\d*)$/);
                if (ruleRangeMatch) {
                    for (let i = parseInt(ruleRangeMatch[1], 10); i <= parseInt(ruleRangeMatch[2], 10); i++) {
                        rules.push(`SC${i}`);
                    }
                }
                else {
                    arg
                        .split(',')
                        .map((arg) => arg.trim())
                        .filter((arg) => arg !== '')
                        .forEach((arg) => rules.push(arg));
                }
            }
            directives.push({
                type,
                rules,
            });
        }
    }
    return directives;
}
//# sourceMappingURL=directive.js.map