/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.owl.ui.prefix.PrefixListElement;
import org.protege.editor.owl.ui.prefix.PrefixMapping;
import org.semanticweb.owlapi.vocab.Namespaces;

public class PrefixesListSectionRow
implements MListItem,
PrefixListElement {
    @Nonnull
    private PrefixMapping value;
    @Nonnull
    private Consumer<PrefixMapping> deleteHandler = pm -> {};
    @Nonnull
    private Consumer<PrefixMapping> editHandler = pm -> {};
    private static ImmutableSet<PrefixMapping> immutablePrefixMappings = ImmutableSet.of((Object)PrefixesListSectionRow.prefixMapping(Namespaces.OWL), (Object)PrefixesListSectionRow.prefixMapping(Namespaces.RDFS), (Object)PrefixesListSectionRow.prefixMapping(Namespaces.RDF), (Object)PrefixesListSectionRow.prefixMapping(Namespaces.XML), (Object)PrefixesListSectionRow.prefixMapping(Namespaces.XSD));

    public void setDeleteHandler(@Nonnull Consumer<PrefixMapping> deleteHandler) {
        this.deleteHandler = (Consumer)Preconditions.checkNotNull(deleteHandler);
    }

    public void setEditHandler(@Nonnull Consumer<PrefixMapping> editHandler) {
        this.editHandler = (Consumer)Preconditions.checkNotNull(editHandler);
    }

    private static PrefixMapping prefixMapping(Namespaces owl) {
        return PrefixMapping.get(owl.getPrefixName() + ":", owl.getPrefixIRI());
    }

    @Nonnull
    public PrefixMapping getValue() {
        return this.value;
    }

    public PrefixesListSectionRow(@Nonnull PrefixMapping value) {
        this.value = (PrefixMapping)Preconditions.checkNotNull((Object)value);
    }

    public boolean isEditable() {
        return !immutablePrefixMappings.contains((Object)this.value);
    }

    public void handleEdit() {
        this.editHandler.accept(this.value);
    }

    public boolean isDeleteable() {
        return !immutablePrefixMappings.contains((Object)this.value);
    }

    public boolean handleDelete() {
        this.deleteHandler.accept(this.value);
        return true;
    }

    public String getTooltip() {
        return String.format("Prefix name %s maps to prefix %s", this.value.getPrefixName(), this.value.getPrefix());
    }
}

