/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.plantuml.klimt.sprite.SpriteGrayLevel;
import net.sourceforge.plantuml.klimt.sprite.SpriteUtils;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.version.PSystemVersion;

public class SpriteWindow
extends JFrame {
    private final JTextArea area = new JTextArea();
    private String last;

    public SpriteWindow() {
        super("SpriteWindows");
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.area.setFont(new Font("Courier", 0, 14));
        this.area.setText("Copy an image to the clipboard.\nIt will be converted inside this window.\n");
        JScrollPane scroll = new JScrollPane(this.area);
        this.getContentPane().add((Component)scroll, "Center");
        this.setSize(400, 320);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        this.startTimer();
    }

    private void startTimer() {
        Log.info("Init done");
        Timer timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpriteWindow.this.tick();
            }
        });
        timer.setInitialDelay(0);
        timer.start();
        Log.info("Timer started");
    }

    private void tick() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpriteWindow.this.encode();
            }
        });
    }

    private void encode() {
        BufferedImage img = SpriteWindow.getClipboard();
        if (img == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        this.encodeColor(img, sb);
        this.encode(img, SpriteGrayLevel.GRAY_16, sb);
        this.encodeCompressed(img, SpriteGrayLevel.GRAY_16, sb);
        this.encode(img, SpriteGrayLevel.GRAY_8, sb);
        this.encodeCompressed(img, SpriteGrayLevel.GRAY_8, sb);
        this.encode(img, SpriteGrayLevel.GRAY_4, sb);
        this.encodeCompressed(img, SpriteGrayLevel.GRAY_4, sb);
        this.printData(sb.toString());
    }

    private void encodeColor(BufferedImage img, StringBuilder sb) {
        sb.append("\n");
        sb.append(SpriteUtils.encodeColor(img, "demo"));
    }

    private void encodeCompressed(BufferedImage img, SpriteGrayLevel level, StringBuilder sb) {
        sb.append("\n");
        sb.append(SpriteUtils.encodeCompressed(img, "demo", level));
    }

    private void encode(BufferedImage img, SpriteGrayLevel level, StringBuilder sb) {
        sb.append("\n");
        sb.append(SpriteUtils.encode(img, "demo", level));
    }

    private void printData(String s2) {
        if (!s2.equals(this.last)) {
            this.area.setText(s2);
            this.last = s2;
        }
    }

    public static BufferedImage getClipboard() {
        Transferable t2 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t2 != null && t2.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                BufferedImage text = (BufferedImage)t2.getTransferData(DataFlavor.imageFlavor);
                return text;
            }
        }
        catch (UnsupportedFlavorException e) {
            Log.error(e.toString());
        }
        catch (IOException e) {
            Log.error(e.toString());
        }
        return null;
    }

    public static void main(String[] args) {
        new SpriteWindow();
    }
}

