"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ouiResizableButtonWithControls = ouiResizableButtonWithControls;
Object.defineProperty(exports, "EuiResizableButton", {
  enumerable: true,
  get: function get() {
    return _resizable_button.EuiResizableButton;
  }
});
Object.defineProperty(exports, "euiResizableButtonWithControls", {
  enumerable: true,
  get: function get() {
    return _resizable_button.euiResizableButtonWithControls;
  }
});
exports.OuiResizableButton = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _services = require("../../services");

var _context = require("./context");

var _resizable_button = require("../../eui_components/resizable_container/resizable_button");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; } /*
                                                                                                                                                                                                                                                                                                                     * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * The OpenSearch Contributors require contributions made to
                                                                                                                                                                                                                                                                                                                     * this file be licensed under the Apache-2.0 license or a
                                                                                                                                                                                                                                                                                                                     * compatible open source license.
                                                                                                                                                                                                                                                                                                                     *
                                                                                                                                                                                                                                                                                                                     * Modifications Copyright OpenSearch Contributors. See
                                                                                                                                                                                                                                                                                                                     * GitHub history for details.
                                                                                                                                                                                                                                                                                                                     */ /*
                                                                                                                                                                                                                                                                                                                         * Licensed to Elasticsearch B.V. under one or more contributor
                                                                                                                                                                                                                                                                                                                         * license agreements. See the NOTICE file distributed with
                                                                                                                                                                                                                                                                                                                         * this work for additional information regarding copyright
                                                                                                                                                                                                                                                                                                                         * ownership. Elasticsearch B.V. licenses this file to you under
                                                                                                                                                                                                                                                                                                                         * the Apache License, Version 2.0 (the "License"); you may
                                                                                                                                                                                                                                                                                                                         * not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                         * You may obtain a copy of the License at
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         *    http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                         *
                                                                                                                                                                                                                                                                                                                         * Unless required by applicable law or agreed to in writing,
                                                                                                                                                                                                                                                                                                                         * software distributed under the License is distributed on an
                                                                                                                                                                                                                                                                                                                         * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
                                                                                                                                                                                                                                                                                                                         * KIND, either express or implied.  See the License for the
                                                                                                                                                                                                                                                                                                                         * specific language governing permissions and limitations
                                                                                                                                                                                                                                                                                                                         * under the License.
                                                                                                                                                                                                                                                                                                                         */

var generatePanelId = (0, _services.htmlIdGenerator)('resizable-button');

var OuiResizableButton = function OuiResizableButton(_ref) {
  var isHorizontal = _ref.isHorizontal,
      className = _ref.className,
      id = _ref.id,
      registration = _ref.registration,
      disabled = _ref.disabled,
      onFocus = _ref.onFocus,
      onBlur = _ref.onBlur,
      rest = _objectWithoutProperties(_ref, ["isHorizontal", "className", "id", "registration", "disabled", "onFocus", "onBlur"]);

  var resizerId = (0, _react.useRef)(id || generatePanelId());

  var _useOuiResizableConta = (0, _context.useOuiResizableContainerContext)(),
      _useOuiResizableConta2 = _useOuiResizableConta.registry;

  _useOuiResizableConta2 = _useOuiResizableConta2 === void 0 ? {
    resizers: {}
  } : _useOuiResizableConta2;
  var resizers = _useOuiResizableConta2.resizers;
  var isDisabled = (0, _react.useMemo)(function () {
    return disabled || resizers[resizerId.current] && resizers[resizerId.current].isDisabled;
  }, [resizers, disabled]);
  var classes = (0, _classnames.default)('ouiResizableButton', {
    'ouiResizableButton--vertical': !isHorizontal,
    'ouiResizableButton--horizontal': isHorizontal,
    'ouiResizableButton--disabled': isDisabled
  }, className);
  var previousRef = (0, _react.useRef)();
  var onRef = (0, _react.useCallback)(function (ref) {
    if (!registration) return;
    var id = resizerId.current;

    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: id,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(id);
        previousRef.current = undefined;
      }
    }
  }, [registration, disabled]);

  var setFocus = function setFocus(e) {
    return e.currentTarget.focus();
  };

  var handleFocus = function handleFocus() {
    onFocus && onFocus(resizerId.current);
  };

  return /*#__PURE__*/_react.default.createElement(_i18n.OuiI18n, {
    tokens: ['ouiResizableButton.horizontalResizerAriaLabel', 'ouiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press left or right to adjust panels size', 'Press up or down to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        horizontalResizerAriaLabel = _ref3[0],
        verticalResizerAriaLabel = _ref3[1];

    return /*#__PURE__*/_react.default.createElement("button", _extends({
      id: resizerId.current,
      ref: onRef,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      "data-test-subj": "ouiResizableButton",
      type: "button",
      onClick: setFocus,
      onFocus: handleFocus,
      onBlur: onBlur,
      disabled: isDisabled
    }, rest));
  });
};

exports.OuiResizableButton = OuiResizableButton;
OuiResizableButton.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

function ouiResizableButtonWithControls(controls) {
  return function (props) {
    return /*#__PURE__*/_react.default.createElement(OuiResizableButton, _extends({}, controls, props));
  };
}
/* OUI -> EUI Aliases: Build-Time */

/* OUI -> EUI Aliases: Build-Time */