/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.SearchEmailGroupAction;
import org.opensearch.alerting.model.destination.email.EmailGroup;
import org.opensearch.alerting.util.RestHandlerUtilsKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/opensearch/alerting/resthandler/RestSearchEmailGroupAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "searchEmailGroupResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/action/search/SearchResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "opensearch-alerting"})
public final class RestSearchEmailGroupAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "search_email_group_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/_search"), new RestHandler.ReplacedRoute(RestRequest.Method.GET, AlertingPlugin.EMAIL_GROUP_BASE_URI + "/_search", RestRequest.Method.GET, AlertingPlugin.LEGACY_OPENDISTRO_EMAIL_GROUP_BASE_URI + "/_search")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtilsKt.context(request));
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must(searchSourceBuilder.query()).filter((QueryBuilder)QueryBuilders.existsQuery((String)"email_group"))).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        String[] stringArray = new String[]{".opendistro-alerting-config"};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(stringArray);
        return arg_0 -> RestSearchEmailGroupAction.prepareRequest$lambda$0(client, searchRequest, this, arg_0);
    }

    private final RestResponseListener<SearchResponse> searchEmailGroupResponse(RestChannel channel) {
        return (RestResponseListener)new RestResponseListener<SearchResponse>(channel){
            final /* synthetic */ RestChannel $channel;
            {
                this.$channel = $channel;
                super($channel);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public RestResponse buildResponse(@NotNull SearchResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (response2.isTimedOut()) {
                    return (RestResponse)new BytesRestResponse(RestStatus.REQUEST_TIMEOUT, response2.toString());
                }
                for (SearchHit hit : response2.getHits()) {
                    Closeable closeable = (Closeable)XContentType.JSON.xContent().createParser(this.$channel.request().getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                    Throwable throwable = null;
                    try {
                        XContentParser hitsParser = (XContentParser)closeable;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)hitsParser, (String)"hitsParser");
                        String string = hit.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hit.id");
                        EmailGroup emailGroup = EmailGroup.Companion.parseWithType(hitsParser, string, hit.getVersion());
                        XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder()");
                        ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                        XContentBuilder xcb = emailGroup.toXContent(xContentBuilder, params);
                        SearchHit searchHit = hit.sourceRef(BytesReference.bytes((XContentBuilder)xcb));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return (RestResponse)new BytesRestResponse(RestStatus.OK, response2.toXContent(this.$channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, SearchRequest $searchRequest, RestSearchEmailGroupAction this$0, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActionType actionType = SearchEmailGroupAction.Companion.getINSTANCE();
        ActionRequest actionRequest = (ActionRequest)$searchRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        $client.execute(actionType, actionRequest, (ActionListener)this$0.searchEmailGroupResponse(channel));
    }
}

