/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.tools.Utils;

public class ChangesetListModel
extends DefaultListModel<Changeset>
implements ChangesetCacheListener {
    private final transient List<Changeset> data = new ArrayList<Changeset>();
    private final transient Storage<Changeset> shownChangesets = new Storage(true);
    private final DefaultListSelectionModel selectionModel;

    public ChangesetListModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public synchronized Set<Changeset> getSelectedChangesets() {
        return IntStream.range(0, this.getSize()).filter(this.selectionModel::isSelectedIndex).mapToObj(this.data::get).collect(Collectors.toSet());
    }

    public synchronized Set<Integer> getSelectedChangesetIds() {
        return IntStream.range(0, this.getSize()).filter(this.selectionModel::isSelectedIndex).mapToObj(this.data::get).map(Changeset::getId).collect(Collectors.toSet());
    }

    public synchronized void setSelectedChangesets(Collection<Changeset> changesets) {
        TableHelper.setSelectedIndices(this.selectionModel, changesets != null ? changesets.stream().mapToInt(this.data::indexOf) : IntStream.empty());
    }

    protected void setChangesets(Collection<Changeset> changesets) {
        this.shownChangesets.clear();
        if (changesets != null) {
            this.shownChangesets.addAll(changesets);
        }
        this.updateModel();
    }

    private synchronized void updateModel() {
        Set<Changeset> sel = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(this.shownChangesets);
        ChangesetCache cache = ChangesetCache.getInstance();
        for (Changeset cs : this.data) {
            if (!cache.contains(cs) || cache.get(cs.getId()) == cs) continue;
            cs.mergeFrom(cache.get(cs.getId()));
        }
        this.sort();
        this.fireIntervalAdded(this, 0, this.getSize());
        this.setSelectedChangesets(sel);
    }

    public void initFromChangesetIds(Collection<Integer> ids) {
        if (Utils.isEmpty(ids)) {
            this.setChangesets(null);
            return;
        }
        Set<Changeset> changesets = ids.stream().mapToInt(id -> id).filter(id -> id > 0).mapToObj(Changeset::new).collect(Collectors.toSet());
        this.setChangesets(changesets);
    }

    public void initFromPrimitives(Collection<? extends OsmPrimitive> primitives) {
        if (primitives == null) {
            this.setChangesets(null);
            return;
        }
        this.initFromChangesetIds(primitives.stream().map(AbstractPrimitive::getChangesetId).collect(Collectors.toList()));
    }

    public void initFromDataSet(DataSet ds) {
        if (ds == null) {
            this.setChangesets(null);
            return;
        }
        this.initFromChangesetIds(ds.allPrimitives().stream().map(AbstractPrimitive::getChangesetId).collect(Collectors.toList()));
    }

    @Override
    public synchronized Changeset getElementAt(int idx) {
        return this.data.get(idx);
    }

    @Override
    public synchronized int getSize() {
        return this.data.size();
    }

    protected synchronized void sort() {
        this.data.sort(Comparator.comparingInt(Changeset::getId).reversed());
    }

    public boolean hasSelectedOpenChangesets() {
        return !this.getSelectedOpenChangesets().isEmpty();
    }

    public synchronized List<Changeset> getSelectedOpenChangesets() {
        return IntStream.range(0, this.getSize()).filter(this.selectionModel::isSelectedIndex).mapToObj(this.data::get).filter(Changeset::isOpen).collect(Collectors.toList());
    }

    @Override
    public synchronized void changesetCacheUpdated(ChangesetCacheEvent event) {
        int idx;
        Set<Changeset> sel = this.getSelectedChangesets();
        for (Changeset cs : event.getAddedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0 || this.data.get(idx) == cs) continue;
            this.data.get(idx).mergeFrom(cs);
        }
        for (Changeset cs : event.getUpdatedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0 || this.data.get(idx) == cs) continue;
            this.data.get(idx).mergeFrom(cs);
        }
        for (Changeset cs : event.getRemovedChangesets()) {
            idx = this.data.indexOf(cs);
            if (idx < 0) continue;
            this.data.set(idx, new Changeset(cs.getId()));
        }
        GuiHelper.runInEDT(() -> {
            this.fireContentsChanged(this, 0, this.getSize());
            this.setSelectedChangesets(sel);
        });
    }
}

