/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.segments;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.cmd.PointFlag;
import tim.prune.cmd.SetSegmentsCmd;
import tim.prune.data.DataPoint;
import tim.prune.function.DistanceTimeLimitFunction;

public class SplitSegmentsFunction
extends DistanceTimeLimitFunction {
    public SplitSegmentsFunction(App app) {
        super(app, false);
    }

    @Override
    public String getNameKey() {
        return "function.splitsegments";
    }

    @Override
    protected void performFunction() {
        boolean bl;
        int n = this.getTimeLimitInSeconds();
        boolean bl2 = n > 0;
        double d = this.getDistanceLimitRadians();
        boolean bl3 = bl = d > 0.0;
        if (!bl2 && !bl) {
            return;
        }
        int n2 = this._app.getTrackInfo().getTrack().getNumPoints();
        DataPoint dataPoint = null;
        ArrayList<PointFlag> arrayList = new ArrayList<PointFlag>();
        int n3 = 0;
        while (n3 < n2) {
            DataPoint dataPoint2 = this._app.getTrackInfo().getTrack().getPoint(n3);
            if (!dataPoint2.isWaypoint()) {
                boolean bl4;
                boolean bl5 = bl4 = dataPoint != null && (bl && DataPoint.calculateRadiansBetween(dataPoint, dataPoint2) > d || bl2 && dataPoint2.hasTimestamp() && dataPoint.hasTimestamp() && dataPoint2.getTimestamp().getSecondsSince(dataPoint.getTimestamp()) > (long)n);
                if (bl4 && !dataPoint2.getSegmentStart()) {
                    arrayList.add(new PointFlag(dataPoint2, true));
                }
                dataPoint = dataPoint2;
            }
            ++n3;
        }
        if (!arrayList.isEmpty()) {
            SetSegmentsCmd setSegmentsCmd = new SetSegmentsCmd(arrayList);
            setSegmentsCmd.setConfirmText(I18nManager.getTextWithNumber("confirm.splitsegments", arrayList.size()));
            setSegmentsCmd.setDescription(this.getName());
            this._app.execute(setSegmentsCmd);
            this._dialog.dispose();
        } else {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("error.tracksplit.nosplit"), I18nManager.getText("error.function.noop.title"), 2);
        }
    }
}

