/*
 * Copyright (c) 2025, Mediatek Inc. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef MT_SPM_REG_H
#define MT_SPM_REG_H

#include <pcm_def.h>
#include <sleep_def.h>

/**************************************
 * Define and Declare
 **************************************/
#define POWERON_CONFIG_EN			(SPM_BASE + 0x0000)
#define SPM_POWER_ON_VAL0			(SPM_BASE + 0x0004)
#define SPM_POWER_ON_VAL1			(SPM_BASE + 0x0008)
#define SPM_POWER_ON_VAL2			(SPM_BASE + 0x000C)
#define SPM_POWER_ON_VAL3			(SPM_BASE + 0x0010)
#define PCM_PWR_IO_EN				(SPM_BASE + 0x0014)
#define PCM_CON0				(SPM_BASE + 0x0018)
#define PCM_CON1				(SPM_BASE + 0x001C)
#define SPM_SRAM_SLEEP_CTRL			(SPM_BASE + 0x0020)
#define SPM_CLK_CON				(SPM_BASE + 0x0024)
#define SPM_CLK_SETTLE				(SPM_BASE + 0x0028)
#define SPM_SW_RST_CON				(SPM_BASE + 0x0040)
#define SPM_SW_RST_CON_SET			(SPM_BASE + 0x0044)
#define SPM_SW_RST_CON_CLR			(SPM_BASE + 0x0048)
#define R_SEC_READ_MASK				(SPM_BASE + 0x0050)
#define R_ONE_TIME_LOCK_L			(SPM_BASE + 0x0054)
#define R_ONE_TIME_LOCK_M			(SPM_BASE + 0x0058)
#define R_ONE_TIME_LOCK_H			(SPM_BASE + 0x005C)
#define SSPM_CLK_CON				(SPM_BASE + 0x0084)
#define SCP_CLK_CON				(SPM_BASE + 0x0088)
#define SPM_SWINT				(SPM_BASE + 0x0090)
#define SPM_SWINT_SET				(SPM_BASE + 0x0094)
#define SPM_SWINT_CLR				(SPM_BASE + 0x0098)
#define SPM_CPU_WAKEUP_EVENT			(SPM_BASE + 0x00B0)
#define SPM_IRQ_MASK				(SPM_BASE + 0x00B4)
#define MD32PCM_SCU_CTRL0			(SPM_BASE + 0x0100)
#define MD32PCM_SCU_CTRL1			(SPM_BASE + 0x0104)
#define MD32PCM_SCU_CTRL2			(SPM_BASE + 0x0108)
#define MD32PCM_SCU_CTRL3			(SPM_BASE + 0x010C)
#define MD32PCM_SCU_STA0			(SPM_BASE + 0x0110)
#define SPM_IRQ_STA				(SPM_BASE + 0x0128)
#define MD32PCM_WAKEUP_STA			(SPM_BASE + 0x0130)
#define MD32PCM_EVENT_STA			(SPM_BASE + 0x0134)
#define SPM_WAKEUP_MISC				(SPM_BASE + 0x0140)
#define SPM_CK_STA				(SPM_BASE + 0x0164)
#define MD32PCM_STA				(SPM_BASE + 0x0190)
#define MD32PCM_PC				(SPM_BASE + 0x0194)
#define SPM_CSOPLU_EN_CG_CON			(SPM_BASE + 0x0198)
#define SPM_RESOURCE_CSOPLU_ACK_CON		(SPM_BASE + 0x019C)
#define SPM_CSOPLU_OFF_MODE_CON			(SPM_BASE + 0x01A0)
#define SPM_CSOPLU_ACK_STA			(SPM_BASE + 0x01A4)
#define SPM_REOSURCE_CSOPLU_MASK		(SPM_BASE + 0x01A8)
#define SPM_REQ_BLOCK				(SPM_BASE + 0x01AC)
#define DVFS_IPS_CTRL				(SPM_BASE + 0x01B0)
#define TOP_CKSYS_CON				(SPM_BASE + 0x01B4)
#define SPM_AP_STANDBY_CON			(SPM_BASE + 0x0200)
#define CPU_WFI_EN				(SPM_BASE + 0x0204)
#define CPU_WFI_EN_SET				(SPM_BASE + 0x0208)
#define CPU_WFI_EN_CLR				(SPM_BASE + 0x020C)
#define EXT_INT_WAKEUP_REQ			(SPM_BASE + 0x0210)
#define EXT_INT_WAKEUP_REQ_SET			(SPM_BASE + 0x0214)
#define EXT_INT_WAKEUP_REQ_CLR			(SPM_BASE + 0x0218)
#define MCUSYS_IDLE_STA				(SPM_BASE + 0x021C)
#define CPU_PWR_STATUS				(SPM_BASE + 0x0220)
#define SW2SPM_WAKEUP				(SPM_BASE + 0x0224)
#define SW2SPM_WAKEUP_SET			(SPM_BASE + 0x0228)
#define SW2SPM_WAKEUP_CLR			(SPM_BASE + 0x022C)
#define SW2SPM_MAILBOX_0			(SPM_BASE + 0x0230)
#define SW2SPM_MAILBOX_1			(SPM_BASE + 0x0234)
#define SW2SPM_MAILBOX_2			(SPM_BASE + 0x0238)
#define SW2SPM_MAILBOX_3			(SPM_BASE + 0x023C)
#define SPM2SW_MAILBOX_0			(SPM_BASE + 0x0240)
#define SPM2SW_MAILBOX_1			(SPM_BASE + 0x0244)
#define SPM2SW_MAILBOX_2			(SPM_BASE + 0x0248)
#define SPM2SW_MAILBOX_3			(SPM_BASE + 0x024C)
#define SPM2MCUPM_CON				(SPM_BASE + 0x0250)
#define SPM_MCUSYS_PWR_CON			(SPM_BASE + 0x0260)
#define SPM_CPUTOP_PWR_CON			(SPM_BASE + 0x0264)
#define SPM_CPU0_PWR_CON			(SPM_BASE + 0x0268)
#define SPM_CPU1_PWR_CON			(SPM_BASE + 0x026C)
#define SPM_CPU2_PWR_CON			(SPM_BASE + 0x0270)
#define SPM_CPU3_PWR_CON			(SPM_BASE + 0x0274)
#define SPM_CPU4_PWR_CON			(SPM_BASE + 0x0278)
#define SPM_CPU5_PWR_CON			(SPM_BASE + 0x027C)
#define SPM_CPU6_PWR_CON			(SPM_BASE + 0x0280)
#define SPM_CPU7_PWR_CON			(SPM_BASE + 0x0284)
#define SPM_MCUPM_SPMC_CON			(SPM_BASE + 0x0288)
#define SODI5_MCUSYS_CON			(SPM_BASE + 0x028C)
#define SPM_DPM_P2P_STA				(SPM_BASE + 0x02A0)
#define SPM_DPM_P2P_CON				(SPM_BASE + 0x02A4)
#define SPM_DPM_INTF_STA			(SPM_BASE + 0x02A8)
#define SPM_DPM_WB_CON				(SPM_BASE + 0x02AC)
#define SPM_PWRAP_CON				(SPM_BASE + 0x0300)
#define SPM_PWRAP_CON_STA			(SPM_BASE + 0x0304)
#define SPM_PMIC_SPMI_CON			(SPM_BASE + 0x0308)
#define SPM_PWRAP_CMD0				(SPM_BASE + 0x0310)
#define SPM_PWRAP_CMD1				(SPM_BASE + 0x0314)
#define SPM_PWRAP_CMD2				(SPM_BASE + 0x0318)
#define SPM_PWRAP_CMD3				(SPM_BASE + 0x031C)
#define SPM_PWRAP_CMD4				(SPM_BASE + 0x0320)
#define SPM_PWRAP_CMD5				(SPM_BASE + 0x0324)
#define SPM_PWRAP_CMD6				(SPM_BASE + 0x0328)
#define SPM_PWRAP_CMD7				(SPM_BASE + 0x032C)
#define SPM_PWRAP_CMD8				(SPM_BASE + 0x0330)
#define SPM_PWRAP_CMD9				(SPM_BASE + 0x0334)
#define SPM_PWRAP_CMD10				(SPM_BASE + 0x0338)
#define SPM_PWRAP_CMD11				(SPM_BASE + 0x033C)
#define SPM_PWRAP_CMD12				(SPM_BASE + 0x0340)
#define SPM_PWRAP_CMD13				(SPM_BASE + 0x0344)
#define SPM_PWRAP_CMD14				(SPM_BASE + 0x0348)
#define SPM_PWRAP_CMD15				(SPM_BASE + 0x034C)
#define SPM_PWRAP_CMD16				(SPM_BASE + 0x0350)
#define SPM_PWRAP_CMD17				(SPM_BASE + 0x0354)
#define SPM_PWRAP_CMD18				(SPM_BASE + 0x0358)
#define SPM_PWRAP_CMD19				(SPM_BASE + 0x035C)
#define SPM_PWRAP_CMD20				(SPM_BASE + 0x0360)
#define SPM_PWRAP_CMD21				(SPM_BASE + 0x0364)
#define SPM_PWRAP_CMD22				(SPM_BASE + 0x0368)
#define SPM_PWRAP_CMD23				(SPM_BASE + 0x036C)
#define SPM_PWRAP_CMD24				(SPM_BASE + 0x0370)
#define SPM_PWRAP_CMD25				(SPM_BASE + 0x0374)
#define SPM_PWRAP_CMD26				(SPM_BASE + 0x0378)
#define SPM_PWRAP_CMD27				(SPM_BASE + 0x037C)
#define SPM_PWRAP_CMD28				(SPM_BASE + 0x0380)
#define SPM_PWRAP_CMD29				(SPM_BASE + 0x0384)
#define SPM_PWRAP_CMD30				(SPM_BASE + 0x0388)
#define SPM_PWRAP_CMD31				(SPM_BASE + 0x038C)
#define DVFSRC_EVENT_STA			(SPM_BASE + 0x0390)
#define SPM_FORCE_DVFS				(SPM_BASE + 0x0394)
#define SPM_DVFS_STA				(SPM_BASE + 0x0398)
#define SPM_DVS_DFS_LEVEL			(SPM_BASE + 0x039C)
#define SPM_DVFS_LEVEL				(SPM_BASE + 0x03A0)
#define SPM_DVFS_OPP				(SPM_BASE + 0x03A4)
#define SPM_ULTRA_REQ				(SPM_BASE + 0x03A8)
#define SPM_DVFS_CON				(SPM_BASE + 0x03AC)
#define SPM_SRAMRC_CON				(SPM_BASE + 0x03B0)
#define SPM_SRCLKENRC_CON			(SPM_BASE + 0x03B4)
#define SPM_DPSW_VAPU_ISO_CON			(SPM_BASE + 0x03BC)
#define SPM_DPSW_VMM_ISO_CON			(SPM_BASE + 0x03C0)
#define SPM_DPSW_VMD_ISO_CON			(SPM_BASE + 0x03C4)
#define SPM_DPSW_VMODEM_ISO_CON			(SPM_BASE + 0x03C8)
#define SPM_DPSW_VCORE_ISO_CON			(SPM_BASE + 0x03CC)
#define SPM_DPSW_CON				(SPM_BASE + 0x03D0)
#define SPM_DPSW_CON_SET			(SPM_BASE + 0x03D4)
#define SPM_DPSW_CON_CLR			(SPM_BASE + 0x03D8)
#define SPM_DPSW_AOC_ISO_CON			(SPM_BASE + 0x03DC)
#define SPM_DPSW_AOC_ISO_CON_SET		(SPM_BASE + 0x03E0)
#define SPM_DPSW_AOC_ISO_CON_CLR		(SPM_BASE + 0x03E4)
#define SPM_DPSW_FORCE_SWITCH_CON		(SPM_BASE + 0x03E8)
#define SPM_DPSW_FORCE_SWITCH_CON_SET		(SPM_BASE + 0x03EC)
#define SPM_DPSW_FORCE_SWITCH_CON_CLR		(SPM_BASE + 0x03F0)
#define SPM2DPSW_CTRL_ACK			(SPM_BASE + 0x03F4)
#define CSOPLU_CON				(SPM_BASE + 0x0400)
#define AP_MDSRC_REQ				(SPM_BASE + 0x0404)
#define SPM2MD_SWITCH_CTRL			(SPM_BASE + 0x0408)
#define RC_SPM_CTRL				(SPM_BASE + 0x040C)
#define SPM2GPUPM_CON				(SPM_BASE + 0x0410)
#define SPM2APU_CON				(SPM_BASE + 0x0414)
#define SPM2EFUSE_CON				(SPM_BASE + 0x0418)
#define SPM2DFD_CON				(SPM_BASE + 0x041C)
#define RSV_PLL_CON				(SPM_BASE + 0x0420)
#define EMI_SLB_CON				(SPM_BASE + 0x0424)
#define SPM_SUSPEND_FLAG_CON			(SPM_BASE + 0x0428)
#define SPM2PMSR_CON				(SPM_BASE + 0x042C)
#define SPM_TOPCK_RTFF_CON			(SPM_BASE + 0x0430)
#define EMI_SHF_CON				(SPM_BASE + 0x0434)
#define CIRQ_BYPASS_CON				(SPM_BASE + 0x0438)
#define AOC_VCORE_SRAM_CON			(SPM_BASE + 0x043C)
#define SPM2EMI_PDN_CTRL			(SPM_BASE + 0x0440)
#define VLP_RTFF_CTRL_MASK			(SPM_BASE + 0x0444)
#define VLP_RTFF_CTRL_MASK_SET			(SPM_BASE + 0x0448)
#define VLP_RTFF_CTRL_MASK_CLR			(SPM_BASE + 0x044C)
#define VLP_RTFF_CTRL_MASK_2			(SPM_BASE + 0x0450)
#define VLP_RTFF_CTRL_MASK_2_SET		(SPM_BASE + 0x0454)
#define VLP_RTFF_CTRL_MASK_2_CLR		(SPM_BASE + 0x0458)

/* SW CG Register Define*/
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_0	(SPM_BASE + 0x0460)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_1	(SPM_BASE + 0x0464)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_2	(SPM_BASE + 0x0468)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_3	(SPM_BASE + 0x046C)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_0	(SPM_BASE + 0x0470)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_1	(SPM_BASE + 0x0474)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_2	(SPM_BASE + 0x0478)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_3	(SPM_BASE + 0x047C)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_0	(SPM_BASE + 0x0480)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_1	(SPM_BASE + 0x0484)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_2	(SPM_BASE + 0x0488)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_3	(SPM_BASE + 0x048C)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_0	(SPM_BASE + 0x0490)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_1	(SPM_BASE + 0x0494)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_2	(SPM_BASE + 0x0498)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_3	(SPM_BASE + 0x049C)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_0	(SPM_BASE + 0x04A0)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_1	(SPM_BASE + 0x04A4)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_2	(SPM_BASE + 0x04A8)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_3	(SPM_BASE + 0x04AC)
#define REG_PWR_STATUS_DDREN_REQ_MASK		(SPM_BASE + 0x04B0)
#define REG_PWR_STATUS_VRF18_REQ_MASK		(SPM_BASE + 0x04B4)
#define REG_PWR_STATUS_INFRA_REQ_MASK		(SPM_BASE + 0x04B8)
#define REG_PWR_STATUS_F26M_REQ_MASK		(SPM_BASE + 0x04BC)
#define REG_PWR_STATUS_PMIC_REQ_MASK		(SPM_BASE + 0x04C0)
#define REG_PWR_STATUS_VCORE_REQ_MASK		(SPM_BASE + 0x04C4)
#define REG_PWR_STATUS_MSB_DDREN_REQ_MASK	(SPM_BASE + 0x04C8)
#define REG_PWR_STATUS_MSB_VRF18_REQ_MASK	(SPM_BASE + 0x04CC)
#define REG_PWR_STATUS_MSB_INFRA_REQ_MASK	(SPM_BASE + 0x04D0)
#define REG_PWR_STATUS_MSB_F26M_REQ_MASK	(SPM_BASE + 0x04D4)
#define REG_PWR_STATUS_MSB_PMIC_REQ_MASK	(SPM_BASE + 0x04D8)
#define REG_PWR_STATUS_MSB_VCORE_REQ_MASK	(SPM_BASE + 0x04DC)
#define REG_MODULE_BUSY_DDREN_REQ_MASK		(SPM_BASE + 0x04E0)
#define REG_MODULE_BUSY_VRF18_REQ_MASK		(SPM_BASE + 0x04E4)
#define REG_MODULE_BUSY_INFRA_REQ_MASK		(SPM_BASE + 0x04E8)
#define REG_MODULE_BUSY_F26M_REQ_MASK		(SPM_BASE + 0x04EC)
#define REG_MODULE_BUSY_PMIC_REQ_MASK		(SPM_BASE + 0x04F0)
#define REG_MODULE_BUSY_VCORE_REQ_MASK		(SPM_BASE + 0x04F4)

/* SYS TIMER Register Define */
#define SYS_TIMER_CON				(SPM_BASE + 0x0500)
#define SYS_TIMER_VALUE_L			(SPM_BASE + 0x0504)
#define SYS_TIMER_VALUE_H			(SPM_BASE + 0x0508)
#define SYS_TIMER_START_L			(SPM_BASE + 0x050C)
#define SYS_TIMER_START_H			(SPM_BASE + 0x0510)
#define SYS_TIMER_LATCH_L_00			(SPM_BASE + 0x0514)
#define SYS_TIMER_LATCH_H_00			(SPM_BASE + 0x0518)
#define SYS_TIMER_LATCH_L_01			(SPM_BASE + 0x051C)
#define SYS_TIMER_LATCH_H_01			(SPM_BASE + 0x0520)
#define SYS_TIMER_LATCH_L_02			(SPM_BASE + 0x0524)
#define SYS_TIMER_LATCH_H_02			(SPM_BASE + 0x0528)
#define SYS_TIMER_LATCH_L_03			(SPM_BASE + 0x052C)
#define SYS_TIMER_LATCH_H_03			(SPM_BASE + 0x0530)
#define SYS_TIMER_LATCH_L_04			(SPM_BASE + 0x0534)
#define SYS_TIMER_LATCH_H_04			(SPM_BASE + 0x0538)
#define SYS_TIMER_LATCH_L_05			(SPM_BASE + 0x053C)
#define SYS_TIMER_LATCH_H_05			(SPM_BASE + 0x0540)
#define SYS_TIMER_LATCH_L_06			(SPM_BASE + 0x0544)
#define SYS_TIMER_LATCH_H_06			(SPM_BASE + 0x0548)
#define SYS_TIMER_LATCH_L_07			(SPM_BASE + 0x054C)
#define SYS_TIMER_LATCH_H_07			(SPM_BASE + 0x0550)
#define SYS_TIMER_LATCH_L_08			(SPM_BASE + 0x0554)
#define SYS_TIMER_LATCH_H_08			(SPM_BASE + 0x0558)
#define SYS_TIMER_LATCH_L_09			(SPM_BASE + 0x055C)
#define SYS_TIMER_LATCH_H_09			(SPM_BASE + 0x0560)
#define SYS_TIMER_LATCH_L_10			(SPM_BASE + 0x0564)
#define SYS_TIMER_LATCH_H_10			(SPM_BASE + 0x0568)
#define SYS_TIMER_LATCH_L_11			(SPM_BASE + 0x056C)
#define SYS_TIMER_LATCH_H_11			(SPM_BASE + 0x0570)
#define SYS_TIMER_LATCH_L_12			(SPM_BASE + 0x0574)
#define SYS_TIMER_LATCH_H_12			(SPM_BASE + 0x0578)
#define SYS_TIMER_LATCH_L_13			(SPM_BASE + 0x057C)
#define SYS_TIMER_LATCH_H_13			(SPM_BASE + 0x0580)
#define SYS_TIMER_LATCH_L_14			(SPM_BASE + 0x0584)
#define SYS_TIMER_LATCH_H_14			(SPM_BASE + 0x0588)
#define SYS_TIMER_LATCH_L_15			(SPM_BASE + 0x058C)
#define SYS_TIMER_LATCH_H_15			(SPM_BASE + 0x0590)
#define PCM_TIMER_VAL				(SPM_BASE + 0x0594)
#define PCM_TIMER_OUT				(SPM_BASE + 0x0598)
#define SPM_COUNTER_0				(SPM_BASE + 0x059C)
#define SPM_COUNTER_1				(SPM_BASE + 0x05A0)
#define SPM_COUNTER_2				(SPM_BASE + 0x05A4)
#define PCM_WDT_VAL				(SPM_BASE + 0x05A8)
#define PCM_WDT_OUT				(SPM_BASE + 0x05AC)
#define SPM_SW_FLAG_0				(SPM_BASE + 0x0600)
#define SPM_SW_DEBUG_0				(SPM_BASE + 0x0604)
#define SPM_SW_FLAG_1				(SPM_BASE + 0x0608)
#define SPM_SW_DEBUG_1				(SPM_BASE + 0x060C)
#define SPM_SW_RSV_0				(SPM_BASE + 0x0610)
#define SPM_SW_RSV_1				(SPM_BASE + 0x0614)
#define SPM_SW_RSV_2				(SPM_BASE + 0x0618)
#define SPM_SW_RSV_3				(SPM_BASE + 0x061C)
#define SPM_SW_RSV_4				(SPM_BASE + 0x0620)
#define SPM_SW_RSV_5				(SPM_BASE + 0x0624)
#define SPM_SW_RSV_6				(SPM_BASE + 0x0628)
#define SPM_SW_RSV_7				(SPM_BASE + 0x062C)
#define SPM_SW_RSV_8				(SPM_BASE + 0x0630)
#define SPM_BK_WAKE_EVENT			(SPM_BASE + 0x0634)
#define SPM_BK_VTCXO_DUR			(SPM_BASE + 0x0638)
#define SPM_BK_WAKE_MISC			(SPM_BASE + 0x063C)
#define SPM_BK_PCM_TIMER			(SPM_BASE + 0x0640)
#define SPM_RSV_CON_0				(SPM_BASE + 0x0650)
#define SPM_RSV_CON_1				(SPM_BASE + 0x0654)
#define SPM_RSV_STA_0				(SPM_BASE + 0x0658)
#define SPM_RSV_STA_1				(SPM_BASE + 0x065C)
#define SPM_SPARE_CON				(SPM_BASE + 0x0660)
#define SPM_SPARE_CON_SET			(SPM_BASE + 0x0664)
#define SPM_SPARE_CON_CLR			(SPM_BASE + 0x0668)
#define SPM_CROSS_WAKE_M00_REQ			(SPM_BASE + 0x066C)
#define SPM_CROSS_WAKE_M01_REQ			(SPM_BASE + 0x0670)
#define SPM_CROSS_WAKE_M02_REQ			(SPM_BASE + 0x0674)
#define SPM_CROSS_WAKE_M03_REQ			(SPM_BASE + 0x0678)
#define SCP_VCORE_LEVEL				(SPM_BASE + 0x067C)
#define SPM_DDREN_ACK_SEL_CON			(SPM_BASE + 0x0680)
#define SPM_SW_FLAG_2				(SPM_BASE + 0x0684)
#define SPM_SW_DEBUG_2				(SPM_BASE + 0x0688)
#define SPM_DV_CON_0				(SPM_BASE + 0x068C)
#define SPM_DV_CON_1				(SPM_BASE + 0x0690)
#define SPM_SEMA_M0				(SPM_BASE + 0x069C)
#define SPM_SEMA_M1				(SPM_BASE + 0x06A0)
#define SPM_SEMA_M2				(SPM_BASE + 0x06A4)
#define SPM_SEMA_M3				(SPM_BASE + 0x06A8)
#define SPM_SEMA_M4				(SPM_BASE + 0x06AC)
#define SPM_SEMA_M5				(SPM_BASE + 0x06B0)
#define SPM_SEMA_M6				(SPM_BASE + 0x06B4)
#define SPM_SEMA_M7				(SPM_BASE + 0x06B8)
#define SPM2ADSP_MAILBOX			(SPM_BASE + 0x06BC)
#define ADSP2SPM_MAILBOX			(SPM_BASE + 0x06C0)
#define SPM2PMCU_MAILBOX_0			(SPM_BASE + 0x06C4)
#define SPM2PMCU_MAILBOX_1			(SPM_BASE + 0x06C8)
#define SPM2PMCU_MAILBOX_2			(SPM_BASE + 0x06CC)
#define SPM2PMCU_MAILBOX_3			(SPM_BASE + 0x06D0)
#define PMCU2SPM_MAILBOX_0			(SPM_BASE + 0x06D4)
#define PMCU2SPM_MAILBOX_1			(SPM_BASE + 0x06D8)
#define PMCU2SPM_MAILBOX_2			(SPM_BASE + 0x06DC)
#define PMCU2SPM_MAILBOX_3			(SPM_BASE + 0x06E0)
#define SPM2SCP_MAILBOX				(SPM_BASE + 0x06E4)
#define SCP2SPM_MAILBOX				(SPM_BASE + 0x06E8)
#define SCP_AOV_BUS_CON				(SPM_BASE + 0x06EC)
#define VCORE_RTFF_CTRL_MASK			(SPM_BASE + 0x06F0)
#define VCORE_RTFF_CTRL_MASK_SET		(SPM_BASE + 0x06F4)
#define VCORE_RTFF_CTRL_MASK_CLR		(SPM_BASE + 0x06F8)
#define SPM_SRAM_SRCLKENO_MASK			(SPM_BASE + 0x06FC)
#define SPM_WAKEUP_STA				(SPM_BASE + 0x0800)
#define SPM_WAKEUP_EXT_STA			(SPM_BASE + 0x0804)
#define SPM_WAKEUP_EVENT_MASK			(SPM_BASE + 0x0808)
#define SPM_WAKEUP_EVENT_EXT_MASK		(SPM_BASE + 0x080C)
#define SPM_WAKEUP_EVENT_SENS			(SPM_BASE + 0x0810)
#define SPM_WAKEUP_EVENT_CLEAR			(SPM_BASE + 0x0814)
#define SPM_SRC_REQ				(SPM_BASE + 0x0818)
#define SPM_SRC_MASK_0				(SPM_BASE + 0x081C)
#define SPM_SRC_MASK_1				(SPM_BASE + 0x0820)
#define SPM_SRC_MASK_2				(SPM_BASE + 0x0824)
#define SPM_SRC_MASK_3				(SPM_BASE + 0x0828)
#define SPM_SRC_MASK_4				(SPM_BASE + 0x082C)
#define SPM_SRC_MASK_5				(SPM_BASE + 0x0830)
#define SPM_SRC_MASK_6				(SPM_BASE + 0x0834)
#define SPM_SRC_MASK_7				(SPM_BASE + 0x0838)
#define SPM_SRC_MASK_8				(SPM_BASE + 0x083C)
#define SPM_SRC_MASK_9				(SPM_BASE + 0x0840)
#define SPM_SRC_MASK_10				(SPM_BASE + 0x0844)
#define SPM_SRC_MASK_11				(SPM_BASE + 0x0848)
#define SPM_SRC_MASK_12				(SPM_BASE + 0x084C)
#define SPM_SRC_MASK_13				(SPM_BASE + 0x0850)
#define SPM_SRC_MASK_14				(SPM_BASE + 0x0854)
#define SPM_SRC_MASK_15				(SPM_BASE + 0x0858)
#define SPM_SRC_MASK_16				(SPM_BASE + 0x085C)
#define SPM_REQ_STA_0				(SPM_BASE + 0x0860)
#define SPM_REQ_STA_1				(SPM_BASE + 0x0864)
#define SPM_REQ_STA_2				(SPM_BASE + 0x0868)
#define SPM_REQ_STA_3				(SPM_BASE + 0x086C)
#define SPM_REQ_STA_4				(SPM_BASE + 0x0870)
#define SPM_REQ_STA_5				(SPM_BASE + 0x0874)
#define SPM_REQ_STA_6				(SPM_BASE + 0x0878)
#define SPM_REQ_STA_7				(SPM_BASE + 0x087C)
#define SPM_REQ_STA_8				(SPM_BASE + 0x0880)
#define SPM_REQ_STA_9				(SPM_BASE + 0x0884)
#define SPM_REQ_STA_10				(SPM_BASE + 0x0888)
#define SPM_REQ_STA_11				(SPM_BASE + 0x088C)
#define SPM_REQ_STA_12				(SPM_BASE + 0x0890)
#define SPM_REQ_STA_13				(SPM_BASE + 0x0894)
#define SPM_REQ_STA_14				(SPM_BASE + 0x0898)
#define SPM_REQ_STA_15				(SPM_BASE + 0x089C)
#define SPM_REQ_STA_16				(SPM_BASE + 0x08A0)
#define SPM_IPC_WAKEUP_REQ			(SPM_BASE + 0x08A4)
#define IPC_WAKEUP_REQ_MASK_STA			(SPM_BASE + 0x08A8)
#define SPM_EVENT_CON_MISC			(SPM_BASE + 0x08AC)
#define DDREN_DBC_CON				(SPM_BASE + 0x08B0)
#define SPM_RESOURCE_ACK_CON_0			(SPM_BASE + 0x08B4)
#define SPM_RESOURCE_ACK_CON_1			(SPM_BASE + 0x08B8)
#define SPM_RESOURCE_ACK_MASK_0			(SPM_BASE + 0x08BC)
#define SPM_RESOURCE_ACK_MASK_1			(SPM_BASE + 0x08C0)
#define SPM_RESOURCE_ACK_MASK_2			(SPM_BASE + 0x08C4)
#define SPM_RESOURCE_ACK_MASK_3			(SPM_BASE + 0x08C8)
#define SPM_RESOURCE_ACK_MASK_4			(SPM_BASE + 0x08CC)
#define SPM_RESOURCE_ACK_MASK_5			(SPM_BASE + 0x08D0)
#define SPM_RESOURCE_ACK_MASK_6			(SPM_BASE + 0x08D4)
#define SPM_RESOURCE_ACK_MASK_7			(SPM_BASE + 0x08D8)
#define SPM_RESOURCE_ACK_MASK_8			(SPM_BASE + 0x08DC)
#define SPM_RESOURCE_ACK_MASK_9			(SPM_BASE + 0x08E0)
#define SPM_RESOURCE_ACK_MASK_10		(SPM_BASE + 0x08E4)
#define SPM_RESOURCE_ACK_MASK_11		(SPM_BASE + 0x08E8)
#define SPM_RESOURCE_ACK_MASK_12		(SPM_BASE + 0x08EC)
#define SPM_EVENT_COUNTER_CLEAR			(SPM_BASE + 0x08F0)
#define SPM_VCORE_EVENT_COUNT_STA		(SPM_BASE + 0x08F4)
#define SPM_PMIC_EVENT_COUNT_STA		(SPM_BASE + 0x08F8)
#define SPM_SRCCLKENA_EVENT_COUNT_STA		(SPM_BASE + 0x08FC)
#define SPM_INFRA_EVENT_COUNT_STA		(SPM_BASE + 0x0900)
#define SPM_VRF18_EVENT_COUNT_STA		(SPM_BASE + 0x0904)
#define SPM_EMI_EVENT_COUNT_STA			(SPM_BASE + 0x0908)
#define SPM_APSRC_EVENT_COUNT_STA		(SPM_BASE + 0x090C)
#define SPM_DDREN_EVENT_COUNT_STA		(SPM_BASE + 0x0910)
#define SPM_SRC_MASK_17				(SPM_BASE + 0x0914)
#define SPM_SRC_MASK_18				(SPM_BASE + 0x0918)
#define SPM_RESOURCE_ACK_MASK_13		(SPM_BASE + 0x091C)
#define SPM_RESOURCE_ACK_MASK_14		(SPM_BASE + 0x0920)
#define SPM_REQ_STA_17				(SPM_BASE + 0x0924)
#define SPM_REQ_STA_18				(SPM_BASE + 0x0928)
#define MD1_PWR_CON				(SPM_BASE + 0x0E00)
#define CONN_PWR_CON				(SPM_BASE + 0x0E04)
#define APIFR_IO_PWR_CON			(SPM_BASE + 0x0E08)
#define APIFR_MEM_PWR_CON			(SPM_BASE + 0x0E0C)
#define PERI_PWR_CON				(SPM_BASE + 0x0E10)
#define PERI_ETHER_PWR_CON			(SPM_BASE + 0x0E14)
#define SSUSB_DP_PHY_P0_PWR_CON			(SPM_BASE + 0x0E18)
#define SSUSB_P0_PWR_CON			(SPM_BASE + 0x0E1C)
#define SSUSB_P1_PWR_CON			(SPM_BASE + 0x0E20)
#define SSUSB_P23_PWR_CON			(SPM_BASE + 0x0E24)
#define SSUSB_PHY_P2_PWR_CON			(SPM_BASE + 0x0E28)
#define UFS0_PWR_CON				(SPM_BASE + 0x0E2C)
#define UFS0_PHY_PWR_CON			(SPM_BASE + 0x0E30)
#define PEXTP_MAC0_PWR_CON			(SPM_BASE + 0x0E34)
#define PEXTP_MAC1_PWR_CON			(SPM_BASE + 0x0E38)
#define PEXTP_MAC2_PWR_CON			(SPM_BASE + 0x0E3C)
#define PEXTP_PHY0_PWR_CON			(SPM_BASE + 0x0E40)
#define PEXTP_PHY1_PWR_CON			(SPM_BASE + 0x0E44)
#define PEXTP_PHY2_PWR_CON			(SPM_BASE + 0x0E48)
#define AUDIO_PWR_CON				(SPM_BASE + 0x0E4C)
#define ADSP_CORE1_PWR_CON			(SPM_BASE + 0x0E50)
#define ADSP_TOP_PWR_CON			(SPM_BASE + 0x0E54)
#define ADSP_INFRA_PWR_CON			(SPM_BASE + 0x0E58)
#define ADSP_AO_PWR_CON				(SPM_BASE + 0x0E5C)
#define MM_PROC_PWR_CON				(SPM_BASE + 0x0E60)
#define SCP_PWR_CON				(SPM_BASE + 0x0E64)
#define DPM0_PWR_CON				(SPM_BASE + 0x0E68)
#define DPM1_PWR_CON				(SPM_BASE + 0x0E6C)
#define DPM2_PWR_CON				(SPM_BASE + 0x0E70)
#define DPM3_PWR_CON				(SPM_BASE + 0x0E74)
#define EMI0_PWR_CON				(SPM_BASE + 0x0E78)
#define EMI1_PWR_CON				(SPM_BASE + 0x0E7C)
#define EMI_INFRA_PWR_CON			(SPM_BASE + 0x0E80)
#define SSRSYS_PWR_CON				(SPM_BASE + 0x0E84)
#define SPU_ISE_PWR_CON				(SPM_BASE + 0x0E88)
#define SPU_HWROT_PWR_CON			(SPM_BASE + 0x0E8C)
#define VLP_PWR_CON				(SPM_BASE + 0x0E90)
#define HSGMII0_PWR_CON				(SPM_BASE + 0x0E94)
#define HSGMII1_PWR_CON				(SPM_BASE + 0x0E98)
#define MFG_VLP_PWR_CON				(SPM_BASE + 0x0E9C)
#define MCUSYS_BUSBLK_PWR_CON			(SPM_BASE + 0x0EA0)
#define CPUEB_PWR_CON				(SPM_BASE + 0x0EA4)
#define MFG0_PWR_CON				(SPM_BASE + 0x0EA8)
#define ADSP_HRE_SRAM_CON			(SPM_BASE + 0x0EAC)
#define CCU_SLEEP_SRAM_CON			(SPM_BASE + 0x0EB0)
#define EFUSE_SRAM_CON				(SPM_BASE + 0x0EB4)
#define EMI_HRE_SRAM_CON			(SPM_BASE + 0x0EB8)
#define INFRA_HRE_SRAM_CON			(SPM_BASE + 0x0EBC)
#define INFRA_SLEEP_SRAM_CON			(SPM_BASE + 0x0EC0)
#define MML_HRE_SRAM_CON			(SPM_BASE + 0x0EC4)
#define MM_HRE_SRAM_CON				(SPM_BASE + 0x0EC8)
#define MM_INFRA_AO_PDN_SRAM_CON		(SPM_BASE + 0x0ECC)
#define NTH_EMI_SLB_SRAM_CON			(SPM_BASE + 0x0ED0)
#define PERI_SLEEP_SRAM_CON			(SPM_BASE + 0x0ED4)
#define SPM_SRAM_CON				(SPM_BASE + 0x0ED8)
#define SPU_HWROT_SLEEP_SRAM_CON		(SPM_BASE + 0x0EDC)
#define SPU_ISE_SLEEP_SRAM_CON			(SPM_BASE + 0x0EE0)
#define SSPM_SRAM_CON				(SPM_BASE + 0x0EE4)
#define SSR_SLEEP_SRAM_CON			(SPM_BASE + 0x0EE8)
#define STH_EMI_SLB_SRAM_CON			(SPM_BASE + 0x0EEC)
#define UFS_SLEEP_SRAM_CON			(SPM_BASE + 0x0EF0)
#define UNIPRO_PDN_SRAM_CON			(SPM_BASE + 0x0EF4)
#define CPU_BUCK_ISO_CON			(SPM_BASE + 0x0EF8)
#define MD_BUCK_ISO_CON				(SPM_BASE + 0x0EFC)
#define SOC_BUCK_ISO_CON			(SPM_BASE + 0x0F00)
#define SOC_BUCK_ISO_CON_SET			(SPM_BASE + 0x0F0C)
#define SOC_BUCK_ISO_CON_CLR			(SPM_BASE + 0x0F10)
#define PWR_STATUS				(SPM_BASE + 0x0F14)
#define PWR_STATUS_2ND				(SPM_BASE + 0x0F18)
#define PWR_STATUS_MSB				(SPM_BASE + 0x0F1C)
#define PWR_STATUS_MSB_2ND			(SPM_BASE + 0x0F20)
#define XPU_PWR_STATUS				(SPM_BASE + 0x0F24)
#define XPU_PWR_STATUS_2ND			(SPM_BASE + 0x0F28)
#define DFD_SOC_PWR_LATCH			(SPM_BASE + 0x0F2C)
#define NTH_EMI_SLB_SRAM_ACK			(SPM_BASE + 0x0F30)
#define STH_EMI_SLB_SRAM_ACK			(SPM_BASE + 0x0F34)
#define DPYD0_PWR_CON				(SPM_BASE + 0x0F38)
#define DPYD1_PWR_CON				(SPM_BASE + 0x0F3C)
#define DPYD2_PWR_CON				(SPM_BASE + 0x0F40)
#define DPYD3_PWR_CON				(SPM_BASE + 0x0F44)
#define DPYA0_PWR_CON				(SPM_BASE + 0x0F48)
#define DPYA1_PWR_CON				(SPM_BASE + 0x0F4C)
#define DPYA2_PWR_CON				(SPM_BASE + 0x0F50)
#define DPYA3_PWR_CON				(SPM_BASE + 0x0F5C)
#define SCP_2_PWR_CON				(SPM_BASE + 0x0F60)
#define RSV_0_SLEEP_SRAM_CON			(SPM_BASE + 0x0F64)
#define RSV_1_SLEEP_SRAM_CON			(SPM_BASE + 0x0F68)
#define APIFR_MEM_SLEEP_SRAM_CON		(SPM_BASE + 0x0F6C)
#define RSV_0_PWR_CON				(SPM_BASE + 0x0F70)
#define RSV_1_PWR_CON				(SPM_BASE + 0x0F74)
#define SPM_TWAM_CON				(SPM_BASE + 0x0FD0)
#define SPM_TWAM_WINDOW_LEN			(SPM_BASE + 0x0FD4)
#define SPM_TWAM_IDLE_SEL			(SPM_BASE + 0x0FD8)
#define SPM_TWAM_LAST_STA_0			(SPM_BASE + 0x0FDC)
#define SPM_TWAM_LAST_STA_1			(SPM_BASE + 0x0FE0)
#define SPM_TWAM_LAST_STA_2			(SPM_BASE + 0x0FE4)
#define SPM_TWAM_LAST_STA_3			(SPM_BASE + 0x0FE8)
#define SPM_TWAM_CURR_STA_0			(SPM_BASE + 0x0FEC)
#define SPM_TWAM_CURR_STA_1			(SPM_BASE + 0x0FF0)
#define SPM_TWAM_CURR_STA_2			(SPM_BASE + 0x0FF4)
#define SPM_TWAM_CURR_STA_3			(SPM_BASE + 0x0FF8)
#define SPM_TWAM_TIMER_OUT			(SPM_BASE + 0x0FFC)
#define MD1_SSYSPM_CON				(SPM_BASE + 0x9000)
#define CONN_SSYSPM_CON				(SPM_BASE + 0x9004)
#define APIFR_IO_SSYSPM_CON			(SPM_BASE + 0x9008)
#define APIFR_MEM_SSYSPM_CON			(SPM_BASE + 0x900C)
#define PERI_SSYSPM_CON				(SPM_BASE + 0x9010)
#define PERI_ETHER_SSYSPM_CON			(SPM_BASE + 0x9014)
#define SSUSB_DP_PHY_P0_SSYSPM_CON		(SPM_BASE + 0x9018)
#define SSUSB_P0_SSYSPM_CON			(SPM_BASE + 0x901C)
#define SSUSB_P1_SSYSPM_CON			(SPM_BASE + 0x9020)
#define SSUSB_P23_SSYSPM_CON			(SPM_BASE + 0x9024)
#define SSUSB_PHY_P2_SSYSPM_CON			(SPM_BASE + 0x9028)
#define UFS0_SSYSPM_CON				(SPM_BASE + 0x902C)
#define UFS0_PHY_SSYSPM_CON			(SPM_BASE + 0x9030)
#define PEXTP_MAC0_SSYSPM_CON			(SPM_BASE + 0x9034)
#define PEXTP_MAC1_SSYSPM_CON			(SPM_BASE + 0x9038)
#define PEXTP_MAC2_SSYSPM_CON			(SPM_BASE + 0x903C)
#define PEXTP_PHY0_SSYSPM_CON			(SPM_BASE + 0x9040)
#define PEXTP_PHY1_SSYSPM_CON			(SPM_BASE + 0x9044)
#define PEXTP_PHY2_SSYSPM_CON			(SPM_BASE + 0x9048)
#define AUDIO_SSYSPM_CON			(SPM_BASE + 0x904C)
#define ADSP_CORE1_SSYSPM_CON			(SPM_BASE + 0x9050)
#define ADSP_TOP_SSYSPM_CON			(SPM_BASE + 0x9054)
#define ADSP_INFRA_SSYSPM_CON			(SPM_BASE + 0x9058)
#define ADSP_AO_SSYSPM_CON			(SPM_BASE + 0x905C)
#define MM_PROC_SSYSPM_CON			(SPM_BASE + 0x9060)
#define SCP_SSYSPM_CON				(SPM_BASE + 0x9064)
#define SCP_2_SSYSPM_CON			(SPM_BASE + 0x9068)
#define DPYD0_SSYSPM_CON			(SPM_BASE + 0x906C)
#define DPYD1_SSYSPM_CON			(SPM_BASE + 0x9070)
#define DPYD2_SSYSPM_CON			(SPM_BASE + 0x9074)
#define DPYD3_SSYSPM_CON			(SPM_BASE + 0x9078)
#define DPYA0_SSYSPM_CON			(SPM_BASE + 0x907C)
#define DPYA1_SSYSPM_CON			(SPM_BASE + 0x9080)
#define DPYA2_SSYSPM_CON			(SPM_BASE + 0x9084)
#define DPYA3_SSYSPM_CON			(SPM_BASE + 0x9088)
#define DPM0_SSYSPM_CON				(SPM_BASE + 0x908C)
#define DPM1_SSYSPM_CON				(SPM_BASE + 0x9090)
#define DPM2_SSYSPM_CON				(SPM_BASE + 0x9094)
#define DPM3_SSYSPM_CON				(SPM_BASE + 0x9098)
#define EMI0_SSYSPM_CON				(SPM_BASE + 0x909C)
#define EMI1_SSYSPM_CON				(SPM_BASE + 0x90A0)
#define EMI_INFRA_SSYSPM_CON			(SPM_BASE + 0x90A4)
#define SSRSYS_SSYSPM_CON			(SPM_BASE + 0x90A8)
#define SPU_ISE_SSYSPM_CON			(SPM_BASE + 0x90AC)
#define SPU_HWROT_SSYSPM_CON			(SPM_BASE + 0x90B0)
#define VLP_SSYSPM_CON				(SPM_BASE + 0x90B4)
#define HSGMII0_SSYSPM_CON			(SPM_BASE + 0x90B8)
#define HSGMII1_SSYSPM_CON			(SPM_BASE + 0x90BC)
#define MFG_VLP_SSYSPM_CON			(SPM_BASE + 0x90C0)
#define MCUSYS_BUSBLK_SSYSPM_CON		(SPM_BASE + 0x90C4)
#define RSV_0_SSYSPM_CON			(SPM_BASE + 0x90C8)
#define RSV_1_SSYSPM_CON			(SPM_BASE + 0x90CC)
#define CPUEB_SSYSPM_CON			(SPM_BASE + 0x90D0)
#define MFG0_SSYSPM_CON				(SPM_BASE + 0x90D4)
#define BUS_PROTECT_CON				(SPM_BASE + 0x90D8)
#define BUS_PROTECT_CON_SET			(SPM_BASE + 0x90DC)
#define BUS_PROTECT_CON_CLR			(SPM_BASE + 0x90E0)
#define BUS_PROTECT_MSB_CON			(SPM_BASE + 0x90E4)
#define BUS_PROTECT_MSB_CON_SET			(SPM_BASE + 0x90E8)
#define BUS_PROTECT_MSB_CON_CLR			(SPM_BASE + 0x90EC)
#define BUS_PROTECT_CG_CON			(SPM_BASE + 0x90F0)
#define BUS_PROTECT_CG_CON_SET			(SPM_BASE + 0x90F4)
#define BUS_PROTECT_CG_CON_CLR			(SPM_BASE + 0x90F8)
#define BUS_PROTECT_CG_MSB_CON			(SPM_BASE + 0x90FC)
#define ALCO_EN					(SPM_BASE + 0x9100)
#define ALCO_SW_RST				(SPM_BASE + 0x9104)
#define ALCO_CONFIG_0				(SPM_BASE + 0x9108)
#define ALCO_CAND_MUX_SEL			(SPM_BASE + 0x910C)
#define ALCO_SLEEP_SRAM_CON			(SPM_BASE + 0x9110)
#define ALCO_COMP_VAL				(SPM_BASE + 0x9114)
#define ALCO_VCORE_REQ_SEL			(SPM_BASE + 0x9118)
#define ALCO_VCORE_ACK_SEL			(SPM_BASE + 0x911C)
#define ALCO_PMIC_REQ_SEL			(SPM_BASE + 0x9120)
#define ALCO_PMIC_ACK_SEL			(SPM_BASE + 0x9124)
#define ALCO_26M_REQ_SEL			(SPM_BASE + 0x9128)
#define ALCO_26M_ACK_SEL			(SPM_BASE + 0x912C)
#define ALCO_INFRA_REQ_SEL			(SPM_BASE + 0x9130)
#define ALCO_INFRA_ACK_SEL			(SPM_BASE + 0x9134)
#define ALCO_BUSPLL_REQ_SEL			(SPM_BASE + 0x9138)
#define ALCO_BUSPLL_ACK_SEL			(SPM_BASE + 0x913C)
#define ALCO_EMI_REQ_SEL			(SPM_BASE + 0x9140)
#define ALCO_EMI_ACK_SEL			(SPM_BASE + 0x9144)
#define ALCO_APSRC_REQ_SEL			(SPM_BASE + 0x9148)
#define ALCO_APSRC_ACK_SEL			(SPM_BASE + 0x914C)
#define ALCO_DDREN_REQ_SEL			(SPM_BASE + 0x9150)
#define ALCO_DDREN_ACK_SEL			(SPM_BASE + 0x9154)
#define ALCO_MTCMOS_PWR_ON_SEL			(SPM_BASE + 0x9158)
#define ALCO_MTCMOS_PWR_ACK_SEL			(SPM_BASE + 0x915C)
#define ALCO_MON_MODE_0				(SPM_BASE + 0x9160)
#define ALCO_MON_MODE_1				(SPM_BASE + 0x9164)
#define ALCO_BIT_SEQ_0				(SPM_BASE + 0x9168)
#define ALCO_BIT_SEQ_1				(SPM_BASE + 0x916C)
#define ALCO_BIT_EN				(SPM_BASE + 0x9170)
#define ALCO_TIMER_LSB				(SPM_BASE + 0x9174)
#define ALCO_TIMER_MSB				(SPM_BASE + 0x9178)
#define ALCO_TRIG_ADDR				(SPM_BASE + 0x917C)
#define ALCO_STA				(SPM_BASE + 0x9180)
#define ALCO_LEVEL_MAX_TIME			(SPM_BASE + 0x9184)
#define ALCO_RSV_0				(SPM_BASE + 0x9188)
#define ALCO_RSV_1				(SPM_BASE + 0x918C)
#define ALCO_RSV_2				(SPM_BASE + 0x9190)
#define ALCO_RSV_3				(SPM_BASE + 0x9194)
#define ALCO_RSV_4				(SPM_BASE + 0x9198)
#define ALCO_RSV_5				(SPM_BASE + 0x919C)
#define BUS_PROTECT_CG_MSB_CON_SET		(SPM_BASE + 0x9200)
#define BUS_PROTECT_CG_MSB_CON_CLR		(SPM_BASE + 0x9204)
#define BUS_PROTECT_RDY				(SPM_BASE + 0x9208)
#define BUS_PROTECT_RDY_MSB			(SPM_BASE + 0x920C)
#define SPM_RSV_CSOPLU_REQ			(SPM_BASE + 0x9210)
#define SPM_SW_RSV_VCORE_REQ_CON		(SPM_BASE + 0x9214)
#define SPM_SW_RSV_VCORE_REQ_CON_SET		(SPM_BASE + 0x9218)
#define SPM_SW_RSV_VCORE_REQ_CON_CLR		(SPM_BASE + 0x921C)
#define SPM_LTECLKSQ_BG_OFF			(SPM_BASE + 0x9220)
#define PBUS_VCORE_PKT_CTRL			(SPM_BASE + 0x9300)
#define PBUS_VLP_PKT_CTRL			(SPM_BASE + 0x9304)
#define PBUS_VLP_PKT_DATA_0			(SPM_BASE + 0x9310)
#define PBUS_VLP_PKT_DATA_1			(SPM_BASE + 0x9314)
#define PBUS_VLP_PKT_DATA_2			(SPM_BASE + 0x9318)
#define PBUS_VLP_PKT_DATA_3			(SPM_BASE + 0x931C)
#define PBUS_VCORE_PKT_DATA_0			(SPM_BASE + 0x9320)
#define PBUS_VCORE_PKT_DATA_1			(SPM_BASE + 0x9324)
#define PBUS_VCORE_PKT_DATA_2			(SPM_BASE + 0x9328)
#define PBUS_VCORE_PKT_DATA_3			(SPM_BASE + 0x932C)
#define PBUS_VCORE_CTRL				(SPM_BASE + 0x9330)
#define PBUS_VLP_CTRL				(SPM_BASE + 0x9334)
#define PBUS_VCORE_RX_PKT_CTRL			(SPM_BASE + 0x9340)
#define PBUS_VLP_RX_PKT_CTRL			(SPM_BASE + 0x9344)
#define PBUS_VLP_RX_PKT_DATA_0			(SPM_BASE + 0x9350)
#define PBUS_VLP_RX_PKT_DATA_1			(SPM_BASE + 0x9354)
#define PBUS_VLP_RX_PKT_DATA_2			(SPM_BASE + 0x9358)
#define PBUS_VLP_RX_PKT_DATA_3			(SPM_BASE + 0x935C)
#define PBUS_VCORE_RX_PKT_DATA_0		(SPM_BASE + 0x9360)
#define PBUS_VCORE_RX_PKT_DATA_1		(SPM_BASE + 0x9364)
#define PBUS_VCORE_RX_PKT_DATA_2		(SPM_BASE + 0x9368)
#define PBUS_VCORE_RX_PKT_DATA_3		(SPM_BASE + 0x936C)
#define PCM_WDT_LATCH_0				(SPM_BASE + 0x9500)
#define PCM_WDT_LATCH_1				(SPM_BASE + 0x9504)
#define PCM_WDT_LATCH_2				(SPM_BASE + 0x9508)
#define PCM_WDT_LATCH_3				(SPM_BASE + 0x950C)
#define PCM_WDT_LATCH_4				(SPM_BASE + 0x9510)
#define PCM_WDT_LATCH_5				(SPM_BASE + 0x9514)
#define PCM_WDT_LATCH_6				(SPM_BASE + 0x9518)
#define PCM_WDT_LATCH_7				(SPM_BASE + 0x951C)
#define PCM_WDT_LATCH_8				(SPM_BASE + 0x9520)
#define PCM_WDT_LATCH_9				(SPM_BASE + 0x9524)
#define PCM_WDT_LATCH_10			(SPM_BASE + 0x9528)
#define PCM_WDT_LATCH_11			(SPM_BASE + 0x952C)
#define PCM_WDT_LATCH_12			(SPM_BASE + 0x9530)
#define PCM_WDT_LATCH_13			(SPM_BASE + 0x9534)
#define PCM_WDT_LATCH_14			(SPM_BASE + 0x9538)
#define PCM_WDT_LATCH_15			(SPM_BASE + 0x953C)
#define PCM_WDT_LATCH_16			(SPM_BASE + 0x9540)
#define PCM_WDT_LATCH_17			(SPM_BASE + 0x9544)
#define PCM_WDT_LATCH_18			(SPM_BASE + 0x9548)
#define PCM_WDT_LATCH_19			(SPM_BASE + 0x954C)
#define PCM_WDT_LATCH_20			(SPM_BASE + 0x9550)
#define PCM_WDT_LATCH_21			(SPM_BASE + 0x9554)
#define PCM_WDT_LATCH_22			(SPM_BASE + 0x9558)
#define PCM_WDT_LATCH_23			(SPM_BASE + 0x955C)
#define PCM_WDT_LATCH_24			(SPM_BASE + 0x9560)
#define PCM_WDT_LATCH_25			(SPM_BASE + 0x9564)
#define PCM_WDT_LATCH_26			(SPM_BASE + 0x9568)
#define PCM_WDT_LATCH_27			(SPM_BASE + 0x956C)
#define PCM_WDT_LATCH_28			(SPM_BASE + 0x9570)
#define PCM_WDT_LATCH_29			(SPM_BASE + 0x9574)
#define PCM_WDT_LATCH_30			(SPM_BASE + 0x9578)
#define PCM_WDT_LATCH_31			(SPM_BASE + 0x957C)
#define PCM_WDT_LATCH_32			(SPM_BASE + 0x9580)
#define PCM_WDT_LATCH_33			(SPM_BASE + 0x9584)
#define PCM_WDT_LATCH_34			(SPM_BASE + 0x9588)
#define PCM_WDT_LATCH_35			(SPM_BASE + 0x958C)
#define PCM_WDT_LATCH_36			(SPM_BASE + 0x9590)
#define PCM_WDT_LATCH_37			(SPM_BASE + 0x9594)
#define PCM_WDT_LATCH_38			(SPM_BASE + 0x9598)
#define PCM_WDT_LATCH_SPARE_0			(SPM_BASE + 0x959C)
#define PCM_WDT_LATCH_SPARE_1			(SPM_BASE + 0x95A0)
#define PCM_WDT_LATCH_SPARE_2			(SPM_BASE + 0x95A4)
#define PCM_WDT_LATCH_SPARE_3			(SPM_BASE + 0x95A8)
#define PCM_WDT_LATCH_SPARE_4			(SPM_BASE + 0x95AC)
#define PCM_WDT_LATCH_SPARE_5			(SPM_BASE + 0x95B0)
#define PCM_WDT_LATCH_SPARE_6			(SPM_BASE + 0x95B4)
#define PCM_WDT_LATCH_SPARE_7			(SPM_BASE + 0x95B8)
#define PCM_WDT_LATCH_SPARE_8			(SPM_BASE + 0x95BC)
#define PCM_WDT_LATCH_SPARE_9			(SPM_BASE + 0x95C0)
#define DRAMC_GATING_ERR_LATCH_0		(SPM_BASE + 0x95C4)
#define DRAMC_GATING_ERR_LATCH_1		(SPM_BASE + 0x95C8)
#define DRAMC_GATING_ERR_LATCH_2		(SPM_BASE + 0x95CC)
#define DRAMC_GATING_ERR_LATCH_3		(SPM_BASE + 0x95D0)
#define DRAMC_GATING_ERR_LATCH_4		(SPM_BASE + 0x95D4)
#define DRAMC_GATING_ERR_LATCH_5		(SPM_BASE + 0x95D8)
#define DRAMC_GATING_ERR_LATCH_SPARE_0		(SPM_BASE + 0x95DC)
#define SPM_DEBUG_CON				(SPM_BASE + 0x95E0)
#define SPM_ACK_CHK_CON_0			(SPM_BASE + 0x95E4)
#define SPM_ACK_CHK_SEL_0			(SPM_BASE + 0x95E8)
#define SPM_ACK_CHK_TIMER_0			(SPM_BASE + 0x95EC)
#define SPM_ACK_CHK_STA_0			(SPM_BASE + 0x95F0)
#define SPM_ACK_CHK_CON_1			(SPM_BASE + 0x95F4)
#define SPM_ACK_CHK_SEL_1			(SPM_BASE + 0x95F8)
#define SPM_ACK_CHK_TIMER_1			(SPM_BASE + 0x95FC)
#define SPM_ACK_CHK_STA_1			(SPM_BASE + 0x9600)
#define SPM_ACK_CHK_CON_2			(SPM_BASE + 0x9604)
#define SPM_ACK_CHK_SEL_2			(SPM_BASE + 0x9608)
#define SPM_ACK_CHK_TIMER_2			(SPM_BASE + 0x960C)
#define SPM_ACK_CHK_STA_2			(SPM_BASE + 0x9610)
#define SPM_ACK_CHK_CON_3			(SPM_BASE + 0x9614)
#define SPM_ACK_CHK_SEL_3			(SPM_BASE + 0x9618)
#define SPM_ACK_CHK_TIMER_3			(SPM_BASE + 0x961C)
#define SPM_ACK_CHK_STA_3			(SPM_BASE + 0x9620)
#define PCM_APWDT_LATCH_0			(SPM_BASE + 0x9630)
#define PCM_APWDT_LATCH_1			(SPM_BASE + 0x9634)
#define PCM_APWDT_LATCH_2			(SPM_BASE + 0x9638)
#define PCM_APWDT_LATCH_3			(SPM_BASE + 0x963C)
#define PCM_APWDT_LATCH_4			(SPM_BASE + 0x9640)
#define PCM_APWDT_LATCH_5			(SPM_BASE + 0x9644)
#define PCM_APWDT_LATCH_6			(SPM_BASE + 0x9648)
#define PCM_APWDT_LATCH_7			(SPM_BASE + 0x964C)
#define PCM_APWDT_LATCH_8			(SPM_BASE + 0x9650)
#define PCM_APWDT_LATCH_9			(SPM_BASE + 0x9654)
#define PCM_APWDT_LATCH_10			(SPM_BASE + 0x9658)
#define PCM_APWDT_LATCH_11			(SPM_BASE + 0x965C)
#define PCM_APWDT_LATCH_12			(SPM_BASE + 0x9660)
#define PCM_APWDT_LATCH_13			(SPM_BASE + 0x9664)
#define PCM_APWDT_LATCH_14			(SPM_BASE + 0x9668)
#define PCM_APWDT_LATCH_15			(SPM_BASE + 0x966C)
#define PCM_APWDT_LATCH_16			(SPM_BASE + 0x9670)
#define PCM_APWDT_LATCH_17			(SPM_BASE + 0x9674)
#define PCM_APWDT_LATCH_18			(SPM_BASE + 0x9678)
#define PCM_APWDT_LATCH_19			(SPM_BASE + 0x967C)
#define PCM_APWDT_LATCH_20			(SPM_BASE + 0x9680)
#define PCM_APWDT_LATCH_21			(SPM_BASE + 0x9684)
#define PCM_APWDT_LATCH_22			(SPM_BASE + 0x9688)
#define PCM_APWDT_LATCH_23			(SPM_BASE + 0x968C)
#define PCM_APWDT_LATCH_24			(SPM_BASE + 0x9690)
#define PCM_APWDT_LATCH_25			(SPM_BASE + 0x9694)
#define PCM_APWDT_LATCH_26			(SPM_BASE + 0x9698)
#define PCM_APWDT_LATCH_27			(SPM_BASE + 0x96A4)
#define PCM_APWDT_LATCH_28			(SPM_BASE + 0x96A8)
#define PCM_APWDT_LATCH_29			(SPM_BASE + 0x96AC)
#define PCM_APWDT_LATCH_30			(SPM_BASE + 0x96B0)
#define PCM_APWDT_LATCH_31			(SPM_BASE + 0x96B4)
#define PCM_APWDT_LATCH_32			(SPM_BASE + 0x96B8)
#define PCM_APWDT_LATCH_33			(SPM_BASE + 0x96BC)
#define PCM_APWDT_LATCH_34			(SPM_BASE + 0x96C0)
#define PCM_APWDT_LATCH_35			(SPM_BASE + 0x96C4)
#define PCM_APWDT_LATCH_36			(SPM_BASE + 0x96C8)
#define PCM_APWDT_LATCH_37			(SPM_BASE + 0x96CC)
#define PCM_APWDT_LATCH_38			(SPM_BASE + 0x96D0)

#define MODE_SET				0x1002d3d8
#define SET_GPIO_MODE				0x70000000

#define MODE_BACKUP_REG				0x1002d3d0
#define DIR_BACKUP_REG				0x1002d030
#define DOUT_BACKUP_REG				0x1002d130

#define EC_SUSPEND_PIN				38
#define EC_SUSPEND_BK_PIN			111

/* POWERON_CONFIG_EN (0x1C004000+0x0) */
#define BCLK_CG_EN_LSB				BIT(0)
#define PROJECT_CODE_LSB			BIT(16)
#define POWER_ON_VAL0_LSB			BIT(0)
#define POWER_ON_VAL1_LSB			BIT(0)
#define POWER_ON_VAL2_LSB			BIT(0)
#define POWER_ON_VAL3_LSB			BIT(0)
#define PCM_PWR_IO_EN_LSB			BIT(0)
#define PCM_CK_EN_LSB				BIT(2)
#define PCM_SW_RESET_LSB			BIT(15)
#define PCM_CON0_PROJECT_CODE_LSB		BIT(16)
#define REG_SPM_APB_INTERNAL_EN_LSB		BIT(3)
#define REG_PCM_TIMER_EN_LSB			BIT(5)
#define REG_PCM_WDT_EN_LSB			BIT(8)
#define REG_PCM_WDT_WAKE_LSB			BIT(9)
#define REG_SSPM_APB_P2P_EN_LSB			BIT(10)
#define REG_MCUPM_APB_P2P_EN_LSB		BIT(11)
#define REG_RSV_APB_P2P_EN_LSB			BIT(12)
#define RG_PCM_IRQ_MSK_LSB			BIT(15)
#define PCM_CON1_PROJECT_CODE_LSB		BIT(16)
#define REG_SRAM_ISO_ACTIVE_LSB			BIT(0)
#define REG_SRAM_SLP2ISO_TIME_LSB		BIT(8)
#define REG_SPM_SRAM_CTRL_MUX_LSB		BIT(16)
#define REG_SRAM_SLEEP_TIME_LSB			BIT(24)
#define REG_SPM_LOCK_INFRA_DCM_LSB		BIT(0)
#define REG_CXO32K_REMOVE_EN_LSB		BIT(1)
#define REG_SPM_LEAVE_SUSPEND_MERGE_MASK_LSB	BIT(4)
#define REG_SRCLKENO0_SRC_MB_LSB		BIT(8)
#define REG_SRCLKENO1_SRC_MB_LSB		BIT(16)
#define REG_SRCLKENO2_SRC_MB_LSB		BIT(24)
#define SYSCLK_SETTLE_LSB			BIT(0)
#define SPM_SW_RST_CON_LSB			BIT(0)
#define SPM_SW_RST_CON_PROJECT_CODE_LSB		BIT(16)
#define SPM_SW_RST_CON_SET_LSB			BIT(0)
#define SPM_SW_RST_CON_SET_PROJECT_CODE_LSB	BIT(16)
#define SPM_SW_RST_CON_CLR_LSB			BIT(0)
#define SPM_SW_RST_CON_CLR_PROJECT_CODE_LSB	BIT(16)
#define SPM_SEC_READ_MASK_LSB			BIT(0)
#define SPM_ONE_TIME_LOCK_L_LSB			BIT(0)
#define SPM_ONE_TIME_LOCK_M_LSB			BIT(0)
#define SPM_ONE_TIME_LOCK_H_LSB			BIT(0)
#define REG_SSPM_26M_CK_SEL_LSB			BIT(0)
#define REG_SSPM_DCM_EN_LSB			BIT(1)
#define REG_SCP_26M_CK_SEL_LSB			BIT(0)
#define REG_SCP_DCM_EN_LSB			BIT(1)
#define SCP_SECURE_VREQ_MASK_LSB		BIT(2)
#define SCP_SLP_REQ_LSB				BIT(3)
#define SCP_SLP_ACK_LSB				BIT(4)
#define SPM_SWINT_LSB				BIT(0)
#define SPM_SWINT_SET_LSB			BIT(0)
#define SPM_SWINT_CLR_LSB			BIT(0)
#define REG_CPU_WAKEUP_LSB			BIT(0)
#define REG_SPM_IRQ_MASK_LSB			BIT(0)
#define MD32PCM_CTRL0_LSB			BIT(0)
#define MD32PCM_CTRL1_LSB			BIT(0)
#define MD32PCM_CTRL2_LSB			BIT(0)
#define MD32PCM_CTRL3_LSB			BIT(0)
#define MD32PCM_STA0_LSB			BIT(0)
#define PCM_IRQ_LSB				BIT(3)
#define MD32PCM_WAKEUP_STA_LSB			BIT(0)
#define MD32PCM_EVENT_STA_LSB			BIT(0)
#define SRCLKEN_RC_ERR_INT_LSB			BIT(0)
#define SPM_TIMEOUT_WAKEUP_0_LSB		BIT(1)
#define SPM_TIMEOUT_WAKEUP_1_LSB		BIT(2)
#define SPM_TIMEOUT_WAKEUP_2_LSB		BIT(3)
#define DVFSRC_IRQ_LSB				BIT(4)
#define TWAM_IRQ_B_LSB				BIT(5)
#define SPM_ACK_CHK_WAKEUP_0_LSB		BIT(6)
#define SPM_ACK_CHK_WAKEUP_1_LSB		BIT(7)
#define SPM_ACK_CHK_WAKEUP_2_LSB		BIT(8)
#define SPM_ACK_CHK_WAKEUP_3_LSB		BIT(9)
#define SPM_ACK_CHK_WAKEUP_ALL_LSB		BIT(10)
#define VLP_BUS_TIMEOUT_IRQ_LSB			BIT(11)
#define PCM_TIMER_EVENT_LSB			BIT(16)
#define PMIC_EINT_OUT_LSB			BIT(19)
#define PMIC_IRQ_ACK_LSB			BIT(30)
#define PMIC_SCP_IRQ_LSB			BIT(31)
#define PCM_CK_SEL_O_LSB			BIT(0)
#define EXT_SRC_STA_LSB				BIT(4)
#define CK_SLEEP_EN_LSB				BIT(8)
#define SPM_SRAM_CTRL_CK_SEL_LSB		BIT(9)
#define MD32PCM_HALT_LSB			BIT(0)
#define MD32PCM_GATED_LSB			BIT(1)
#define MON_PC_LSB				BIT(0)
#define REG_CSOPLU_EN_CG_SLOW_MODE_LSB		BIT(0)
#define REG_CSOPLU_EN_CG_LEN_LSB		BIT(4)
#define REG_PCM_CSOPLU_RMB_LSB			BIT(16)
#define REG_CSOPLU_ACK_LEN_LSB			BIT(0)
#define SC_REG_UPLOSC_MODE_SEL_LSB		BIT(0)
#define DA_OSC_EN_32K_LSB			BIT(4)
#define CSOPLU_ACK_LSB				BIT(0)
#define SPM_CSOPLU_INTERNAL_ACK_LSB		BIT(16)
#define REG_CSOPLU_RMB_LSB			BIT(0)
#define REG_CSOPLU_ACK_MASK_LSB			BIT(16)
#define SPM_APSRC_REQ_BLOCK_LSB			BIT(0)
#define SPM_DDREN_REQ_BLOCK_LSB			BIT(1)
#define SPM_VRF18_REQ_BLOCK_LSB			BIT(2)
#define SPM_INFRA_REQ_BLOCK_LSB			BIT(3)
#define SPM_EMI_REQ_BLOCK_LSB			BIT(4)
#define SPM_SRCCLKENA_REQ_BLOCK_LSB		BIT(5)
#define SPM_PMIC_REQ_BLOCK_LSB			BIT(6)
#define SPM_VCORE_REQ_BLOCK_LSB			BIT(7)
#define IPS_DVFS_DELTA_LSB			BIT(0)
#define SPM_AXI_CK_EN_LSB			BIT(0)
#define SPM_MEM_SUB_CK_EN_LSB			BIT(1)
#define SPM_IO_NOC_CK_EN_LSB			BIT(2)
#define TOP_CKSYS_RSV_CON_LSB			BIT(3)
#define REG_WFI_OP_LSB				BIT(0)
#define REG_WFI_TYPE_LSB			BIT(1)
#define REG_MP0_CPUTOP_IDLE_MASK_LSB		BIT(2)
#define REG_MP1_CPUTOP_IDLE_MASK_LSB		BIT(3)
#define REG_MCUSYS_IDLE_MASK_LSB		BIT(4)
#define REG_CSYSPWRUP_REQ_MASK_LSB		BIT(5)
#define WFI_AF_SEL_LSB				BIT(16)
#define CPU_SLEEP_WFI_LSB			BIT(31)
#define CPU_WFI_EN_LSB				BIT(0)
#define CPU_WFI_EN_SET_LSB			BIT(0)
#define CPU_WFI_EN_CLR_LSB			BIT(0)
#define EXT_INT_WAKEUP_REQ_LSB			BIT(0)
#define EXT_INT_WAKEUP_REQ_SET_LSB		BIT(0)
#define EXT_INT_WAKEUP_REQ_CLR_LSB		BIT(0)
#define MCUSYS_DDREN_LSB			BIT(0)
#define ARMBUS_IDLE_TO_26M_LSB			BIT(8)
#define MP0_CLUSTER_IDLE_TO_PWR_OFF_LSB		BIT(9)
#define MP0_CPU_IDLE_TO_PWR_OFF_LSB		BIT(16)
#define MP0_SPMC_PWR_ON_ACK_CPU0_LSB		BIT(0)
#define MP0_SPMC_PWR_ON_ACK_CPU1_LSB		BIT(1)
#define MP0_SPMC_PWR_ON_ACK_CPU2_LSB		BIT(2)
#define MP0_SPMC_PWR_ON_ACK_CPU3_LSB		BIT(3)
#define MP0_SPMC_PWR_ON_ACK_CPU4_LSB		BIT(4)
#define MP0_SPMC_PWR_ON_ACK_CPU5_LSB		BIT(5)
#define MP0_SPMC_PWR_ON_ACK_CPU6_LSB		BIT(6)
#define MP0_SPMC_PWR_ON_ACK_CPU7_LSB		BIT(7)
#define MP0_SPMC_PWR_ON_ACK_CPUTOP_LSB		BIT(8)
#define MCUSYS_SPMC_PWR_ON_ACK_LSB		BIT(9)
#define SW2SPM_WAKEUP_LSB			BIT(0)
#define SW2SPM_WAKEUP_SET_LSB			BIT(0)
#define SW2SPM_WAKEUP_CLR_LSB			BIT(0)
#define SW2SPM_MAILBOX_0_LSB			BIT(0)
#define SW2SPM_MAILBOX_1_LSB			BIT(0)
#define SW2SPM_MAILBOX_2_LSB			BIT(0)
#define SW2SPM_MAILBOX_3_LSB			BIT(0)
#define SPM2SW_MAILBOX_0_LSB			BIT(0)
#define SPM2SW_MAILBOX_1_LSB			BIT(0)
#define SPM2SW_MAILBOX_2_LSB			BIT(0)
#define SPM2SW_MAILBOX_3_LSB			BIT(0)
#define CPUEB_STATE_VALID_LSB			BIT(0)
#define REQ_PWR_ON_LSB				BIT(1)
#define REQ_MEM_RET_LSB				BIT(2)
#define RESET_PWR_ON_LSB			BIT(4)
#define RESET_MEM_RET_LSB			BIT(5)
#define CPUEB_STATE_FINISH_ACK_LSB		BIT(31)
#define MCUSYS_D7X_STATUS_LSB			BIT(0)
#define MCUSYS_VCORE_DEBUG_LSB			BIT(1)
#define DPSW_MCUSYS_ISO_LSB			BIT(2)
#define VMCU_VLP_ISO_LSB			BIT(3)
#define AOC_VMCU_SRAM_ISO_DIN_LSB		BIT(4)
#define AOC_VMCU_SRAM_LATCH_ENB_LSB		BIT(5)
#define AOC_VMCU_ANA_ISO_LSB			BIT(6)
#define P2P_TX_STA_LSB				BIT(0)
#define REG_P2P_TX_ERROR_FLAG_EN_LSB		BIT(0)
#define SC_HW_S1_REQ_LSB			BIT(0)
#define SC_HW_S1_WLA_MEMSYS_ACK_LSB		BIT(1)
#define REG_HW_S1_ACK_MASK_LSB			BIT(4)
#define SC_HW_S1_ACK_LSB			BIT(8)
#define SC_DPM2SPM_PST_ACK_LSB			BIT(16)
#define SC_DPM_WFI_STA_LSB			BIT(20)
#define SC_SPM_WLA_MEMSYS_DDREN_REQ_LSB		BIT(24)
#define SC_SPM_WLA_MEMSYS_DDREN_URGENT_LSB	BIT(25)
#define SC_SPM_WLA_MEMSYS_DDREN_ACK_LSB		BIT(28)
#define REG_DPM_WB_EN_LSB			BIT(0)
#define SPM_PWRAP_CON_LSB			BIT(0)
#define SPM_PWRAP_CON_STA_LSB			BIT(0)
#define SPM_PMIC_SPMI_CMD_LSB			BIT(0)
#define SPM_PMIC_SPMI_SLAVEID_LSB		BIT(2)
#define SPM_PMIC_SPMI_PMIFID_LSB		BIT(6)
#define SPM_PMIC_SPMI_DBCNT_LSB			BIT(7)
#define SPM_PWRAP_CMD0_LSB			BIT(0)
#define SPM_PWRAP_CMD1_LSB			BIT(0)
#define SPM_PWRAP_CMD2_LSB			BIT(0)
#define SPM_PWRAP_CMD3_LSB			BIT(0)
#define SPM_PWRAP_CMD4_LSB			BIT(0)
#define SPM_PWRAP_CMD5_LSB			BIT(0)
#define SPM_PWRAP_CMD6_LSB			BIT(0)
#define SPM_PWRAP_CMD7_LSB			BIT(0)
#define SPM_PWRAP_CMD8_LSB			BIT(0)
#define SPM_PWRAP_CMD9_LSB			BIT(0)
#define SPM_PWRAP_CMD10_LSB			BIT(0)
#define SPM_PWRAP_CMD11_LSB			BIT(0)
#define SPM_PWRAP_CMD12_LSB			BIT(0)
#define SPM_PWRAP_CMD13_LSB			BIT(0)
#define SPM_PWRAP_CMD14_LSB			BIT(0)
#define SPM_PWRAP_CMD15_LSB			BIT(0)
#define SPM_PWRAP_CMD16_LSB			BIT(0)
#define SPM_PWRAP_CMD17_LSB			BIT(0)
#define SPM_PWRAP_CMD18_LSB			BIT(0)
#define SPM_PWRAP_CMD19_LSB			BIT(0)
#define SPM_PWRAP_CMD20_LSB			BIT(0)
#define SPM_PWRAP_CMD21_LSB			BIT(0)
#define SPM_PWRAP_CMD22_LSB			BIT(0)
#define SPM_PWRAP_CMD23_LSB			BIT(0)
#define SPM_PWRAP_CMD24_LSB			BIT(0)
#define SPM_PWRAP_CMD25_LSB			BIT(0)
#define SPM_PWRAP_CMD26_LSB			BIT(0)
#define SPM_PWRAP_CMD27_LSB			BIT(0)
#define SPM_PWRAP_CMD28_LSB			BIT(0)
#define SPM_PWRAP_CMD29_LSB			BIT(0)
#define SPM_PWRAP_CMD30_LSB			BIT(0)
#define SPM_PWRAP_CMD31_LSB			BIT(0)
#define DVFSRC_EVENT_LSB			BIT(0)
#define FORCE_DVFS_LEVEL_LSB			BIT(0)
#define TARGET_DVFS_LEVEL_LSB			BIT(0)
#define SPM_EMI_DFS_LEVEL_LSB			BIT(0)
#define SPM_DDR_DFS_LEVEL_LSB			BIT(12)
#define SPM_DVS_LEVEL_LSB			BIT(24)
#define SPM_DVFS_LEVEL_LSB			BIT(0)
#define SPM_DVFS_OPP_LSB			BIT(0)
#define SPM2MM_FORCE_ULTRA_LSB			BIT(0)
#define SPM2MM_DBL_OSTD_ACT_LSB			BIT(1)
#define SPM2MM_ULTRAREQ_LSB			BIT(2)
#define SPM2MD_ULTRAREQ_LSB			BIT(3)
#define SPM2ISP_ULTRAREQ_LSB			BIT(4)
#define SPM2ISP_ULTRAACK_D2T_LSB		BIT(18)
#define SPM2MM_ULTRAACK_D2T_LSB			BIT(19)
#define SPM2MD_ULTRAACK_D2T_LSB			BIT(20)
#define SPM_DVFS_FORCE_ENABLE_LSB		BIT(2)
#define FORCE_DVFS_WAKE_LSB			BIT(3)
#define SPM_DVFSRC_ENABLE_LSB			BIT(4)
#define DVFSRC_WAKEUP_EVENT_MASK_LSB		BIT(6)
#define SPM2RC_EVENT_ABORT_LSB			BIT(7)
#define DVFSRC_LEVEL_ACK_LSB			BIT(8)
#define VSRAM_GEAR_REQ_LSB			BIT(0)
#define VSRAM_GEAR_RDY_LSB			BIT(4)
#define VSRAM_VAL_LEVEL_LSB			BIT(16)
#define SPM_PMIF_VALID_LSB			BIT(0)
#define SPM_PMIF_ACK_LSB			BIT(4)
#define DPSW_VAPU_ISO_LSB			BIT(0)
#define DPSW_VAPU_ISO_SWITCH_LSB		BIT(4)
#define DPSW_VMM_ISO_LSB			BIT(0)
#define DPSW_VMM_ISO_SWITCH_LSB			BIT(4)
#define DPSW_VMD_ISO_LSB			BIT(0)
#define DPSW_VMD_ISO_SWITCH_LSB			BIT(4)
#define DPSW_VMODEM_ISO_LSB			BIT(0)
#define DPSW_VMODEM_ISO_SWITCH_LSB		BIT(4)
#define DPSW_VCORE_ISO_LSB			BIT(0)
#define DPSW_VCORE_ISO_SWITCH_LSB		BIT(4)
#define SPM2DPSW_CTRL_REQ_SOC_LSB		BIT(0)
#define SPM2DPSW_CTRL_REQ_PCIE_0_LSB		BIT(1)
#define SPM2DPSW_CTRL_REQ_PCIE_1_LSB		BIT(2)
#define SPM2DPSW_CTRL_REQ_USB_LSB		BIT(3)
#define SPM2DPSW_CTRL_REQ_CPU_CORE_LSB		BIT(4)
#define SPM2DPSW_CTRL_REQ_MD_LSB		BIT(5)
#define SPM2DPSW_CTRL_ISO_SOC_LSB		BIT(8)
#define SPM2DPSW_CTRL_ISO_PCIE_0_LSB		BIT(9)
#define SPM2DPSW_CTRL_ISO_PCIE_1_LSB		BIT(10)
#define SPM2DPSW_CTRL_ISO_USB_LSB		BIT(11)
#define SPM2DPSW_CTRL_ISO_CPU_CORE_LSB		BIT(12)
#define SPM2DPSW_CTRL_ISO_MD_LSB		BIT(13)
#define DPSW_AOCISO_SOC_LSB			BIT(0)
#define DPSW_AOCISO_VMM_LSB			BIT(1)
#define DPSW_AOCISO_VAPU_LSB			BIT(2)
#define DPSW_AOCISO_MD_LSB			BIT(3)
#define DPSW_AOCSIO_SWITCH_SOC_LSB		BIT(8)
#define DPSW_AOCSIO_SWITCH_VMM_LSB		BIT(9)
#define DPSW_AOCSIO_SWITCH_VAPU_LSB		BIT(10)
#define DPSW_AOCSIO_SWITCH_MD_LSB		BIT(11)
#define DPSW_FORCE_UP_OUT_SOC_LSB		BIT(0)
#define DPSW_FORCE_UP_OUT_PCIE_0_LSB		BIT(1)
#define DPSW_FORCE_UP_OUT_PCIE_1_LSB		BIT(2)
#define DPSW_FORCE_UP_OUT_USB_LSB		BIT(3)
#define DPSW_FORCE_UP_OUT_CPU_CORE_LSB		BIT(4)
#define DPSW_FORCE_UP_OUT_MD_LSB		BIT(5)
#define DPSW_FORCE_DN_OUT_SOC_LSB		BIT(8)
#define DPSW_FORCE_DN_OUT_PCIE_0_LSB		BIT(9)
#define DPSW_FORCE_DN_OUT_PCIE_1_LSB		BIT(10)
#define DPSW_FORCE_DN_OUT_USB_LSB		BIT(11)
#define DPSW_FORCE_DN_OUT_CPU_CORE_LSB		BIT(12)
#define DPSW_FORCE_DN_OUT_MD_LSB		BIT(13)
#define SPM2DPSW_CTRL_VSRAM_ACK_SOC_LSB		BIT(0)
#define SPM2DPSW_CTRL_VSRAM_ACK_PCIE_0_LSB	BIT(1)
#define SPM2DPSW_CTRL_VSRAM_ACK_PCIE_1_LSB	BIT(2)
#define SPM2DPSW_CTRL_VSRAM_ACK_USB_LSB		BIT(3)
#define SPM2DPSW_CTRL_VSRAM_ACK_CPU_CORE_LSB	BIT(4)
#define SPM2DPSW_CTRL_VSRAM_ACK_MD_LSB		BIT(5)
#define SPM2DPSW_CTRL_VLOGIC_ACK_SOC_LSB	BIT(6)
#define SPM2DPSW_CTRL_VLOGIC_ACK_PCIE_0_LSB	BIT(7)
#define SPM2DPSW_CTRL_VLOGIC_ACK_PCIE_1_LSB	BIT(8)
#define SPM2DPSW_CTRL_VLOOGIC_ACK_USB_LSB	BIT(9)
#define SPM2DPSW_CTRL_VLOGIC_ACK_CPU_CORE_LSB	BIT(10)
#define SPM2DPSW_CTRL_VLOGIC_ACK_MD_LSB		BIT(11)
#define CSOPLU_EN_LSB				BIT(0)
#define CSOPLU_RST_LSB				BIT(1)
#define CSOPLU_CG_EN_LSB			BIT(2)
#define CSOPLU_CLK_SEL_LSB			BIT(3)
#define AP_MDSMSRC_REQ_LSB			BIT(0)
#define AP_L1SMSRC_REQ_LSB			BIT(1)
#define AP2MD_PEER_WAKEUP_LSB			BIT(3)
#define AP_MDSMSRC_ACK_LSB			BIT(4)
#define AP_L1SMSRC_ACK_LSB			BIT(5)
#define SPM2MD_SWITCH_CTRL_LSB			BIT(0)
#define SPM_AP_26M_RDY_LSB			BIT(0)
#define SPM2RC_DMY_CTRL_LSB			BIT(2)
#define RC2SPM_SRCCLKENO_0_ACK_LSB		BIT(16)
#define SPM2GPUEB_SW_RST_B_LSB			BIT(0)
#define SPM2GPUEB_SW_INT_LSB			BIT(1)
#define SC_MFG_PLL_EN_LSB			BIT(4)
#define GPUEB_WFI_LSB				BIT(16)
#define RPC_SRAM_CTRL_MUX_SEL_LSB		BIT(0)
#define APU_VCORE_OFF_ISO_EN_LSB		BIT(1)
#define APU_ARE_REQ_LSB				BIT(4)
#define APU_ARE_ACK_LSB				BIT(8)
#define APU_ACTIVE_STATE_LSB			BIT(9)
#define APU_AOV_WAKEUP_LSB			BIT(16)
#define AOC_EFUSE_EN_LSB			BIT(0)
#define AOC_EFUSE_RESTORE_RDY_LSB		BIT(1)
#define DFD_SOC_MTCMOS_ACK_LSB			BIT(0)
#define DFD_SOC_MTCMOS_REQ_LSB			BIT(1)
#define SC_UNIVPLL_EN_LSB			BIT(0)
#define SC_MMPLL_EN_LSB				BIT(1)
#define SC_RSV_PLL_EN_LSB			BIT(2)
#define APU_26M_CLK_EN_LSB			BIT(16)
#define IFR_26M_CLK_EN_LSB			BIT(17)
#define VLP_26M2CSOPLU_EN_LSB			BIT(18)
#define SC_RSV_CLK_EN_LSB			BIT(20)
#define EMI_SLB_MODE_MASK_LSB			BIT(0)
#define SPM2EMI_SLP_PROT_EN_LSB			BIT(1)
#define SPM2EMI_SLP_PROT_SRC_LSB		BIT(2)
#define EMI_DRAMC_MD32_SLEEP_IDLE_LSB		BIT(4)
#define EMI_SLB_ONLY_MODE_LSB			BIT(8)
#define SPM2SLC_SLP_LSB				BIT(10)
#define SPM2SLC_SLP_DLY_LSB			BIT(12)
#define SPM_SUSPEND_RESUME_FLAG_LSB		BIT(0)
#define SPM2PMSR_DRAMC_S0_FLAG_LSB		BIT(0)
#define SPM2PMSR_SYSTEM_POWER_STATE_LSB		BIT(4)
#define SPM_CKSYS_RTFF_DIVIDER_RST_LSB		BIT(0)
#define SPM_32K_VCORE_CLK_EN_LSB		BIT(1)
#define SPM_CSOPLU_VCORE_CLK_EN_LSB		BIT(2)
#define SPM2EMI_SHF_REQ_LSB			BIT(0)
#define SPM2EMI_SHF_REQ_ACK_LSB			BIT(4)
#define SPM_CIRQ_BYPASS_MODE_EN_LSB		BIT(0)
#define AOC_VCORE_SRAM_PDN_EN_LSB		BIT(0)
#define AOC_VCORE_SRAM_PDN_SHIFT_LSB		BIT(1)
#define SPM2EMI_PDN_REQ_LSB			BIT(0)
#define SPM2EMI_PDN_RDY_LSB			BIT(4)
#define VLP_RTFF_CTRL_MASK_LSB			BIT(0)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_0_LSB	BIT(0)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_1_LSB	BIT(0)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_2_LSB	BIT(0)
#define REG_MODULE_SW_CG_DDREN_REQ_MASK_3_LSB	BIT(0)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_0_LSB	BIT(0)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_1_LS	BIT(0)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_2_LSB	BIT(0)
#define REG_MODULE_SW_CG_VRF18_REQ_MASK_3_LSB	BIT(0)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_0_LSB	BIT(0)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_1_LSB	BIT(0)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_2_LSB	BIT(0)
#define REG_MODULE_SW_CG_INFRA_REQ_MASK_3_LSB	BIT(0)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_0_LSB	BIT(0)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_1_LSB	BIT(0)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_2_LSB	BIT(0)
#define REG_MODULE_SW_CG_F26M_REQ_MASK_3_LSB	BIT(0)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_0_LSB	BIT(0)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_1_LSB	BIT(0)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_2_LSB	BIT(0)
#define REG_MODULE_SW_CG_VCORE_REQ_MASK_3_LSB	BIT(0)
#define REG_PWR_STATUS_DDREN_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_VRF18_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_INFRA_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_F26M_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_PMIC_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_VCORE_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_DDREN_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_VRF18_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_INFRA_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_F26M_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_PMIC_REQ_MASK_LSB	BIT(0)
#define REG_PWR_STATUS_MSB_VCORE_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_DDREN_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_VRF18_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_INFRA_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_F26M_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_PMIC_REQ_MASK_LSB	BIT(0)
#define REG_MODULE_BUSY_VCORE_REQ_MASK_LSB	BIT(0)
#define SYS_TIMER_START_EN_LSB			BIT(0)
#define SYS_TIMER_LATCH_EN_LSB			BIT(1)
#define SYS_TIMER_ID_LSB			BIT(8)
#define SYS_TIMER_VALID_LSB			BIT(31)
#define SYS_TIMER_VALUE_L_LSB			BIT(0)
#define SYS_TIMER_VALUE_H_LSB			BIT(0)
#define SYS_TIMER_START_L_LSB			BIT(0)
#define SYS_TIMER_START_H_LSB			BIT(0)
#define SYS_TIMER_LATCH_L_00_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_00_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_01_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_01_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_02_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_02_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_03_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_03_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_04_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_04_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_05_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_05_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_06_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_06_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_07_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_07_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_08_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_08_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_09_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_09_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_10_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_10_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_11_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_11_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_12_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_12_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_13_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_13_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_14_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_14_LSB		BIT(0)
#define SYS_TIMER_LATCH_L_15_LSB		BIT(0)
#define SYS_TIMER_LATCH_H_15_LSB		BIT(0)
#define REG_PCM_TIMER_VAL_LSB			BIT(0)
#define PCM_TIMER_LSB				BIT(0)
#define SPM_COUNTER_VAL_0_LSB			BIT(0)
#define SPM_COUNTER_OUT_0_LSB			BIT(14)
#define SPM_COUNTER_EN_0_LSB			BIT(28)
#define SPM_COUNTER_CLR_0_LSB			BIT(29)
#define SPM_COUNTER_TIMEOUT_0_LSB		BIT(30)
#define SPM_COUNTER_WAKEUP_EN_0_LSB		BIT(31)
#define SPM_COUNTER_VAL_1_LSB			BIT(0)
#define SPM_COUNTER_OUT_1_LSB			BIT(14)
#define SPM_COUNTER_EN_1_LSB			BIT(28)
#define SPM_COUNTER_CLR_1_LSB			BIT(29)
#define SPM_COUNTER_TIMEOUT_1_LSB		BIT(30)
#define SPM_COUNTER_WAKEUP_EN_1_LSB		BIT(31)
#define SPM_COUNTER_VAL_2_LSB			BIT(0)
#define SPM_COUNTER_OUT_2_LSB			BIT(14)
#define SPM_COUNTER_EN_2_LSB			BIT(28)
#define SPM_COUNTER_CLR_2_LSB			BIT(29)
#define SPM_COUNTER_TIMEOUT_2_LSB		BIT(30)
#define SPM_COUNTER_WAKEUP_EN_2_LSB		BIT(31)
#define REG_PCM_WDT_VAL_LSB			BIT(0)
#define PCM_WDT_TIMER_VAL_OUT_LSB		BIT(0)
#define SPM_SW_FLAG_LSB				BIT(0)
#define SPM_SW_DEBUG_0_LSB			BIT(0)
#define SPM_SW_FLAG_1_LSB			BIT(0)
#define SPM_SW_DEBUG_1_LSB			BIT(0)
#define SPM_SW_RSV_0_LSB			BIT(0)
#define SPM_SW_RSV_1_LSB			BIT(0)
#define SPM_SW_RSV_2_LSB			BIT(0)
#define SPM_SW_RSV_3_LSB			BIT(0)
#define SPM_SW_RSV_4_LSB			BIT(0)
#define SPM_SW_RSV_5_LSB			BIT(0)
#define SPM_SW_RSV_6_LSB			BIT(0)
#define SPM_SW_RSV_7_LSB			BIT(0)
#define SPM_SW_RSV_8_LSB			BIT(0)
#define SPM_BK_WAKE_EVENT_LSB			BIT(0)
#define SPM_BK_VTCXO_DUR_LSB			BIT(0)
#define SPM_BK_WAKE_MISC_LSB			BIT(0)
#define SPM_BK_PCM_TIMER_LSB			BIT(0)
#define SPM_RSV_CON_0_LSB			BIT(0)
#define SPM_RSV_CON_1_LSB			BIT(0)
#define SPM_RSV_STA_0_LSB			BIT(0)
#define SPM_RSV_STA_1_LSB			BIT(0)
#define SPM_SPARE_CON_LSB			BIT(0)
#define SPM_SPARE_CON_SET_LSB			BIT(0)
#define SPM_SPARE_CON_CLR_LSB			BIT(0)
#define SPM_M0_CROSS_WAKE_REQ_LSB		BIT(0)
#define SPM_CROSS_WAKE_M0_CHK_LSB		BIT(4)
#define SPM_M1_CROSS_WAKE_REQ_LSB		BIT(0)
#define SPM_CROSS_WAKE_M1_CHK_LSB		BIT(4)
#define SPM_M2_CROSS_WAKE_REQ_LSB		BIT(0)
#define SPM_CROSS_WAKE_M2_CHK_LSB		BIT(4)
#define SPM_M3_CROSS_WAKE_REQ_LSB		BIT(0)
#define SPM_CROSS_WAKE_M3_CHK_LSB		BIT(4)
#define SCP_VCORE_LEVEL_LSB			BIT(0)
#define SPM_DDREN_ACK_SEL_OTHERS_LSB		BIT(0)
#define SPM_DDREN_ACK_SEL_MCU_LSB		BIT(1)
#define SPM_DDREN_ACK_SEL_WLA_MEMSYS_LSB	BIT(2)
#define SPM_SW_FLAG_2_LSB			BIT(0)
#define SPM_SW_DEBUG_2_LSB			BIT(0)
#define SPM_DV_CON_0_LSB			BIT(0)
#define SPM_DV_CON_1_LSB			BIT(0)
#define SPM_SEMA_M0_LSB				BIT(0)
#define SPM_SEMA_M1_LSB				BIT(0)
#define SPM_SEMA_M2_LSB				BIT(0)
#define SPM_SEMA_M3_LSB				BIT(0)
#define SPM_SEMA_M4_LSB				BIT(0)
#define SPM_SEMA_M5_LSB				BIT(0)
#define SPM_SEMA_M6_LSB				BIT(0)
#define SPM_SEMA_M7_LSB				BIT(0)
#define SPM2ADSP_MAILBOX_LSB			BIT(0)
#define ADSP2SPM_MAILBOX_LSB			BIT(0)
#define SPM2PMCU_MAILBOX_0_LSB			BIT(0)
#define SPM2PMCU_MAILBOX_1_LSB			BIT(0)
#define SPM2PMCU_MAILBOX_2_LSB			BIT(0)
#define SPM2PMCU_MAILBOX_3_LSB			BIT(0)
#define PMCU2SPM_MAILBOX_0_LSB			BIT(0)
#define PMCU2SPM_MAILBOX_1_LSB			BIT(0)
#define PMCU2SPM_MAILBOX_2_LSB			BIT(0)
#define PMCU2SPM_MAILBOX_3_LSB			BIT(0)
#define SPM_SCP_MAILBOX_LSB			BIT(0)
#define SCP_SPM_MAILBOX_LSB			BIT(0)
#define SCP_AOV_BUS_REQ_LSB			BIT(0)
#define SCP_AOV_BUS_ACK_LSB			BIT(8)
#define VCORE_RTFF_CTRL_MASK_LSB		BIT(0)
#define SPM_SRAM_SRCLKENO_MASK_LSB		BIT(0)
#define SPM_WAKEUP_EVENT_L_LSB			BIT(0)
#define EXT_WAKEUP_EVENT_LSB			BIT(0)
#define REG_WAKEUP_EVENT_MASK_LSB		BIT(0)
#define REG_EXT_WAKEUP_EVENT_MASK_LSB		BIT(0)
#define REG_WAKEUP_EVENT_SENS_LSB		BIT(0)
#define REG_WAKEUP_EVENT_CLR_LSB		BIT(0)
#define REG_SPM_ADSP_MAILBOX_REQ_LSB		BIT(0)
#define REG_SPM_APSRC_REQ_LSB			BIT(1)
#define REG_SPM_DDREN_REQ_LSB			BIT(2)
#define REG_SPM_DVFS_REQ_LSB			BIT(3)
#define REG_SPM_EMI_REQ_LSB			BIT(4)
#define REG_SPM_F26M_REQ_LSB			BIT(5)
#define REG_SPM_INFRA_REQ_LSB			BIT(6)
#define REG_SPM_PMIC_REQ_LSB			BIT(7)
#define REG_SPM_SCP_MAILBOX_REQ_LSB		BIT(8)
#define REG_SPM_SSPM_MAILBOX_REQ_LSB		BIT(9)
#define REG_SPM_SW_MAILBOX_REQ_LSB		BIT(10)
#define REG_SPM_VCORE_REQ_LSB			BIT(11)
#define REG_SPM_VRF18_REQ_LSB			BIT(12)
#define ADSP_MAILBOX_STATE_LSB			BIT(16)
#define APSRC_STATE_LSB				BIT(17)
#define DDREN_STATE_LSB				BIT(18)
#define DVFS_STATE_LSB				BIT(19)
#define EMI_STATE_LSB				BIT(20)
#define F26M_STATE_LSB				BIT(21)
#define INFRA_STATE_LSB				BIT(22)
#define PMIC_STATE_LSB				BIT(23)
#define SCP_MAILBOX_STATE_LSB			BIT(24)
#define SSPM_MAILBOX_STATE_LSB			BIT(25)
#define SW_MAILBOX_STATE_LSB			BIT(26)
#define VCORE_STATE_LSB				BIT(27)
#define VRF18_STATE_LSB				BIT(28)
#define REG_APIFR_APSRC_RMB_LSB			BIT(0)
#define REG_APIFR_DDREN_RMB_LSB			BIT(1)
#define REG_APIFR_EMI_RMB_LSB			BIT(2)
#define REG_APIFR_INFRA_RMB_LSB			BIT(3)
#define REG_APIFR_PMIC_RMB_LSB			BIT(4)
#define REG_APIFR_SRCCLKENA_MB_LSB		BIT(5)
#define REG_APIFR_VCORE_RMB_LSB			BIT(6)
#define REG_APIFR_VRF18_RMB_LSB			BIT(7)
#define REG_APU_APSRC_RMB_LSB			BIT(8)
#define REG_APU_DDREN_RMB_LSB			BIT(9)
#define REG_APU_EMI_RMB_LSB			BIT(10)
#define REG_APU_INFRA_RMB_LSB			BIT(11)
#define REG_APU_PMIC_RMB_LSB			BIT(12)
#define REG_APU_SRCCLKENA_MB_LSB		BIT(13)
#define REG_APU_VCORE_RMB_LSB			BIT(14)
#define REG_APU_VRF18_RMB_LSB			BIT(15)
#define REG_AUDIO_APSRC_RMB_LSB			BIT(16)
#define REG_AUDIO_DDREN_RMB_LSB			BIT(17)
#define REG_AUDIO_EMI_RMB_LSB			BIT(18)
#define REG_AUDIO_INFRA_RMB_LSB			BIT(19)
#define REG_AUDIO_PMIC_RMB_LSB			BIT(20)
#define REG_AUDIO_SRCCLKENA_MB_LSB		BIT(21)
#define REG_AUDIO_VCORE_RMB_LSB			BIT(22)
#define REG_AUDIO_VRF18_RMB_LSB			BIT(23)
#define REG_AUDIO_DSP_APSRC_RMB_LSB		BIT(0)
#define REG_AUDIO_DSP_DDREN_RMB_LSB		BIT(1)
#define REG_AUDIO_DSP_EMI_RMB_LSB		BIT(2)
#define REG_AUDIO_DSP_INFRA_RMB_LSB		BIT(3)
#define REG_AUDIO_DSP_PMIC_RMB_LSB		BIT(4)
#define REG_AUDIO_DSP_SRCCLKENA_MB_LSB		BIT(5)
#define REG_AUDIO_DSP_VCORE_RMB_LSB		BIT(6)
#define REG_AUDIO_DSP_VRF18_RMB_LSB		BIT(7)
#define REG_CAM_APSRC_RMB_LSB			BIT(8)
#define REG_CAM_DDREN_RMB_LSB			BIT(9)
#define REG_CAM_EMI_RMB_LSB			BIT(10)
#define REG_CAM_INFRA_RMB_LSB			BIT(11)
#define REG_CAM_PMIC_RMB_LSB			BIT(12)
#define REG_CAM_SRCCLKENA_MB_LSB		BIT(13)
#define REG_CAM_VRF18_RMB_LSB			BIT(14)
#define REG_CCIF_APSRC_RMB_LSB			BIT(15)
#define REG_CCIF_EMI_RMB_LSB			BIT(0)
#define REG_CCIF_INFRA_RMB_LSB			BIT(12)
#define REG_CCIF_PMIC_RMB_LSB			BIT(0)
#define REG_CCIF_SRCCLKENA_MB_LSB		BIT(12)
#define REG_CCIF_VCORE_RMB_LSB			BIT(0)
#define REG_CCIF_VRF18_RMB_LSB			BIT(12)
#define REG_CCU_APSRC_RMB_LSB			BIT(24)
#define REG_CCU_DDREN_RMB_LSB			BIT(25)
#define REG_CCU_EMI_RMB_LSB			BIT(26)
#define REG_CCU_INFRA_RMB_LSB			BIT(27)
#define REG_CCU_PMIC_RMB_LSB			BIT(28)
#define REG_CCU_SRCCLKENA_MB_LSB		BIT(29)
#define REG_CCU_VRF18_RMB_LSB			BIT(30)
#define REG_CG_CHECK_APSRC_RMB_LSB		BIT(31)
#define REG_CG_CHECK_DDREN_RMB_LSB		BIT(0)
#define REG_CG_CHECK_EMI_RMB_LSB		BIT(1)
#define REG_CG_CHECK_INFRA_RMB_LSB		BIT(2)
#define REG_CG_CHECK_PMIC_RMB_LSB		BIT(3)
#define REG_CG_CHECK_SRCCLKENA_MB_LS		BIT(4)
#define REG_CG_CHECK_VCORE_RMB_LSB		BIT(5)
#define REG_CG_CHECK_VRF18_RMB_LSB		BIT(6)
#define REG_CKSYS_APSRC_RMB_LSB			BIT(7)
#define REG_CKSYS_DDREN_RMB_LSB			BIT(8)
#define REG_CKSYS_EMI_RMB_LSB			BIT(9)
#define REG_CKSYS_INFRA_RMB_LSB			BIT(10)
#define REG_CKSYS_PMIC_RMB_LSB			BIT(11)
#define REG_CKSYS_SRCCLKENA_MB_LSB		BIT(12)
#define REG_CKSYS_VCORE_RMB_LSB			BIT(13)
#define REG_CKSYS_VRF18_RMB_LSB			BIT(14)
#define REG_CKSYS_1_APSRC_RMB_LSB		BIT(15)
#define REG_CKSYS_1_DDREN_RMB_LSB		BIT(16)
#define REG_CKSYS_1_EMI_RMB_LSB			BIT(17)
#define REG_CKSYS_1_INFRA_RMB_LSB		BIT(18)
#define REG_CKSYS_1_PMIC_RMB_LSB		BIT(19)
#define REG_CKSYS_1_SRCCLKENA_MB_LSB		BIT(20)
#define REG_CKSYS_1_VCORE_RMB_LSB		BIT(21)
#define REG_CKSYS_1_VRF18_RMB_LSB		BIT(22)
#define REG_CKSYS_2_APSRC_RMB_LSB		BIT(0)
#define REG_CKSYS_2_DDREN_RMB_LSB		BIT(1)
#define REG_CKSYS_2_EMI_RMB_LSB			BIT(2)
#define REG_CKSYS_2_INFRA_RMB_LSB		BIT(3)
#define REG_CKSYS_2_PMIC_RMB_LSB		BIT(4)
#define REG_CKSYS_2_SRCCLKENA_MB_LSB		BIT(5)
#define REG_CKSYS_2_VCORE_RMB_LSB		BIT(6)
#define REG_CKSYS_2_VRF18_RMB_LSB		BIT(7)
#define REG_CONN_APSRC_RMB_LSB			BIT(8)
#define REG_CONN_DDREN_RMB_LSB			BIT(9)
#define REG_CONN_EMI_RMB_LSB			BIT(10)
#define REG_CONN_INFRA_RMB_LSB			BIT(11)
#define REG_CONN_PMIC_RMB_LSB			BIT(12)
#define REG_CONN_SRCCLKENA_MB_LSB		BIT(13)
#define REG_CONN_SRCCLKENB_MB_LSB		BIT(14)
#define REG_CONN_VCORE_RMB_LSB			BIT(15)
#define REG_CONN_VRF18_RMB_LSB			BIT(16)
#define REG_CORECFG_APSRC_RMB_LSB		BIT(17)
#define REG_CORECFG_DDREN_RMB_LSB		BIT(18)
#define REG_CORECFG_EMI_RMB_LSB			BIT(19)
#define REG_CORECFG_INFRA_RMB_LSB		BIT(20)
#define REG_CORECFG_PMIC_RMB_LSB		BIT(21)
#define REG_CORECFG_SRCCLKENA_MB_LSB		BIT(22)
#define REG_CORECFG_VCORE_RMB_LSB		BIT(23)
#define REG_CORECFG_VRF18_RMB_LSB		BIT(24)
#define REG_CPUEB_APSRC_RMB_LSB			BIT(0)
#define REG_CPUEB_DDREN_RMB_LSB			BIT(1)
#define REG_CPUEB_EMI_RMB_LSB			BIT(2)
#define REG_CPUEB_INFRA_RMB_LSB			BIT(3)
#define REG_CPUEB_PMIC_RMB_LSB			BIT(4)
#define REG_CPUEB_SRCCLKENA_MB_LSB		BIT(5)
#define REG_CPUEB_VCORE_RMB_LSB			BIT(6)
#define REG_CPUEB_VRF18_RMB_LSB			BIT(7)
#define REG_DISP0_APSRC_RMB_LSB			BIT(8)
#define REG_DISP0_DDREN_RMB_LSB			BIT(9)
#define REG_DISP0_EMI_RMB_LSB			BIT(10)
#define REG_DISP0_INFRA_RMB_LSB			BIT(11)
#define REG_DISP0_PMIC_RMB_LSB			BIT(12)
#define REG_DISP0_SRCCLKENA_MB_LSB		BIT(13)
#define REG_DISP0_VRF18_RMB_LSB			BIT(14)
#define REG_DISP1_APSRC_RMB_LSB			BIT(15)
#define REG_DISP1_DDREN_RMB_LSB			BIT(16)
#define REG_DISP1_EMI_RMB_LSB			BIT(17)
#define REG_DISP1_INFRA_RMB_LSB			BIT(18)
#define REG_DISP1_PMIC_RMB_LSB			BIT(19)
#define REG_DISP1_SRCCLKENA_MB_LSB		BIT(20)
#define REG_DISP1_VRF18_RMB_LSB			BIT(21)
#define REG_DPM_APSRC_RMB_LSB			BIT(22)
#define REG_DPM_DDREN_RMB_LSB			BIT(26)
#define REG_DPM_EMI_RMB_LSB			BIT(0)
#define REG_DPM_INFRA_RMB_LSB			BIT(4)
#define REG_DPM_PMIC_RMB_LSB			BIT(8)
#define REG_DPM_SRCCLKENA_MB_LSB		BIT(12)
#define REG_DPM_VCORE_RMB_LSB			BIT(16)
#define REG_DPM_VRF18_RMB_LSB			BIT(20)
#define REG_DPMAIF_APSRC_RMB_LSB		BIT(24)
#define REG_DPMAIF_DDREN_RMB_LSB		BIT(25)
#define REG_DPMAIF_EMI_RMB_LSB			BIT(26)
#define REG_DPMAIF_INFRA_RMB_LSB		BIT(27)
#define REG_DPMAIF_PMIC_RMB_LSB			BIT(28)
#define REG_DPMAIF_SRCCLKENA_MB_LSB		BIT(29)
#define REG_DPMAIF_VCORE_RMB_LSB		BIT(30)
#define REG_DPMAIF_VRF18_RMB_LSB		BIT(31)
#define REG_DVFSRC_LEVEL_RMB_LSB		BIT(0)
#define REG_EMISYS_APSRC_RMB_LSB		BIT(1)
#define REG_EMISYS_DDREN_RMB_LSB		BIT(2)
#define REG_EMISYS_EMI_RMB_LSB			BIT(3)
#define REG_EMISYS_INFRA_RMB_LSB		BIT(4)
#define REG_EMISYS_PMIC_RMB_LSB			BIT(5)
#define REG_EMISYS_SRCCLKENA_MB_LSB		BIT(6)
#define REG_EMISYS_VCORE_RMB_LSB		BIT(7)
#define REG_EMISYS_VRF18_RMB_LSB		BIT(8)
#define REG_GCE_APSRC_RMB_LSB			BIT(9)
#define REG_GCE_DDREN_RMB_LSB			BIT(10)
#define REG_GCE_EMI_RMB_LSB			BIT(11)
#define REG_GCE_INFRA_RMB_LSB			BIT(12)
#define REG_GCE_PMIC_RMB_LSB			BIT(13)
#define REG_GCE_SRCCLKENA_MB_LSB		BIT(14)
#define REG_GCE_VCORE_RMB_LSB			BIT(15)
#define REG_GCE_VRF18_RMB_LSB			BIT(16)
#define REG_GPUEB_APSRC_RMB_LSB			BIT(17)
#define REG_GPUEB_DDREN_RMB_LSB			BIT(18)
#define REG_GPUEB_EMI_RMB_LSB			BIT(19)
#define REG_GPUEB_INFRA_RMB_LSB			BIT(20)
#define REG_GPUEB_PMIC_RMB_LSB			BIT(21)
#define REG_GPUEB_SRCCLKENA_MB_LSB		BIT(22)
#define REG_GPUEB_VCORE_RMB_LSB			BIT(23)
#define REG_GPUEB_VRF18_RMB_LSB			BIT(24)
#define REG_HWCCF_APSRC_RMB_LSB			BIT(25)
#define REG_HWCCF_DDREN_RMB_LSB			BIT(26)
#define REG_HWCCF_EMI_RMB_LSB			BIT(27)
#define REG_HWCCF_INFRA_RMB_LSB			BIT(28)
#define REG_HWCCF_PMIC_RMB_LSB			BIT(29)
#define REG_HWCCF_SRCCLKENA_MB_LSB		BIT(30)
#define REG_HWCCF_VCORE_RMB_LSB			BIT(31)
#define REG_HWCCF_VRF18_RMB_LSB			BIT(0)
#define REG_IMG_APSRC_RMB_LSB			BIT(1)
#define REG_IMG_DDREN_RMB_LSB			BIT(2)
#define REG_IMG_EMI_RMB_LSB			BIT(3)
#define REG_IMG_INFRA_RMB_LSB			BIT(4)
#define REG_IMG_PMIC_RMB_LSB			BIT(5)
#define REG_IMG_SRCCLKENA_MB_LSB		BIT(6)
#define REG_IMG_VRF18_RMB_LSB			BIT(7)
#define REG_INFRASYS_APSRC_RMB_LSB		BIT(8)
#define REG_INFRASYS_DDREN_RMB_LSB		BIT(9)
#define REG_INFRASYS_EMI_RMB_LSB		BIT(10)
#define REG_INFRASYS_INFRA_RMB_LSB		BIT(11)
#define REG_INFRASYS_PMIC_RMB_LSB		BIT(12)
#define REG_INFRASYS_SRCCLKENA_MB_LSB		BIT(13)
#define REG_INFRASYS_VCORE_RMB_LSB		BIT(14)
#define REG_INFRASYS_VRF18_RMB_LSB		BIT(15)
#define REG_IPIC_INFRA_RMB_LSB			BIT(16)
#define REG_IPIC_VRF18_RMB_LSB			BIT(17)
#define REG_MCU_APSRC_RMB_LSB			BIT(18)
#define REG_MCU_DDREN_RMB_LSB			BIT(19)
#define REG_MCU_EMI_RMB_LSB			BIT(20)
#define REG_MCU_INFRA_RMB_LSB			BIT(21)
#define REG_MCU_PMIC_RMB_LSB			BIT(22)
#define REG_MCU_SRCCLKENA_MB_LSB		BIT(23)
#define REG_MCU_VCORE_RMB_LSB			BIT(24)
#define REG_MCU_VRF18_RMB_LSB			BIT(25)
#define REG_MD_APSRC_RMB_LSB			BIT(26)
#define REG_MD_DDREN_RMB_LSB			BIT(27)
#define REG_MD_EMI_RMB_LSB			BIT(28)
#define REG_MD_INFRA_RMB_LSB			BIT(29)
#define REG_MD_PMIC_RMB_LSB			BIT(30)
#define REG_MD_SRCCLKENA_MB_LSB			BIT(31)
#define REG_MD_SRCCLKENA1_MB_LSB		BIT(0)
#define REG_MD_VCORE_RMB_LSB			BIT(1)
#define REG_MD_VRF18_RMB_LSB			BIT(2)
#define REG_MM_PROC_APSRC_RMB_LSB		BIT(3)
#define REG_MM_PROC_DDREN_RMB_LSB		BIT(4)
#define REG_MM_PROC_EMI_RMB_LSB			BIT(5)
#define REG_MM_PROC_INFRA_RMB_LSB		BIT(6)
#define REG_MM_PROC_PMIC_RMB_LSB		BIT(7)
#define REG_MM_PROC_SRCCLKENA_MB_LSB		BIT(8)
#define REG_MM_PROC_VCORE_RMB_LSB		BIT(9)
#define REG_MM_PROC_VRF18_RMB_LSB		BIT(10)
#define REG_MML0_APSRC_RMB_LSB			BIT(11)
#define REG_MML0_DDREN_RMB_LSB			BIT(12)
#define REG_MML0_EMI_RMB_LSB			BIT(13)
#define REG_MML0_INFRA_RMB_LSB			BIT(14)
#define REG_MML0_PMIC_RMB_LSB			BIT(15)
#define REG_MML0_SRCCLKENA_MB_LSB		BIT(16)
#define REG_MML0_VRF18_RMB_LSB			BIT(17)
#define REG_MML1_APSRC_RMB_LSB			BIT(18)
#define REG_MML1_DDREN_RMB_LSB			BIT(19)
#define REG_MML1_EMI_RMB_LSB			BIT(20)
#define REG_MML1_INFRA_RMB_LSB			BIT(21)
#define REG_MML1_PMIC_RMB_LSB			BIT(22)
#define REG_MML1_SRCCLKENA_MB_LSB		BIT(23)
#define REG_MML1_VRF18_RMB_LSB			BIT(24)
#define REG_OVL0_APSRC_RMB_LSB			BIT(25)
#define REG_OVL0_DDREN_RMB_LSB			BIT(26)
#define REG_OVL0_EMI_RMB_LSB			BIT(27)
#define REG_OVL0_INFRA_RMB_LSB			BIT(28)
#define REG_OVL0_PMIC_RMB_LSB			BIT(29)
#define REG_OVL0_SRCCLKENA_MB_LSB		BIT(30)
#define REG_OVL0_VRF18_RMB_LSB			BIT(31)
#define REG_OVL1_APSRC_RMB_LSB			BIT(0)
#define REG_OVL1_DDREN_RMB_LSB			BIT(1)
#define REG_OVL1_EMI_RMB_LSB			BIT(2)
#define REG_OVL1_INFRA_RMB_LSB			BIT(3)
#define REG_OVL1_PMIC_RMB_LSB			BIT(4)
#define REG_OVL1_SRCCLKENA_MB_LSB		BIT(5)
#define REG_OVL1_VRF18_RMB_LSB			BIT(6)
#define REG_PCIE0_APSRC_RMB_LSB			BIT(7)
#define REG_PCIE0_DDREN_RMB_LSB			BIT(8)
#define REG_PCIE0_EMI_RMB_LSB			BIT(9)
#define REG_PCIE0_INFRA_RMB_LSB			BIT(10)
#define REG_PCIE0_PMIC_RMB_LSB			BIT(11)
#define REG_PCIE0_SRCCLKENA_MB_LSB		BIT(12)
#define REG_PCIE0_VCORE_RMB_LSB			BIT(13)
#define REG_PCIE0_VRF18_RMB_LSB			BIT(14)
#define REG_PCIE1_APSRC_RMB_LSB			BIT(15)
#define REG_PCIE1_DDREN_RMB_LSB			BIT(16)
#define REG_PCIE1_EMI_RMB_LSB			BIT(17)
#define REG_PCIE1_INFRA_RMB_LSB			BIT(18)
#define REG_PCIE1_PMIC_RMB_LSB			BIT(19)
#define REG_PCIE1_SRCCLKENA_MB_LSB		BIT(20)
#define REG_PCIE1_VCORE_RMB_LSB			BIT(21)
#define REG_PCIE1_VRF18_RMB_LSB			BIT(22)
#define REG_PERISYS_APSRC_RMB_LSB		BIT(23)
#define REG_PERISYS_DDREN_RMB_LSB		BIT(24)
#define REG_PERISYS_EMI_RMB_LSB			BIT(25)
#define REG_PERISYS_INFRA_RMB_LSB		BIT(26)
#define REG_PERISYS_PMIC_RMB_LSB		BIT(27)
#define REG_PERISYS_SRCCLKENA_MB_LSB		BIT(28)
#define REG_PERISYS_VCORE_RMB_LSB		BIT(29)
#define REG_PERISYS_VRF18_RMB_LSB		BIT(30)
#define REG_PMSR_APSRC_RMB_LSB			BIT(31)
#define REG_PMSR_DDREN_RMB_LSB			BIT(0)
#define REG_PMSR_EMI_RMB_LSB			BIT(1)
#define REG_PMSR_INFRA_RMB_LSB			BIT(2)
#define REG_PMSR_PMIC_RMB_LSB			BIT(3)
#define REG_PMSR_SRCCLKENA_MB_LSB		BIT(4)
#define REG_PMSR_VCORE_RMB_LSB			BIT(5)
#define REG_PMSR_VRF18_RMB_LSB			BIT(6)
#define REG_SCP_APSRC_RMB_LSB			BIT(7)
#define REG_SCP_DDREN_RMB_LSB			BIT(8)
#define REG_SCP_EMI_RMB_LSB			BIT(9)
#define REG_SCP_INFRA_RMB_LSB			BIT(10)
#define REG_SCP_PMIC_RMB_LSB			BIT(11)
#define REG_SCP_SRCCLKENA_MB_LSB		BIT(12)
#define REG_SCP_VCORE_RMB_LSB			BIT(13)
#define REG_SCP_VRF18_RMB_LSB			BIT(14)
#define REG_SPU_HWR_APSRC_RMB_LSB		BIT(15)
#define REG_SPU_HWR_DDREN_RMB_LSB		BIT(16)
#define REG_SPU_HWR_EMI_RMB_LSB			BIT(17)
#define REG_SPU_HWR_INFRA_RMB_LSB		BIT(18)
#define REG_SPU_HWR_PMIC_RMB_LSB		BIT(19)
#define REG_SPU_HWR_SRCCLKENA_MB_LSB		BIT(20)
#define REG_SPU_HWR_VCORE_RMB_LSB		BIT(21)
#define REG_SPU_HWR_VRF18_RMB_LSB		BIT(22)
#define REG_SPU_ISE_APSRC_RMB_LSB		BIT(23)
#define REG_SPU_ISE_DDREN_RMB_LSB		BIT(24)
#define REG_SPU_ISE_EMI_RMB_LSB			BIT(25)
#define REG_SPU_ISE_INFRA_RMB_LSB		BIT(26)
#define REG_SPU_ISE_PMIC_RMB_LSB		BIT(27)
#define REG_SPU_ISE_SRCCLKENA_MB_LSB		BIT(28)
#define REG_SPU_ISE_VCORE_RMB_LSB		BIT(29)
#define REG_SPU_ISE_VRF18_RMB_LSB		BIT(30)
#define REG_SRCCLKENI_INFRA_RMB_LSB		BIT(0)
#define REG_SRCCLKENI_PMIC_RMB_LSB		BIT(2)
#define REG_SRCCLKENI_SRCCLKENA_MB_LSB		BIT(4)
#define REG_SRCCLKENI_VCORE_RMB_LSB		BIT(6)
#define REG_SSPM_APSRC_RMB_LSB			BIT(8)
#define REG_SSPM_DDREN_RMB_LSB			BIT(9)
#define REG_SSPM_EMI_RMB_LSB			BIT(10)
#define REG_SSPM_INFRA_RMB_LSB			BIT(11)
#define REG_SSPM_PMIC_RMB_LSB			BIT(12)
#define REG_SSPM_SRCCLKENA_MB_LSB		BIT(13)
#define REG_SSPM_VRF18_RMB_LSB			BIT(14)
#define REG_SSRSYS_APSRC_RMB_LSB		BIT(15)
#define REG_SSRSYS_DDREN_RMB_LSB		BIT(16)
#define REG_SSRSYS_EMI_RMB_LSB			BIT(17)
#define REG_SSRSYS_INFRA_RMB_LSB		BIT(18)
#define REG_SSRSYS_PMIC_RMB_LSB			BIT(19)
#define REG_SSRSYS_SRCCLKENA_MB_LSB		BIT(20)
#define REG_SSRSYS_VCORE_RMB_LSB		BIT(21)
#define REG_SSRSYS_VRF18_RMB_LSB		BIT(22)
#define REG_SSUSB_APSRC_RMB_LSB			BIT(23)
#define REG_SSUSB_DDREN_RMB_LSB			BIT(24)
#define REG_SSUSB_EMI_RMB_LSB			BIT(25)
#define REG_SSUSB_INFRA_RMB_LSB			BIT(26)
#define REG_SSUSB_PMIC_RMB_LSB			BIT(27)
#define REG_SSUSB_SRCCLKENA_MB_LSB		BIT(28)
#define REG_SSUSB_VCORE_RMB_LSB			BIT(29)
#define REG_SSUSB_VRF18_RMB_LSB			BIT(30)
#define REG_UART_HUB_INFRA_RMB_LSB		BIT(31)
#define REG_UART_HUB_PMIC_RMB_LSB		BIT(0)
#define REG_UART_HUB_SRCCLKENA_MB_LSB		BIT(1)
#define REG_UART_HUB_VCORE_RMB_LSB		BIT(2)
#define REG_UART_HUB_VRF18_RMB_LSB		BIT(3)
#define REG_UFS_APSRC_RMB_LSB			BIT(4)
#define REG_UFS_DDREN_RMB_LSB			BIT(5)
#define REG_UFS_EMI_RMB_LSB			BIT(6)
#define REG_UFS_INFRA_RMB_LSB			BIT(7)
#define REG_UFS_PMIC_RMB_LSB			BIT(8)
#define REG_UFS_SRCCLKENA_MB_LSB		BIT(9)
#define REG_UFS_VCORE_RMB_LSB			BIT(10)
#define REG_UFS_VRF18_RMB_LSB			BIT(11)
#define REG_VDEC_APSRC_RMB_LSB			BIT(12)
#define REG_VDEC_DDREN_RMB_LSB			BIT(13)
#define REG_VDEC_EMI_RMB_LSB			BIT(14)
#define REG_VDEC_INFRA_RMB_LSB			BIT(15)
#define REG_VDEC_PMIC_RMB_LSB			BIT(16)
#define REG_VDEC_SRCCLKENA_MB_LSB		BIT(17)
#define REG_VDEC_VRF18_RMB_LSB			BIT(18)
#define REG_VENC_APSRC_RMB_LSB			BIT(19)
#define REG_VENC_DDREN_RMB_LSB			BIT(20)
#define REG_VENC_EMI_RMB_LSB			BIT(21)
#define REG_VENC_INFRA_RMB_LSB			BIT(22)
#define REG_VENC_PMIC_RMB_LSB			BIT(23)
#define REG_VENC_SRCCLKENA_MB_LSB		BIT(24)
#define REG_VENC_VRF18_RMB_LSB			BIT(25)
#define REG_VLPCFG_APSRC_RMB_LSB		BIT(26)
#define REG_VLPCFG_DDREN_RMB_LSB		BIT(27)
#define REG_VLPCFG_EMI_RMB_LSB			BIT(28)
#define REG_VLPCFG_INFRA_RMB_LSB		BIT(29)
#define REG_VLPCFG_PMIC_RMB_LSB			BIT(30)
#define REG_VLPCFG_SRCCLKENA_MB_LSB		BIT(31)
#define REG_VLPCFG_VCORE_RMB_LSB		BIT(0)
#define REG_VLPCFG_VRF18_RMB_LSB		BIT(1)
#define REG_VLPCFG1_APSRC_RMB_LSB		BIT(2)
#define REG_VLPCFG1_DDREN_RMB_LSB		BIT(3)
#define REG_VLPCFG1_EMI_RMB_LSB			BIT(4)
#define REG_VLPCFG1_INFRA_RMB_LSB		BIT(5)
#define REG_VLPCFG1_PMIC_RMB_LSB		BIT(6)
#define REG_VLPCFG1_SRCCLKENA_MB_LSB		BIT(7)
#define REG_VLPCFG1_VCORE_RMB_LSB		BIT(8)
#define REG_VLPCFG1_VRF18_RMB_LSB		BIT(9)
#define APIFR_MEM_APSRC_REQ_LSB			BIT(0)
#define APIFR_MEM_DDREN_REQ_LSB			BIT(1)
#define APIFR_MEM_EMI_REQ_LSB			BIT(2)
#define APIFR_MEM_INFRA_REQ_LSB			BIT(3)
#define APIFR_MEM_PMIC_REQ_LSB			BIT(4)
#define APIFR_MEM_SRCCLKENA_LSB			BIT(5)
#define APIFR_MEM_VCORE_REQ_LSB			BIT(6)
#define APIFR_MEM_VRF18_REQ_LSB			BIT(7)
#define APU_APSRC_REQ_LSB			BIT(8)
#define APU_DDREN_REQ_LSB			BIT(9)
#define APU_EMI_REQ_LSB				BIT(10)
#define APU_INFRA_REQ_LSB			BIT(11)
#define APU_PMIC_REQ_LSB			BIT(12)
#define APU_SRCCLKENA_LSB			BIT(13)
#define APU_VCORE_REQ_LSB			BIT(14)
#define APU_VRF18_REQ_LSB			BIT(15)
#define AUDIO_APSRC_REQ_LSB			BIT(16)
#define AUDIO_DDREN_REQ_LSB			BIT(17)
#define AUDIO_EMI_REQ_LSB			BIT(18)
#define AUDIO_INFRA_REQ_LSB			BIT(19)
#define AUDIO_PMIC_REQ_LSB			BIT(20)
#define AUDIO_SRCCLKENA_LSB			BIT(21)
#define AUDIO_VCORE_REQ_LSB			BIT(22)
#define AUDIO_VRF18_REQ_LSB			BIT(23)
#define AUDIO_DSP_APSRC_REQ_LSB			BIT(0)
#define AUDIO_DSP_DDREN_REQ_LSB			BIT(1)
#define AUDIO_DSP_EMI_REQ_LSB			BIT(2)
#define AUDIO_DSP_INFRA_REQ_LSB			BIT(3)
#define AUDIO_DSP_PMIC_REQ_LSB			BIT(4)
#define AUDIO_DSP_SRCCLKENA_LSB			BIT(5)
#define AUDIO_DSP_VCORE_REQ_LSB			BIT(6)
#define AUDIO_DSP_VRF18_REQ_LSB			BIT(7)
#define CAM_APSRC_REQ_LSB			BIT(8)
#define CAM_DDREN_REQ_LSB			BIT(9)
#define CAM_EMI_REQ_LSB				BIT(10)
#define CAM_INFRA_REQ_LSB			BIT(11)
#define CAM_PMIC_REQ_LSB			BIT(12)
#define CAM_SRCCLKENA_LSB			BIT(13)
#define CAM_VRF18_REQ_LSB			BIT(14)
#define CCIF_APSRC_REQ_LSB			BIT(15)
#define CCIF_EMI_REQ_LSB			BIT(0)
#define CCIF_INFRA_REQ_LSB			BIT(12)
#define CCIF_PMIC_REQ_LSB			BIT(0)
#define CCIF_SRCCLKENA_LSB			BIT(12)
#define CCIF_VCORE_REQ_LSB			BIT(0)
#define CCIF_VRF18_REQ_LSB			BIT(12)
#define CCU_APSRC_REQ_LSB			BIT(24)
#define CCU_DDREN_REQ_LSB			BIT(25)
#define CCU_EMI_REQ_LSB				BIT(26)
#define CCU_INFRA_REQ_LSB			BIT(27)
#define CCU_PMIC_REQ_LSB			BIT(28)
#define CCU_SRCCLKENA_LSB			BIT(29)
#define CCU_VRF18_REQ_LSB			BIT(30)
#define CG_CHECK_APSRC_REQ_LSB			BIT(31)
#define CG_CHECK_DDREN_REQ_LSB			BIT(0)
#define CG_CHECK_EMI_REQ_LSB			BIT(1)
#define CG_CHECK_INFRA_REQ_LSB			BIT(2)
#define CG_CHECK_PMIC_REQ_LSB			BIT(3)
#define CG_CHECK_SRCCLKENA_LSB			BIT(4)
#define CG_CHECK_VCORE_REQ_LSB			BIT(5)
#define CG_CHECK_VRF18_REQ_LSB			BIT(6)
#define CKSYS_APSRC_REQ_LSB			BIT(7)
#define CKSYS_DDREN_REQ_LSB			BIT(8)
#define CKSYS_EMI_REQ_LSB			BIT(9)
#define CKSYS_INFRA_REQ_LSB			BIT(10)
#define CKSYS_PMIC_REQ_LSB			BIT(11)
#define CKSYS_SRCCLKENA_LSB			BIT(12)
#define CKSYS_VCORE_REQ_LSB			BIT(13)
#define CKSYS_VRF18_REQ_LSB			BIT(14)
#define CKSYS_1_APSRC_REQ_LSB			BIT(15)
#define CKSYS_1_DDREN_REQ_LSB			BIT(16)
#define CKSYS_1_EMI_REQ_LSB			BIT(17)
#define CKSYS_1_INFRA_REQ_LSB			BIT(18)
#define CKSYS_1_PMIC_REQ_LSB			BIT(19)
#define CKSYS_1_SRCCLKENA_LSB			BIT(20)
#define CKSYS_1_VCORE_REQ_LSB			BIT(21)
#define CKSYS_1_VRF18_REQ_LSB			BIT(22)
#define CKSYS_2_APSRC_REQ_LSB			BIT(23)
#define CKSYS_2_DDREN_REQ_LSB			BIT(24)
#define CKSYS_2_EMI_REQ_LSB			BIT(25)
#define CKSYS_2_INFRA_REQ_LSB			BIT(26)
#define CKSYS_2_PMIC_REQ_LSB			BIT(27)
#define CKSYS_2_SRCCLKENA_LSB			BIT(28)
#define CKSYS_2_VCORE_REQ_LSB			BIT(29)
#define CKSYS_2_VRF18_REQ_LSB			BIT(30)
#define CONN_APSRC_REQ_LSB			BIT(0)
#define CONN_DDREN_REQ_LSB			BIT(1)
#define CONN_EMI_REQ_LSB			BIT(2)
#define CONN_INFRA_REQ_LSB			BIT(3)
#define CONN_PMIC_REQ_LSB			BIT(4)
#define CONN_SRCCLKENA_LSB			BIT(5)
#define CONN_SRCCLKENB_LSB			BIT(6)
#define CONN_VCORE_REQ_LSB			BIT(7)
#define CONN_VRF18_REQ_LSB			BIT(8)
#define CORECFG_RSV0_APSRC_REQ_LSB		BIT(9)
#define CORECFG_RSV0_DDREN_REQ_LSB		BIT(10)
#define CORECFG_RSV0_EMI_REQ_LSB		BIT(11)
#define CORECFG_RSV0_INFRA_REQ_LSB		BIT(12)
#define CORECFG_RSV0_PMIC_REQ_LSB		BIT(13)
#define CORECFG_RSV0_SRCCLKENA_LSB		BIT(14)
#define CPUEB_APSRC_REQ_LSB			BIT(0)
#define CPUEB_DDREN_REQ_LSB			BIT(1)
#define CPUEB_EMI_REQ_LSB			BIT(2)
#define CPUEB_INFRA_REQ_LSB			BIT(3)
#define CPUEB_PMIC_REQ_LSB			BIT(4)
#define CPUEB_SRCCLKENA_LSB			BIT(5)
#define CPUEB_VCORE_REQ_LSB			BIT(6)
#define CPUEB_VRF18_REQ_LSB			BIT(7)
#define DISP0_APSRC_REQ_LSB			BIT(8)
#define DISP0_DDREN_REQ_LSB			BIT(9)
#define DISP0_EMI_REQ_LSB			BIT(10)
#define DISP0_INFRA_REQ_LSB			BIT(11)
#define DISP0_PMIC_REQ_LSB			BIT(12)
#define DISP0_SRCCLKENA_LSB			BIT(13)
#define DISP0_VRF18_REQ_LSB			BIT(14)
#define DISP1_APSRC_REQ_LSB			BIT(15)
#define DISP1_DDREN_REQ_LSB			BIT(16)
#define DISP1_EMI_REQ_LSB			BIT(17)
#define DISP1_INFRA_REQ_LSB			BIT(18)
#define DISP1_PMIC_REQ_LSB			BIT(19)
#define DISP1_SRCCLKENA_LSB			BIT(20)
#define DISP1_VRF18_REQ_LSB			BIT(21)
#define DPM_APSRC_REQ_LSB			BIT(22)
#define DPM_DDREN_REQ_LSB			BIT(26)
#define DPM_EMI_REQ_LSB				BIT(0)
#define DPM_INFRA_REQ_LSB			BIT(4)
#define DPM_PMIC_REQ_LSB			BIT(8)
#define DPM_SRCCLKENA_LSB			BIT(12)
#define DPM_VCORE_REQ_LSB			BIT(16)
#define DPM_VRF18_REQ_LSB			BIT(20)
#define DPMAIF_APSRC_REQ_LSB			BIT(24)
#define DPMAIF_DDREN_REQ_LSB			BIT(25)
#define DPMAIF_EMI_REQ_LSB			BIT(26)
#define DPMAIF_INFRA_REQ_LSB			BIT(27)
#define DPMAIF_PMIC_REQ_LSB			BIT(28)
#define DPMAIF_SRCCLKENA_LSB			BIT(29)
#define DPMAIF_VCORE_REQ_LSB			BIT(30)
#define DPMAIF_VRF18_REQ_LSB			BIT(31)
#define DVFSRC_LEVEL_REQ_LSB			BIT(0)
#define EMISYS_APSRC_REQ_LSB			BIT(1)
#define EMISYS_DDREN_REQ_LSB			BIT(2)
#define EMISYS_EMI_REQ_LSB			BIT(3)
#define EMISYS_INFRA_REQ_LSB			BIT(4)
#define EMISYS_PMIC_REQ_LSB			BIT(5)
#define EMISYS_SRCCLKENA_LSB			BIT(6)
#define EMISYS_VCORE_REQ_LSB			BIT(7)
#define EMISYS_VRF18_REQ_LSB			BIT(8)
#define GCE_APSRC_REQ_LSB			BIT(9)
#define GCE_DDREN_REQ_LSB			BIT(10)
#define GCE_EMI_REQ_LSB				BIT(11)
#define GCE_INFRA_REQ_LSB			BIT(12)
#define GCE_PMIC_REQ_LSB			BIT(13)
#define GCE_SRCCLKENA_LSB			BIT(14)
#define GCE_VCORE_REQ_LSB			BIT(15)
#define GCE_VRF18_REQ_LSB			BIT(16)
#define GPUEB_APSRC_REQ_LSB			BIT(17)
#define GPUEB_DDREN_REQ_LSB			BIT(18)
#define GPUEB_EMI_REQ_LSB			BIT(19)
#define GPUEB_INFRA_REQ_LSB			BIT(20)
#define GPUEB_PMIC_REQ_LSB			BIT(21)
#define GPUEB_SRCCLKENA_LSB			BIT(22)
#define GPUEB_VCORE_REQ_LSB			BIT(23)
#define GPUEB_VRF18_REQ_LSB			BIT(24)
#define HWCCF_APSRC_REQ_LSB			BIT(25)
#define HWCCF_DDREN_REQ_LSB			BIT(26)
#define HWCCF_EMI_REQ_LSB			BIT(27)
#define HWCCF_INFRA_REQ_LSB			BIT(28)
#define HWCCF_PMIC_REQ_LSB			BIT(29)
#define HWCCF_SRCCLKENA_LSB			BIT(30)
#define HWCCF_VCORE_REQ_LSB			BIT(31)
#define HWCCF_VRF18_REQ_LSB			BIT(0)
#define IMG_APSRC_REQ_LSB			BIT(1)
#define IMG_DDREN_REQ_LSB			BIT(2)
#define IMG_EMI_REQ_LSB				BIT(3)
#define IMG_INFRA_REQ_LSB			BIT(4)
#define IMG_PMIC_REQ_LSB			BIT(5)
#define IMG_SRCCLKENA_LSB			BIT(6)
#define IMG_VRF18_REQ_LSB			BIT(7)
#define INFRASYS_APSRC_REQ_LSB			BIT(8)
#define INFRASYS_DDREN_REQ_LSB			BIT(9)
#define INFRASYS_EMI_REQ_LSB			BIT(10)
#define INFRASYS_INFRA_REQ_LSB			BIT(11)
#define INFRASYS_PMIC_REQ_LSB			BIT(12)
#define INFRASYS_SRCCLKENA_LSB			BIT(13)
#define INFRASYS_VCORE_REQ_LSB			BIT(14)
#define INFRASYS_VRF18_REQ_LSB			BIT(15)
#define IPIC_INFRA_REQ_LSB			BIT(16)
#define IPIC_VRF18_REQ_LSB			BIT(17)
#define MCU_APSRC_REQ_LSB			BIT(18)
#define MCU_DDREN_REQ_LSB			BIT(19)
#define MCU_EMI_REQ_LSB				BIT(20)
#define MCU_INFRA_REQ_LSB			BIT(21)
#define MCU_PMIC_REQ_LSB			BIT(22)
#define MCU_SRCCLKENA_LSB			BIT(23)
#define MCU_VCORE_REQ_LSB			BIT(24)
#define MCU_VRF18_REQ_LSB			BIT(25)
#define MD_APSRC_REQ_LSB			BIT(26)
#define MD_DDREN_REQ_LSB			BIT(27)
#define MD_EMI_REQ_LSB				BIT(28)
#define MD_INFRA_REQ_LSB			BIT(29)
#define MD_PMIC_REQ_LSB				BIT(30)
#define MD_SRCCLKENA_LSB			BIT(31)
#define MD_SRCCLKENA1_LSB			BIT(0)
#define MD_VCORE_REQ_LSB			BIT(1)
#define MD_VRF18_REQ_LSB			BIT(2)
#define MM_PROC_APSRC_REQ_LSB			BIT(3)
#define MM_PROC_DDREN_REQ_LSB			BIT(4)
#define MM_PROC_EMI_REQ_LSB			BIT(5)
#define MM_PROC_INFRA_REQ_LSB			BIT(6)
#define MM_PROC_PMIC_REQ_LSB			BIT(7)
#define MM_PROC_SRCCLKENA_LSB			BIT(8)
#define MM_PROC_VCORE_REQ_LSB			BIT(9)
#define MM_PROC_VRF18_REQ_LSB			BIT(10)
#define MML0_APSRC_REQ_LSB			BIT(11)
#define MML0_DDREN_REQ_LSB			BIT(12)
#define MML0_EMI_REQ_LSB			BIT(13)
#define MML0_INFRA_REQ_LSB			BIT(14)
#define MML0_PMIC_REQ_LSB			BIT(15)
#define MML0_SRCCLKENA_LSB			BIT(16)
#define MML0_VRF18_REQ_LSB			BIT(17)
#define MML1_APSRC_REQ_LSB			BIT(18)
#define MML1_DDREN_REQ_LSB			BIT(19)
#define MML1_EMI_REQ_LSB			BIT(20)
#define MML1_INFRA_REQ_LSB			BIT(21)
#define MML1_PMIC_REQ_LSB			BIT(22)
#define MML1_SRCCLKENA_LSB			BIT(23)
#define MML1_VRF18_REQ_LSB			BIT(24)
#define OVL0_APSRC_REQ_LSB			BIT(25)
#define OVL0_DDREN_REQ_LSB			BIT(26)
#define OVL0_EMI_REQ_LSB			BIT(27)
#define OVL0_INFRA_REQ_LSB			BIT(28)
#define OVL0_PMIC_REQ_LSB			BIT(29)
#define OVL0_SRCCLKENA_LSB			BIT(30)
#define OVL0_VRF18_REQ_LSB			BIT(31)
#define OVL1_APSRC_REQ_LSB			BIT(0)
#define OVL1_DDREN_REQ_LSB			BIT(1)
#define OVL1_EMI_REQ_LSB			BIT(2)
#define OVL1_INFRA_REQ_LSB			BIT(3)
#define OVL1_PMIC_REQ_LSB			BIT(4)
#define OVL1_SRCCLKENA_LSB			BIT(5)
#define OVL1_VRF18_REQ_LSB			BIT(6)
#define PCIE0_APSRC_REQ_LSB			BIT(7)
#define PCIE0_DDREN_REQ_LSB			BIT(8)
#define PCIE0_EMI_REQ_LSB			BIT(9)
#define PCIE0_INFRA_REQ_LSB			BIT(10)
#define PCIE0_PMIC_REQ_LSB			BIT(11)
#define PCIE0_SRCCLKENA_LSB			BIT(12)
#define PCIE0_VCORE_REQ_LSB			BIT(13)
#define PCIE0_VRF18_REQ_LSB			BIT(14)
#define PCIE1_APSRC_REQ_LSB			BIT(15)
#define PCIE1_DDREN_REQ_LSB			BIT(16)
#define PCIE1_EMI_REQ_LSB			BIT(17)
#define PCIE1_INFRA_REQ_LSB			BIT(18)
#define PCIE1_PMIC_REQ_LSB			BIT(19)
#define PCIE1_SRCCLKENA_LSB			BIT(20)
#define PCIE1_VCORE_REQ_LSB			BIT(21)
#define PCIE1_VRF18_REQ_LSB			BIT(22)
#define PERISYS_APSRC_REQ_LSB			BIT(23)
#define PERISYS_DDREN_REQ_LSB			BIT(24)
#define PERISYS_EMI_REQ_LSB			BIT(25)
#define PERISYS_INFRA_REQ_LSB			BIT(26)
#define PERISYS_PMIC_REQ_LSB			BIT(27)
#define PERISYS_SRCCLKENA_LSB			BIT(28)
#define PERISYS_VCORE_REQ_LSB			BIT(29)
#define PERISYS_VRF18_REQ_LSB			BIT(30)
#define PMSR_APSRC_REQ_LSB			BIT(31)
#define PMSR_DDREN_REQ_LSB			BIT(0)
#define PMSR_EMI_REQ_LSB			BIT(1)
#define PMSR_INFRA_REQ_LSB			BIT(2)
#define PMSR_PMIC_REQ_LSB			BIT(3)
#define PMSR_SRCCLKENA_LSB			BIT(4)
#define PMSR_VCORE_REQ_LSB			BIT(5)
#define PMSR_VRF18_REQ_LSB			BIT(6)
#define SCP_APSRC_REQ_LSB			BIT(7)
#define SCP_DDREN_REQ_LSB			BIT(8)
#define SCP_EMI_REQ_LSB				BIT(9)
#define SCP_INFRA_REQ_LSB			BIT(10)
#define SCP_PMIC_REQ_LSB			BIT(11)
#define SCP_SRCCLKENA_LSB			BIT(12)
#define SCP_VCORE_REQ_LSB			BIT(13)
#define SCP_VRF18_REQ_LSB			BIT(14)
#define SPU_HWROT_APSRC_REQ_LSB			BIT(15)
#define SPU_HWROT_DDREN_REQ_LSB			BIT(16)
#define SPU_HWROT_EMI_REQ_LSB			BIT(17)
#define SPU_HWROT_INFRA_REQ_LSB			BIT(18)
#define SPU_HWROT_PMIC_REQ_LSB			BIT(19)
#define SPU_HWROT_SRCCLKENA_LSB			BIT(20)
#define SPU_HWROT_VCORE_REQ_LSB			BIT(21)
#define SPU_HWROT_VRF18_REQ_LSB			BIT(22)
#define SPU_ISE_APSRC_REQ_LSB			BIT(23)
#define SPU_ISE_DDREN_REQ_LSB			BIT(24)
#define SPU_ISE_EMI_REQ_LSB			BIT(25)
#define SPU_ISE_INFRA_REQ_LSB			BIT(26)
#define SPU_ISE_PMIC_REQ_LSB			BIT(27)
#define SPU_ISE_SRCCLKENA_LSB			BIT(28)
#define SPU_ISE_VCORE_REQ_LSB			BIT(29)
#define SPU_ISE_VRF18_REQ_LSB			BIT(30)
#define SRCCLKENI_INFRA_REQ_LSB			BIT(0)
#define SRCCLKENI_PMIC_REQ_LSB			BIT(2)
#define SRCCLKENI_SRCCLKENA_LSB			BIT(4)
#define SRCCLKENI_VCORE_REQ_LSB			BIT(6)
#define SSPM_APSRC_REQ_LSB			BIT(8)
#define SSPM_DDREN_REQ_LSB			BIT(9)
#define SSPM_EMI_REQ_LSB			BIT(10)
#define SSPM_INFRA_REQ_LSB			BIT(11)
#define SSPM_PMIC_REQ_LSB			BIT(12)
#define SSPM_SRCCLKENA_LSB			BIT(13)
#define SSPM_VRF18_REQ_LSB			BIT(14)
#define SSRSYS_APSRC_REQ_LSB			BIT(15)
#define SSRSYS_DDREN_REQ_LSB			BIT(16)
#define SSRSYS_EMI_REQ_LSB			BIT(17)
#define SSRSYS_INFRA_REQ_LSB			BIT(18)
#define SSRSYS_PMIC_REQ_LSB			BIT(19)
#define SSRSYS_SRCCLKENA_LSB			BIT(20)
#define SSRSYS_VCORE_REQ_LSB			BIT(21)
#define SSRSYS_VRF18_REQ_LSB			BIT(22)
#define SSUSB_APSRC_REQ_LSB			BIT(23)
#define SSUSB_DDREN_REQ_LSB			BIT(24)
#define SSUSB_EMI_REQ_LSB			BIT(25)
#define SSUSB_INFRA_REQ_LSB			BIT(26)
#define SSUSB_PMIC_REQ_LSB			BIT(27)
#define SSUSB_SRCCLKENA_LSB			BIT(28)
#define SSUSB_VCORE_REQ_LSB			BIT(29)
#define SSUSB_VRF18_REQ_LSB			BIT(30)
#define UART_HUB_INFRA_REQ_LSB			BIT(31)
#define UART_HUB_PMIC_REQ_LSB			BIT(0)
#define UART_HUB_SRCCLKENA_LSB			BIT(1)
#define UART_HUB_VCORE_REQ_LSB			BIT(2)
#define UART_HUB_VRF18_REQ_LSB			BIT(3)
#define UFS_APSRC_REQ_LSB			BIT(4)
#define UFS_DDREN_REQ_LSB			BIT(5)
#define UFS_EMI_REQ_LSB				BIT(6)
#define UFS_INFRA_REQ_LSB			BIT(7)
#define UFS_PMIC_REQ_LSB			BIT(8)
#define UFS_SRCCLKENA_LSB			BIT(9)
#define UFS_VCORE_REQ_LSB			BIT(10)
#define UFS_VRF18_REQ_LSB			BIT(11)
#define VDEC_APSRC_REQ_LSB			BIT(12)
#define VDEC_DDREN_REQ_LSB			BIT(13)
#define VDEC_EMI_REQ_LSB			BIT(14)
#define VDEC_INFRA_REQ_LSB			BIT(15)
#define VDEC_PMIC_REQ_LSB			BIT(16)
#define VDEC_SRCCLKENA_LSB			BIT(17)
#define VDEC_VRF18_REQ_LSB			BIT(18)
#define VENC_APSRC_REQ_LSB			BIT(19)
#define VENC_DDREN_REQ_LSB			BIT(20)
#define VENC_EMI_REQ_LSB			BIT(21)
#define VENC_INFRA_REQ_LSB			BIT(22)
#define VENC_PMIC_REQ_LSB			BIT(23)
#define VENC_SRCCLKENA_LSB			BIT(24)
#define VENC_VRF18_REQ_LSB			BIT(25)
#define VLPCFG_RSV0_APSRC_REQ_LSB		BIT(26)
#define VLPCFG_RSV0_DDREN_REQ_LSB		BIT(27)
#define VLPCFG_RSV0_EMI_REQ_LSB			BIT(28)
#define VLPCFG_RSV0_INFRA_REQ_LSB		BIT(29)
#define VLPCFG_RSV0_PMIC_REQ_LSB		BIT(30)
#define VLPCFG_RSV0_SRCCLKENA_LSB		BIT(31)
#define VLPCFG_RSV0_VCORE_REQ_LSB		BIT(0)
#define VLPCFG_RSV0_VRF18_REQ_LSB		BIT(1)
#define VLPCFG_RSV1_APSRC_REQ_LSB		BIT(2)
#define VLPCFG_RSV1_DDREN_REQ_LSB		BIT(3)
#define VLPCFG_RSV1_EMI_REQ_LSB			BIT(4)
#define VLPCFG_RSV1_INFRA_REQ_LSB		BIT(5)
#define VLPCFG_RSV1_PMIC_REQ_LSB		BIT(6)
#define VLPCFG_RSV1_SRCCLKENA_LSB		BIT(7)
#define VLPCFG_RSV1_VCORE_REQ_LSB		BIT(8)
#define VLPCFG_RSV1_VRF18_REQ_LSB		BIT(9)
#define SPM2SSPM_WAKEUP_LSB			BIT(0)
#define SPM2SCP_WAKEUP_LSB			BIT(1)
#define SPM2ADSP_WAKEUP_LSB			BIT(2)
#define REG_SW2SPM_WAKEUP_MB_LSB		BIT(0)
#define REG_SSPM2SPM_WAKEUP_MB_LSB		BIT(4)
#define REG_SCP2SPM_WAKEUP_MB_LSB		BIT(5)
#define REG_ADSP2SPM_WAKEUP_MB_LSB		BIT(6)
#define SSPM2SPM_WAKEUP_LSB			BIT(20)
#define SCP2SPM_WAKEUP_LSB			BIT(21)
#define ADSP2SPM_WAKEUP_LSB			BIT(22)
#define REG_SRCCLKEN_FAST_RESP_LSB		BIT(0)
#define REG_CSYSPWRUP_ACK_MASK_LSB		BIT(1)
#define REG_DDREN_DBC_LEN_LSB			BIT(0)
#define REG_DDREN_DBC_EN_LSB			BIT(16)
#define SPM_VCORE_ACK_WAIT_CYCLE_LSB		BIT(0)
#define SPM_PMIC_ACK_WAIT_CYCLE_LSB		BIT(8)
#define SPM_SRCCLKENA_ACK_WAIT_CYCLE_LSB	BIT(16)
#define SPM_INFRA_ACK_WAIT_CYCLE_LSB		BIT(24)
#define SPM_VRF18_ACK_WAIT_CYCLE_LSB		BIT(0)
#define SPM_EMI_ACK_WAIT_CYCLE_LSB		BIT(8)
#define SPM_APSRC_ACK_WAIT_CYCLE_LSB		BIT(16)
#define SPM_DDREN_ACK_WAIT_CYCLE_LSB		BIT(24)
#define REG_APIFR_APSRC_ACK_MASK_LSB		BIT(0)
#define REG_APIFR_DDREN_ACK_MASK_LSB		BIT(1)
#define REG_APIFR_EMI_ACK_MASK_LSB		BIT(2)
#define REG_APIFR_INFRA_ACK_MASK_LSB		BIT(3)
#define REG_APIFR_PMIC_ACK_MASK_LSB		BIT(4)
#define REG_APIFR_SRCCLKENA_ACK_MASK_LSB	BIT(5)
#define REG_APIFR_VCORE_ACK_MASK_LSB		BIT(6)
#define REG_APIFR_VRF18_ACK_MASK_LSB		BIT(7)
#define REG_APU_APSRC_ACK_MASK_LSB		BIT(8)
#define REG_APU_DDREN_ACK_MASK_LSB		BIT(9)
#define REG_APU_EMI_ACK_MASK_LSB		BIT(10)
#define REG_APU_INFRA_ACK_MASK_LSB		BIT(11)
#define REG_APU_PMIC_ACK_MASK_LSB		BIT(12)
#define REG_APU_SRCCLKENA_ACK_MASK_LSB		BIT(13)
#define REG_APU_VCORE_ACK_MASK_LSB		BIT(14)
#define REG_APU_VRF18_ACK_MASK_LSB		BIT(15)
#define REG_AUDIO_APSRC_ACK_MASK_LSB		BIT(16)
#define REG_AUDIO_DDREN_ACK_MASK_LSB		BIT(17)
#define REG_AUDIO_EMI_ACK_MASK_LSB		BIT(18)
#define REG_AUDIO_INFRA_ACK_MASK_LSB		BIT(19)
#define REG_AUDIO_PMIC_ACK_MASK_LSB		BIT(20)
#define REG_AUDIO_SRCCLKENA_ACK_MASK_LSB	BIT(21)
#define REG_AUDIO_VCORE_ACK_MASK_LSB		BIT(22)
#define REG_AUDIO_VRF18_ACK_MASK_LSB		BIT(23)
/* SPM_RESOURCE_ACK_MASK_1 (0x1C004000+0x8C0) */
#define REG_AUDIO_DSP_APSRC_ACK_MASK_LSB	BIT(0)
#define REG_AUDIO_DSP_DDREN_ACK_MASK_LSB	BIT(1)
#define REG_AUDIO_DSP_EMI_ACK_MASK_LSB		BIT(2)
#define REG_AUDIO_DSP_INFRA_ACK_MASK_LSB	BIT(3)
#define REG_AUDIO_DSP_PMIC_ACK_MASK_LSB		BIT(4)
#define REG_AUDIO_DSP_SRCCLKENA_ACK_MASK_LSB	BIT(5)
#define REG_AUDIO_DSP_VCORE_ACK_MASK_LSB	BIT(6)
#define REG_AUDIO_DSP_VRF18_ACK_MASK_LSB	BIT(7)
#define REG_SPM_EVENT_COUNTER_CLR_LSB		BIT(0)
#define SPM2MCUPM_SW_INT_LSB			BIT(1)

#define SPM_PROJECT_CODE			0xb16
#define SPM_REGWR_CFG_KEY			(SPM_PROJECT_CODE << 16)

#endif /* MT_SPM_REG_H */
