/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.Collection;
import java.util.HashSet;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.Operation;

public class FragmentedOperation
extends Operation {
    private final String description;
    private final Collection<ContinuousOperation> children = new HashSet<ContinuousOperation>();

    public FragmentedOperation(String description) {
        this.description = description;
    }

    @Override
    public long getElapsedTime() {
        long result = 0L;
        for (ContinuousOperation child : this.children) {
            result += child.getElapsedTime();
        }
        return result;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public ContinuousOperation start(long start) {
        ContinuousOperation child = new ContinuousOperation("<child>");
        child.setStart(start);
        this.children.add(child);
        return child;
    }
}

