/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.internal.spotbugs;

import com.github.spotbugs.internal.spotbugs.SpotBugsExecutor;
import com.github.spotbugs.internal.spotbugs.SpotBugsResult;
import com.github.spotbugs.internal.spotbugs.SpotBugsSpec;
import com.github.spotbugs.internal.spotbugs.SpotBugsWorker;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.gradle.api.file.FileCollection;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class SpotBugsWorkerManager {
    public SpotBugsResult runWorker(File workingDir, WorkerProcessFactory workerFactory, FileCollection findBugsClasspath, SpotBugsSpec spec) throws IOException, InterruptedException {
        SpotBugsWorker worker = this.createWorkerProcess(workingDir, workerFactory, findBugsClasspath, spec);
        return worker.runSpotbugs(spec);
    }

    private SpotBugsWorker createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, FileCollection findBugsClasspath, SpotBugsSpec spec) {
        SingleRequestWorkerProcessBuilder builder = workerFactory.singleRequestWorker(SpotBugsWorker.class, SpotBugsExecutor.class);
        builder.setBaseName("Gradle SpotBugs Worker");
        builder.applicationClasspath((Iterable)findBugsClasspath);
        builder.sharedPackages(Arrays.asList("edu.umd.cs.findbugs"));
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.jvmArgs(spec.getJvmArgs());
        return (SpotBugsWorker)builder.build();
    }
}

