/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.plugin;

import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.VersionMismatchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.xpack.ql.util.Holder;

public final class TransportActionUtils {
    public static void executeRequestWithRetryAttempt(ClusterService clusterService, Consumer<Exception> onFailure, Consumer<Consumer<Exception>> queryRunner, Consumer<DiscoveryNode> retryRequest, Logger log) {
        Holder<Boolean> retrySecondTime = new Holder<Boolean>(false);
        queryRunner.accept(e -> {
            if (e instanceof SearchPhaseExecutionException && ((SearchPhaseExecutionException)e).getCause() instanceof VersionMismatchException) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception type [{}] with cause [{}].", (Object)e.getClass().getName(), (Object)e.getCause());
                }
                DiscoveryNode localNode = clusterService.state().nodes().getLocalNode();
                DiscoveryNode candidateNode = null;
                for (DiscoveryNode node : clusterService.state().nodes()) {
                    if (node == localNode || !node.getVersion().before(localNode.getVersion())) continue;
                    candidateNode = node;
                    break;
                }
                if (candidateNode != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Candidate node to resend the request to: address [{}], id [{}], name [{}], version [{}]", (Object)candidateNode.getAddress(), (Object)candidateNode.getId(), (Object)candidateNode.getName(), (Object)candidateNode.getVersion());
                    }
                    retryRequest.accept(candidateNode);
                } else {
                    retrySecondTime.set(true);
                }
            } else {
                onFailure.accept((Exception)e);
            }
        });
        if (retrySecondTime.get().booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("No candidate node found, likely all were upgraded in the meantime. Re-trying the original request.");
            }
            queryRunner.accept(onFailure);
        }
    }
}

