/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.core.ssl.CertificateTrustRestrictions;
import org.elasticsearch.xpack.core.ssl.DerParser;

public final class RestrictedTrustManager
extends X509ExtendedTrustManager {
    private static final Logger logger = LogManager.getLogger(RestrictedTrustManager.class);
    private static final String CN_OID = "2.5.4.3";
    private static final int SAN_CODE_OTHERNAME = 0;
    private static final int SAN_CODE_DNS = 2;
    private final X509ExtendedTrustManager delegate;
    private final CertificateTrustRestrictions trustRestrictions;
    private final Set<String> x509Fields;

    public RestrictedTrustManager(X509ExtendedTrustManager delegate, CertificateTrustRestrictions restrictions, Set<String> x509Fields) {
        this.delegate = delegate;
        this.trustRestrictions = restrictions;
        this.x509Fields = x509Fields.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        logger.debug("Configured with trust restrictions: [{}]", (Object)restrictions);
        logger.debug("Configured with x509 fields: [{}]", x509Fields);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, socket);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, socket);
        this.verifyTrust(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType, engine);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType, engine);
        this.verifyTrust(chain);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkClientTrusted(chain, authType);
        this.verifyTrust(chain);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.delegate.checkServerTrusted(chain, authType);
        this.verifyTrust(chain);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }

    private void verifyTrust(X509Certificate[] chain) throws CertificateException {
        if (chain.length == 0) {
            throw new CertificateException("No certificate presented");
        }
        X509Certificate certificate = chain[0];
        Set<String> values = this.readX509Certificate(certificate);
        if (!this.verifyCertificateNames(values)) {
            logger.info("Rejecting certificate [{}] [{}] for fields [{}] with values [{}]", (Object)certificate.getSubjectDN(), (Object)certificate.getSerialNumber().toString(16), this.x509Fields, values);
            throw new CertificateException("Certificate for " + certificate.getSubjectDN() + " with fields " + this.x509Fields + " with values " + values + " does not match the trusted names " + this.trustRestrictions.getTrustedNames());
        }
        logger.debug(() -> new ParameterizedMessage("Trusting certificate [{}] [{}] with fields [{}] with values [{}]", new Object[]{certificate.getSubjectDN(), certificate.getSerialNumber().toString(16), this.x509Fields, values}));
    }

    private boolean verifyCertificateNames(Set<String> names) {
        for (Predicate<String> trust : this.trustRestrictions.getTrustedNames()) {
            Optional<String> match = names.stream().filter(trust).findFirst();
            if (!match.isPresent()) continue;
            logger.debug("Name [{}] matches trusted pattern [{}]", (Object)match.get(), trust);
            return true;
        }
        return false;
    }

    private Set<String> readX509Certificate(X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> sans = this.getSubjectAlternativeNames(certificate);
        HashSet<String> values = new HashSet<String>();
        if (this.x509Fields.contains("subjectAltName.dnsName".toLowerCase(Locale.ROOT))) {
            Set dnsNames = sans.stream().filter(pair -> (Integer)pair.get(0) == 2).map(pair -> pair.get(1)).map(Object::toString).filter(Objects::nonNull).collect(Collectors.toSet());
            values.addAll(dnsNames);
        }
        if (this.x509Fields.contains("subjectAltName.otherName.commonName".toLowerCase(Locale.ROOT))) {
            Set otherNames = sans.stream().filter(pair -> (Integer)pair.get(0) == 0).map(pair -> pair.get(1)).map(value -> this.decodeDerValue((byte[])value, certificate)).filter(Objects::nonNull).collect(Collectors.toSet());
            values.addAll(otherNames);
        }
        return values;
    }

    private String decodeDerValue(byte[] value, X509Certificate certificate) {
        try {
            DerParser parser = new DerParser(value);
            DerParser.Asn1Object seq = parser.readAsn1Object();
            parser = seq.getParser();
            String id = parser.readAsn1Object().getOid();
            if (CN_OID.equals(id)) {
                DerParser.Asn1Object cnObject = parser.readAsn1Object();
                DerParser.Asn1Object innerObject = (parser = cnObject.getParser()).readAsn1Object();
                if (innerObject.isConstructed()) {
                    innerObject = innerObject.getParser().readAsn1Object();
                }
                logger.trace("Read innermost ASN.1 Object with type code [{}]", (Object)innerObject.getType());
                String cn = innerObject.getString();
                logger.trace("Read cn [{}] from ASN1Sequence [{}]", (Object)cn, (Object)seq);
                return cn;
            }
            logger.debug("Certificate [{}] has 'otherName' [{}] with unsupported object-id [{}]", (Object)certificate.getSubjectDN(), (Object)seq, (Object)id);
            return null;
        }
        catch (IOException e) {
            logger.warn("Failed to read 'otherName' from certificate [{}]", (Object)certificate.getSubjectDN());
            return null;
        }
    }

    private Collection<List<?>> getSubjectAlternativeNames(X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> sans = certificate.getSubjectAlternativeNames();
        logger.trace("Certificate [{}] has subject alternative names [{}]", (Object)certificate.getSubjectDN(), sans);
        return sans == null ? Collections.emptyList() : sans;
    }
}

