/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class SamlMetadataRequest
extends ActionRequest {
    private String spEntityId;
    private String assertionConsumerService;

    public SamlMetadataRequest(StreamInput in) throws IOException {
        super(in);
        this.spEntityId = in.readString();
        this.assertionConsumerService = in.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.spEntityId);
        out.writeOptionalString(this.assertionConsumerService);
    }

    public SamlMetadataRequest(String spEntityId, @Nullable String acs) {
        this.spEntityId = Objects.requireNonNull(spEntityId, "Service Provider entity id must be provided");
        this.assertionConsumerService = acs;
    }

    public SamlMetadataRequest() {
        this.spEntityId = null;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public String getSpEntityId() {
        return this.spEntityId;
    }

    public void setSpEntityId(String spEntityId) {
        this.spEntityId = spEntityId;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{spEntityId='" + this.spEntityId + "' acs='" + this.assertionConsumerService + "'}";
    }

    public String getAssertionConsumerService() {
        return this.assertionConsumerService;
    }

    public void setAssertionConsumerService(String assertionConsumerService) {
        this.assertionConsumerService = assertionConsumerService;
    }
}

