/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.shared;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.DataTier;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractAsyncTask;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.node.NodeRoleSettings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.CacheKey;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.SparseFileTracker;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.SharedBytes;

public class FrozenCacheService
implements Releasable {
    private static final String SHARED_CACHE_SETTINGS_PREFIX = "xpack.searchable.snapshot.shared_cache.";
    public static final Setting<ByteSizeValue> SHARED_CACHE_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.range_size", ByteSizeValue.ofMb((long)16L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.range_size"), FrozenCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.recovery_range_size", ByteSizeValue.ofKb((long)128L).getStringRep(), s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.recovery_range_size"), FrozenCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.recovery_range_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SHARED_CACHE_REGION_SIZE_SETTING = new Setting("xpack.searchable.snapshot.shared_cache.region_size", SHARED_CACHE_RANGE_SIZE_SETTING, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.region_size"), FrozenCacheService.getPositivePageSizeAlignedByteSizeValueValidator("xpack.searchable.snapshot.shared_cache.region_size"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<RelativeByteSizeValue> SHARED_CACHE_SIZE_SETTING = new Setting<RelativeByteSizeValue>((Setting.Key)new Setting.SimpleKey("xpack.searchable.snapshot.shared_cache.size"), settings -> {
        if (DiscoveryNode.isDedicatedFrozenNode((Settings)settings)) {
            return "90%";
        }
        return ByteSizeValue.ZERO.getStringRep();
    }, s -> RelativeByteSizeValue.parseRelativeByteSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size"), (Setting.Validator)new Setting.Validator<RelativeByteSizeValue>(){

        public void validate(RelativeByteSizeValue value) {
        }

        public void validate(RelativeByteSizeValue value, Map<Setting<?>, Object> settings) {
            if (value.isAbsolute() && value.getAbsolute().getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{"xpack.searchable.snapshot.shared_cache.size"});
            }
            if (value.isNonZeroSize()) {
                List dataPaths;
                List roles = (List)settings.get(NodeRoleSettings.NODE_ROLES_SETTING);
                if (!DataTier.isFrozenNode(new HashSet(roles))) {
                    deprecationLogger.critical(DeprecationCategory.SETTINGS, "shared_cache", "setting [{}] to be positive [{}] on node without the data_frozen role is deprecated, roles are [{}]", new Object[]{"xpack.searchable.snapshot.shared_cache.size", value.getStringRep(), roles.stream().map(DiscoveryNodeRole::roleName).collect(Collectors.joining(","))});
                }
                if ((dataPaths = (List)settings.get(Environment.PATH_DATA_SETTING)).size() > 1) {
                    throw new SettingsException("setting [{}={}] is not permitted on nodes with multiple data paths [{}]", new Object[]{SHARED_CACHE_SIZE_SETTING.getKey(), value.getStringRep(), String.join((CharSequence)",", dataPaths)});
                }
            }
        }

        public Iterator<Setting<?>> settings() {
            List<Setting> settings = Arrays.asList(NodeRoleSettings.NODE_ROLES_SETTING, Environment.PATH_DATA_SETTING);
            return settings.iterator();
        }
    }, new Setting.Property[]{Setting.Property.NodeScope}){

        public RelativeByteSizeValue get(Settings settings) {
            RelativeByteSizeValue value = (RelativeByteSizeValue)super.get(settings);
            List roles = (List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings);
            HashSet roleSet = new HashSet(roles);
            if (DataTier.isFrozenNode(roleSet)) {
                return value;
            }
            return RelativeByteSizeValue.ZERO;
        }
    };
    public static final Setting<ByteSizeValue> SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING = new Setting((Setting.Key)new Setting.SimpleKey("xpack.searchable.snapshot.shared_cache.size.max_headroom"), settings -> {
        if (!SHARED_CACHE_SIZE_SETTING.exists(settings) && DiscoveryNode.isDedicatedFrozenNode((Settings)settings)) {
            return "100GB";
        }
        return "-1";
    }, s -> ByteSizeValue.parseBytesSizeValue((String)s, (String)"xpack.searchable.snapshot.shared_cache.size.max_headroom"), (Setting.Validator)new Setting.Validator<ByteSizeValue>(){
        private final Collection<Setting<?>> dependencies = Collections.singletonList(SHARED_CACHE_SIZE_SETTING);

        public Iterator<Setting<?>> settings() {
            return this.dependencies.iterator();
        }

        public void validate(ByteSizeValue value) {
        }

        public void validate(ByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            RelativeByteSizeValue sizeValue;
            if (isPresent && value.getBytes() != -1L && (sizeValue = (RelativeByteSizeValue)settings.get(SHARED_CACHE_SIZE_SETTING)).isAbsolute()) {
                throw new SettingsException("setting [{}] cannot be specified for absolute [{}={}]", new Object[]{SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.getKey(), SHARED_CACHE_SIZE_SETTING.getKey(), sizeValue.getStringRep()});
            }
        }
    }, new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue MIN_SHARED_CACHE_DECAY_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    public static final Setting<TimeValue> SHARED_CACHE_DECAY_INTERVAL_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.decay.interval", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)MIN_SHARED_CACHE_DECAY_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<Integer> SHARED_CACHE_MAX_FREQ_SETTING = Setting.intSetting((String)"xpack.searchable.snapshot.shared_cache.max_freq", (int)100, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> SHARED_CACHE_MIN_TIME_DELTA_SETTING = Setting.timeSetting((String)"xpack.searchable.snapshot.shared_cache.min_time_delta", (TimeValue)TimeValue.timeValueSeconds((long)60L), (TimeValue)TimeValue.timeValueSeconds((long)0L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(FrozenCacheService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(FrozenCacheService.class);
    private final ConcurrentHashMap<RegionKey, Entry<CacheFileRegion>> keyMapping;
    private final LongSupplier currentTimeSupplier;
    private final KeyedLock<CacheKey> keyedLock = new KeyedLock();
    private final SharedBytes sharedBytes;
    private final long cacheSize;
    private final long regionSize;
    private final ByteSizeValue rangeSize;
    private final ByteSizeValue recoveryRangeSize;
    private final int numRegions;
    private final ConcurrentLinkedQueue<Integer> freeRegions = new ConcurrentLinkedQueue();
    private final Entry<CacheFileRegion>[] freqs;
    private final int maxFreq;
    private final long minTimeDelta;
    private final AtomicReference<CacheFileRegion>[] regionOwners;
    private final CacheDecayTask decayTask;
    private final LongAdder writeCount = new LongAdder();
    private final LongAdder writeBytes = new LongAdder();
    private final LongAdder readCount = new LongAdder();
    private final LongAdder readBytes = new LongAdder();
    private final LongAdder evictCount = new LongAdder();

    private static Setting.Validator<ByteSizeValue> getPageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() == -1L) {
                throw new SettingsException("setting [{}] must be non-negative", new Object[]{settingName});
            }
            if (value.getBytes() % (long)SharedBytes.PAGE_SIZE != 0L) {
                throw new SettingsException("setting [{}] must be multiple of {}", new Object[]{settingName, SharedBytes.PAGE_SIZE});
            }
        };
    }

    private static Setting.Validator<ByteSizeValue> getPositivePageSizeAlignedByteSizeValueValidator(String settingName) {
        return value -> {
            if (value.getBytes() <= 0L) {
                throw new SettingsException("setting [{}] must be greater than zero", new Object[]{settingName});
            }
            FrozenCacheService.getPageSizeAlignedByteSizeValueValidator(settingName).validate(value);
        };
    }

    public FrozenCacheService(NodeEnvironment environment, Settings settings, ThreadPool threadPool) {
        int i;
        long totalFsSize;
        this.currentTimeSupplier = () -> ((ThreadPool)threadPool).relativeTimeInMillis();
        try {
            totalFsSize = FsProbe.getTotal((FileStore)Environment.getFileStore((Path)environment.nodeDataPaths()[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to probe size of filesystem [" + environment.nodeDataPaths()[0] + "]");
        }
        this.cacheSize = FrozenCacheService.calculateCacheSize(settings, totalFsSize);
        long regionSize = ((ByteSizeValue)SHARED_CACHE_REGION_SIZE_SETTING.get(settings)).getBytes();
        this.numRegions = Math.toIntExact(this.cacheSize / regionSize);
        this.keyMapping = new ConcurrentHashMap();
        if (Assertions.ENABLED) {
            this.regionOwners = new AtomicReference[this.numRegions];
            for (i = 0; i < this.numRegions; ++i) {
                this.regionOwners[i] = new AtomicReference();
            }
        } else {
            this.regionOwners = null;
        }
        for (i = 0; i < this.numRegions; ++i) {
            this.freeRegions.add(i);
        }
        this.regionSize = regionSize;
        assert (regionSize > 0L);
        this.maxFreq = (Integer)SHARED_CACHE_MAX_FREQ_SETTING.get(settings);
        this.minTimeDelta = ((TimeValue)SHARED_CACHE_MIN_TIME_DELTA_SETTING.get(settings)).millis();
        this.freqs = new Entry[this.maxFreq];
        try {
            this.sharedBytes = new SharedBytes(this.numRegions, regionSize, environment, this.writeBytes::add, this.readBytes::add);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.decayTask = new CacheDecayTask(threadPool, (TimeValue)SHARED_CACHE_DECAY_INTERVAL_SETTING.get(settings));
        this.decayTask.rescheduleIfNecessary();
        this.rangeSize = (ByteSizeValue)SHARED_CACHE_RANGE_SIZE_SETTING.get(settings);
        this.recoveryRangeSize = (ByteSizeValue)SHARED_CACHE_RECOVERY_RANGE_SIZE_SETTING.get(settings);
    }

    static long calculateCacheSize(Settings settings, long totalFsSize) {
        return ((RelativeByteSizeValue)SHARED_CACHE_SIZE_SETTING.get(settings)).calculateValue(ByteSizeValue.ofBytes((long)totalFsSize), (ByteSizeValue)SHARED_CACHE_SIZE_MAX_HEADROOM_SETTING.get(settings)).getBytes();
    }

    public int getRangeSize() {
        return SearchableSnapshotsUtils.toIntBytes(this.rangeSize.getBytes());
    }

    public int getRecoveryRangeSize() {
        return SearchableSnapshotsUtils.toIntBytes(this.recoveryRangeSize.getBytes());
    }

    private int getRegion(long position) {
        return Math.toIntExact(position / this.regionSize);
    }

    private long getRegionRelativePosition(long position) {
        return position % this.regionSize;
    }

    private long getRegionStart(int region) {
        return (long)region * this.regionSize;
    }

    private long getRegionEnd(int region) {
        return (long)(region + 1) * this.regionSize;
    }

    private int getEndingRegion(long position) {
        assert (position > 0L);
        if (position % this.regionSize == 0L) {
            return this.getRegion(position - 1L);
        }
        return this.getRegion(position);
    }

    private ByteRange mapSubRangeToRegion(ByteRange range, int region) {
        long rangeEnd;
        long regionStart = this.getRegionStart(region);
        long regionEnd = this.getRegionEnd(region);
        if (range.start() >= regionEnd || range.end() <= regionStart) {
            return ByteRange.EMPTY;
        }
        long rangeStart = Math.max(regionStart, range.start());
        if (rangeStart >= (rangeEnd = Math.min(regionEnd, range.end()))) {
            return ByteRange.EMPTY;
        }
        return ByteRange.of(this.getRegionRelativePosition(rangeStart), rangeEnd == regionEnd ? this.regionSize : this.getRegionRelativePosition(rangeEnd));
    }

    private long getRegionSize(long fileLength, int region) {
        long effectiveRegionSize;
        assert (fileLength > 0L);
        int maxRegion = this.getEndingRegion(fileLength);
        assert (region >= 0 && region <= maxRegion) : region + " - " + maxRegion;
        if (region == maxRegion && (long)(region + 1) * this.regionSize != fileLength) {
            assert (this.getRegionRelativePosition(fileLength) != 0L);
            effectiveRegionSize = this.getRegionRelativePosition(fileLength);
        } else {
            effectiveRegionSize = this.regionSize;
        }
        assert (this.getRegionStart(region) + effectiveRegionSize <= fileLength);
        return effectiveRegionSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheFileRegion get(CacheKey cacheKey, long fileLength, int region) {
        long effectiveRegionSize = this.getRegionSize(fileLength, region);
        try (Releasable ignore = this.keyedLock.acquire((Object)cacheKey);){
            RegionKey regionKey = new RegionKey(cacheKey, region);
            long now = this.currentTimeSupplier.getAsLong();
            Entry entry = this.keyMapping.computeIfAbsent(regionKey, key -> new Entry<CacheFileRegion>(new CacheFileRegion(regionKey, effectiveRegionSize), now));
            if (((CacheFileRegion)((Object)entry.chunk)).sharedBytesPos == -1) {
                assert (entry.freq == 0);
                assert (entry.prev == null);
                assert (entry.next == null);
                Integer freeSlot = this.freeRegions.poll();
                if (freeSlot != null) {
                    ((CacheFileRegion)((Object)entry.chunk)).sharedBytesPos = freeSlot;
                    assert (this.regionOwners[freeSlot].compareAndSet(null, (CacheFileRegion)((Object)entry.chunk)));
                    FrozenCacheService frozenCacheService = this;
                    synchronized (frozenCacheService) {
                        this.pushEntryToBack(entry);
                    }
                }
                FrozenCacheService frozenCacheService = this;
                synchronized (frozenCacheService) {
                    this.maybeEvict();
                }
                Integer freeSlotRetry = this.freeRegions.poll();
                if (freeSlotRetry != null) {
                    ((CacheFileRegion)((Object)entry.chunk)).sharedBytesPos = freeSlotRetry;
                    assert (this.regionOwners[freeSlotRetry].compareAndSet(null, (CacheFileRegion)((Object)entry.chunk)));
                    FrozenCacheService frozenCacheService2 = this;
                    synchronized (frozenCacheService2) {
                        this.pushEntryToBack(entry);
                    }
                }
                boolean removed = this.keyMapping.remove(regionKey, entry);
                assert (removed);
                throw new AlreadyClosedException("no free region found");
            }
            Object object = this;
            synchronized (object) {
                if (now - entry.lastAccessed >= this.minTimeDelta && entry.freq + 1 < this.maxFreq) {
                    this.unlink(entry);
                    ++entry.freq;
                    entry.lastAccessed = now;
                    this.pushEntryToBack(entry);
                }
            }
            object = (CacheFileRegion)((Object)entry.chunk);
            return object;
        }
    }

    public void onClose(CacheFileRegion chunk) {
        assert (this.regionOwners[chunk.sharedBytesPos].compareAndSet(chunk, null));
        this.freeRegions.add(chunk.sharedBytesPos);
    }

    int freeRegionCount() {
        return this.freeRegions.size();
    }

    public Stats getStats() {
        return new Stats(this.numRegions, this.cacheSize, this.regionSize, this.evictCount.sum(), this.writeCount.sum(), this.writeBytes.sum(), this.readCount.sum(), this.readBytes.sum());
    }

    private synchronized boolean invariant(Entry<CacheFileRegion> e, boolean present) {
        boolean found = false;
        for (int i = 0; i < this.maxFreq; ++i) {
            assert (this.freqs[i] == null || this.freqs[i].prev != null);
            assert (this.freqs[i] == null || this.freqs[i].prev != this.freqs[i] || this.freqs[i].next == null);
            assert (this.freqs[i] == null || this.freqs[i].prev.next == null);
            Entry<CacheFileRegion> entry = this.freqs[i];
            while (entry != null) {
                assert (entry.next == null || entry.next.prev == entry);
                assert (entry.prev != null);
                assert (entry.prev.next == null || entry.prev.next == entry);
                assert (entry.freq == i);
                if (entry == e) {
                    found = true;
                }
                entry = entry.next;
            }
            entry = this.freqs[i];
            while (entry != null && entry.prev != this.freqs[i]) {
                assert (entry.next == null || entry.next.prev == entry);
                assert (entry.prev != null);
                assert (entry.prev.next == null || entry.prev.next == entry);
                assert (entry.freq == i);
                if (entry == e) {
                    found = true;
                }
                entry = entry.prev;
            }
        }
        assert (found == present);
        return true;
    }

    private void maybeEvict() {
        assert (Thread.holdsLock(this));
        for (int i = 0; i < this.maxFreq; ++i) {
            Entry<CacheFileRegion> entry = this.freqs[i];
            while (entry != null) {
                boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).tryEvict();
                if (evicted) {
                    this.unlink(entry);
                    this.keyMapping.remove(((CacheFileRegion)((Object)entry.chunk)).regionKey, entry);
                    return;
                }
                entry = entry.next;
            }
        }
    }

    private void pushEntryToBack(Entry<CacheFileRegion> entry) {
        assert (Thread.holdsLock(this));
        assert (this.invariant(entry, false));
        assert (entry.prev == null);
        assert (entry.next == null);
        Entry<CacheFileRegion> currFront = this.freqs[entry.freq];
        if (currFront == null) {
            this.freqs[entry.freq] = entry;
            entry.prev = entry;
            entry.next = null;
        } else {
            assert (currFront.freq == entry.freq);
            Entry last = currFront.prev;
            currFront.prev = entry;
            last.next = entry;
            entry.prev = last;
            entry.next = null;
        }
        assert (this.freqs[entry.freq].prev == entry);
        assert (this.freqs[entry.freq].prev.next == null);
        assert (entry.prev != null);
        assert (entry.prev.next == null || entry.prev.next == entry);
        assert (entry.next == null);
        assert (this.invariant(entry, true));
    }

    private void unlink(Entry<CacheFileRegion> entry) {
        assert (Thread.holdsLock(this));
        assert (this.invariant(entry, true));
        assert (entry.prev != null);
        Entry<CacheFileRegion> currFront = this.freqs[entry.freq];
        assert (currFront != null);
        if (currFront == entry) {
            this.freqs[entry.freq] = entry.next;
            if (entry.next != null) {
                assert (entry.prev != entry);
                entry.next.prev = entry.prev;
            }
        } else {
            if (entry.next != null) {
                entry.next.prev = entry.prev;
            }
            entry.prev.next = entry.next;
            if (currFront.prev == entry) {
                currFront.prev = entry.prev;
            }
        }
        entry.next = null;
        entry.prev = null;
        assert (this.invariant(entry, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeDecay() {
        FrozenCacheService frozenCacheService = this;
        synchronized (frozenCacheService) {
            long now = this.currentTimeSupplier.getAsLong();
            for (int i = 0; i < this.maxFreq; ++i) {
                Entry<CacheFileRegion> entry = this.freqs[i];
                while (entry != null) {
                    if (now - entry.lastAccessed >= 2L * this.minTimeDelta && entry.freq > 0) {
                        this.unlink(entry);
                        --entry.freq;
                        this.pushEntryToBack(entry);
                    }
                    entry = entry.next;
                }
            }
        }
    }

    public void removeFromCache(CacheKey cacheKey) {
        this.forceEvict(cacheKey::equals);
    }

    public void markShardAsEvictedInCache(String snapshotUUID, String snapshotIndexName, ShardId shardId) {
        this.forceEvict(k -> shardId.equals((Object)k.getShardId()) && snapshotIndexName.equals(k.getSnapshotIndexName()) && snapshotUUID.equals(k.getSnapshotUUID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceEvict(Predicate<CacheKey> cacheKeyPredicate) {
        ArrayList matchingEntries = new ArrayList();
        this.keyMapping.forEach((key, value) -> {
            if (cacheKeyPredicate.test(key.file)) {
                matchingEntries.add(value);
            }
        });
        if (!matchingEntries.isEmpty()) {
            FrozenCacheService frozenCacheService = this;
            synchronized (frozenCacheService) {
                for (Entry entry : matchingEntries) {
                    boolean evicted = ((CacheFileRegion)((Object)entry.chunk)).forceEvict();
                    if (!evicted) continue;
                    this.unlink(entry);
                    this.keyMapping.remove(((CacheFileRegion)((Object)entry.chunk)).regionKey, entry);
                }
            }
        }
    }

    int getFreq(CacheFileRegion cacheFileRegion) {
        return this.keyMapping.get((Object)cacheFileRegion.regionKey).freq;
    }

    public void close() {
        this.sharedBytes.decRef();
        this.decayTask.close();
    }

    public FrozenCacheFile getFrozenCacheFile(CacheKey cacheKey, long length) {
        return new FrozenCacheFile(cacheKey, length);
    }

    static class Entry<T> {
        final T chunk;
        Entry<T> prev;
        Entry<T> next;
        int freq;
        long lastAccessed;

        Entry(T chunk, long lastAccessed) {
            this.chunk = chunk;
            this.lastAccessed = lastAccessed;
        }
    }

    class CacheDecayTask
    extends AbstractAsyncTask {
        CacheDecayTask(ThreadPool threadPool, TimeValue interval) {
            super(logger, Objects.requireNonNull(threadPool), Objects.requireNonNull(interval), true);
        }

        protected boolean mustReschedule() {
            return true;
        }

        public void runInternal() {
            FrozenCacheService.this.computeDecay();
        }

        protected String getThreadPool() {
            return "generic";
        }

        public String toString() {
            return "frozen_cache_decay_task";
        }
    }

    private static class RegionKey {
        final CacheKey file;
        final int region;

        RegionKey(CacheKey file, int region) {
            this.file = file;
            this.region = region;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegionKey regionKey = (RegionKey)o;
            return this.region == regionKey.region && this.file.equals(regionKey.file);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.region);
        }

        public String toString() {
            return "Chunk{file=" + this.file + ", region=" + this.region + '}';
        }
    }

    class CacheFileRegion
    extends AbstractRefCounted {
        final RegionKey regionKey;
        final SparseFileTracker tracker;
        volatile int sharedBytesPos = -1;
        private final AtomicBoolean evicted = new AtomicBoolean(false);

        CacheFileRegion(RegionKey regionKey, long regionSize) {
            this.regionKey = regionKey;
            assert (regionSize > 0L);
            this.tracker = new SparseFileTracker("file", regionSize);
        }

        public long physicalStartOffset() {
            return FrozenCacheService.this.sharedBytes.getPhysicalOffset(this.sharedBytesPos);
        }

        public long physicalEndOffset() {
            return FrozenCacheService.this.sharedBytes.getPhysicalOffset(this.sharedBytesPos + 1);
        }

        public boolean tryEvict() {
            if (this.refCount() <= 1 && this.evicted.compareAndSet(false, true)) {
                logger.trace("evicted {} with channel offset {}", (Object)this.regionKey, (Object)this.physicalStartOffset());
                FrozenCacheService.this.evictCount.increment();
                this.decRef();
                return true;
            }
            return false;
        }

        public boolean forceEvict() {
            if (this.evicted.compareAndSet(false, true)) {
                logger.trace("force evicted {} with channel offset {}", (Object)this.regionKey, (Object)this.physicalStartOffset());
                FrozenCacheService.this.evictCount.increment();
                this.decRef();
                return true;
            }
            return false;
        }

        public boolean isEvicted() {
            return this.evicted.get();
        }

        protected void closeInternal() {
            FrozenCacheService.this.onClose(this);
            logger.trace("closed {} with channel offset {}", (Object)this.regionKey, (Object)this.physicalStartOffset());
        }

        private void ensureOpen() {
            if (this.evicted.get()) {
                this.throwAlreadyEvicted();
            }
        }

        private void throwAlreadyEvicted() {
            throw new AlreadyClosedException("File chunk is evicted");
        }

        StepListener<Integer> populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, final RangeMissingHandler writer, Executor executor) {
            assert (rangeToRead.length() > 0L);
            StepListener listener = new StepListener();
            Releasable decrementRef = null;
            try {
                this.ensureOpen();
                this.incRef();
                decrementRef = Releasables.releaseOnce(() -> ((CacheFileRegion)this).decRef());
                this.ensureOpen();
                Releasable finalDecrementRef = decrementRef;
                listener.whenComplete(integer -> finalDecrementRef.close(), throwable -> finalDecrementRef.close());
                final SharedBytes.IO fileChannel = FrozenCacheService.this.sharedBytes.getFileChannel(this.sharedBytesPos);
                listener.whenComplete(integer -> fileChannel.decRef(), e -> fileChannel.decRef());
                ActionListener<Void> rangeListener = this.rangeListener(rangeToRead, reader, (ActionListener<Integer>)listener, fileChannel);
                List<SparseFileTracker.Gap> gaps = this.tracker.waitForRange(rangeToWrite, rangeToRead, rangeListener);
                for (final SparseFileTracker.Gap gap : gaps) {
                    executor.execute((Runnable)new AbstractRunnable(){

                        protected void doRun() throws Exception {
                            if (!CacheFileRegion.this.tryIncRef()) {
                                throw new AlreadyClosedException("Cache file channel has been released and closed");
                            }
                            try {
                                CacheFileRegion.this.ensureOpen();
                                long start = gap.start();
                                assert (FrozenCacheService.this.regionOwners[CacheFileRegion.this.sharedBytesPos].get() == CacheFileRegion.this);
                                writer.fillCacheRange(fileChannel, CacheFileRegion.this.physicalStartOffset() + gap.start(), gap.start(), gap.end() - gap.start(), progress -> gap.onProgress(start + progress));
                                FrozenCacheService.this.writeCount.increment();
                            }
                            finally {
                                CacheFileRegion.this.decRef();
                            }
                            gap.onCompletion();
                        }

                        public void onFailure(Exception e) {
                            gap.onFailure(e);
                        }
                    });
                }
            }
            catch (Exception e2) {
                this.releaseAndFail((ActionListener<Integer>)listener, decrementRef, e2);
            }
            return listener;
        }

        private ActionListener<Void> rangeListener(ByteRange rangeToRead, RangeAvailableHandler reader, ActionListener<Integer> listener, SharedBytes.IO fileChannel) {
            return ActionListener.wrap(success -> {
                long physicalStartOffset = this.physicalStartOffset();
                assert (FrozenCacheService.this.regionOwners[this.sharedBytesPos].get() == this);
                int read = reader.onRangeAvailable(fileChannel, physicalStartOffset + rangeToRead.start(), rangeToRead.start(), rangeToRead.length());
                assert ((long)read == rangeToRead.length()) : "partial read [" + read + "] does not match the range to read [" + rangeToRead.end() + '-' + rangeToRead.start() + ']';
                FrozenCacheService.this.readCount.increment();
                listener.onResponse((Object)read);
            }, arg_0 -> listener.onFailure(arg_0));
        }

        private void releaseAndFail(ActionListener<Integer> listener, Releasable decrementRef, Exception e) {
            try {
                Releasables.close((Releasable)decrementRef);
            }
            catch (Exception ex) {
                e.addSuppressed(ex);
            }
            listener.onFailure(e);
        }

        protected void alreadyClosed() {
            this.throwAlreadyEvicted();
        }
    }

    public static class Stats {
        public static final Stats EMPTY = new Stats(0, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        private final int numberOfRegions;
        private final long size;
        private final long regionSize;
        private final long evictCount;
        private final long writeCount;
        private final long writeBytes;
        private final long readCount;
        private final long readBytes;

        private Stats(int numberOfRegions, long size, long regionSize, long evictCount, long writeCount, long writeBytes, long readCount, long readBytes) {
            this.numberOfRegions = numberOfRegions;
            this.size = size;
            this.regionSize = regionSize;
            this.evictCount = evictCount;
            this.writeCount = writeCount;
            this.writeBytes = writeBytes;
            this.readCount = readCount;
            this.readBytes = readBytes;
        }

        public int getNumberOfRegions() {
            return this.numberOfRegions;
        }

        public long getSize() {
            return this.size;
        }

        public long getRegionSize() {
            return this.regionSize;
        }

        public long getEvictCount() {
            return this.evictCount;
        }

        public long getWriteCount() {
            return this.writeCount;
        }

        public long getWriteBytes() {
            return this.writeBytes;
        }

        public long getReadCount() {
            return this.readCount;
        }

        public long getReadBytes() {
            return this.readBytes;
        }
    }

    public class FrozenCacheFile {
        private final CacheKey cacheKey;
        private final long length;

        private FrozenCacheFile(CacheKey cacheKey, long length) {
            this.cacheKey = cacheKey;
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public CacheKey getCacheKey() {
            return this.cacheKey;
        }

        public StepListener<Integer> populateAndRead(ByteRange rangeToWrite, ByteRange rangeToRead, RangeAvailableHandler reader, RangeMissingHandler writer, Executor executor) {
            StepListener stepListener = null;
            long writeStart = rangeToWrite.start();
            long readStart = rangeToRead.start();
            for (int region = FrozenCacheService.this.getRegion(rangeToWrite.start()); region <= FrozenCacheService.this.getEndingRegion(rangeToWrite.end()); ++region) {
                ByteRange subRangeToWrite = FrozenCacheService.this.mapSubRangeToRegion(rangeToWrite, region);
                ByteRange subRangeToRead = FrozenCacheService.this.mapSubRangeToRegion(rangeToRead, region);
                if (subRangeToRead.length() == 0L) {
                    if (stepListener != null) continue;
                    stepListener = new StepListener();
                    stepListener.onResponse((Object)0);
                    continue;
                }
                CacheFileRegion fileRegion = FrozenCacheService.this.get(this.cacheKey, this.length, region);
                long regionStart = FrozenCacheService.this.getRegionStart(region);
                long writeOffset = writeStart - regionStart;
                long readOffset = readStart - regionStart;
                StepListener lis = fileRegion.populateAndRead(subRangeToWrite, subRangeToRead, (channel, channelPos, relativePos, len) -> {
                    assert (FrozenCacheService.this.regionOwners[fileRegion.sharedBytesPos].get() == fileRegion);
                    assert (channelPos >= fileRegion.physicalStartOffset() && channelPos + len <= fileRegion.physicalEndOffset());
                    return reader.onRangeAvailable(channel, channelPos, relativePos - readOffset, len);
                }, (channel, channelPos, relativePos, len, progressUpdater) -> {
                    assert (FrozenCacheService.this.regionOwners[fileRegion.sharedBytesPos].get() == fileRegion);
                    assert (channelPos >= fileRegion.physicalStartOffset() && channelPos + len <= fileRegion.physicalEndOffset());
                    writer.fillCacheRange(channel, channelPos, relativePos - writeOffset, len, progressUpdater);
                }, executor);
                assert (lis != null);
                stepListener = stepListener == null ? lis : stepListener.thenCombine(lis, Math::addExact);
            }
            return stepListener;
        }

        public String toString() {
            return "FrozenCacheFile{cacheKey=" + this.cacheKey + ", length=" + this.length + '}';
        }
    }

    @FunctionalInterface
    public static interface RangeMissingHandler {
        public void fillCacheRange(SharedBytes.IO var1, long var2, long var4, long var6, Consumer<Long> var8) throws IOException;
    }

    @FunctionalInterface
    public static interface RangeAvailableHandler {
        public int onRangeAvailable(SharedBytes.IO var1, long var2, long var4, long var6) throws IOException;
    }
}

