/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.elasticsearch.Assertions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ProgressListenableActionFuture;

public class SparseFileTracker {
    private final TreeSet<Range> ranges = new TreeSet<Range>(Comparator.comparingLong(r -> r.start));
    private final Object mutex = new Object();
    private final String description;
    private final long length;
    private final long initialLength;

    public SparseFileTracker(String description, long length) {
        this(description, length, Collections.emptySortedSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparseFileTracker(String description, long length, SortedSet<ByteRange> ranges) {
        this.description = description;
        this.length = length;
        if (length < 0L) {
            throw new IllegalArgumentException("Length [" + length + "] must be equal to or greater than 0 for [" + description + "]");
        }
        long initialLength = 0L;
        if (!ranges.isEmpty()) {
            Object object = this.mutex;
            synchronized (object) {
                Range previous = null;
                for (ByteRange next : ranges) {
                    if (next.length() == 0L) {
                        throw new IllegalArgumentException("Range " + next + " cannot be empty");
                    }
                    if (length < next.end()) {
                        throw new IllegalArgumentException("Range " + next + " is exceeding maximum length [" + length + ']');
                    }
                    Range range = new Range(next);
                    if (previous != null && range.start <= previous.end) {
                        throw new IllegalArgumentException("Range " + range + " is overlapping a previous range " + previous);
                    }
                    boolean added = this.ranges.add(range);
                    assert (added) : range + " already exist in " + this.ranges;
                    previous = range;
                    initialLength += range.end - range.start;
                }
                assert (this.invariant());
            }
        }
        this.initialLength = initialLength;
    }

    public long getLength() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<ByteRange> getCompletedRanges() {
        TreeSet<ByteRange> completedRanges = null;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.invariant());
            for (Range range : this.ranges) {
                if (range.isPending()) continue;
                if (completedRanges == null) {
                    completedRanges = new TreeSet<ByteRange>();
                }
                completedRanges.add(ByteRange.of(range.start, range.end));
            }
        }
        return completedRanges == null ? Collections.emptySortedSet() : completedRanges;
    }

    public long getInitialLength() {
        return this.initialLength;
    }

    private long computeLengthOfRanges() {
        assert (Thread.holdsLock(this.mutex)) : "sum of length of the ranges must be computed under mutex";
        return this.ranges.stream().mapToLong(range -> range.end - range.start).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Gap> waitForRange(ByteRange range, ByteRange subRange, ActionListener<Void> listener) {
        ArrayList<Range> requiredRanges;
        if (this.length < range.end()) {
            throw new IllegalArgumentException("invalid range [" + range + ", length=" + this.length + "]");
        }
        if (this.length < subRange.end()) {
            throw new IllegalArgumentException("invalid range to listen to [" + subRange + ", length=" + this.length + "]");
        }
        if (!subRange.isSubRangeOf(range)) {
            throw new IllegalArgumentException("unable to listen to range [start=" + subRange.start() + ", end=" + subRange.end() + "] when range is [start=" + range.start() + ", end=" + range.end() + ", length=" + this.length + "]");
        }
        ActionListener<Void> wrappedListener = this.wrapWithAssertions(listener);
        ArrayList<Gap> gaps = new ArrayList<Gap>();
        Object object = this.mutex;
        synchronized (object) {
            assert (this.invariant());
            ArrayList<Range> pendingRanges = new ArrayList<Range>();
            Range targetRange = new Range(range);
            NavigableSet<Range> earlierRanges = this.ranges.headSet(targetRange, false);
            if (!earlierRanges.isEmpty()) {
                Range lastEarlierRange = (Range)earlierRanges.last();
                if (range.start() < lastEarlierRange.end) {
                    if (lastEarlierRange.isPending()) {
                        pendingRanges.add(lastEarlierRange);
                    }
                    targetRange.start = Math.min(range.end(), lastEarlierRange.end);
                }
            }
            while (targetRange.start < range.end()) {
                assert (0L <= targetRange.start) : targetRange;
                assert (this.invariant());
                SortedSet<Range> existingRanges = this.ranges.tailSet(targetRange);
                if (existingRanges.isEmpty()) {
                    Range newPendingRange = new Range(targetRange.start, range.end(), new ProgressListenableActionFuture(targetRange.start, range.end()));
                    this.ranges.add(newPendingRange);
                    pendingRanges.add(newPendingRange);
                    gaps.add(new Gap(newPendingRange));
                    targetRange.start = range.end();
                    continue;
                }
                Range firstExistingRange = existingRanges.first();
                assert (targetRange.start <= firstExistingRange.start) : targetRange + " vs " + firstExistingRange;
                if (targetRange.start == firstExistingRange.start) {
                    if (firstExistingRange.isPending()) {
                        pendingRanges.add(firstExistingRange);
                    }
                    targetRange.start = Math.min(range.end(), firstExistingRange.end);
                    continue;
                }
                long newPendingRangeEnd = Math.min(range.end(), firstExistingRange.start);
                Range newPendingRange = new Range(targetRange.start, newPendingRangeEnd, new ProgressListenableActionFuture(targetRange.start, newPendingRangeEnd));
                this.ranges.add(newPendingRange);
                pendingRanges.add(newPendingRange);
                gaps.add(new Gap(newPendingRange));
                targetRange.start = newPendingRange.end;
            }
            assert (targetRange.start == targetRange.end) : targetRange;
            assert (targetRange.start == range.end()) : targetRange;
            assert (this.invariant());
            assert (this.ranges.containsAll(pendingRanges)) : this.ranges + " vs " + pendingRanges;
            assert (pendingRanges.stream().allMatch(Range::isPending)) : pendingRanges;
            assert (pendingRanges.size() != 1 || gaps.size() <= 1) : gaps;
            requiredRanges = range.equals(subRange) ? pendingRanges : pendingRanges.stream().filter(pendingRange -> pendingRange.start < subRange.end()).filter(pendingRange -> subRange.start() < pendingRange.end).sorted(Comparator.comparingLong(r -> r.start)).collect(Collectors.toList());
        }
        switch (requiredRanges.size()) {
            case 0: {
                wrappedListener.onResponse(null);
                break;
            }
            case 1: {
                Range requiredRange = (Range)requiredRanges.get(0);
                requiredRange.completionListener.addListener((ActionListener<Long>)wrappedListener.map(progress -> null), Math.min(requiredRange.completionListener.end, subRange.end()));
                break;
            }
            default: {
                GroupedActionListener groupedActionListener = new GroupedActionListener(wrappedListener.map(progress -> null), requiredRanges.size());
                requiredRanges.forEach(r -> r.completionListener.addListener((ActionListener<Long>)groupedActionListener, Math.min(r.completionListener.end, subRange.end())));
            }
        }
        return Collections.unmodifiableList(gaps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForRangeIfPending(ByteRange range, ActionListener<Void> listener) {
        if (this.length < range.end()) {
            throw new IllegalArgumentException("invalid range [" + range + ", length=" + this.length + "]");
        }
        ActionListener<Void> wrappedListener = this.wrapWithAssertions(listener);
        ArrayList<Range> pendingRanges = new ArrayList<Range>();
        Object object = this.mutex;
        synchronized (object) {
            assert (this.invariant());
            Range targetRange = new Range(range);
            NavigableSet<Range> earlierRanges = this.ranges.headSet(targetRange, false);
            if (!earlierRanges.isEmpty()) {
                Range lastEarlierRange = (Range)earlierRanges.last();
                if (range.start() < lastEarlierRange.end) {
                    if (lastEarlierRange.isPending()) {
                        pendingRanges.add(lastEarlierRange);
                    }
                    targetRange.start = Math.min(range.end(), lastEarlierRange.end);
                }
            }
            while (targetRange.start < range.end()) {
                assert (0L <= targetRange.start) : targetRange;
                assert (this.invariant());
                SortedSet<Range> existingRanges = this.ranges.tailSet(targetRange);
                if (existingRanges.isEmpty()) {
                    return false;
                }
                Range firstExistingRange = existingRanges.first();
                assert (targetRange.start <= firstExistingRange.start) : targetRange + " vs " + firstExistingRange;
                if (targetRange.start == firstExistingRange.start) {
                    if (firstExistingRange.isPending()) {
                        pendingRanges.add(firstExistingRange);
                    }
                    targetRange.start = Math.min(range.end(), firstExistingRange.end);
                    continue;
                }
                return false;
            }
            assert (targetRange.start == targetRange.end) : targetRange;
            assert (targetRange.start == range.end()) : targetRange;
            assert (this.invariant());
        }
        switch (pendingRanges.size()) {
            case 0: {
                wrappedListener.onResponse(null);
                break;
            }
            case 1: {
                Range pendingRange = (Range)pendingRanges.get(0);
                pendingRange.completionListener.addListener((ActionListener<Long>)wrappedListener.map(progress -> null), Math.min(pendingRange.completionListener.end, range.end()));
                return true;
            }
            default: {
                GroupedActionListener groupedActionListener = new GroupedActionListener(wrappedListener.map(progress -> null), pendingRanges.size());
                pendingRanges.forEach(r -> r.completionListener.addListener((ActionListener<Long>)groupedActionListener, Math.min(r.completionListener.end, range.end())));
                return true;
            }
        }
        return true;
    }

    private ActionListener<Void> wrapWithAssertions(ActionListener<Void> listener) {
        if (Assertions.ENABLED) {
            return ActionListener.runAfter(listener, () -> {
                assert (!Thread.holdsLock(this.mutex)) : "mutex unexpectedly held in listener";
            });
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ByteRange getAbsentRangeWithin(ByteRange range) {
        Object object = this.mutex;
        synchronized (object) {
            long resultEnd;
            long resultStart;
            long start = range.start();
            NavigableSet<Range> startRanges = this.ranges.headSet(new Range(start, start, null), true);
            if (startRanges.isEmpty()) {
                resultStart = start;
            } else {
                Range lastStartRange = (Range)startRanges.last();
                resultStart = lastStartRange.end < start ? start : (lastStartRange.isPending() ? start : lastStartRange.end);
            }
            assert (resultStart >= start);
            long end = range.end();
            NavigableSet<Range> endRanges = this.ranges.headSet(new Range(end, end, null), false);
            if (endRanges.isEmpty()) {
                resultEnd = end;
            } else {
                Range lastEndRange = (Range)endRanges.last();
                resultEnd = lastEndRange.end < end ? end : (lastEndRange.isPending() ? end : lastEndRange.start);
            }
            assert (resultEnd <= end);
            return resultStart < resultEnd ? ByteRange.of(resultStart, resultEnd) : null;
        }
    }

    private boolean assertPendingRangeExists(Range range) {
        assert (Thread.holdsLock(this.mutex));
        SortedSet<Range> existingRanges = this.ranges.tailSet(range);
        assert (!existingRanges.isEmpty());
        Range existingRange = existingRanges.first();
        assert (existingRange == range);
        assert (existingRange.isPending());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGapSuccess(Range gapRange) {
        ProgressListenableActionFuture completionListener;
        Object object = this.mutex;
        synchronized (object) {
            boolean mergeWithNext;
            Range nextRange;
            Range prevRange;
            assert (this.invariant());
            assert (this.assertPendingRangeExists(gapRange));
            completionListener = gapRange.completionListener;
            this.ranges.remove(gapRange);
            SortedSet<Range> prevRanges = this.ranges.headSet(gapRange);
            Range range = prevRange = prevRanges.isEmpty() ? null : prevRanges.last();
            assert (prevRange == null || prevRange.end <= gapRange.start) : prevRange + " vs " + gapRange;
            boolean mergeWithPrev = prevRange != null && !prevRange.isPending() && prevRange.end == gapRange.start;
            SortedSet<Range> nextRanges = this.ranges.tailSet(gapRange);
            Range range2 = nextRange = nextRanges.isEmpty() ? null : nextRanges.first();
            assert (nextRange == null || gapRange.end <= nextRange.start) : gapRange + " vs " + nextRange;
            boolean bl = mergeWithNext = nextRange != null && !nextRange.isPending() && gapRange.end == nextRange.start;
            if (mergeWithPrev && mergeWithNext) {
                assert (!prevRange.isPending()) : prevRange;
                assert (!nextRange.isPending()) : nextRange;
                assert (prevRange.end == gapRange.start) : prevRange + " vs " + gapRange;
                assert (gapRange.end == nextRange.start) : gapRange + " vs " + nextRange;
                prevRange.end = nextRange.end;
                this.ranges.remove(nextRange);
            } else if (mergeWithPrev) {
                assert (!prevRange.isPending()) : prevRange;
                assert (prevRange.end == gapRange.start) : prevRange + " vs " + gapRange;
                prevRange.end = gapRange.end;
            } else if (mergeWithNext) {
                assert (!nextRange.isPending()) : nextRange;
                assert (gapRange.end == nextRange.start) : gapRange + " vs " + nextRange;
                nextRange.start = gapRange.start;
            } else {
                this.ranges.add(new Range(gapRange.start, gapRange.end, null));
            }
            assert (this.invariant());
        }
        completionListener.onResponse(gapRange.end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGapProgress(Range gapRange, long value) {
        ProgressListenableActionFuture completionListener;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.invariant());
            assert (this.assertPendingRangeExists(gapRange));
            completionListener = gapRange.completionListener;
            assert (this.invariant());
        }
        completionListener.onProgress(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGapFailure(Range gapRange, Exception e) {
        ProgressListenableActionFuture completionListener;
        Object object = this.mutex;
        synchronized (object) {
            assert (this.invariant());
            assert (this.assertPendingRangeExists(gapRange));
            completionListener = gapRange.completionListener;
            boolean removed = this.ranges.remove(gapRange);
            assert (removed) : gapRange + " not found";
            assert (this.invariant());
        }
        completionListener.onFailure(e);
    }

    private boolean invariant() {
        long lengthOfRanges = 0L;
        Range previousRange = null;
        for (Range range : this.ranges) {
            if (previousRange != null) {
                assert (range.start < range.end) : range;
                assert (previousRange.end <= range.start) : previousRange + " vs " + range;
                assert (previousRange.isPending() || range.isPending() || previousRange.end < range.start) : previousRange + " vs " + range;
            }
            assert (range.end <= this.length);
            lengthOfRanges += range.end - range.start;
            previousRange = range;
        }
        assert (this.computeLengthOfRanges() <= this.length);
        assert (this.computeLengthOfRanges() == lengthOfRanges);
        return true;
    }

    public String toString() {
        return "SparseFileTracker[" + this.description + ']';
    }

    private static class Range {
        long start;
        long end;
        @Nullable
        final ProgressListenableActionFuture completionListener;

        Range(ByteRange range) {
            this(range.start(), range.end(), null);
        }

        Range(long start, long end, @Nullable ProgressListenableActionFuture completionListener) {
            assert (start <= end) : start + "-" + end;
            this.start = start;
            this.end = end;
            this.completionListener = completionListener;
        }

        boolean isPending() {
            return this.completionListener != null;
        }

        public String toString() {
            return "[" + this.start + "-" + this.end + (this.isPending() ? ", pending]" : "]");
        }
    }

    public class Gap {
        public final Range range;

        Gap(Range range) {
            assert (range.start < range.end) : range.start + "-" + range.end;
            this.range = range;
        }

        public long start() {
            return this.range.start;
        }

        public long end() {
            return this.range.end;
        }

        public void onCompletion() {
            SparseFileTracker.this.onGapSuccess(this.range);
        }

        public void onProgress(long value) {
            SparseFileTracker.this.onGapProgress(this.range, value);
        }

        public void onFailure(Exception e) {
            SparseFileTracker.this.onGapFailure(this.range, e);
        }

        public String toString() {
            return SparseFileTracker.this.toString() + ' ' + this.range;
        }
    }
}

