/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.StreamFileValuePatternReaderThread;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.ValuePatternComponent;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

final class StreamFileValuePatternComponent
extends ValuePatternComponent {
    private static final long serialVersionUID = -4557045230341165225L;
    private final AtomicLong nextReadPosition;
    private final AtomicReference<StreamFileValuePatternReaderThread> threadRef;
    private final File file;
    private final LinkedBlockingQueue<String> lineQueue;
    private final long maxOfferBlockTimeMillis;

    StreamFileValuePatternComponent(String path) throws IOException {
        this(path, 1000, 60000L);
    }

    StreamFileValuePatternComponent(String path, int queueSize, long maxOfferBlockTimeMillis) throws IOException {
        Validator.ensureNotNull(path);
        Validator.ensureTrue(queueSize > 0);
        Validator.ensureTrue(maxOfferBlockTimeMillis > 0L);
        this.maxOfferBlockTimeMillis = maxOfferBlockTimeMillis;
        this.file = new File(path);
        if (!this.file.exists()) {
            throw new IOException(UtilityMessages.ERR_STREAM_FILE_VALUE_PATTERN_PATH_MISSING.get(this.file.getAbsolutePath()));
        }
        if (!this.file.isFile()) {
            throw new IOException(UtilityMessages.ERR_STREAM_FILE_VALUE_PATTERN_PATH_NOT_FILE.get(this.file.getAbsolutePath()));
        }
        if (this.file.length() <= 0L) {
            throw new IOException(UtilityMessages.ERR_STREAM_FILE_VALUE_PATTERN_FILE_EMPTY.get(this.file.getAbsolutePath()));
        }
        this.lineQueue = new LinkedBlockingQueue(queueSize);
        this.nextReadPosition = new AtomicLong(0L);
        this.threadRef = new AtomicReference();
        StreamFileValuePatternReaderThread readerThread = new StreamFileValuePatternReaderThread(this.file, this.lineQueue, maxOfferBlockTimeMillis, this.nextReadPosition, this.threadRef);
        this.threadRef.set(readerThread);
        readerThread.start();
    }

    @Override
    void append(StringBuilder buffer) {
        String line = this.lineQueue.poll();
        if (line != null) {
            buffer.append(line);
            return;
        }
        StreamFileValuePatternComponent streamFileValuePatternComponent = this;
        synchronized (streamFileValuePatternComponent) {
            try {
                do {
                    StreamFileValuePatternReaderThread readerThread;
                    if ((readerThread = this.threadRef.get()) != null) continue;
                    readerThread = new StreamFileValuePatternReaderThread(this.file, this.lineQueue, this.maxOfferBlockTimeMillis, this.nextReadPosition, this.threadRef);
                    this.threadRef.set(readerThread);
                    readerThread.start();
                } while ((line = this.lineQueue.poll(10L, TimeUnit.MILLISECONDS)) == null);
                buffer.append(line);
                return;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_STREAM_FILE_VALUE_PATTERN_ERROR_GETTING_NEXT_VALUE.get(this.file.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e));
            }
        }
    }

    @Override
    boolean supportsBackReference() {
        return true;
    }
}

