// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package mybusinessplaceactions provides access to the My Business Place Actions API.
//
// For product documentation, see: https://developers.google.com/my-business/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/mybusinessplaceactions/v1"
//	...
//	ctx := context.Background()
//	mybusinessplaceactionsService, err := mybusinessplaceactions.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	mybusinessplaceactionsService, err := mybusinessplaceactions.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	mybusinessplaceactionsService, err := mybusinessplaceactions.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package mybusinessplaceactions // import "google.golang.org/api/mybusinessplaceactions/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "mybusinessplaceactions:v1"
const apiName = "mybusinessplaceactions"
const apiVersion = "v1"
const basePath = "https://mybusinessplaceactions.googleapis.com/"
const mtlsBasePath = "https://mybusinessplaceactions.mtls.googleapis.com/"

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Locations = NewLocationsService(s)
	s.PlaceActionTypeMetadata = NewPlaceActionTypeMetadataService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Locations *LocationsService

	PlaceActionTypeMetadata *PlaceActionTypeMetadataService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewLocationsService(s *Service) *LocationsService {
	rs := &LocationsService{s: s}
	rs.PlaceActionLinks = NewLocationsPlaceActionLinksService(s)
	return rs
}

type LocationsService struct {
	s *Service

	PlaceActionLinks *LocationsPlaceActionLinksService
}

func NewLocationsPlaceActionLinksService(s *Service) *LocationsPlaceActionLinksService {
	rs := &LocationsPlaceActionLinksService{s: s}
	return rs
}

type LocationsPlaceActionLinksService struct {
	s *Service
}

func NewPlaceActionTypeMetadataService(s *Service) *PlaceActionTypeMetadataService {
	rs := &PlaceActionTypeMetadataService{s: s}
	return rs
}

type PlaceActionTypeMetadataService struct {
	s *Service
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// ListPlaceActionLinksResponse: Response message for
// PlaceActions.ListPlaceActionLinks.
type ListPlaceActionLinksResponse struct {
	// NextPageToken: If there are more place action links than the
	// requested page size, then this field is populated with a token to
	// fetch the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PlaceActionLinks: The returned list of place action links.
	PlaceActionLinks []*PlaceActionLink `json:"placeActionLinks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPlaceActionLinksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPlaceActionLinksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListPlaceActionTypeMetadataResponse: Response message for
// PlaceActions.ListPlaceActionTypeMetadata.
type ListPlaceActionTypeMetadataResponse struct {
	// NextPageToken: If the number of action types exceeded the requested
	// page size, this field will be populated with a token to fetch the
	// next page on a subsequent call to `placeActionTypeMetadata.list`. If
	// there are no more results, this field will not be present in the
	// response.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// PlaceActionTypeMetadata: A collection of metadata for the available
	// place action types.
	PlaceActionTypeMetadata []*PlaceActionTypeMetadata `json:"placeActionTypeMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListPlaceActionTypeMetadataResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPlaceActionTypeMetadataResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PlaceActionLink: Represents a place action link and its attributes.
type PlaceActionLink struct {
	// CreateTime: Output only. The time when the place action link was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// IsEditable: Output only. Indicates whether this link can be edited by
	// the client.
	IsEditable bool `json:"isEditable,omitempty"`

	// IsPreferred: Optional. Whether this link is preferred by the
	// merchant. Only one link can be marked as preferred per place action
	// type at a location. If a future request marks a different link as
	// preferred for the same place action type, then the current preferred
	// link (if any exists) will lose its preference.
	IsPreferred bool `json:"isPreferred,omitempty"`

	// Name: Optional. The resource name, in the format
	// `locations/{location_id}/placeActionLinks/{place_action_link_id}`.
	// The name field will only be considered in UpdatePlaceActionLink and
	// DeletePlaceActionLink requests for updating and deleting links
	// respectively. However, it will be ignored in CreatePlaceActionLink
	// request, where `place_action_link_id` will be assigned by the server
	// on successful creation of a new link and returned as part of the
	// response.
	Name string `json:"name,omitempty"`

	// PlaceActionType: Required. The type of place action that can be
	// performed using this link.
	//
	// Possible values:
	//   "PLACE_ACTION_TYPE_UNSPECIFIED" - Not specified.
	//   "APPOINTMENT" - The action type is booking an appointment.
	//   "ONLINE_APPOINTMENT" - The action type is booking an online
	// appointment.
	//   "DINING_RESERVATION" - The action type is making a dining
	// reservation.
	//   "FOOD_ORDERING" - The action type is ordering food for delivery
	// and/or takeout.
	//   "FOOD_DELIVERY" - The action type is ordering food for delivery.
	//   "FOOD_TAKEOUT" - The action type is ordering food for takeout.
	//   "SHOP_ONLINE" - The action type is shopping, that can be delivery
	// and/or pickup.
	PlaceActionType string `json:"placeActionType,omitempty"`

	// ProviderType: Output only. Specifies the provider type.
	//
	// Possible values:
	//   "PROVIDER_TYPE_UNSPECIFIED" - Not specified.
	//   "MERCHANT" - A 1P provider such as a merchant, or an agency on
	// behalf of a merchant.
	//   "AGGREGATOR_3P" - A 3P aggregator, such as a `Reserve with Google`
	// partner.
	ProviderType string `json:"providerType,omitempty"`

	// UpdateTime: Output only. The time when the place action link was last
	// modified.
	UpdateTime string `json:"updateTime,omitempty"`

	// Uri: Required. The link uri. The same uri can be reused for different
	// action types across different locations. However, only one place
	// action link is allowed for each unique combination of (uri, place
	// action type, location).
	Uri string `json:"uri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PlaceActionLink) MarshalJSON() ([]byte, error) {
	type NoMethod PlaceActionLink
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PlaceActionTypeMetadata: Metadata for supported place action types.
type PlaceActionTypeMetadata struct {
	// DisplayName: The localized display name for the attribute, if
	// available; otherwise, the English display name.
	DisplayName string `json:"displayName,omitempty"`

	// PlaceActionType: The place action type.
	//
	// Possible values:
	//   "PLACE_ACTION_TYPE_UNSPECIFIED" - Not specified.
	//   "APPOINTMENT" - The action type is booking an appointment.
	//   "ONLINE_APPOINTMENT" - The action type is booking an online
	// appointment.
	//   "DINING_RESERVATION" - The action type is making a dining
	// reservation.
	//   "FOOD_ORDERING" - The action type is ordering food for delivery
	// and/or takeout.
	//   "FOOD_DELIVERY" - The action type is ordering food for delivery.
	//   "FOOD_TAKEOUT" - The action type is ordering food for takeout.
	//   "SHOP_ONLINE" - The action type is shopping, that can be delivery
	// and/or pickup.
	PlaceActionType string `json:"placeActionType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PlaceActionTypeMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod PlaceActionTypeMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "mybusinessplaceactions.locations.placeActionLinks.create":

type LocationsPlaceActionLinksCreateCall struct {
	s               *Service
	parent          string
	placeactionlink *PlaceActionLink
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Creates a place action link associated with the specified
// location, and returns it. The request is considered duplicate if the
// `parent`, `place_action_link.uri` and
// `place_action_link.place_action_type` are the same as a previous
// request.
//
//   - parent: The resource name of the location where to create this
//     place action link. `locations/{location_id}`.
func (r *LocationsPlaceActionLinksService) Create(parent string, placeactionlink *PlaceActionLink) *LocationsPlaceActionLinksCreateCall {
	c := &LocationsPlaceActionLinksCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.placeactionlink = placeactionlink
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsPlaceActionLinksCreateCall) Fields(s ...googleapi.Field) *LocationsPlaceActionLinksCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsPlaceActionLinksCreateCall) Context(ctx context.Context) *LocationsPlaceActionLinksCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsPlaceActionLinksCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsPlaceActionLinksCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.placeactionlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/placeActionLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.locations.placeActionLinks.create" call.
// Exactly one of *PlaceActionLink or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *PlaceActionLink.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *LocationsPlaceActionLinksCreateCall) Do(opts ...googleapi.CallOption) (*PlaceActionLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlaceActionLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a place action link associated with the specified location, and returns it. The request is considered duplicate if the `parent`, `place_action_link.uri` and `place_action_link.place_action_type` are the same as a previous request.",
	//   "flatPath": "v1/locations/{locationsId}/placeActionLinks",
	//   "httpMethod": "POST",
	//   "id": "mybusinessplaceactions.locations.placeActionLinks.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the location where to create this place action link. `locations/{location_id}`.",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/placeActionLinks",
	//   "request": {
	//     "$ref": "PlaceActionLink"
	//   },
	//   "response": {
	//     "$ref": "PlaceActionLink"
	//   }
	// }

}

// method id "mybusinessplaceactions.locations.placeActionLinks.delete":

type LocationsPlaceActionLinksDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a place action link from the specified location.
//
//   - name: The resource name of the place action link to remove from the
//     location.
func (r *LocationsPlaceActionLinksService) Delete(name string) *LocationsPlaceActionLinksDeleteCall {
	c := &LocationsPlaceActionLinksDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsPlaceActionLinksDeleteCall) Fields(s ...googleapi.Field) *LocationsPlaceActionLinksDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsPlaceActionLinksDeleteCall) Context(ctx context.Context) *LocationsPlaceActionLinksDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsPlaceActionLinksDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsPlaceActionLinksDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.locations.placeActionLinks.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *LocationsPlaceActionLinksDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a place action link from the specified location.",
	//   "flatPath": "v1/locations/{locationsId}/placeActionLinks/{placeActionLinksId}",
	//   "httpMethod": "DELETE",
	//   "id": "mybusinessplaceactions.locations.placeActionLinks.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the place action link to remove from the location.",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+/placeActionLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   }
	// }

}

// method id "mybusinessplaceactions.locations.placeActionLinks.get":

type LocationsPlaceActionLinksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the specified place action link.
//
// - name: The name of the place action link to fetch.
func (r *LocationsPlaceActionLinksService) Get(name string) *LocationsPlaceActionLinksGetCall {
	c := &LocationsPlaceActionLinksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsPlaceActionLinksGetCall) Fields(s ...googleapi.Field) *LocationsPlaceActionLinksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *LocationsPlaceActionLinksGetCall) IfNoneMatch(entityTag string) *LocationsPlaceActionLinksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsPlaceActionLinksGetCall) Context(ctx context.Context) *LocationsPlaceActionLinksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsPlaceActionLinksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsPlaceActionLinksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.locations.placeActionLinks.get" call.
// Exactly one of *PlaceActionLink or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *PlaceActionLink.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *LocationsPlaceActionLinksGetCall) Do(opts ...googleapi.CallOption) (*PlaceActionLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlaceActionLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the specified place action link.",
	//   "flatPath": "v1/locations/{locationsId}/placeActionLinks/{placeActionLinksId}",
	//   "httpMethod": "GET",
	//   "id": "mybusinessplaceactions.locations.placeActionLinks.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the place action link to fetch.",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+/placeActionLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "PlaceActionLink"
	//   }
	// }

}

// method id "mybusinessplaceactions.locations.placeActionLinks.list":

type LocationsPlaceActionLinksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the place action links for the specified location.
//
//   - parent: The name of the location whose place action links will be
//     listed. `locations/{location_id}`.
func (r *LocationsPlaceActionLinksService) List(parent string) *LocationsPlaceActionLinksListCall {
	c := &LocationsPlaceActionLinksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter constraining
// the place action links to return. The response includes entries that
// match the filter. We support only the following filter: 1.
// place_action_type=XYZ where XYZ is a valid PlaceActionType.
func (c *LocationsPlaceActionLinksListCall) Filter(filter string) *LocationsPlaceActionLinksListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": How many place
// action links to return per page. Default of 10. The minimum is 1.
func (c *LocationsPlaceActionLinksListCall) PageSize(pageSize int64) *LocationsPlaceActionLinksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If specified,
// returns the next page of place action links.
func (c *LocationsPlaceActionLinksListCall) PageToken(pageToken string) *LocationsPlaceActionLinksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsPlaceActionLinksListCall) Fields(s ...googleapi.Field) *LocationsPlaceActionLinksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *LocationsPlaceActionLinksListCall) IfNoneMatch(entityTag string) *LocationsPlaceActionLinksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsPlaceActionLinksListCall) Context(ctx context.Context) *LocationsPlaceActionLinksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsPlaceActionLinksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsPlaceActionLinksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/placeActionLinks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.locations.placeActionLinks.list" call.
// Exactly one of *ListPlaceActionLinksResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListPlaceActionLinksResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *LocationsPlaceActionLinksListCall) Do(opts ...googleapi.CallOption) (*ListPlaceActionLinksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPlaceActionLinksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the place action links for the specified location.",
	//   "flatPath": "v1/locations/{locationsId}/placeActionLinks",
	//   "httpMethod": "GET",
	//   "id": "mybusinessplaceactions.locations.placeActionLinks.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. A filter constraining the place action links to return. The response includes entries that match the filter. We support only the following filter: 1. place_action_type=XYZ where XYZ is a valid PlaceActionType.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. How many place action links to return per page. Default of 10. The minimum is 1.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If specified, returns the next page of place action links.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The name of the location whose place action links will be listed. `locations/{location_id}`.",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/placeActionLinks",
	//   "response": {
	//     "$ref": "ListPlaceActionLinksResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *LocationsPlaceActionLinksListCall) Pages(ctx context.Context, f func(*ListPlaceActionLinksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "mybusinessplaceactions.locations.placeActionLinks.patch":

type LocationsPlaceActionLinksPatchCall struct {
	s               *Service
	name            string
	placeactionlink *PlaceActionLink
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the specified place action link and returns it.
//
//   - name: Optional. The resource name, in the format
//     `locations/{location_id}/placeActionLinks/{place_action_link_id}`.
//     The name field will only be considered in UpdatePlaceActionLink and
//     DeletePlaceActionLink requests for updating and deleting links
//     respectively. However, it will be ignored in CreatePlaceActionLink
//     request, where `place_action_link_id` will be assigned by the
//     server on successful creation of a new link and returned as part of
//     the response.
func (r *LocationsPlaceActionLinksService) Patch(name string, placeactionlink *PlaceActionLink) *LocationsPlaceActionLinksPatchCall {
	c := &LocationsPlaceActionLinksPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.placeactionlink = placeactionlink
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// specific fields to update. The only editable fields are `uri`,
// `place_action_type` and `is_preferred`. If the updated link already
// exists at the same location with the same `place_action_type` and
// `uri`, fails with an `ALREADY_EXISTS` error.
func (c *LocationsPlaceActionLinksPatchCall) UpdateMask(updateMask string) *LocationsPlaceActionLinksPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *LocationsPlaceActionLinksPatchCall) Fields(s ...googleapi.Field) *LocationsPlaceActionLinksPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *LocationsPlaceActionLinksPatchCall) Context(ctx context.Context) *LocationsPlaceActionLinksPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *LocationsPlaceActionLinksPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *LocationsPlaceActionLinksPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.placeactionlink)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.locations.placeActionLinks.patch" call.
// Exactly one of *PlaceActionLink or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *PlaceActionLink.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *LocationsPlaceActionLinksPatchCall) Do(opts ...googleapi.CallOption) (*PlaceActionLink, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlaceActionLink{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the specified place action link and returns it.",
	//   "flatPath": "v1/locations/{locationsId}/placeActionLinks/{placeActionLinksId}",
	//   "httpMethod": "PATCH",
	//   "id": "mybusinessplaceactions.locations.placeActionLinks.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Optional. The resource name, in the format `locations/{location_id}/placeActionLinks/{place_action_link_id}`. The name field will only be considered in UpdatePlaceActionLink and DeletePlaceActionLink requests for updating and deleting links respectively. However, it will be ignored in CreatePlaceActionLink request, where `place_action_link_id` will be assigned by the server on successful creation of a new link and returned as part of the response.",
	//       "location": "path",
	//       "pattern": "^locations/[^/]+/placeActionLinks/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The specific fields to update. The only editable fields are `uri`, `place_action_type` and `is_preferred`. If the updated link already exists at the same location with the same `place_action_type` and `uri`, fails with an `ALREADY_EXISTS` error.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "PlaceActionLink"
	//   },
	//   "response": {
	//     "$ref": "PlaceActionLink"
	//   }
	// }

}

// method id "mybusinessplaceactions.placeActionTypeMetadata.list":

type PlaceActionTypeMetadataListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns the list of available place action types for a location
// or country.
func (r *PlaceActionTypeMetadataService) List() *PlaceActionTypeMetadataListCall {
	c := &PlaceActionTypeMetadataListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": A filter constraining
// the place action types to return metadata for. The response includes
// entries that match the filter. We support only the following filters:
// 1. location=XYZ where XYZ is a string indicating the resource name of
// a location, in the format `locations/{location_id}`. 2.
// region_code=XYZ where XYZ is a Unicode CLDR region code to find
// available action types. If no filter is provided, all place action
// types are returned.
func (c *PlaceActionTypeMetadataListCall) Filter(filter string) *PlaceActionTypeMetadataListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// LanguageCode sets the optional parameter "languageCode": The IETF
// BCP-47 code of language to get display names in. If this language is
// not available, they will be provided in English.
func (c *PlaceActionTypeMetadataListCall) LanguageCode(languageCode string) *PlaceActionTypeMetadataListCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// PageSize sets the optional parameter "pageSize": How many action
// types to include per page. Default is 10, minimum is 1.
func (c *PlaceActionTypeMetadataListCall) PageSize(pageSize int64) *PlaceActionTypeMetadataListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": If specified, the
// next page of place action type metadata is retrieved. The `pageToken`
// is returned when a call to `placeActionTypeMetadata.list` returns
// more results than can fit into the requested page size.
func (c *PlaceActionTypeMetadataListCall) PageToken(pageToken string) *PlaceActionTypeMetadataListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *PlaceActionTypeMetadataListCall) Fields(s ...googleapi.Field) *PlaceActionTypeMetadataListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *PlaceActionTypeMetadataListCall) IfNoneMatch(entityTag string) *PlaceActionTypeMetadataListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *PlaceActionTypeMetadataListCall) Context(ctx context.Context) *PlaceActionTypeMetadataListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *PlaceActionTypeMetadataListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlaceActionTypeMetadataListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/placeActionTypeMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "mybusinessplaceactions.placeActionTypeMetadata.list" call.
// Exactly one of *ListPlaceActionTypeMetadataResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ListPlaceActionTypeMetadataResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *PlaceActionTypeMetadataListCall) Do(opts ...googleapi.CallOption) (*ListPlaceActionTypeMetadataResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPlaceActionTypeMetadataResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the list of available place action types for a location or country.",
	//   "flatPath": "v1/placeActionTypeMetadata",
	//   "httpMethod": "GET",
	//   "id": "mybusinessplaceactions.placeActionTypeMetadata.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. A filter constraining the place action types to return metadata for. The response includes entries that match the filter. We support only the following filters: 1. location=XYZ where XYZ is a string indicating the resource name of a location, in the format `locations/{location_id}`. 2. region_code=XYZ where XYZ is a Unicode CLDR region code to find available action types. If no filter is provided, all place action types are returned.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "languageCode": {
	//       "description": "Optional. The IETF BCP-47 code of language to get display names in. If this language is not available, they will be provided in English.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. How many action types to include per page. Default is 10, minimum is 1.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. If specified, the next page of place action type metadata is retrieved. The `pageToken` is returned when a call to `placeActionTypeMetadata.list` returns more results than can fit into the requested page size.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/placeActionTypeMetadata",
	//   "response": {
	//     "$ref": "ListPlaceActionTypeMetadataResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PlaceActionTypeMetadataListCall) Pages(ctx context.Context, f func(*ListPlaceActionTypeMetadataResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
