package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DiscribeSmartAccessGatewayDiagnosisReport invokes the smartag.DiscribeSmartAccessGatewayDiagnosisReport API synchronously
func (client *Client) DiscribeSmartAccessGatewayDiagnosisReport(request *DiscribeSmartAccessGatewayDiagnosisReportRequest) (response *DiscribeSmartAccessGatewayDiagnosisReportResponse, err error) {
	response = CreateDiscribeSmartAccessGatewayDiagnosisReportResponse()
	err = client.DoAction(request, response)
	return
}

// DiscribeSmartAccessGatewayDiagnosisReportWithChan invokes the smartag.DiscribeSmartAccessGatewayDiagnosisReport API asynchronously
func (client *Client) DiscribeSmartAccessGatewayDiagnosisReportWithChan(request *DiscribeSmartAccessGatewayDiagnosisReportRequest) (<-chan *DiscribeSmartAccessGatewayDiagnosisReportResponse, <-chan error) {
	responseChan := make(chan *DiscribeSmartAccessGatewayDiagnosisReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DiscribeSmartAccessGatewayDiagnosisReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DiscribeSmartAccessGatewayDiagnosisReportWithCallback invokes the smartag.DiscribeSmartAccessGatewayDiagnosisReport API asynchronously
func (client *Client) DiscribeSmartAccessGatewayDiagnosisReportWithCallback(request *DiscribeSmartAccessGatewayDiagnosisReportRequest, callback func(response *DiscribeSmartAccessGatewayDiagnosisReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DiscribeSmartAccessGatewayDiagnosisReportResponse
		var err error
		defer close(result)
		response, err = client.DiscribeSmartAccessGatewayDiagnosisReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DiscribeSmartAccessGatewayDiagnosisReportRequest is the request struct for api DiscribeSmartAccessGatewayDiagnosisReport
type DiscribeSmartAccessGatewayDiagnosisReportRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DiscribeSmartAccessGatewayDiagnosisReportResponse is the response struct for api DiscribeSmartAccessGatewayDiagnosisReport
type DiscribeSmartAccessGatewayDiagnosisReportResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	DiagnoseResult DiagnoseResult `json:"DiagnoseResult" xml:"DiagnoseResult"`
}

// CreateDiscribeSmartAccessGatewayDiagnosisReportRequest creates a request to invoke DiscribeSmartAccessGatewayDiagnosisReport API
func CreateDiscribeSmartAccessGatewayDiagnosisReportRequest() (request *DiscribeSmartAccessGatewayDiagnosisReportRequest) {
	request = &DiscribeSmartAccessGatewayDiagnosisReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DiscribeSmartAccessGatewayDiagnosisReport", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDiscribeSmartAccessGatewayDiagnosisReportResponse creates a response to parse from DiscribeSmartAccessGatewayDiagnosisReport response
func CreateDiscribeSmartAccessGatewayDiagnosisReportResponse() (response *DiscribeSmartAccessGatewayDiagnosisReportResponse) {
	response = &DiscribeSmartAccessGatewayDiagnosisReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
