package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRouteDistributionStrategies invokes the smartag.DescribeRouteDistributionStrategies API synchronously
func (client *Client) DescribeRouteDistributionStrategies(request *DescribeRouteDistributionStrategiesRequest) (response *DescribeRouteDistributionStrategiesResponse, err error) {
	response = CreateDescribeRouteDistributionStrategiesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRouteDistributionStrategiesWithChan invokes the smartag.DescribeRouteDistributionStrategies API asynchronously
func (client *Client) DescribeRouteDistributionStrategiesWithChan(request *DescribeRouteDistributionStrategiesRequest) (<-chan *DescribeRouteDistributionStrategiesResponse, <-chan error) {
	responseChan := make(chan *DescribeRouteDistributionStrategiesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRouteDistributionStrategies(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRouteDistributionStrategiesWithCallback invokes the smartag.DescribeRouteDistributionStrategies API asynchronously
func (client *Client) DescribeRouteDistributionStrategiesWithCallback(request *DescribeRouteDistributionStrategiesRequest, callback func(response *DescribeRouteDistributionStrategiesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRouteDistributionStrategiesResponse
		var err error
		defer close(result)
		response, err = client.DescribeRouteDistributionStrategies(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRouteDistributionStrategiesRequest is the request struct for api DescribeRouteDistributionStrategies
type DescribeRouteDistributionStrategiesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	SourceType           string           `position:"Query" name:"SourceType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeRouteDistributionStrategiesResponse is the response struct for api DescribeRouteDistributionStrategies
type DescribeRouteDistributionStrategiesResponse struct {
	*responses.BaseResponse
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	Strategies Strategies `json:"Strategies" xml:"Strategies"`
}

// CreateDescribeRouteDistributionStrategiesRequest creates a request to invoke DescribeRouteDistributionStrategies API
func CreateDescribeRouteDistributionStrategiesRequest() (request *DescribeRouteDistributionStrategiesRequest) {
	request = &DescribeRouteDistributionStrategiesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeRouteDistributionStrategies", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRouteDistributionStrategiesResponse creates a response to parse from DescribeRouteDistributionStrategies response
func CreateDescribeRouteDistributionStrategiesResponse() (response *DescribeRouteDistributionStrategiesResponse) {
	response = &DescribeRouteDistributionStrategiesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
