package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushUserAnalyzerEntries invokes the opensearch.PushUserAnalyzerEntries API synchronously
func (client *Client) PushUserAnalyzerEntries(request *PushUserAnalyzerEntriesRequest) (response *PushUserAnalyzerEntriesResponse, err error) {
	response = CreatePushUserAnalyzerEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// PushUserAnalyzerEntriesWithChan invokes the opensearch.PushUserAnalyzerEntries API asynchronously
func (client *Client) PushUserAnalyzerEntriesWithChan(request *PushUserAnalyzerEntriesRequest) (<-chan *PushUserAnalyzerEntriesResponse, <-chan error) {
	responseChan := make(chan *PushUserAnalyzerEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushUserAnalyzerEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushUserAnalyzerEntriesWithCallback invokes the opensearch.PushUserAnalyzerEntries API asynchronously
func (client *Client) PushUserAnalyzerEntriesWithCallback(request *PushUserAnalyzerEntriesRequest, callback func(response *PushUserAnalyzerEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushUserAnalyzerEntriesResponse
		var err error
		defer close(result)
		response, err = client.PushUserAnalyzerEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushUserAnalyzerEntriesRequest is the request struct for api PushUserAnalyzerEntries
type PushUserAnalyzerEntriesRequest struct {
	*requests.RoaRequest
	Name string `position:"Path" name:"name"`
}

// PushUserAnalyzerEntriesResponse is the response struct for api PushUserAnalyzerEntries
type PushUserAnalyzerEntriesResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreatePushUserAnalyzerEntriesRequest creates a request to invoke PushUserAnalyzerEntries API
func CreatePushUserAnalyzerEntriesRequest() (request *PushUserAnalyzerEntriesRequest) {
	request = &PushUserAnalyzerEntriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "PushUserAnalyzerEntries", "/v4/openapi/user-analyzers/[name]/entries/actions/bulk", "opensearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePushUserAnalyzerEntriesResponse creates a response to parse from PushUserAnalyzerEntries response
func CreatePushUserAnalyzerEntriesResponse() (response *PushUserAnalyzerEntriesResponse) {
	response = &PushUserAnalyzerEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
