package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateThingScript invokes the iot.UpdateThingScript API synchronously
func (client *Client) UpdateThingScript(request *UpdateThingScriptRequest) (response *UpdateThingScriptResponse, err error) {
	response = CreateUpdateThingScriptResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateThingScriptWithChan invokes the iot.UpdateThingScript API asynchronously
func (client *Client) UpdateThingScriptWithChan(request *UpdateThingScriptRequest) (<-chan *UpdateThingScriptResponse, <-chan error) {
	responseChan := make(chan *UpdateThingScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateThingScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateThingScriptWithCallback invokes the iot.UpdateThingScript API asynchronously
func (client *Client) UpdateThingScriptWithCallback(request *UpdateThingScriptRequest, callback func(response *UpdateThingScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateThingScriptResponse
		var err error
		defer close(result)
		response, err = client.UpdateThingScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateThingScriptRequest is the request struct for api UpdateThingScript
type UpdateThingScriptRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ScriptType    string `position:"Query" name:"ScriptType"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	ScriptContent string `position:"Query" name:"ScriptContent"`
}

// UpdateThingScriptResponse is the response struct for api UpdateThingScript
type UpdateThingScriptResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateUpdateThingScriptRequest creates a request to invoke UpdateThingScript API
func CreateUpdateThingScriptRequest() (request *UpdateThingScriptRequest) {
	request = &UpdateThingScriptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "UpdateThingScript", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateThingScriptResponse creates a response to parse from UpdateThingScript response
func CreateUpdateThingScriptResponse() (response *UpdateThingScriptResponse) {
	response = &UpdateThingScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
