package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForSynchronizingDnsHost invokes the domain.SaveSingleTaskForSynchronizingDnsHost API synchronously
func (client *Client) SaveSingleTaskForSynchronizingDnsHost(request *SaveSingleTaskForSynchronizingDnsHostRequest) (response *SaveSingleTaskForSynchronizingDnsHostResponse, err error) {
	response = CreateSaveSingleTaskForSynchronizingDnsHostResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForSynchronizingDnsHostWithChan invokes the domain.SaveSingleTaskForSynchronizingDnsHost API asynchronously
func (client *Client) SaveSingleTaskForSynchronizingDnsHostWithChan(request *SaveSingleTaskForSynchronizingDnsHostRequest) (<-chan *SaveSingleTaskForSynchronizingDnsHostResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForSynchronizingDnsHostResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForSynchronizingDnsHost(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForSynchronizingDnsHostWithCallback invokes the domain.SaveSingleTaskForSynchronizingDnsHost API asynchronously
func (client *Client) SaveSingleTaskForSynchronizingDnsHostWithCallback(request *SaveSingleTaskForSynchronizingDnsHostRequest, callback func(response *SaveSingleTaskForSynchronizingDnsHostResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForSynchronizingDnsHostResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForSynchronizingDnsHost(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForSynchronizingDnsHostRequest is the request struct for api SaveSingleTaskForSynchronizingDnsHost
type SaveSingleTaskForSynchronizingDnsHostRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// SaveSingleTaskForSynchronizingDnsHostResponse is the response struct for api SaveSingleTaskForSynchronizingDnsHost
type SaveSingleTaskForSynchronizingDnsHostResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForSynchronizingDnsHostRequest creates a request to invoke SaveSingleTaskForSynchronizingDnsHost API
func CreateSaveSingleTaskForSynchronizingDnsHostRequest() (request *SaveSingleTaskForSynchronizingDnsHostRequest) {
	request = &SaveSingleTaskForSynchronizingDnsHostRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForSynchronizingDnsHost", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForSynchronizingDnsHostResponse creates a response to parse from SaveSingleTaskForSynchronizingDnsHost response
func CreateSaveSingleTaskForSynchronizingDnsHostResponse() (response *SaveSingleTaskForSynchronizingDnsHostResponse) {
	response = &SaveSingleTaskForSynchronizingDnsHostResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
