package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckMetaPartition invokes the dataworks_public.CheckMetaPartition API synchronously
func (client *Client) CheckMetaPartition(request *CheckMetaPartitionRequest) (response *CheckMetaPartitionResponse, err error) {
	response = CreateCheckMetaPartitionResponse()
	err = client.DoAction(request, response)
	return
}

// CheckMetaPartitionWithChan invokes the dataworks_public.CheckMetaPartition API asynchronously
func (client *Client) CheckMetaPartitionWithChan(request *CheckMetaPartitionRequest) (<-chan *CheckMetaPartitionResponse, <-chan error) {
	responseChan := make(chan *CheckMetaPartitionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckMetaPartition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckMetaPartitionWithCallback invokes the dataworks_public.CheckMetaPartition API asynchronously
func (client *Client) CheckMetaPartitionWithCallback(request *CheckMetaPartitionRequest, callback func(response *CheckMetaPartitionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckMetaPartitionResponse
		var err error
		defer close(result)
		response, err = client.CheckMetaPartition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckMetaPartitionRequest is the request struct for api CheckMetaPartition
type CheckMetaPartitionRequest struct {
	*requests.RpcRequest
	DataSourceType string `position:"Query" name:"DataSourceType"`
	Partition      string `position:"Query" name:"Partition"`
	TableGuid      string `position:"Query" name:"TableGuid"`
	DatabaseName   string `position:"Query" name:"DatabaseName"`
	ClusterId      string `position:"Query" name:"ClusterId"`
	TableName      string `position:"Query" name:"TableName"`
}

// CheckMetaPartitionResponse is the response struct for api CheckMetaPartition
type CheckMetaPartitionResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateCheckMetaPartitionRequest creates a request to invoke CheckMetaPartition API
func CreateCheckMetaPartitionRequest() (request *CheckMetaPartitionRequest) {
	request = &CheckMetaPartitionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CheckMetaPartition", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckMetaPartitionResponse creates a response to parse from CheckMetaPartition response
func CreateCheckMetaPartitionResponse() (response *CheckMetaPartitionResponse) {
	response = &CheckMetaPartitionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
