package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetConfigRulesReport invokes the config.GetConfigRulesReport API synchronously
func (client *Client) GetConfigRulesReport(request *GetConfigRulesReportRequest) (response *GetConfigRulesReportResponse, err error) {
	response = CreateGetConfigRulesReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetConfigRulesReportWithChan invokes the config.GetConfigRulesReport API asynchronously
func (client *Client) GetConfigRulesReportWithChan(request *GetConfigRulesReportRequest) (<-chan *GetConfigRulesReportResponse, <-chan error) {
	responseChan := make(chan *GetConfigRulesReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetConfigRulesReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetConfigRulesReportWithCallback invokes the config.GetConfigRulesReport API asynchronously
func (client *Client) GetConfigRulesReportWithCallback(request *GetConfigRulesReportRequest, callback func(response *GetConfigRulesReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetConfigRulesReportResponse
		var err error
		defer close(result)
		response, err = client.GetConfigRulesReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetConfigRulesReportRequest is the request struct for api GetConfigRulesReport
type GetConfigRulesReportRequest struct {
	*requests.RpcRequest
	ReportId string `position:"Query" name:"ReportId"`
}

// GetConfigRulesReportResponse is the response struct for api GetConfigRulesReport
type GetConfigRulesReportResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ConfigRulesReport ConfigRulesReport `json:"ConfigRulesReport" xml:"ConfigRulesReport"`
}

// CreateGetConfigRulesReportRequest creates a request to invoke GetConfigRulesReport API
func CreateGetConfigRulesReportRequest() (request *GetConfigRulesReportRequest) {
	request = &GetConfigRulesReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetConfigRulesReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGetConfigRulesReportResponse creates a response to parse from GetConfigRulesReport response
func CreateGetConfigRulesReportResponse() (response *GetConfigRulesReportResponse) {
	response = &GetConfigRulesReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
