package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivatePhotos invokes the cloudphoto.ActivatePhotos API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/activatephotos.html
func (client *Client) ActivatePhotos(request *ActivatePhotosRequest) (response *ActivatePhotosResponse, err error) {
	response = CreateActivatePhotosResponse()
	err = client.DoAction(request, response)
	return
}

// ActivatePhotosWithChan invokes the cloudphoto.ActivatePhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/activatephotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ActivatePhotosWithChan(request *ActivatePhotosRequest) (<-chan *ActivatePhotosResponse, <-chan error) {
	responseChan := make(chan *ActivatePhotosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivatePhotos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivatePhotosWithCallback invokes the cloudphoto.ActivatePhotos API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/activatephotos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ActivatePhotosWithCallback(request *ActivatePhotosRequest, callback func(response *ActivatePhotosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivatePhotosResponse
		var err error
		defer close(result)
		response, err = client.ActivatePhotos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivatePhotosRequest is the request struct for api ActivatePhotos
type ActivatePhotosRequest struct {
	*requests.RpcRequest
	LibraryId string    `position:"Query" name:"LibraryId"`
	PhotoId   *[]string `position:"Query" name:"PhotoId"  type:"Repeated"`
	StoreName string    `position:"Query" name:"StoreName"`
}

// ActivatePhotosResponse is the response struct for api ActivatePhotos
type ActivatePhotosResponse struct {
	*responses.BaseResponse
	Code      string   `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Action    string   `json:"Action" xml:"Action"`
	Results   []Result `json:"Results" xml:"Results"`
}

// CreateActivatePhotosRequest creates a request to invoke ActivatePhotos API
func CreateActivatePhotosRequest() (request *ActivatePhotosRequest) {
	request = &ActivatePhotosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "ActivatePhotos", "cloudphoto", "openAPI")
	return
}

// CreateActivatePhotosResponse creates a response to parse from ActivatePhotos response
func CreateActivatePhotosResponse() (response *ActivatePhotosResponse) {
	response = &ActivatePhotosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
