package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryItems invokes the cloudgameapi.QueryItems API synchronously
func (client *Client) QueryItems(request *QueryItemsRequest) (response *QueryItemsResponse, err error) {
	response = CreateQueryItemsResponse()
	err = client.DoAction(request, response)
	return
}

// QueryItemsWithChan invokes the cloudgameapi.QueryItems API asynchronously
func (client *Client) QueryItemsWithChan(request *QueryItemsRequest) (<-chan *QueryItemsResponse, <-chan error) {
	responseChan := make(chan *QueryItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryItemsWithCallback invokes the cloudgameapi.QueryItems API asynchronously
func (client *Client) QueryItemsWithCallback(request *QueryItemsRequest, callback func(response *QueryItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryItemsResponse
		var err error
		defer close(result)
		response, err = client.QueryItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryItemsRequest is the request struct for api QueryItems
type QueryItemsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// QueryItemsResponse is the response struct for api QueryItems
type QueryItemsResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateQueryItemsRequest creates a request to invoke QueryItems API
func CreateQueryItemsRequest() (request *QueryItemsRequest) {
	request = &QueryItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryItems", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryItemsResponse creates a response to parse from QueryItems response
func CreateQueryItemsResponse() (response *QueryItemsResponse) {
	response = &QueryItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
