package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FindAgentData invokes the cloudcallcenter.FindAgentData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findagentdata.html
func (client *Client) FindAgentData(request *FindAgentDataRequest) (response *FindAgentDataResponse, err error) {
	response = CreateFindAgentDataResponse()
	err = client.DoAction(request, response)
	return
}

// FindAgentDataWithChan invokes the cloudcallcenter.FindAgentData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findagentdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindAgentDataWithChan(request *FindAgentDataRequest) (<-chan *FindAgentDataResponse, <-chan error) {
	responseChan := make(chan *FindAgentDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FindAgentData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FindAgentDataWithCallback invokes the cloudcallcenter.FindAgentData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/findagentdata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FindAgentDataWithCallback(request *FindAgentDataRequest, callback func(response *FindAgentDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FindAgentDataResponse
		var err error
		defer close(result)
		response, err = client.FindAgentData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FindAgentDataRequest is the request struct for api FindAgentData
type FindAgentDataRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	StartDay   string           `position:"Query" name:"StartDay"`
	Criteria   string           `position:"Query" name:"Criteria"`
	EndDay     string           `position:"Query" name:"EndDay"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// FindAgentDataResponse is the response struct for api FindAgentData
type FindAgentDataResponse struct {
	*responses.BaseResponse
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DataList       DataList `json:"DataList" xml:"DataList"`
}

// CreateFindAgentDataRequest creates a request to invoke FindAgentData API
func CreateFindAgentDataRequest() (request *FindAgentDataRequest) {
	request = &FindAgentDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "FindAgentData", "", "")
	request.Method = requests.POST
	return
}

// CreateFindAgentDataResponse creates a response to parse from FindAgentData response
func CreateFindAgentDataResponse() (response *FindAgentDataResponse) {
	response = &FindAgentDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
