package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConfigItems invokes the ccc.ListConfigItems API synchronously
func (client *Client) ListConfigItems(request *ListConfigItemsRequest) (response *ListConfigItemsResponse, err error) {
	response = CreateListConfigItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConfigItemsWithChan invokes the ccc.ListConfigItems API asynchronously
func (client *Client) ListConfigItemsWithChan(request *ListConfigItemsRequest) (<-chan *ListConfigItemsResponse, <-chan error) {
	responseChan := make(chan *ListConfigItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConfigItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConfigItemsWithCallback invokes the ccc.ListConfigItems API asynchronously
func (client *Client) ListConfigItemsWithCallback(request *ListConfigItemsRequest, callback func(response *ListConfigItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConfigItemsResponse
		var err error
		defer close(result)
		response, err = client.ListConfigItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConfigItemsRequest is the request struct for api ListConfigItems
type ListConfigItemsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ObjectType string `position:"Query" name:"ObjectType"`
	ObjectId   string `position:"Query" name:"ObjectId"`
}

// ListConfigItemsResponse is the response struct for api ListConfigItems
type ListConfigItemsResponse struct {
	*responses.BaseResponse
	Code           string       `json:"Code" xml:"Code"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string       `json:"Message" xml:"Message"`
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Params         []string     `json:"Params" xml:"Params"`
	Data           []ConfigItem `json:"Data" xml:"Data"`
}

// CreateListConfigItemsRequest creates a request to invoke ListConfigItems API
func CreateListConfigItemsRequest() (request *ListConfigItemsRequest) {
	request = &ListConfigItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListConfigItems", "", "")
	request.Method = requests.POST
	return
}

// CreateListConfigItemsResponse creates a response to parse from ListConfigItems response
func CreateListConfigItemsResponse() (response *ListConfigItemsResponse) {
	response = &ListConfigItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
