package aliyuncvc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDeviceInfo invokes the aliyuncvc.GetDeviceInfo API synchronously
func (client *Client) GetDeviceInfo(request *GetDeviceInfoRequest) (response *GetDeviceInfoResponse, err error) {
	response = CreateGetDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetDeviceInfoWithChan invokes the aliyuncvc.GetDeviceInfo API asynchronously
func (client *Client) GetDeviceInfoWithChan(request *GetDeviceInfoRequest) (<-chan *GetDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *GetDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDeviceInfoWithCallback invokes the aliyuncvc.GetDeviceInfo API asynchronously
func (client *Client) GetDeviceInfoWithCallback(request *GetDeviceInfoRequest, callback func(response *GetDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.GetDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDeviceInfoRequest is the request struct for api GetDeviceInfo
type GetDeviceInfoRequest struct {
	*requests.RpcRequest
	CastScreenCode string `position:"Body" name:"CastScreenCode"`
}

// GetDeviceInfoResponse is the response struct for api GetDeviceInfo
type GetDeviceInfoResponse struct {
	*responses.BaseResponse
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Device    Device `json:"Device" xml:"Device"`
}

// CreateGetDeviceInfoRequest creates a request to invoke GetDeviceInfo API
func CreateGetDeviceInfoRequest() (request *GetDeviceInfoRequest) {
	request = &GetDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aliyuncvc", "2019-10-30", "GetDeviceInfo", "aliyuncvc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDeviceInfoResponse creates a response to parse from GetDeviceInfo response
func CreateGetDeviceInfoResponse() (response *GetDeviceInfoResponse) {
	response = &GetDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
