package logz

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MonitorClient is the client for the Monitor methods of the Logz service.
type MonitorClient struct {
	BaseClient
}

// NewMonitorClient creates an instance of the MonitorClient client.
func NewMonitorClient(subscriptionID string) MonitorClient {
	return NewMonitorClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewMonitorClientWithBaseURI creates an instance of the MonitorClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewMonitorClientWithBaseURI(baseURI string, subscriptionID string) MonitorClient {
	return MonitorClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListVMHosts sends the list vm hosts request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
func (client MonitorClient) ListVMHosts(ctx context.Context, resourceGroupName string, monitorName string) (result VMResourcesListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorClient.ListVMHosts")
		defer func() {
			sc := -1
			if result.vrlr.Response.Response != nil {
				sc = result.vrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.MonitorClient", "ListVMHosts", err.Error())
	}

	result.fn = client.listVMHostsNextResults
	req, err := client.ListVMHostsPreparer(ctx, resourceGroupName, monitorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHosts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVMHostsSender(req)
	if err != nil {
		result.vrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHosts", resp, "Failure sending request")
		return
	}

	result.vrlr, err = client.ListVMHostsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHosts", resp, "Failure responding to request")
		return
	}
	if result.vrlr.hasNextLink() && result.vrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVMHostsPreparer prepares the ListVMHosts request.
func (client MonitorClient) ListVMHostsPreparer(ctx context.Context, resourceGroupName string, monitorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/listVMHosts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVMHostsSender sends the ListVMHosts request. The method will close the
// http.Response Body if it receives an error.
func (client MonitorClient) ListVMHostsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVMHostsResponder handles the response to the ListVMHosts request. The method always
// closes the http.Response Body.
func (client MonitorClient) ListVMHostsResponder(resp *http.Response) (result VMResourcesListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVMHostsNextResults retrieves the next set of results, if any.
func (client MonitorClient) listVMHostsNextResults(ctx context.Context, lastResults VMResourcesListResponse) (result VMResourcesListResponse, err error) {
	req, err := lastResults.vMResourcesListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVMHostsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVMHostsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVMHostsComplete enumerates all values, automatically crossing page boundaries as required.
func (client MonitorClient) ListVMHostsComplete(ctx context.Context, resourceGroupName string, monitorName string) (result VMResourcesListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorClient.ListVMHosts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVMHosts(ctx, resourceGroupName, monitorName)
	return
}

// ListVMHostUpdate sends the list vm host update request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
// body - request body to update the collection for agent installed in the given monitor.
func (client MonitorClient) ListVMHostUpdate(ctx context.Context, resourceGroupName string, monitorName string, body *VMHostUpdateRequest) (result VMResourcesListResponsePage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorClient.ListVMHostUpdate")
		defer func() {
			sc := -1
			if result.vrlr.Response.Response != nil {
				sc = result.vrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.MonitorClient", "ListVMHostUpdate", err.Error())
	}

	result.fn = client.listVMHostUpdateNextResults
	req, err := client.ListVMHostUpdatePreparer(ctx, resourceGroupName, monitorName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHostUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListVMHostUpdateSender(req)
	if err != nil {
		result.vrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHostUpdate", resp, "Failure sending request")
		return
	}

	result.vrlr, err = client.ListVMHostUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "ListVMHostUpdate", resp, "Failure responding to request")
		return
	}
	if result.vrlr.hasNextLink() && result.vrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListVMHostUpdatePreparer prepares the ListVMHostUpdate request.
func (client MonitorClient) ListVMHostUpdatePreparer(ctx context.Context, resourceGroupName string, monitorName string, body *VMHostUpdateRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/vmHostUpdate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListVMHostUpdateSender sends the ListVMHostUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client MonitorClient) ListVMHostUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListVMHostUpdateResponder handles the response to the ListVMHostUpdate request. The method always
// closes the http.Response Body.
func (client MonitorClient) ListVMHostUpdateResponder(resp *http.Response) (result VMResourcesListResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listVMHostUpdateNextResults retrieves the next set of results, if any.
func (client MonitorClient) listVMHostUpdateNextResults(ctx context.Context, lastResults VMResourcesListResponse) (result VMResourcesListResponse, err error) {
	req, err := lastResults.vMResourcesListResponsePreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostUpdateNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListVMHostUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostUpdateNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListVMHostUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "listVMHostUpdateNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListVMHostUpdateComplete enumerates all values, automatically crossing page boundaries as required.
func (client MonitorClient) ListVMHostUpdateComplete(ctx context.Context, resourceGroupName string, monitorName string, body *VMHostUpdateRequest) (result VMResourcesListResponseIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorClient.ListVMHostUpdate")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListVMHostUpdate(ctx, resourceGroupName, monitorName, body)
	return
}

// VMHostPayload sends the vm host payload request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// monitorName - monitor resource name
func (client MonitorClient) VMHostPayload(ctx context.Context, resourceGroupName string, monitorName string) (result VMExtensionPayload, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MonitorClient.VMHostPayload")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("logz.MonitorClient", "VMHostPayload", err.Error())
	}

	req, err := client.VMHostPayloadPreparer(ctx, resourceGroupName, monitorName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "VMHostPayload", nil, "Failure preparing request")
		return
	}

	resp, err := client.VMHostPayloadSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "VMHostPayload", resp, "Failure sending request")
		return
	}

	result, err = client.VMHostPayloadResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logz.MonitorClient", "VMHostPayload", resp, "Failure responding to request")
		return
	}

	return
}

// VMHostPayloadPreparer prepares the VMHostPayload request.
func (client MonitorClient) VMHostPayloadPreparer(ctx context.Context, resourceGroupName string, monitorName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"monitorName":       autorest.Encode("path", monitorName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logz/monitors/{monitorName}/vmHostPayload", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// VMHostPayloadSender sends the VMHostPayload request. The method will close the
// http.Response Body if it receives an error.
func (client MonitorClient) VMHostPayloadSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// VMHostPayloadResponder handles the response to the VMHostPayload request. The method always
// closes the http.Response Body.
func (client MonitorClient) VMHostPayloadResponder(resp *http.Response) (result VMExtensionPayload, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
