#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 393
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 101
#define ALIAS_COUNT 0
#define TOKEN_COUNT 50
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 17
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  anon_sym_SEMI = 3,
  anon_sym_module = 4,
  anon_sym_LPAREN = 5,
  anon_sym_COMMA = 6,
  anon_sym_RPAREN = 7,
  anon_sym_function = 8,
  anon_sym_EQ = 9,
  anon_sym_include = 10,
  anon_sym_use = 11,
  sym_include_path = 12,
  anon_sym_LBRACE = 13,
  anon_sym_RBRACE = 14,
  anon_sym_for = 15,
  anon_sym_intersection_for = 16,
  anon_sym_let = 17,
  anon_sym_assign = 18,
  anon_sym_if = 19,
  anon_sym_else = 20,
  anon_sym_STAR = 21,
  anon_sym_BANG = 22,
  anon_sym_POUND = 23,
  anon_sym_PERCENT = 24,
  sym_special_variable = 25,
  sym_string = 26,
  aux_sym_number_token1 = 27,
  aux_sym_number_token2 = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  sym_undef = 31,
  anon_sym_LBRACK = 32,
  anon_sym_COLON = 33,
  anon_sym_RBRACK = 34,
  anon_sym_each = 35,
  anon_sym_DOT = 36,
  anon_sym_DASH = 37,
  anon_sym_PLUS = 38,
  anon_sym_PIPE_PIPE = 39,
  anon_sym_AMP_AMP = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_BANG_EQ = 42,
  anon_sym_LT = 43,
  anon_sym_GT = 44,
  anon_sym_LT_EQ = 45,
  anon_sym_GT_EQ = 46,
  anon_sym_SLASH = 47,
  anon_sym_CARET = 48,
  anon_sym_QMARK = 49,
  sym_source_file = 50,
  sym__item = 51,
  sym_module_declaration = 52,
  sym_parameters_declaration = 53,
  sym__parameter_declaration = 54,
  sym_function_declaration = 55,
  sym__statement = 56,
  sym_include_statement = 57,
  sym_use_statement = 58,
  sym_assignment = 59,
  sym_union_block = 60,
  sym_for_block = 61,
  sym_intersection_for_block = 62,
  sym_let_block = 63,
  sym_assign_block = 64,
  sym_if_block = 65,
  sym_modifier_chain = 66,
  sym_modifier = 67,
  sym_transform_chain = 68,
  sym_module_call = 69,
  sym_arguments = 70,
  sym_parenthesized_assignments = 71,
  sym_parenthesized_expression = 72,
  sym_condition_update_clause = 73,
  sym__expression = 74,
  sym_let_expression = 75,
  sym__variable_name = 76,
  sym__literal = 77,
  sym_number = 78,
  sym_boolean = 79,
  sym_function = 80,
  sym_range = 81,
  sym_list = 82,
  sym__list_cell = 83,
  sym__comprehension_cell = 84,
  sym_each = 85,
  sym_list_comprehension = 86,
  sym_for_clause = 87,
  sym_if_clause = 88,
  sym_function_call = 89,
  sym_index_expression = 90,
  sym_dot_index_expression = 91,
  sym_unary_expression = 92,
  sym_binary_expression = 93,
  sym_ternary_expression = 94,
  aux_sym_source_file_repeat1 = 95,
  aux_sym_parameters_declaration_repeat1 = 96,
  aux_sym_union_block_repeat1 = 97,
  aux_sym_arguments_repeat1 = 98,
  aux_sym_parenthesized_assignments_repeat1 = 99,
  aux_sym_list_repeat1 = 100,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [anon_sym_SEMI] = ";",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_function] = "function",
  [anon_sym_EQ] = "=",
  [anon_sym_include] = "include",
  [anon_sym_use] = "use",
  [sym_include_path] = "include_path",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_for] = "for",
  [anon_sym_intersection_for] = "intersection_for",
  [anon_sym_let] = "let",
  [anon_sym_assign] = "assign",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_STAR] = "*",
  [anon_sym_BANG] = "!",
  [anon_sym_POUND] = "#",
  [anon_sym_PERCENT] = "%",
  [sym_special_variable] = "special_variable",
  [sym_string] = "string",
  [aux_sym_number_token1] = "number_token1",
  [aux_sym_number_token2] = "number_token2",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_undef] = "undef",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACK] = "]",
  [anon_sym_each] = "each",
  [anon_sym_DOT] = ".",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_SLASH] = "/",
  [anon_sym_CARET] = "^",
  [anon_sym_QMARK] = "\?",
  [sym_source_file] = "source_file",
  [sym__item] = "_item",
  [sym_module_declaration] = "module_declaration",
  [sym_parameters_declaration] = "parameters_declaration",
  [sym__parameter_declaration] = "_parameter_declaration",
  [sym_function_declaration] = "function_declaration",
  [sym__statement] = "_statement",
  [sym_include_statement] = "include_statement",
  [sym_use_statement] = "use_statement",
  [sym_assignment] = "assignment",
  [sym_union_block] = "union_block",
  [sym_for_block] = "for_block",
  [sym_intersection_for_block] = "intersection_for_block",
  [sym_let_block] = "let_block",
  [sym_assign_block] = "assign_block",
  [sym_if_block] = "if_block",
  [sym_modifier_chain] = "modifier_chain",
  [sym_modifier] = "modifier",
  [sym_transform_chain] = "transform_chain",
  [sym_module_call] = "module_call",
  [sym_arguments] = "arguments",
  [sym_parenthesized_assignments] = "parenthesized_assignments",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_condition_update_clause] = "condition_update_clause",
  [sym__expression] = "_expression",
  [sym_let_expression] = "let_expression",
  [sym__variable_name] = "_variable_name",
  [sym__literal] = "_literal",
  [sym_number] = "number",
  [sym_boolean] = "boolean",
  [sym_function] = "function",
  [sym_range] = "range",
  [sym_list] = "list",
  [sym__list_cell] = "_list_cell",
  [sym__comprehension_cell] = "_comprehension_cell",
  [sym_each] = "each",
  [sym_list_comprehension] = "list_comprehension",
  [sym_for_clause] = "for_clause",
  [sym_if_clause] = "if_clause",
  [sym_function_call] = "function_call",
  [sym_index_expression] = "index_expression",
  [sym_dot_index_expression] = "dot_index_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_parameters_declaration_repeat1] = "parameters_declaration_repeat1",
  [aux_sym_union_block_repeat1] = "union_block_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_parenthesized_assignments_repeat1] = "parenthesized_assignments_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_use] = anon_sym_use,
  [sym_include_path] = sym_include_path,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_intersection_for] = anon_sym_intersection_for,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_assign] = anon_sym_assign,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [sym_special_variable] = sym_special_variable,
  [sym_string] = sym_string,
  [aux_sym_number_token1] = aux_sym_number_token1,
  [aux_sym_number_token2] = aux_sym_number_token2,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_undef] = sym_undef,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_each] = anon_sym_each,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [sym_source_file] = sym_source_file,
  [sym__item] = sym__item,
  [sym_module_declaration] = sym_module_declaration,
  [sym_parameters_declaration] = sym_parameters_declaration,
  [sym__parameter_declaration] = sym__parameter_declaration,
  [sym_function_declaration] = sym_function_declaration,
  [sym__statement] = sym__statement,
  [sym_include_statement] = sym_include_statement,
  [sym_use_statement] = sym_use_statement,
  [sym_assignment] = sym_assignment,
  [sym_union_block] = sym_union_block,
  [sym_for_block] = sym_for_block,
  [sym_intersection_for_block] = sym_intersection_for_block,
  [sym_let_block] = sym_let_block,
  [sym_assign_block] = sym_assign_block,
  [sym_if_block] = sym_if_block,
  [sym_modifier_chain] = sym_modifier_chain,
  [sym_modifier] = sym_modifier,
  [sym_transform_chain] = sym_transform_chain,
  [sym_module_call] = sym_module_call,
  [sym_arguments] = sym_arguments,
  [sym_parenthesized_assignments] = sym_parenthesized_assignments,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_condition_update_clause] = sym_condition_update_clause,
  [sym__expression] = sym__expression,
  [sym_let_expression] = sym_let_expression,
  [sym__variable_name] = sym__variable_name,
  [sym__literal] = sym__literal,
  [sym_number] = sym_number,
  [sym_boolean] = sym_boolean,
  [sym_function] = sym_function,
  [sym_range] = sym_range,
  [sym_list] = sym_list,
  [sym__list_cell] = sym__list_cell,
  [sym__comprehension_cell] = sym__comprehension_cell,
  [sym_each] = sym_each,
  [sym_list_comprehension] = sym_list_comprehension,
  [sym_for_clause] = sym_for_clause,
  [sym_if_clause] = sym_if_clause,
  [sym_function_call] = sym_function_call,
  [sym_index_expression] = sym_index_expression,
  [sym_dot_index_expression] = sym_dot_index_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_parameters_declaration_repeat1] = aux_sym_parameters_declaration_repeat1,
  [aux_sym_union_block_repeat1] = aux_sym_union_block_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_parenthesized_assignments_repeat1] = aux_sym_parenthesized_assignments_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use] = {
    .visible = true,
    .named = false,
  },
  [sym_include_path] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_intersection_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assign] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [sym_special_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_number_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_undef] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__item] = {
    .visible = false,
    .named = true,
  },
  [sym_module_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__parameter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_union_block] = {
    .visible = true,
    .named = true,
  },
  [sym_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_intersection_for_block] = {
    .visible = true,
    .named = true,
  },
  [sym_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_block] = {
    .visible = true,
    .named = true,
  },
  [sym_if_block] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_transform_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_module_call] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_assignments] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_update_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_let_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_name] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_range] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__list_cell] = {
    .visible = false,
    .named = true,
  },
  [sym__comprehension_cell] = {
    .visible = false,
    .named = true,
  },
  [sym_each] = {
    .visible = true,
    .named = true,
  },
  [sym_list_comprehension] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_dot_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parenthesized_assignments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_arguments = 2,
  field_body = 3,
  field_condition = 4,
  field_consequence = 5,
  field_end = 6,
  field_function = 7,
  field_increment = 8,
  field_index = 9,
  field_initializer = 10,
  field_left = 11,
  field_name = 12,
  field_parameters = 13,
  field_right = 14,
  field_start = 15,
  field_update = 16,
  field_value = 17,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_end] = "end",
  [field_function] = "function",
  [field_increment] = "increment",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_right] = "right",
  [field_start] = "start",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 3},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 2},
  [8] = {.index = 14, .length = 2},
  [9] = {.index = 16, .length = 2},
  [10] = {.index = 18, .length = 4},
  [11] = {.index = 22, .length = 2},
  [12] = {.index = 24, .length = 3},
  [13] = {.index = 27, .length = 3},
  [14] = {.index = 30, .length = 1},
  [15] = {.index = 31, .length = 3},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 3},
  [19] = {.index = 41, .length = 3},
  [20] = {.index = 44, .length = 3},
  [21] = {.index = 47, .length = 4},
  [22] = {.index = 51, .length = 4},
  [23] = {.index = 55, .length = 5},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_body, 2},
  [3] =
    {field_condition, 1},
    {field_consequence, 2},
  [5] =
    {field_left, 0},
    {field_right, 2},
  [7] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [10] =
    {field_arguments, 1},
    {field_function, 0},
  [12] =
    {field_name, 1},
    {field_parameters, 2},
  [14] =
    {field_body, 2},
    {field_parameters, 1},
  [16] =
    {field_index, 2},
    {field_value, 0},
  [18] =
    {field_alternative, 3},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [22] =
    {field_end, 3},
    {field_start, 1},
  [24] =
    {field_alternative, 4},
    {field_condition, 0},
    {field_consequence, 2},
  [27] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [30] =
    {field_condition, 2},
  [31] =
    {field_end, 5},
    {field_increment, 3},
    {field_start, 1},
  [34] =
    {field_condition, 2},
    {field_update, 4},
  [36] =
    {field_condition, 3},
    {field_initializer, 1},
  [38] =
    {field_condition, 2},
    {field_update, 4},
    {field_update, 5},
  [41] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
  [44] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
  [47] =
    {field_condition, 3},
    {field_initializer, 1},
    {field_update, 5},
    {field_update, 6},
  [51] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
  [55] =
    {field_condition, 4},
    {field_initializer, 1},
    {field_initializer, 2},
    {field_update, 6},
    {field_update, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(25)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(5)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(5)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(6)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(6)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(16);
      if (lookahead == '=') ADVANCE(46);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(14);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(67);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 9:
      if (lookahead == '&') ADVANCE(79);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 11:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '/') ADVANCE(39);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 12:
      if (lookahead == '*') ADVANCE(11);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 15:
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 16:
      if (lookahead == '>') ADVANCE(48);
      if (lookahead != 0) ADVANCE(16);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(17);
      END_STATE();
    case 19:
      if (lookahead == '|') ADVANCE(78);
      END_STATE();
    case 20:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 22:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 23:
      if (lookahead != 0 &&
          lookahead != '\r') ADVANCE(40);
      if (lookahead == '\r') ADVANCE(41);
      END_STATE();
    case 24:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 25:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(24)
      END_STATE();
    case 26:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      END_STATE();
    case 27:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(34)
      if (lookahead == '\r') SKIP(26)
      END_STATE();
    case 28:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      END_STATE();
    case 29:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(35)
      if (lookahead == '\r') SKIP(28)
      END_STATE();
    case 30:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      END_STATE();
    case 31:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(36)
      if (lookahead == '\r') SKIP(30)
      END_STATE();
    case 32:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      END_STATE();
    case 33:
      if (eof) ADVANCE(38);
      if (lookahead == '\n') SKIP(37)
      if (lookahead == '\r') SKIP(32)
      END_STATE();
    case 34:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '"') ADVANCE(7);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(75);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(27)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(34)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 35:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(45);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == ',') ADVANCE(44);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ':') ADVANCE(72);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(47);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(29)
      if (lookahead == ']') ADVANCE(73);
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(35)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 36:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(55);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '&') ADVANCE(9);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '+') ADVANCE(77);
      if (lookahead == '-') ADVANCE(76);
      if (lookahead == '.') ADVANCE(74);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '<') ADVANCE(82);
      if (lookahead == '=') ADVANCE(15);
      if (lookahead == '>') ADVANCE(83);
      if (lookahead == '?') ADVANCE(88);
      if (lookahead == '[') ADVANCE(71);
      if (lookahead == '\\') SKIP(31)
      if (lookahead == '^') ADVANCE(87);
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '|') ADVANCE(19);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(36)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 37:
      if (eof) ADVANCE(38);
      if (lookahead == '!') ADVANCE(54);
      if (lookahead == '#') ADVANCE(56);
      if (lookahead == '$') ADVANCE(22);
      if (lookahead == '%') ADVANCE(57);
      if (lookahead == '*') ADVANCE(53);
      if (lookahead == '/') ADVANCE(10);
      if (lookahead == ';') ADVANCE(42);
      if (lookahead == '\\') SKIP(33)
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == '{') ADVANCE(49);
      if (lookahead == '}') ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(37)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\\') ADVANCE(23);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\\') ADVANCE(40);
      if (lookahead == '\\') ADVANCE(23);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(80);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_include_path);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(81);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_special_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_string);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_string);
      if (lookahead == '"') ADVANCE(66);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(7);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (lookahead == '.') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_number_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_number_token2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(70);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(85);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(12);
      if (lookahead == '/') ADVANCE(40);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == 'a') ADVANCE(2);
      if (lookahead == 'e') ADVANCE(3);
      if (lookahead == 'f') ADVANCE(4);
      if (lookahead == 'i') ADVANCE(5);
      if (lookahead == 'l') ADVANCE(6);
      if (lookahead == 'm') ADVANCE(7);
      if (lookahead == 't') ADVANCE(8);
      if (lookahead == 'u') ADVANCE(9);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 2:
      if (lookahead == 's') ADVANCE(11);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(12);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(13);
      if (lookahead == 'o') ADVANCE(14);
      if (lookahead == 'u') ADVANCE(15);
      END_STATE();
    case 5:
      if (lookahead == 'f') ADVANCE(16);
      if (lookahead == 'n') ADVANCE(17);
      END_STATE();
    case 6:
      if (lookahead == 'e') ADVANCE(18);
      END_STATE();
    case 7:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 8:
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 9:
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 11:
      if (lookahead == 's') ADVANCE(23);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(24);
      END_STATE();
    case 13:
      if (lookahead == 'l') ADVANCE(25);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(28);
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 18:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(31);
      END_STATE();
    case 20:
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(33);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(34);
      END_STATE();
    case 23:
      if (lookahead == 'i') ADVANCE(35);
      END_STATE();
    case 24:
      if (lookahead == 'h') ADVANCE(36);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(38);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(39);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 31:
      if (lookahead == 'u') ADVANCE(41);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(42);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_use);
      END_STATE();
    case 35:
      if (lookahead == 'g') ADVANCE(44);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 39:
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(48);
      END_STATE();
    case 41:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(50);
      END_STATE();
    case 44:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(52);
      END_STATE();
    case 47:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(54);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_undef);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_assign);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(57);
      END_STATE();
    case 54:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 56:
      if (lookahead == 'n') ADVANCE(59);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 58:
      if (lookahead == 'c') ADVANCE(60);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(64);
      END_STATE();
    case 64:
      if (lookahead == '_') ADVANCE(65);
      END_STATE();
    case 65:
      if (lookahead == 'f') ADVANCE(66);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(67);
      END_STATE();
    case 67:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_intersection_for);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 34},
  [2] = {.lex_state = 34},
  [3] = {.lex_state = 5},
  [4] = {.lex_state = 5},
  [5] = {.lex_state = 5},
  [6] = {.lex_state = 5},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 5},
  [13] = {.lex_state = 35},
  [14] = {.lex_state = 5},
  [15] = {.lex_state = 5},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 5},
  [18] = {.lex_state = 35},
  [19] = {.lex_state = 5},
  [20] = {.lex_state = 5},
  [21] = {.lex_state = 5},
  [22] = {.lex_state = 35},
  [23] = {.lex_state = 35},
  [24] = {.lex_state = 35},
  [25] = {.lex_state = 34},
  [26] = {.lex_state = 35},
  [27] = {.lex_state = 35},
  [28] = {.lex_state = 35},
  [29] = {.lex_state = 35},
  [30] = {.lex_state = 35},
  [31] = {.lex_state = 5},
  [32] = {.lex_state = 35},
  [33] = {.lex_state = 35},
  [34] = {.lex_state = 35},
  [35] = {.lex_state = 35},
  [36] = {.lex_state = 35},
  [37] = {.lex_state = 35},
  [38] = {.lex_state = 35},
  [39] = {.lex_state = 35},
  [40] = {.lex_state = 34},
  [41] = {.lex_state = 35},
  [42] = {.lex_state = 35},
  [43] = {.lex_state = 34},
  [44] = {.lex_state = 35},
  [45] = {.lex_state = 34},
  [46] = {.lex_state = 36},
  [47] = {.lex_state = 35},
  [48] = {.lex_state = 35},
  [49] = {.lex_state = 34},
  [50] = {.lex_state = 34},
  [51] = {.lex_state = 35},
  [52] = {.lex_state = 35},
  [53] = {.lex_state = 35},
  [54] = {.lex_state = 35},
  [55] = {.lex_state = 34},
  [56] = {.lex_state = 35},
  [57] = {.lex_state = 35},
  [58] = {.lex_state = 35},
  [59] = {.lex_state = 35},
  [60] = {.lex_state = 35},
  [61] = {.lex_state = 35},
  [62] = {.lex_state = 35},
  [63] = {.lex_state = 35},
  [64] = {.lex_state = 35},
  [65] = {.lex_state = 36},
  [66] = {.lex_state = 35},
  [67] = {.lex_state = 35},
  [68] = {.lex_state = 35},
  [69] = {.lex_state = 35},
  [70] = {.lex_state = 35},
  [71] = {.lex_state = 35},
  [72] = {.lex_state = 35},
  [73] = {.lex_state = 35},
  [74] = {.lex_state = 35},
  [75] = {.lex_state = 35},
  [76] = {.lex_state = 35},
  [77] = {.lex_state = 35},
  [78] = {.lex_state = 35},
  [79] = {.lex_state = 35},
  [80] = {.lex_state = 35},
  [81] = {.lex_state = 35},
  [82] = {.lex_state = 35},
  [83] = {.lex_state = 35},
  [84] = {.lex_state = 35},
  [85] = {.lex_state = 35},
  [86] = {.lex_state = 35},
  [87] = {.lex_state = 35},
  [88] = {.lex_state = 35},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 5},
  [91] = {.lex_state = 5},
  [92] = {.lex_state = 5},
  [93] = {.lex_state = 5},
  [94] = {.lex_state = 5},
  [95] = {.lex_state = 5},
  [96] = {.lex_state = 5},
  [97] = {.lex_state = 5},
  [98] = {.lex_state = 5},
  [99] = {.lex_state = 5},
  [100] = {.lex_state = 5},
  [101] = {.lex_state = 5},
  [102] = {.lex_state = 5},
  [103] = {.lex_state = 5},
  [104] = {.lex_state = 5},
  [105] = {.lex_state = 5},
  [106] = {.lex_state = 5},
  [107] = {.lex_state = 5},
  [108] = {.lex_state = 5},
  [109] = {.lex_state = 5},
  [110] = {.lex_state = 5},
  [111] = {.lex_state = 5},
  [112] = {.lex_state = 5},
  [113] = {.lex_state = 5},
  [114] = {.lex_state = 5},
  [115] = {.lex_state = 5},
  [116] = {.lex_state = 5},
  [117] = {.lex_state = 5},
  [118] = {.lex_state = 5},
  [119] = {.lex_state = 5},
  [120] = {.lex_state = 5},
  [121] = {.lex_state = 5},
  [122] = {.lex_state = 5},
  [123] = {.lex_state = 5},
  [124] = {.lex_state = 5},
  [125] = {.lex_state = 5},
  [126] = {.lex_state = 5},
  [127] = {.lex_state = 5},
  [128] = {.lex_state = 5},
  [129] = {.lex_state = 5},
  [130] = {.lex_state = 5},
  [131] = {.lex_state = 5},
  [132] = {.lex_state = 5},
  [133] = {.lex_state = 5},
  [134] = {.lex_state = 5},
  [135] = {.lex_state = 5},
  [136] = {.lex_state = 5},
  [137] = {.lex_state = 5},
  [138] = {.lex_state = 5},
  [139] = {.lex_state = 5},
  [140] = {.lex_state = 5},
  [141] = {.lex_state = 5},
  [142] = {.lex_state = 5},
  [143] = {.lex_state = 5},
  [144] = {.lex_state = 5},
  [145] = {.lex_state = 5},
  [146] = {.lex_state = 5},
  [147] = {.lex_state = 5},
  [148] = {.lex_state = 5},
  [149] = {.lex_state = 5},
  [150] = {.lex_state = 5},
  [151] = {.lex_state = 5},
  [152] = {.lex_state = 5},
  [153] = {.lex_state = 5},
  [154] = {.lex_state = 5},
  [155] = {.lex_state = 5},
  [156] = {.lex_state = 5},
  [157] = {.lex_state = 5},
  [158] = {.lex_state = 5},
  [159] = {.lex_state = 5},
  [160] = {.lex_state = 5},
  [161] = {.lex_state = 5},
  [162] = {.lex_state = 5},
  [163] = {.lex_state = 34},
  [164] = {.lex_state = 34},
  [165] = {.lex_state = 34},
  [166] = {.lex_state = 5},
  [167] = {.lex_state = 5},
  [168] = {.lex_state = 5},
  [169] = {.lex_state = 34},
  [170] = {.lex_state = 5},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 34},
  [173] = {.lex_state = 34},
  [174] = {.lex_state = 34},
  [175] = {.lex_state = 34},
  [176] = {.lex_state = 34},
  [177] = {.lex_state = 34},
  [178] = {.lex_state = 34},
  [179] = {.lex_state = 34},
  [180] = {.lex_state = 5},
  [181] = {.lex_state = 5},
  [182] = {.lex_state = 34},
  [183] = {.lex_state = 34},
  [184] = {.lex_state = 34},
  [185] = {.lex_state = 34},
  [186] = {.lex_state = 34},
  [187] = {.lex_state = 35},
  [188] = {.lex_state = 35},
  [189] = {.lex_state = 35},
  [190] = {.lex_state = 35},
  [191] = {.lex_state = 35},
  [192] = {.lex_state = 35},
  [193] = {.lex_state = 35},
  [194] = {.lex_state = 35},
  [195] = {.lex_state = 35},
  [196] = {.lex_state = 35},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 6},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 6},
  [214] = {.lex_state = 35},
  [215] = {.lex_state = 35},
  [216] = {.lex_state = 35},
  [217] = {.lex_state = 35},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 35},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 6},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 35},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 35},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 35},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 35},
  [238] = {.lex_state = 35},
  [239] = {.lex_state = 35},
  [240] = {.lex_state = 35},
  [241] = {.lex_state = 35},
  [242] = {.lex_state = 35},
  [243] = {.lex_state = 35},
  [244] = {.lex_state = 37},
  [245] = {.lex_state = 37},
  [246] = {.lex_state = 37},
  [247] = {.lex_state = 37},
  [248] = {.lex_state = 37},
  [249] = {.lex_state = 37},
  [250] = {.lex_state = 37},
  [251] = {.lex_state = 37},
  [252] = {.lex_state = 35},
  [253] = {.lex_state = 35},
  [254] = {.lex_state = 35},
  [255] = {.lex_state = 35},
  [256] = {.lex_state = 37},
  [257] = {.lex_state = 35},
  [258] = {.lex_state = 37},
  [259] = {.lex_state = 35},
  [260] = {.lex_state = 35},
  [261] = {.lex_state = 35},
  [262] = {.lex_state = 35},
  [263] = {.lex_state = 35},
  [264] = {.lex_state = 35},
  [265] = {.lex_state = 37},
  [266] = {.lex_state = 35},
  [267] = {.lex_state = 35},
  [268] = {.lex_state = 35},
  [269] = {.lex_state = 37},
  [270] = {.lex_state = 35},
  [271] = {.lex_state = 34},
  [272] = {.lex_state = 34},
  [273] = {.lex_state = 34},
  [274] = {.lex_state = 34},
  [275] = {.lex_state = 34},
  [276] = {.lex_state = 34},
  [277] = {.lex_state = 34},
  [278] = {.lex_state = 34},
  [279] = {.lex_state = 34},
  [280] = {.lex_state = 34},
  [281] = {.lex_state = 34},
  [282] = {.lex_state = 34},
  [283] = {.lex_state = 34},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 5},
  [288] = {.lex_state = 5},
  [289] = {.lex_state = 5},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 5},
  [293] = {.lex_state = 5},
  [294] = {.lex_state = 5},
  [295] = {.lex_state = 34},
  [296] = {.lex_state = 34},
  [297] = {.lex_state = 34},
  [298] = {.lex_state = 34},
  [299] = {.lex_state = 34},
  [300] = {.lex_state = 34},
  [301] = {.lex_state = 34},
  [302] = {.lex_state = 34},
  [303] = {.lex_state = 34},
  [304] = {.lex_state = 34},
  [305] = {.lex_state = 34},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 34},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 6},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 0},
  [340] = {.lex_state = 0},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 0},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 34},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 34},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 5},
  [386] = {.lex_state = 5},
  [387] = {.lex_state = 34},
  [388] = {.lex_state = 34},
  [389] = {.lex_state = 34},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 34},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [anon_sym_use] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_intersection_for] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_assign] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [sym_special_variable] = ACTIONS(1),
    [sym_string] = ACTIONS(1),
    [aux_sym_number_token1] = ACTIONS(1),
    [aux_sym_number_token2] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_undef] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(377),
    [sym__item] = STATE(25),
    [sym_module_declaration] = STATE(25),
    [sym_function_declaration] = STATE(25),
    [sym__statement] = STATE(25),
    [sym_include_statement] = STATE(25),
    [sym_use_statement] = STATE(25),
    [sym_assignment] = STATE(376),
    [sym_union_block] = STATE(25),
    [sym_for_block] = STATE(25),
    [sym_intersection_for_block] = STATE(25),
    [sym_let_block] = STATE(25),
    [sym_assign_block] = STATE(25),
    [sym_if_block] = STATE(25),
    [sym_modifier_chain] = STATE(25),
    [sym_modifier] = STATE(183),
    [sym_transform_chain] = STATE(25),
    [sym_module_call] = STATE(184),
    [sym__variable_name] = STATE(375),
    [aux_sym_source_file_repeat1] = STATE(25),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_module] = ACTIONS(11),
    [anon_sym_function] = ACTIONS(13),
    [anon_sym_include] = ACTIONS(15),
    [anon_sym_use] = ACTIONS(17),
    [anon_sym_LBRACE] = ACTIONS(19),
    [anon_sym_for] = ACTIONS(21),
    [anon_sym_intersection_for] = ACTIONS(23),
    [anon_sym_let] = ACTIONS(25),
    [anon_sym_assign] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_STAR] = ACTIONS(31),
    [anon_sym_BANG] = ACTIONS(31),
    [anon_sym_POUND] = ACTIONS(31),
    [anon_sym_PERCENT] = ACTIONS(31),
    [sym_special_variable] = ACTIONS(33),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 18,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [51] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(43), 1,
      anon_sym_COMMA,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(67), 1,
      anon_sym_RBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    STATE(235), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(331), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [139] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(73), 1,
      anon_sym_COMMA,
    ACTIONS(75), 1,
      anon_sym_RBRACK,
    STATE(215), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(340), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [227] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(77), 1,
      anon_sym_COMMA,
    ACTIONS(79), 1,
      anon_sym_RBRACK,
    STATE(214), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(328), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [315] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [400] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(83), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [485] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(85), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [570] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(87), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [655] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(89), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [740] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(91), 1,
      anon_sym_RBRACK,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [825] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(103), 1,
      anon_sym_if,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(119), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(309), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [907] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(123), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [961] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(103), 1,
      anon_sym_if,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(119), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(310), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1043] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    STATE(220), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(316), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1125] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    STATE(241), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(353), 3,
      sym__list_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1207] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(103), 1,
      anon_sym_if,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(119), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(316), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1289] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(135), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 21,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1343] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    ACTIONS(133), 1,
      anon_sym_LPAREN,
    STATE(220), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(307), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1425] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(99), 1,
      anon_sym_for,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(103), 1,
      anon_sym_if,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(119), 1,
      anon_sym_each,
    STATE(205), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(307), 3,
      sym__comprehension_cell,
      sym_each,
      sym_list_comprehension,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1507] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    STATE(254), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(374), 2,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [1588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1633] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1678] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1723] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(13), 1,
      anon_sym_function,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(17), 1,
      anon_sym_use,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(151), 1,
      ts_builtin_sym_end,
    ACTIONS(153), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(40), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [1804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(157), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(165), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [1984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2029] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(47), 1,
      anon_sym_for,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(51), 1,
      anon_sym_if,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(69), 1,
      anon_sym_each,
    STATE(253), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(315), 2,
      sym_for_clause,
      sym_if_clause,
    STATE(374), 2,
      sym_each,
      sym_list_comprehension,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [2110] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2290] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2380] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(205), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2470] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 1,
      ts_builtin_sym_end,
    ACTIONS(209), 1,
      sym_identifier,
    ACTIONS(212), 1,
      anon_sym_SEMI,
    ACTIONS(215), 1,
      anon_sym_module,
    ACTIONS(218), 1,
      anon_sym_function,
    ACTIONS(221), 1,
      anon_sym_include,
    ACTIONS(224), 1,
      anon_sym_use,
    ACTIONS(227), 1,
      anon_sym_LBRACE,
    ACTIONS(230), 1,
      anon_sym_for,
    ACTIONS(233), 1,
      anon_sym_intersection_for,
    ACTIONS(236), 1,
      anon_sym_let,
    ACTIONS(239), 1,
      anon_sym_assign,
    ACTIONS(242), 1,
      anon_sym_if,
    ACTIONS(248), 1,
      sym_special_variable,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(245), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(40), 15,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_use_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_source_file_repeat1,
  [2551] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(265), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(267), 1,
      anon_sym_AMP_AMP,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    ACTIONS(279), 1,
      anon_sym_QMARK,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(251), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(253), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [2622] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(123), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2679] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(281), 1,
      anon_sym_SEMI,
    ACTIONS(283), 1,
      anon_sym_function,
    ACTIONS(285), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(55), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2756] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(135), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(137), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [2813] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(287), 1,
      sym_identifier,
    ACTIONS(290), 1,
      anon_sym_SEMI,
    ACTIONS(293), 1,
      anon_sym_module,
    ACTIONS(296), 1,
      anon_sym_function,
    ACTIONS(299), 1,
      anon_sym_include,
    ACTIONS(302), 1,
      anon_sym_LBRACE,
    ACTIONS(305), 1,
      anon_sym_RBRACE,
    ACTIONS(307), 1,
      anon_sym_for,
    ACTIONS(310), 1,
      anon_sym_intersection_for,
    ACTIONS(313), 1,
      anon_sym_let,
    ACTIONS(316), 1,
      anon_sym_assign,
    ACTIONS(319), 1,
      anon_sym_if,
    ACTIONS(325), 1,
      sym_special_variable,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(322), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(45), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [2890] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 1,
      aux_sym_number_token2,
    ACTIONS(330), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(328), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [2935] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(265), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(267), 1,
      anon_sym_AMP_AMP,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    ACTIONS(279), 1,
      anon_sym_QMARK,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(334), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(336), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3006] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(123), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3071] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(283), 1,
      anon_sym_function,
    ACTIONS(338), 1,
      anon_sym_SEMI,
    ACTIONS(340), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(45), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [3148] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(283), 1,
      anon_sym_function,
    ACTIONS(342), 1,
      anon_sym_SEMI,
    ACTIONS(344), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(49), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [3225] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
    ACTIONS(123), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3288] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(123), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [3341] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(135), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3392] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(265), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(267), 1,
      anon_sym_AMP_AMP,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    ACTIONS(279), 1,
      anon_sym_QMARK,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(346), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(348), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3463] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_module,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(33), 1,
      sym_special_variable,
    ACTIONS(283), 1,
      anon_sym_function,
    ACTIONS(338), 1,
      anon_sym_SEMI,
    ACTIONS(350), 1,
      anon_sym_RBRACE,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    STATE(375), 1,
      sym__variable_name,
    STATE(376), 1,
      sym_assignment,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(45), 14,
      sym__item,
      sym_module_declaration,
      sym_function_declaration,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
      aux_sym_union_block_repeat1,
  [3540] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(125), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
    ACTIONS(123), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
  [3599] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(267), 1,
      anon_sym_AMP_AMP,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(123), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3666] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(123), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 17,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3717] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_LPAREN,
    ACTIONS(259), 1,
      anon_sym_LBRACK,
    ACTIONS(261), 1,
      anon_sym_DOT,
    ACTIONS(265), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(267), 1,
      anon_sym_AMP_AMP,
    ACTIONS(275), 1,
      anon_sym_SLASH,
    ACTIONS(277), 1,
      anon_sym_CARET,
    ACTIONS(279), 1,
      anon_sym_QMARK,
    STATE(74), 1,
      sym_arguments,
    ACTIONS(257), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(263), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(269), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(271), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(273), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(352), 5,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(354), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [3788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3872] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [3956] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(360), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(362), 1,
      anon_sym_AMP_AMP,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(334), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(336), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4026] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(376), 1,
      aux_sym_number_token2,
    ACTIONS(330), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(328), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4070] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4112] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(165), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4154] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4238] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(205), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4322] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4364] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4448] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(360), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(362), 1,
      anon_sym_AMP_AMP,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(251), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(253), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4518] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(360), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(362), 1,
      anon_sym_AMP_AMP,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(352), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(354), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4630] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(123), 13,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4724] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
    ACTIONS(123), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4788] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(360), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(362), 1,
      anon_sym_AMP_AMP,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    ACTIONS(374), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(346), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
    ACTIONS(348), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [4858] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(123), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [4914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4956] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 14,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(157), 20,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [4998] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(135), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(137), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [5054] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(362), 1,
      anon_sym_AMP_AMP,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(364), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
    ACTIONS(123), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
  [5120] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(123), 12,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 12,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [5178] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(370), 1,
      anon_sym_SLASH,
    ACTIONS(372), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(356), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(358), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(366), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(368), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(123), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_BANG,
      sym_identifier,
    ACTIONS(125), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_POUND,
      sym_special_variable,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [5240] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(378), 1,
      sym_identifier,
    ACTIONS(380), 1,
      anon_sym_RPAREN,
    ACTIONS(382), 1,
      sym_special_variable,
    STATE(226), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(330), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5312] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(378), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_special_variable,
    ACTIONS(384), 1,
      anon_sym_RPAREN,
    STATE(217), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(336), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5384] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(378), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_special_variable,
    ACTIONS(386), 1,
      anon_sym_RPAREN,
    STATE(232), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(342), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5456] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(378), 1,
      sym_identifier,
    ACTIONS(382), 1,
      sym_special_variable,
    STATE(239), 1,
      sym__expression,
    STATE(242), 1,
      sym__variable_name,
    STATE(356), 1,
      sym_assignment,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 9,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5525] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(59), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5589] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(189), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5653] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(266), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5717] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(196), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5781] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(243), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5845] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(187), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5909] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(188), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [5973] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(195), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6037] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(191), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6101] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(193), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6165] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(13), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6229] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(260), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6293] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(240), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6357] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(261), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6421] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(267), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6485] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(81), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6549] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(194), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6613] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(192), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6677] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(53), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6741] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(198), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6805] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(259), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6869] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(254), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6933] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(270), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [6997] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(203), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7061] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(47), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7125] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(202), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7189] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(13), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7253] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(237), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7317] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(211), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7381] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(87), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7445] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(238), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7509] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(88), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7573] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(199), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7637] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(262), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7701] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(264), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7765] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(255), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7829] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(253), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7893] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(18), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [7957] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8021] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(80), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8085] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(86), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8149] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(82), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8213] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(78), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8277] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(207), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8341] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(201), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8405] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8469] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(56), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8533] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(51), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8597] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(76), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8661] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(268), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8725] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(75), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8789] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(210), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8853] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(208), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8917] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(85), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [8981] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(200), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9045] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(206), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9109] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(48), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9173] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(57), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9237] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(54), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9301] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(42), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9365] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_function,
    ACTIONS(414), 1,
      anon_sym_let,
    ACTIONS(416), 1,
      anon_sym_BANG,
    ACTIONS(418), 1,
      aux_sym_number_token1,
    STATE(64), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(420), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9429] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(52), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9493] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(190), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9557] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(252), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9621] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(41), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9685] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 1,
      sym_identifier,
    ACTIONS(390), 1,
      anon_sym_LPAREN,
    ACTIONS(392), 1,
      anon_sym_function,
    ACTIONS(394), 1,
      anon_sym_let,
    ACTIONS(396), 1,
      anon_sym_BANG,
    ACTIONS(398), 1,
      sym_special_variable,
    ACTIONS(400), 1,
      sym_string,
    ACTIONS(402), 1,
      aux_sym_number_token1,
    ACTIONS(406), 1,
      sym_undef,
    ACTIONS(408), 1,
      anon_sym_LBRACK,
    STATE(44), 1,
      sym__expression,
    ACTIONS(404), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(410), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(83), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(62), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9749] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(263), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9813] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(18), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9877] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(93), 1,
      sym_identifier,
    ACTIONS(97), 1,
      anon_sym_function,
    ACTIONS(101), 1,
      anon_sym_let,
    ACTIONS(105), 1,
      anon_sym_BANG,
    ACTIONS(107), 1,
      sym_special_variable,
    ACTIONS(109), 1,
      sym_string,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(115), 1,
      sym_undef,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(422), 1,
      anon_sym_LPAREN,
    STATE(204), 1,
      sym__expression,
    ACTIONS(113), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(121), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(221), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [9941] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(39), 1,
      sym_identifier,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    ACTIONS(45), 1,
      anon_sym_function,
    ACTIONS(49), 1,
      anon_sym_let,
    ACTIONS(53), 1,
      anon_sym_BANG,
    ACTIONS(55), 1,
      sym_special_variable,
    ACTIONS(57), 1,
      sym_string,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(63), 1,
      sym_undef,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    STATE(257), 1,
      sym__expression,
    ACTIONS(61), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(71), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
    STATE(34), 10,
      sym_parenthesized_expression,
      sym_let_expression,
      sym__variable_name,
      sym__literal,
      sym_function_call,
      sym_index_expression,
      sym_dot_index_expression,
      sym_unary_expression,
      sym_binary_expression,
      sym_ternary_expression,
  [10005] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(426), 1,
      anon_sym_SEMI,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(250), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10060] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(442), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(245), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10115] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(444), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(275), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10170] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(448), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 12,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
    ACTIONS(452), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 12,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
    ACTIONS(456), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10269] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(458), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(274), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10324] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(462), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10357] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 12,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
    ACTIONS(466), 13,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10390] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(468), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(280), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10445] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(470), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(251), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10500] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(472), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(249), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10555] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(474), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(248), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10610] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(476), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(269), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10665] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(478), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(246), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10720] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(480), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(278), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10775] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(281), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10830] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(486), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 11,
      anon_sym_function,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
    ACTIONS(490), 14,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_EQ,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
  [10896] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(492), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(244), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [10951] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(494), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(276), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11006] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(496), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(271), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11061] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(428), 1,
      anon_sym_include,
    ACTIONS(430), 1,
      anon_sym_LBRACE,
    ACTIONS(432), 1,
      anon_sym_for,
    ACTIONS(434), 1,
      anon_sym_intersection_for,
    ACTIONS(436), 1,
      anon_sym_let,
    ACTIONS(438), 1,
      anon_sym_assign,
    ACTIONS(440), 1,
      anon_sym_if,
    ACTIONS(498), 1,
      anon_sym_SEMI,
    STATE(164), 1,
      sym_modifier,
    STATE(177), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(258), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11116] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_include,
    ACTIONS(19), 1,
      anon_sym_LBRACE,
    ACTIONS(21), 1,
      anon_sym_for,
    ACTIONS(23), 1,
      anon_sym_intersection_for,
    ACTIONS(25), 1,
      anon_sym_let,
    ACTIONS(27), 1,
      anon_sym_assign,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(424), 1,
      sym_identifier,
    ACTIONS(500), 1,
      anon_sym_SEMI,
    STATE(183), 1,
      sym_modifier,
    STATE(184), 1,
      sym_module_call,
    ACTIONS(31), 4,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    STATE(282), 10,
      sym__statement,
      sym_include_statement,
      sym_union_block,
      sym_for_block,
      sym_intersection_for_block,
      sym_let_block,
      sym_assign_block,
      sym_if_block,
      sym_modifier_chain,
      sym_transform_chain,
  [11171] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(123), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(125), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11217] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 7,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [11271] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(135), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(137), 14,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11317] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(346), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11375] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 10,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [11425] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(251), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11483] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(123), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(125), 12,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11531] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(352), 5,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
  [11589] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 8,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [11641] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(506), 1,
      anon_sym_CARET,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(123), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 16,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11683] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 1,
      aux_sym_number_token2,
    ACTIONS(330), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(328), 20,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11717] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(135), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(137), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11762] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(123), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(125), 13,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [11807] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(123), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [11846] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_QMARK,
  [11897] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    ACTIONS(544), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(546), 1,
      anon_sym_AMP_AMP,
    ACTIONS(548), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(352), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [11954] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    ACTIONS(544), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(546), 1,
      anon_sym_AMP_AMP,
    ACTIONS(548), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(251), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [12011] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    ACTIONS(544), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(546), 1,
      anon_sym_AMP_AMP,
    ACTIONS(548), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(346), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [12068] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    ACTIONS(544), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(546), 1,
      anon_sym_AMP_AMP,
    ACTIONS(548), 1,
      anon_sym_QMARK,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(550), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [12125] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(135), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(137), 16,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12164] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    ACTIONS(546), 1,
      anon_sym_AMP_AMP,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(538), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 6,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_QMARK,
  [12217] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(123), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(125), 11,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12264] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(552), 1,
      aux_sym_number_token2,
    ACTIONS(330), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(328), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12297] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(532), 1,
      anon_sym_SLASH,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(526), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(536), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(540), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(542), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(125), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_QMARK,
  [12346] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(528), 1,
      anon_sym_LBRACK,
    ACTIONS(530), 1,
      anon_sym_DOT,
    ACTIONS(534), 1,
      anon_sym_CARET,
    STATE(229), 1,
      sym_arguments,
    ACTIONS(123), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(125), 15,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_QMARK,
  [12387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(179), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(181), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(147), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(149), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12447] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(556), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12505] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(558), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [12563] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(560), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [12619] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(564), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    STATE(343), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12679] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(155), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(157), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(159), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(161), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12739] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(550), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [12795] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(183), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12825] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(141), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12855] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(187), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(189), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(171), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(173), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(205), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [12945] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(566), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    STATE(326), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13005] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(37), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13035] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(175), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(177), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13065] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(143), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(145), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13095] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(199), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(201), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13125] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(197), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13155] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(568), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(163), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(165), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(191), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(193), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13275] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(570), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [13333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(167), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(169), 19,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13363] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(572), 1,
      anon_sym_COLON,
    ACTIONS(574), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13420] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(576), 1,
      anon_sym_COLON,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13477] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(580), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13532] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(582), 1,
      anon_sym_COLON,
    ACTIONS(584), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13589] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(554), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [13644] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(586), 1,
      anon_sym_EQ,
    ACTIONS(183), 3,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_SLASH,
    ACTIONS(185), 17,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_CARET,
      anon_sym_QMARK,
  [13675] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(588), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [13729] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(590), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(592), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(596), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(600), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(604), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(608), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13869] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(612), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13897] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(616), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(620), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [13953] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(622), 1,
      anon_sym_SEMI,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14007] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(624), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14061] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(626), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14115] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(628), 1,
      anon_sym_RPAREN,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14169] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14197] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(634), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14251] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_else,
    ACTIONS(636), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(638), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14281] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(642), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14335] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(644), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14389] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(646), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14443] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(648), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14497] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(650), 1,
      anon_sym_SEMI,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14551] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(652), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(656), 11,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      anon_sym_else,
      sym_identifier,
  [14633] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(658), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14687] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(660), 1,
      anon_sym_COLON,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14741] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(662), 1,
      anon_sym_SEMI,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14795] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(664), 1,
      anon_sym_else,
    ACTIONS(636), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(638), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14825] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(129), 1,
      anon_sym_LBRACK,
    ACTIONS(131), 1,
      anon_sym_DOT,
    ACTIONS(504), 1,
      anon_sym_SLASH,
    ACTIONS(506), 1,
      anon_sym_CARET,
    ACTIONS(510), 1,
      anon_sym_AMP_AMP,
    ACTIONS(518), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(520), 1,
      anon_sym_QMARK,
    ACTIONS(666), 1,
      anon_sym_RBRACK,
    STATE(23), 1,
      sym_arguments,
    ACTIONS(502), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(508), 2,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(512), 2,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(514), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(516), 2,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [14879] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(598), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(600), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14906] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(604), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(630), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(632), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(620), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [14987] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(590), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(592), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(594), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(596), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(656), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15068] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(668), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(670), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15095] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(674), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(614), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(616), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15149] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(612), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(608), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15203] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
      sym_special_variable,
    ACTIONS(678), 10,
      anon_sym_module,
      anon_sym_function,
      anon_sym_include,
      anon_sym_use,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15229] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(680), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(684), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(688), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(694), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(692), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15329] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(698), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(696), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(702), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(700), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15379] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(704), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(710), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(708), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(714), 8,
      anon_sym_LPAREN,
      anon_sym_BANG,
      sym_special_variable,
      sym_string,
      aux_sym_number_token1,
      anon_sym_LBRACK,
      anon_sym_DASH,
      anon_sym_PLUS,
    ACTIONS(712), 9,
      anon_sym_function,
      anon_sym_for,
      anon_sym_let,
      anon_sym_if,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      sym_undef,
      anon_sym_each,
  [15454] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(111), 1,
      aux_sym_number_token1,
    ACTIONS(117), 1,
      anon_sym_LBRACK,
    ACTIONS(716), 1,
      anon_sym_function,
    STATE(311), 1,
      sym__literal,
    ACTIONS(109), 2,
      sym_string,
      sym_undef,
    ACTIONS(718), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(223), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [15485] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      aux_sym_number_token1,
    ACTIONS(65), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      anon_sym_function,
    STATE(311), 1,
      sym__literal,
    ACTIONS(57), 2,
      sym_string,
      sym_undef,
    ACTIONS(722), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(35), 5,
      sym_number,
      sym_boolean,
      sym_function,
      sym_range,
      sym_list,
  [15516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(724), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(730), 6,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_POUND,
      anon_sym_PERCENT,
    ACTIONS(728), 7,
      anon_sym_include,
      anon_sym_for,
      anon_sym_intersection_for,
      anon_sym_let,
      anon_sym_assign,
      anon_sym_if,
      sym_identifier,
  [15558] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_COMMA,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(732), 2,
      sym_identifier,
      sym_special_variable,
    STATE(322), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15579] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(732), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15597] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 1,
      anon_sym_RPAREN,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(732), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15615] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_SEMI,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(308), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15635] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_RPAREN,
    STATE(321), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15652] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(746), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15669] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(332), 1,
      sym__variable_name,
    ACTIONS(732), 2,
      sym_identifier,
      sym_special_variable,
    STATE(363), 2,
      sym__parameter_declaration,
      sym_assignment,
  [15684] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    STATE(324), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15701] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_RPAREN,
    STATE(334), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15718] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(752), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15728] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15738] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_SEMI,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(314), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_else,
    ACTIONS(762), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [15766] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(766), 1,
      anon_sym_else,
    ACTIONS(762), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [15778] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15788] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
    ACTIONS(770), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
  [15802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(323), 1,
      sym_assignment,
    STATE(375), 1,
      sym__variable_name,
    ACTIONS(33), 2,
      sym_identifier,
      sym_special_variable,
  [15816] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      anon_sym_SEMI,
    ACTIONS(777), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15832] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15842] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(781), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_else,
      anon_sym_RBRACK,
  [15852] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(783), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15865] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(785), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15878] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    ACTIONS(787), 1,
      anon_sym_EQ,
    STATE(296), 1,
      sym_arguments,
  [15891] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    ACTIONS(789), 1,
      anon_sym_COMMA,
    STATE(344), 1,
      aux_sym_parameters_declaration_repeat1,
  [15904] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(760), 1,
      anon_sym_RPAREN,
    STATE(329), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15917] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 1,
      anon_sym_COMMA,
    ACTIONS(793), 1,
      anon_sym_RPAREN,
    STATE(320), 1,
      aux_sym_parameters_declaration_repeat1,
  [15930] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(770), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [15939] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(795), 1,
      anon_sym_RPAREN,
    STATE(333), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [15952] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(91), 1,
      anon_sym_RBRACK,
    ACTIONS(797), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15965] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(799), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [15978] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(801), 1,
      anon_sym_COMMA,
    ACTIONS(804), 1,
      anon_sym_RBRACK,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [15991] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 1,
      anon_sym_COMMA,
    ACTIONS(808), 1,
      anon_sym_RBRACK,
    STATE(325), 1,
      aux_sym_list_repeat1,
  [16004] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(777), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [16017] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(566), 1,
      anon_sym_RPAREN,
    STATE(326), 1,
      aux_sym_arguments_repeat1,
  [16030] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_COMMA,
    ACTIONS(812), 1,
      anon_sym_RBRACK,
    STATE(341), 1,
      aux_sym_list_repeat1,
  [16043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      anon_sym_EQ,
    ACTIONS(814), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16054] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(818), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [16067] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(820), 1,
      anon_sym_RPAREN,
    STATE(335), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [16080] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(822), 1,
      anon_sym_RPAREN,
    STATE(312), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [16093] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(564), 1,
      anon_sym_RPAREN,
    STATE(343), 1,
      aux_sym_arguments_repeat1,
  [16106] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 1,
      anon_sym_RPAREN,
    ACTIONS(824), 1,
      anon_sym_COMMA,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [16119] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(758), 1,
      anon_sym_COMMA,
    ACTIONS(827), 1,
      anon_sym_RPAREN,
    STATE(318), 1,
      aux_sym_parenthesized_assignments_repeat1,
  [16132] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    STATE(20), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [16143] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(831), 1,
      anon_sym_COMMA,
    ACTIONS(833), 1,
      anon_sym_RBRACK,
    STATE(345), 1,
      aux_sym_list_repeat1,
  [16156] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      anon_sym_RBRACK,
    ACTIONS(835), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [16169] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(568), 1,
      anon_sym_RPAREN,
    STATE(317), 1,
      aux_sym_arguments_repeat1,
  [16182] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 1,
      anon_sym_COMMA,
    ACTIONS(837), 1,
      anon_sym_RPAREN,
    STATE(337), 1,
      aux_sym_arguments_repeat1,
  [16195] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_COMMA,
    ACTIONS(842), 1,
      anon_sym_RPAREN,
    STATE(344), 1,
      aux_sym_parameters_declaration_repeat1,
  [16208] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACK,
    ACTIONS(844), 1,
      anon_sym_COMMA,
    STATE(327), 1,
      aux_sym_list_repeat1,
  [16221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    STATE(19), 2,
      sym_parenthesized_assignments,
      sym_condition_update_clause,
  [16232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(157), 1,
      sym_parameters_declaration,
  [16242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(169), 1,
      sym_parenthesized_assignments,
  [16252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(109), 1,
      sym_parenthesized_assignments,
  [16262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(12), 1,
      sym_parenthesized_expression,
  [16272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(110), 1,
      sym_parameters_declaration,
  [16282] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(14), 1,
      sym_parenthesized_expression,
  [16292] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(804), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [16300] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(143), 1,
      sym_parameters_declaration,
  [16310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(141), 1,
      sym_parenthesized_assignments,
  [16320] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(176), 1,
      sym_parenthesized_expression,
  [16338] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(127), 1,
      anon_sym_LPAREN,
    STATE(296), 1,
      sym_arguments,
  [16348] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(186), 1,
      sym_parenthesized_assignments,
  [16358] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_parenthesized_assignments,
  [16368] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(93), 1,
      sym_parenthesized_assignments,
  [16378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(172), 1,
      sym_parenthesized_assignments,
  [16388] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [16396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(380), 1,
      sym_parameters_declaration,
  [16406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_LPAREN,
    STATE(185), 1,
      sym_parenthesized_expression,
  [16416] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(173), 1,
      sym_parenthesized_assignments,
  [16426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(163), 1,
      sym_parenthesized_assignments,
  [16436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(174), 1,
      sym_parenthesized_assignments,
  [16446] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(178), 1,
      sym_parameters_declaration,
  [16456] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(175), 1,
      sym_parenthesized_assignments,
  [16466] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(116), 1,
      sym_parameters_declaration,
  [16476] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LPAREN,
    STATE(118), 1,
      sym_parenthesized_assignments,
  [16486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 1,
      anon_sym_LPAREN,
    STATE(381), 1,
      sym_parameters_declaration,
  [16496] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 1,
      anon_sym_RPAREN,
  [16503] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 1,
      anon_sym_EQ,
  [16510] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 1,
      anon_sym_SEMI,
  [16517] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(854), 1,
      ts_builtin_sym_end,
  [16524] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 1,
      sym_include_path,
  [16531] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(858), 1,
      sym_identifier,
  [16538] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 1,
      anon_sym_EQ,
  [16545] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_EQ,
  [16552] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 1,
      sym_identifier,
  [16559] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(808), 1,
      anon_sym_RBRACK,
  [16566] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(793), 1,
      anon_sym_RPAREN,
  [16573] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(866), 1,
      sym_include_path,
  [16580] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 1,
      sym_include_path,
  [16587] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(870), 1,
      sym_identifier,
  [16594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 1,
      sym_identifier,
  [16601] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(874), 1,
      sym_identifier,
  [16608] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_RBRACK,
  [16615] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      anon_sym_RBRACK,
  [16622] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 51,
  [SMALL_STATE(4)] = 139,
  [SMALL_STATE(5)] = 227,
  [SMALL_STATE(6)] = 315,
  [SMALL_STATE(7)] = 400,
  [SMALL_STATE(8)] = 485,
  [SMALL_STATE(9)] = 570,
  [SMALL_STATE(10)] = 655,
  [SMALL_STATE(11)] = 740,
  [SMALL_STATE(12)] = 825,
  [SMALL_STATE(13)] = 907,
  [SMALL_STATE(14)] = 961,
  [SMALL_STATE(15)] = 1043,
  [SMALL_STATE(16)] = 1125,
  [SMALL_STATE(17)] = 1207,
  [SMALL_STATE(18)] = 1289,
  [SMALL_STATE(19)] = 1343,
  [SMALL_STATE(20)] = 1425,
  [SMALL_STATE(21)] = 1507,
  [SMALL_STATE(22)] = 1588,
  [SMALL_STATE(23)] = 1633,
  [SMALL_STATE(24)] = 1678,
  [SMALL_STATE(25)] = 1723,
  [SMALL_STATE(26)] = 1804,
  [SMALL_STATE(27)] = 1849,
  [SMALL_STATE(28)] = 1894,
  [SMALL_STATE(29)] = 1939,
  [SMALL_STATE(30)] = 1984,
  [SMALL_STATE(31)] = 2029,
  [SMALL_STATE(32)] = 2110,
  [SMALL_STATE(33)] = 2155,
  [SMALL_STATE(34)] = 2200,
  [SMALL_STATE(35)] = 2245,
  [SMALL_STATE(36)] = 2290,
  [SMALL_STATE(37)] = 2335,
  [SMALL_STATE(38)] = 2380,
  [SMALL_STATE(39)] = 2425,
  [SMALL_STATE(40)] = 2470,
  [SMALL_STATE(41)] = 2551,
  [SMALL_STATE(42)] = 2622,
  [SMALL_STATE(43)] = 2679,
  [SMALL_STATE(44)] = 2756,
  [SMALL_STATE(45)] = 2813,
  [SMALL_STATE(46)] = 2890,
  [SMALL_STATE(47)] = 2935,
  [SMALL_STATE(48)] = 3006,
  [SMALL_STATE(49)] = 3071,
  [SMALL_STATE(50)] = 3148,
  [SMALL_STATE(51)] = 3225,
  [SMALL_STATE(52)] = 3288,
  [SMALL_STATE(53)] = 3341,
  [SMALL_STATE(54)] = 3392,
  [SMALL_STATE(55)] = 3463,
  [SMALL_STATE(56)] = 3540,
  [SMALL_STATE(57)] = 3599,
  [SMALL_STATE(58)] = 3666,
  [SMALL_STATE(59)] = 3717,
  [SMALL_STATE(60)] = 3788,
  [SMALL_STATE(61)] = 3830,
  [SMALL_STATE(62)] = 3872,
  [SMALL_STATE(63)] = 3914,
  [SMALL_STATE(64)] = 3956,
  [SMALL_STATE(65)] = 4026,
  [SMALL_STATE(66)] = 4070,
  [SMALL_STATE(67)] = 4112,
  [SMALL_STATE(68)] = 4154,
  [SMALL_STATE(69)] = 4196,
  [SMALL_STATE(70)] = 4238,
  [SMALL_STATE(71)] = 4280,
  [SMALL_STATE(72)] = 4322,
  [SMALL_STATE(73)] = 4364,
  [SMALL_STATE(74)] = 4406,
  [SMALL_STATE(75)] = 4448,
  [SMALL_STATE(76)] = 4518,
  [SMALL_STATE(77)] = 4588,
  [SMALL_STATE(78)] = 4630,
  [SMALL_STATE(79)] = 4682,
  [SMALL_STATE(80)] = 4724,
  [SMALL_STATE(81)] = 4788,
  [SMALL_STATE(82)] = 4858,
  [SMALL_STATE(83)] = 4914,
  [SMALL_STATE(84)] = 4956,
  [SMALL_STATE(85)] = 4998,
  [SMALL_STATE(86)] = 5054,
  [SMALL_STATE(87)] = 5120,
  [SMALL_STATE(88)] = 5178,
  [SMALL_STATE(89)] = 5240,
  [SMALL_STATE(90)] = 5312,
  [SMALL_STATE(91)] = 5384,
  [SMALL_STATE(92)] = 5456,
  [SMALL_STATE(93)] = 5525,
  [SMALL_STATE(94)] = 5589,
  [SMALL_STATE(95)] = 5653,
  [SMALL_STATE(96)] = 5717,
  [SMALL_STATE(97)] = 5781,
  [SMALL_STATE(98)] = 5845,
  [SMALL_STATE(99)] = 5909,
  [SMALL_STATE(100)] = 5973,
  [SMALL_STATE(101)] = 6037,
  [SMALL_STATE(102)] = 6101,
  [SMALL_STATE(103)] = 6165,
  [SMALL_STATE(104)] = 6229,
  [SMALL_STATE(105)] = 6293,
  [SMALL_STATE(106)] = 6357,
  [SMALL_STATE(107)] = 6421,
  [SMALL_STATE(108)] = 6485,
  [SMALL_STATE(109)] = 6549,
  [SMALL_STATE(110)] = 6613,
  [SMALL_STATE(111)] = 6677,
  [SMALL_STATE(112)] = 6741,
  [SMALL_STATE(113)] = 6805,
  [SMALL_STATE(114)] = 6869,
  [SMALL_STATE(115)] = 6933,
  [SMALL_STATE(116)] = 6997,
  [SMALL_STATE(117)] = 7061,
  [SMALL_STATE(118)] = 7125,
  [SMALL_STATE(119)] = 7189,
  [SMALL_STATE(120)] = 7253,
  [SMALL_STATE(121)] = 7317,
  [SMALL_STATE(122)] = 7381,
  [SMALL_STATE(123)] = 7445,
  [SMALL_STATE(124)] = 7509,
  [SMALL_STATE(125)] = 7573,
  [SMALL_STATE(126)] = 7637,
  [SMALL_STATE(127)] = 7701,
  [SMALL_STATE(128)] = 7765,
  [SMALL_STATE(129)] = 7829,
  [SMALL_STATE(130)] = 7893,
  [SMALL_STATE(131)] = 7957,
  [SMALL_STATE(132)] = 8021,
  [SMALL_STATE(133)] = 8085,
  [SMALL_STATE(134)] = 8149,
  [SMALL_STATE(135)] = 8213,
  [SMALL_STATE(136)] = 8277,
  [SMALL_STATE(137)] = 8341,
  [SMALL_STATE(138)] = 8405,
  [SMALL_STATE(139)] = 8469,
  [SMALL_STATE(140)] = 8533,
  [SMALL_STATE(141)] = 8597,
  [SMALL_STATE(142)] = 8661,
  [SMALL_STATE(143)] = 8725,
  [SMALL_STATE(144)] = 8789,
  [SMALL_STATE(145)] = 8853,
  [SMALL_STATE(146)] = 8917,
  [SMALL_STATE(147)] = 8981,
  [SMALL_STATE(148)] = 9045,
  [SMALL_STATE(149)] = 9109,
  [SMALL_STATE(150)] = 9173,
  [SMALL_STATE(151)] = 9237,
  [SMALL_STATE(152)] = 9301,
  [SMALL_STATE(153)] = 9365,
  [SMALL_STATE(154)] = 9429,
  [SMALL_STATE(155)] = 9493,
  [SMALL_STATE(156)] = 9557,
  [SMALL_STATE(157)] = 9621,
  [SMALL_STATE(158)] = 9685,
  [SMALL_STATE(159)] = 9749,
  [SMALL_STATE(160)] = 9813,
  [SMALL_STATE(161)] = 9877,
  [SMALL_STATE(162)] = 9941,
  [SMALL_STATE(163)] = 10005,
  [SMALL_STATE(164)] = 10060,
  [SMALL_STATE(165)] = 10115,
  [SMALL_STATE(166)] = 10170,
  [SMALL_STATE(167)] = 10203,
  [SMALL_STATE(168)] = 10236,
  [SMALL_STATE(169)] = 10269,
  [SMALL_STATE(170)] = 10324,
  [SMALL_STATE(171)] = 10357,
  [SMALL_STATE(172)] = 10390,
  [SMALL_STATE(173)] = 10445,
  [SMALL_STATE(174)] = 10500,
  [SMALL_STATE(175)] = 10555,
  [SMALL_STATE(176)] = 10610,
  [SMALL_STATE(177)] = 10665,
  [SMALL_STATE(178)] = 10720,
  [SMALL_STATE(179)] = 10775,
  [SMALL_STATE(180)] = 10830,
  [SMALL_STATE(181)] = 10863,
  [SMALL_STATE(182)] = 10896,
  [SMALL_STATE(183)] = 10951,
  [SMALL_STATE(184)] = 11006,
  [SMALL_STATE(185)] = 11061,
  [SMALL_STATE(186)] = 11116,
  [SMALL_STATE(187)] = 11171,
  [SMALL_STATE(188)] = 11217,
  [SMALL_STATE(189)] = 11271,
  [SMALL_STATE(190)] = 11317,
  [SMALL_STATE(191)] = 11375,
  [SMALL_STATE(192)] = 11425,
  [SMALL_STATE(193)] = 11483,
  [SMALL_STATE(194)] = 11531,
  [SMALL_STATE(195)] = 11589,
  [SMALL_STATE(196)] = 11641,
  [SMALL_STATE(197)] = 11683,
  [SMALL_STATE(198)] = 11717,
  [SMALL_STATE(199)] = 11762,
  [SMALL_STATE(200)] = 11807,
  [SMALL_STATE(201)] = 11846,
  [SMALL_STATE(202)] = 11897,
  [SMALL_STATE(203)] = 11954,
  [SMALL_STATE(204)] = 12011,
  [SMALL_STATE(205)] = 12068,
  [SMALL_STATE(206)] = 12125,
  [SMALL_STATE(207)] = 12164,
  [SMALL_STATE(208)] = 12217,
  [SMALL_STATE(209)] = 12264,
  [SMALL_STATE(210)] = 12297,
  [SMALL_STATE(211)] = 12346,
  [SMALL_STATE(212)] = 12387,
  [SMALL_STATE(213)] = 12417,
  [SMALL_STATE(214)] = 12447,
  [SMALL_STATE(215)] = 12505,
  [SMALL_STATE(216)] = 12563,
  [SMALL_STATE(217)] = 12619,
  [SMALL_STATE(218)] = 12679,
  [SMALL_STATE(219)] = 12709,
  [SMALL_STATE(220)] = 12739,
  [SMALL_STATE(221)] = 12795,
  [SMALL_STATE(222)] = 12825,
  [SMALL_STATE(223)] = 12855,
  [SMALL_STATE(224)] = 12885,
  [SMALL_STATE(225)] = 12915,
  [SMALL_STATE(226)] = 12945,
  [SMALL_STATE(227)] = 13005,
  [SMALL_STATE(228)] = 13035,
  [SMALL_STATE(229)] = 13065,
  [SMALL_STATE(230)] = 13095,
  [SMALL_STATE(231)] = 13125,
  [SMALL_STATE(232)] = 13155,
  [SMALL_STATE(233)] = 13215,
  [SMALL_STATE(234)] = 13245,
  [SMALL_STATE(235)] = 13275,
  [SMALL_STATE(236)] = 13333,
  [SMALL_STATE(237)] = 13363,
  [SMALL_STATE(238)] = 13420,
  [SMALL_STATE(239)] = 13477,
  [SMALL_STATE(240)] = 13532,
  [SMALL_STATE(241)] = 13589,
  [SMALL_STATE(242)] = 13644,
  [SMALL_STATE(243)] = 13675,
  [SMALL_STATE(244)] = 13729,
  [SMALL_STATE(245)] = 13757,
  [SMALL_STATE(246)] = 13785,
  [SMALL_STATE(247)] = 13813,
  [SMALL_STATE(248)] = 13841,
  [SMALL_STATE(249)] = 13869,
  [SMALL_STATE(250)] = 13897,
  [SMALL_STATE(251)] = 13925,
  [SMALL_STATE(252)] = 13953,
  [SMALL_STATE(253)] = 14007,
  [SMALL_STATE(254)] = 14061,
  [SMALL_STATE(255)] = 14115,
  [SMALL_STATE(256)] = 14169,
  [SMALL_STATE(257)] = 14197,
  [SMALL_STATE(258)] = 14251,
  [SMALL_STATE(259)] = 14281,
  [SMALL_STATE(260)] = 14335,
  [SMALL_STATE(261)] = 14389,
  [SMALL_STATE(262)] = 14443,
  [SMALL_STATE(263)] = 14497,
  [SMALL_STATE(264)] = 14551,
  [SMALL_STATE(265)] = 14605,
  [SMALL_STATE(266)] = 14633,
  [SMALL_STATE(267)] = 14687,
  [SMALL_STATE(268)] = 14741,
  [SMALL_STATE(269)] = 14795,
  [SMALL_STATE(270)] = 14825,
  [SMALL_STATE(271)] = 14879,
  [SMALL_STATE(272)] = 14906,
  [SMALL_STATE(273)] = 14933,
  [SMALL_STATE(274)] = 14960,
  [SMALL_STATE(275)] = 14987,
  [SMALL_STATE(276)] = 15014,
  [SMALL_STATE(277)] = 15041,
  [SMALL_STATE(278)] = 15068,
  [SMALL_STATE(279)] = 15095,
  [SMALL_STATE(280)] = 15122,
  [SMALL_STATE(281)] = 15149,
  [SMALL_STATE(282)] = 15176,
  [SMALL_STATE(283)] = 15203,
  [SMALL_STATE(284)] = 15229,
  [SMALL_STATE(285)] = 15254,
  [SMALL_STATE(286)] = 15279,
  [SMALL_STATE(287)] = 15304,
  [SMALL_STATE(288)] = 15329,
  [SMALL_STATE(289)] = 15354,
  [SMALL_STATE(290)] = 15379,
  [SMALL_STATE(291)] = 15404,
  [SMALL_STATE(292)] = 15429,
  [SMALL_STATE(293)] = 15454,
  [SMALL_STATE(294)] = 15485,
  [SMALL_STATE(295)] = 15516,
  [SMALL_STATE(296)] = 15537,
  [SMALL_STATE(297)] = 15558,
  [SMALL_STATE(298)] = 15579,
  [SMALL_STATE(299)] = 15597,
  [SMALL_STATE(300)] = 15615,
  [SMALL_STATE(301)] = 15635,
  [SMALL_STATE(302)] = 15652,
  [SMALL_STATE(303)] = 15669,
  [SMALL_STATE(304)] = 15684,
  [SMALL_STATE(305)] = 15701,
  [SMALL_STATE(306)] = 15718,
  [SMALL_STATE(307)] = 15728,
  [SMALL_STATE(308)] = 15738,
  [SMALL_STATE(309)] = 15754,
  [SMALL_STATE(310)] = 15766,
  [SMALL_STATE(311)] = 15778,
  [SMALL_STATE(312)] = 15788,
  [SMALL_STATE(313)] = 15802,
  [SMALL_STATE(314)] = 15816,
  [SMALL_STATE(315)] = 15832,
  [SMALL_STATE(316)] = 15842,
  [SMALL_STATE(317)] = 15852,
  [SMALL_STATE(318)] = 15865,
  [SMALL_STATE(319)] = 15878,
  [SMALL_STATE(320)] = 15891,
  [SMALL_STATE(321)] = 15904,
  [SMALL_STATE(322)] = 15917,
  [SMALL_STATE(323)] = 15930,
  [SMALL_STATE(324)] = 15939,
  [SMALL_STATE(325)] = 15952,
  [SMALL_STATE(326)] = 15965,
  [SMALL_STATE(327)] = 15978,
  [SMALL_STATE(328)] = 15991,
  [SMALL_STATE(329)] = 16004,
  [SMALL_STATE(330)] = 16017,
  [SMALL_STATE(331)] = 16030,
  [SMALL_STATE(332)] = 16043,
  [SMALL_STATE(333)] = 16054,
  [SMALL_STATE(334)] = 16067,
  [SMALL_STATE(335)] = 16080,
  [SMALL_STATE(336)] = 16093,
  [SMALL_STATE(337)] = 16106,
  [SMALL_STATE(338)] = 16119,
  [SMALL_STATE(339)] = 16132,
  [SMALL_STATE(340)] = 16143,
  [SMALL_STATE(341)] = 16156,
  [SMALL_STATE(342)] = 16169,
  [SMALL_STATE(343)] = 16182,
  [SMALL_STATE(344)] = 16195,
  [SMALL_STATE(345)] = 16208,
  [SMALL_STATE(346)] = 16221,
  [SMALL_STATE(347)] = 16232,
  [SMALL_STATE(348)] = 16242,
  [SMALL_STATE(349)] = 16252,
  [SMALL_STATE(350)] = 16262,
  [SMALL_STATE(351)] = 16272,
  [SMALL_STATE(352)] = 16282,
  [SMALL_STATE(353)] = 16292,
  [SMALL_STATE(354)] = 16300,
  [SMALL_STATE(355)] = 16310,
  [SMALL_STATE(356)] = 16320,
  [SMALL_STATE(357)] = 16328,
  [SMALL_STATE(358)] = 16338,
  [SMALL_STATE(359)] = 16348,
  [SMALL_STATE(360)] = 16358,
  [SMALL_STATE(361)] = 16368,
  [SMALL_STATE(362)] = 16378,
  [SMALL_STATE(363)] = 16388,
  [SMALL_STATE(364)] = 16396,
  [SMALL_STATE(365)] = 16406,
  [SMALL_STATE(366)] = 16416,
  [SMALL_STATE(367)] = 16426,
  [SMALL_STATE(368)] = 16436,
  [SMALL_STATE(369)] = 16446,
  [SMALL_STATE(370)] = 16456,
  [SMALL_STATE(371)] = 16466,
  [SMALL_STATE(372)] = 16476,
  [SMALL_STATE(373)] = 16486,
  [SMALL_STATE(374)] = 16496,
  [SMALL_STATE(375)] = 16503,
  [SMALL_STATE(376)] = 16510,
  [SMALL_STATE(377)] = 16517,
  [SMALL_STATE(378)] = 16524,
  [SMALL_STATE(379)] = 16531,
  [SMALL_STATE(380)] = 16538,
  [SMALL_STATE(381)] = 16545,
  [SMALL_STATE(382)] = 16552,
  [SMALL_STATE(383)] = 16559,
  [SMALL_STATE(384)] = 16566,
  [SMALL_STATE(385)] = 16573,
  [SMALL_STATE(386)] = 16580,
  [SMALL_STATE(387)] = 16587,
  [SMALL_STATE(388)] = 16594,
  [SMALL_STATE(389)] = 16601,
  [SMALL_STATE(390)] = 16608,
  [SMALL_STATE(391)] = 16615,
  [SMALL_STATE(392)] = 16622,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(319),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(387),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(385),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(359),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(360),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(362),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(348),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3),
  [37] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(34),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(351),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(346),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(350),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(22),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [97] = {.entry = {.count = 1, .reusable = false}}, SHIFT(371),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 4),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [135] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2),
  [137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2),
  [139] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1),
  [141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [143] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [145] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [147] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [155] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 2),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [163] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 3),
  [165] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3),
  [167] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dot_index_expression, 3, .production_id = 9),
  [169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dot_index_expression, 3, .production_id = 9),
  [171] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [173] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [175] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [177] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 4),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 4),
  [183] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1),
  [191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_index_expression, 4, .production_id = 9),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_index_expression, 4, .production_id = 9),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 5, .production_id = 11),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 5, .production_id = 11),
  [199] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list, 5),
  [201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 5),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_range, 7, .production_id = 15),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_range, 7, .production_id = 15),
  [207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(319),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(40),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(389),
  [218] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(387),
  [221] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(386),
  [224] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(385),
  [227] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(50),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(359),
  [233] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(360),
  [236] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(362),
  [239] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(348),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(365),
  [245] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(295),
  [248] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(375),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 3, .production_id = 8),
  [253] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function, 3, .production_id = 8),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [287] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(319),
  [290] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(45),
  [293] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(389),
  [296] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(388),
  [299] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(386),
  [302] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(50),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2),
  [307] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(359),
  [310] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(360),
  [313] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(362),
  [316] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(348),
  [319] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(365),
  [322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(295),
  [325] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_union_block_repeat1, 2), SHIFT_REPEAT(375),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(72),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_declaration, 5, .production_id = 7),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [348] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ternary_expression, 5, .production_id = 12),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [354] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_expression, 3, .production_id = 2),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [370] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(27),
  [378] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(347),
  [394] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(354),
  [414] = {.entry = {.count = 1, .reusable = false}}, SHIFT(355),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [424] = {.entry = {.count = 1, .reusable = false}}, SHIFT(358),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [428] = {.entry = {.count = 1, .reusable = false}}, SHIFT(378),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [432] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [434] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [436] = {.entry = {.count = 1, .reusable = false}}, SHIFT(367),
  [438] = {.entry = {.count = 1, .reusable = false}}, SHIFT(366),
  [440] = {.entry = {.count = 1, .reusable = false}}, SHIFT(357),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 3),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 3),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 4),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 4),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 3),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 3),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [460] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 5),
  [462] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 5),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_assignments, 2),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_assignments, 2),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [484] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 4),
  [486] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 4),
  [488] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameters_declaration, 2),
  [490] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters_declaration, 2),
  [492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [502] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [504] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [514] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [532] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [536] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [538] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [540] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [550] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 1),
  [552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__list_cell, 1),
  [556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment, 3, .production_id = 4),
  [562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [586] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 5, .production_id = 10),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 5, .production_id = 10),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier_chain, 2),
  [596] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier_chain, 2),
  [598] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_transform_chain, 2),
  [600] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_transform_chain, 2),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 3),
  [604] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 3),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_block, 3, .production_id = 2),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_intersection_for_block, 3, .production_id = 2),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_block, 3, .production_id = 2),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assign_block, 3, .production_id = 2),
  [622] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [624] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [626] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [628] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_block, 2),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_block, 2),
  [634] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_block, 3, .production_id = 3),
  [640] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [642] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [644] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [646] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [648] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [650] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [652] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 2),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 2),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [662] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [664] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [668] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [670] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_declaration, 4, .production_id = 5),
  [672] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__item, 2),
  [674] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__item, 2),
  [676] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 2),
  [678] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 2),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 9, .production_id = 23),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 18),
  [688] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [690] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 22),
  [692] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [694] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 17),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 6, .production_id = 16),
  [700] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [702] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 8, .production_id = 21),
  [704] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 20),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 5, .production_id = 14),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 5, .production_id = 14),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_update_clause, 7, .production_id = 19),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [724] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_modifier, 1),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_modifier, 1),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_call, 2, .production_id = 1),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [740] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [746] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [748] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__comprehension_cell, 3),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_clause, 3),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 3),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each, 2),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2),
  [772] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parenthesized_assignments_repeat1, 2), SHIFT_REPEAT(313),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_comprehension, 1),
  [781] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 5, .production_id = 13),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_name, 1),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [801] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2), SHIFT_REPEAT(16),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [814] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__parameter_declaration, 1),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [824] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(92),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [839] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2), SHIFT_REPEAT(303),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_declaration_repeat1, 2),
  [844] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [846] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [848] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [850] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [852] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [854] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [862] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [864] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [866] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [868] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [870] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [872] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [874] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [876] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_openscad(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
