--echo #
--echo # Preparatory cleanup.
--echo #
--disable_warnings
DROP TABLE IF EXISTS t1;
--enable_warnings

--echo #
--echo # We need a fixed timestamp to avoid varying results.
--echo #
SET timestamp=1000000000;

--echo #
--echo # Delete all existing binary logs.
--echo #
RESET BINARY LOGS AND GTIDS;


CREATE TABLE t1 (c01 BIT);
INSERT INTO t1 VALUES (0);
INSERT INTO t1 VALUES (1);
DROP TABLE t1;

CREATE TABLE t1 (c01 BIT(7));
INSERT INTO t1 VALUES (1);
INSERT INTO t1 VALUES (2);
INSERT INTO t1 VALUES (4);
INSERT INTO t1 VALUES (8);
INSERT INTO t1 VALUES (16);
INSERT INTO t1 VALUES (32);
INSERT INTO t1 VALUES (64);
INSERT INTO t1 VALUES (127);
DELETE FROM t1 WHERE c01=127;
UPDATE t1 SET c01=15 WHERE c01=16;
DROP TABLE t1;

CREATE TABLE t1 (a BIT(20), b CHAR(2));
INSERT INTO t1 VALUES (b'00010010010010001001', 'ab');
DROP TABLE t1;

CREATE TABLE t1 (c02 BIT(64));
INSERT INTO t1 VALUES (1);
INSERT INTO t1 VALUES (2);
INSERT INTO t1 VALUES (128);
INSERT INTO t1 VALUES (b'1111111111111111111111111111111111111111111111111111111111111111');
DROP TABLE t1;


CREATE TABLE t1 (c03 TINYINT);
INSERT INTO t1 VALUES (1),(2),(3);
INSERT INTO t1 VALUES (-128);
UPDATE t1 SET c03=2 WHERE c03=1;
DELETE FROM t1 WHERE c03=-128;
DROP TABLE t1;

CREATE TABLE t1 (c04 TINYINT UNSIGNED);
INSERT INTO t1 VALUES (128), (255);
UPDATE t1 SET c04=2 WHERE c04=1;
DELETE FROM t1 WHERE c04=255;
DROP TABLE t1;

CREATE TABLE t1 (c06 BOOL);
INSERT INTO t1 VALUES (TRUE);
DELETE FROM t1 WHERE c06=TRUE;
DROP TABLE t1;

CREATE TABLE t1 (c07 SMALLINT);
INSERT INTO t1 VALUES (1234);
DELETE FROM t1 WHERE c07=1234;
DROP TABLE t1;

CREATE TABLE t1 (c08 SMALLINT UNSIGNED);
INSERT INTO t1 VALUES (32768), (65535);
UPDATE t1 SET c08=2 WHERE c08=32768;
DELETE FROM t1 WHERE c08=65535;
DROP TABLE t1;

CREATE TABLE t1 (c10 MEDIUMINT);
INSERT INTO t1 VALUES (12345);
DELETE FROM t1 WHERE c10=12345;
DROP TABLE t1;

CREATE TABLE t1 (c11 MEDIUMINT UNSIGNED);
INSERT INTO t1 VALUES (8388608), (16777215);
UPDATE t1 SET c11=2 WHERE c11=8388608;
DELETE FROM t1 WHERE c11=16777215;
DROP TABLE t1;

CREATE TABLE t1 (c13 INT);
INSERT INTO t1 VALUES (123456);
DELETE FROM t1 WHERE c13=123456;
DROP TABLE t1;

CREATE TABLE t1 (c14 INT UNSIGNED);
INSERT INTO t1 VALUES (2147483648), (4294967295);
UPDATE t1 SET c14=2 WHERE c14=2147483648;
DELETE FROM t1 WHERE c14=4294967295;
DROP TABLE t1;

CREATE TABLE t1 (c16 BIGINT);
INSERT INTO t1 VALUES (1234567890);
DELETE FROM t1 WHERE c16=1234567890;
DROP TABLE t1;

CREATE TABLE t1 (c17 BIGINT UNSIGNED);
INSERT INTO t1 VALUES (9223372036854775808), (18446744073709551615);
UPDATE t1 SET c17=2 WHERE c17=9223372036854775808;
DELETE FROM t1 WHERE c17=18446744073709551615;
DROP TABLE t1;

CREATE TABLE t1 (c19 FLOAT);
INSERT INTO t1 VALUES (123.2234);
DELETE FROM t1 WHERE c19>123;
DROP TABLE t1;

CREATE TABLE t1 (c22 DOUBLE);
INSERT INTO t1 VALUES (123434.22344545);
DELETE FROM t1 WHERE c22>123434;
DROP TABLE t1;

#

CREATE TABLE t1 (c25 DECIMAL(10,5));
INSERT INTO t1 VALUES (124.45);
INSERT INTO t1 VALUES (-543.21);
DELETE FROM t1 WHERE c25=124.45;
DROP TABLE t1;

#

CREATE TABLE t1 (c28 DATE);
INSERT INTO t1 VALUES ('2001-02-03');
DELETE FROM t1 WHERE c28='2001-02-03';
DROP TABLE t1;

CREATE TABLE t1 (c29 DATETIME);
INSERT INTO t1 VALUES ('2001-02-03 10:20:30');
DELETE FROM t1 WHERE c29='2001-02-03 10:20:30';
DROP TABLE t1;

CREATE TABLE t1 (c30 TIMESTAMP);
INSERT INTO t1 VALUES ('2001-02-03 10:20:30');
DELETE FROM t1 WHERE c30='2001-02-03 10:20:30';
DROP TABLE t1;

CREATE TABLE t1 (c31 TIME);
INSERT INTO t1 VALUES ('11:22:33');
DELETE FROM t1 WHERE c31='11:22:33';
DROP TABLE t1;

CREATE TABLE t1 (c32 YEAR);
INSERT INTO t1 VALUES ('2001');
DELETE FROM t1 WHERE c32=2001;
DROP TABLE t1;

#

CREATE TABLE t1 (c33 CHAR);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c33='a';
DROP TABLE t1;

CREATE TABLE t1 (c34 CHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c34='';
DROP TABLE t1;

CREATE TABLE t1 (c35 CHAR(1));
INSERT INTO t1 VALUES ('b');
DELETE FROM t1 WHERE c35='b';
DROP TABLE t1;

CREATE TABLE t1 (c36 CHAR(255));
INSERT INTO t1 VALUES (repeat('c',255));
DELETE FROM t1 WHERE c36>'c';
DROP TABLE t1;

#

CREATE TABLE t1 (c37 NATIONAL CHAR);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c37='a';
DROP TABLE t1;

CREATE TABLE t1 (c38 CHAR(0) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c38='';
DROP TABLE t1;

CREATE TABLE t1 (c39 CHAR(1) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c39='a';
DROP TABLE t1;

CREATE TABLE t1 (c40 CHAR(255) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES (repeat('a', 255));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 255));
DELETE FROM t1 WHERE c40>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c41 CHAR CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c41='a';
DROP TABLE t1;

CREATE TABLE t1 (c42 CHAR(0) CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c42='';
DROP TABLE t1;

CREATE TABLE t1 (c43 CHAR(1) CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c43='a';
DROP TABLE t1;

CREATE TABLE t1 (c44 CHAR(255) CHARACTER SET UCS2);
INSERT INTO t1 VALUES (repeat('a', 255));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 255));
DELETE FROM t1 WHERE c44>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c45 VARCHAR(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c45='';
DROP TABLE t1;

CREATE TABLE t1 (c46 VARCHAR(1));
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c46='a';
DROP TABLE t1;

CREATE TABLE t1 (c47 VARCHAR(255));
INSERT INTO t1 VALUES (repeat('a',255));
DELETE FROM t1 WHERE c47>'a';
DROP TABLE t1;

CREATE TABLE t1 (c48 VARCHAR(261));
INSERT INTO t1 VALUES (repeat('a',261));
DELETE FROM t1 WHERE c48>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c49 VARCHAR(0) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c49='';
DROP TABLE t1;

CREATE TABLE t1 (c50 VARCHAR(1) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c50='a';
DROP TABLE t1;

CREATE TABLE t1 (c51 VARCHAR(255) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES (repeat('a',255));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 255));
DELETE FROM t1 WHERE c51>'a';
DROP TABLE t1;

CREATE TABLE t1 (c52 VARCHAR(261) CHARACTER SET utf8mb4);
INSERT INTO t1 VALUES (repeat('a',261));
INSERT INTO t1 VALUES (repeat(_latin1 0xDF, 261));
DELETE FROM t1 WHERE c52>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c53 VARCHAR(0) CHARACTER SET ucs2);
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c53='';
DROP TABLE t1;

CREATE TABLE t1 (c54 VARCHAR(1) CHARACTER SET ucs2);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c54='a';
DROP TABLE t1;

CREATE TABLE t1 (c55 VARCHAR(255) CHARACTER SET ucs2);
INSERT INTO t1 VALUES (repeat('ab', 127));
DELETE FROM t1 WHERE c55>'a';
DROP TABLE t1;

CREATE TABLE t1 (c56 VARCHAR(261) CHARACTER SET ucs2);
INSERT INTO t1 VALUES (repeat('ab', 130));
DELETE FROM t1 WHERE c56>'a';
DROP TABLE t1;

#

CREATE TABLE t1 (c57 BINARY);
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c57='a';
DROP TABLE t1;

CREATE TABLE t1 (c58 BINARY(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c58='';
DROP TABLE t1;

CREATE TABLE t1 (c59 BINARY(1));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c59='a';
DROP TABLE t1;

CREATE TABLE t1 (c60 BINARY(255));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES (repeat('a\0',120));
DELETE FROM t1 WHERE c60<0x02;
DROP TABLE t1;

#

CREATE TABLE t1 (c61 VARBINARY(0));
INSERT INTO t1 VALUES ('');
DELETE FROM t1 WHERE c61='';
DROP TABLE t1;

CREATE TABLE t1 (c62 VARBINARY(1));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES ('a');
DELETE FROM t1 WHERE c62=0x02;
DROP TABLE t1;

CREATE TABLE t1 (c63 VARBINARY(255));
INSERT INTO t1 VALUES (0x00);
INSERT INTO t1 VALUES (0x02);
INSERT INTO t1 VALUES (repeat('a\0',120));
DELETE FROM t1 WHERE c63=0x02;
DROP TABLE t1;

#

CREATE TABLE t1 (c65 TINYBLOB);
INSERT INTO t1 VALUES ('tinyblob1');
DELETE FROM t1 WHERE c65='tinyblob1';
DROP TABLE t1;

CREATE TABLE t1 (c68 BLOB);
INSERT INTO t1 VALUES ('blob1');
DELETE FROM t1 WHERE c68='blob1';
DROP TABLE t1;

CREATE TABLE t1 (c71 MEDIUMBLOB);
INSERT INTO t1 VALUES ('mediumblob1');
DELETE FROM t1 WHERE c71='mediumblob1';
DROP TABLE t1;

CREATE TABLE t1 (c74 LONGBLOB);
INSERT INTO t1 VALUES ('longblob1');
DELETE FROM t1 WHERE c74='longblob1';
DROP TABLE t1;

CREATE TABLE t1 (c66 TINYTEXT);
INSERT INTO t1 VALUES ('tinytext1');
DELETE FROM t1 WHERE c66='tinytext1';
DROP TABLE t1;

CREATE TABLE t1 (c69 TEXT);
INSERT INTO t1 VALUES ('text1');
DELETE FROM t1 WHERE c69='text1';
DROP TABLE t1;

CREATE TABLE t1 (c72 MEDIUMTEXT);
INSERT INTO t1 VALUES ('mediumtext1');
DELETE FROM t1 WHERE c72='mediumtext1';
DROP TABLE t1;

CREATE TABLE t1 (c75 LONGTEXT);
INSERT INTO t1 VALUES ('longtext1');
DELETE FROM t1 WHERE c75='longtext1';
DROP TABLE t1;

#

CREATE TABLE t1 (c67 TINYTEXT CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('tinytext1');
DELETE FROM t1 WHERE c67='tinytext1';
DROP TABLE t1;

CREATE TABLE t1 (c70 TEXT CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('text1');
DELETE FROM t1 WHERE c70='text1';
DROP TABLE t1;

CREATE TABLE t1 (c73 MEDIUMTEXT CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('mediumtext1');
DELETE FROM t1 WHERE c73='mediumtext1';
DROP TABLE t1;

CREATE TABLE t1 (c76 LONGTEXT CHARACTER SET UCS2);
INSERT INTO t1 VALUES ('longtext1');
DELETE FROM t1 WHERE c76='longtext1';
DROP TABLE t1;

#

CREATE TABLE t1 (c77 ENUM('a','b','c'));
INSERT INTO t1 VALUES ('b');
DELETE FROM t1 WHERE c77='b';
DROP TABLE t1;

#

CREATE TABLE t1 (c78 SET('a','b','c','d','e','f'));
INSERT INTO t1 VALUES ('a,b');
INSERT INTO t1 VALUES ('a,c');
INSERT INTO t1 VALUES ('b,c');
INSERT INTO t1 VALUES ('a,b,c');
INSERT INTO t1 VALUES ('a,b,c,d');
INSERT INTO t1 VALUES ('a,b,c,d,e');
INSERT INTO t1 VALUES ('a,b,c,d,e,f');
DELETE FROM t1 WHERE c78='a,b';
DROP TABLE t1;

#
# Start of FSP-enabled data types
#
SET time_zone='+00:00';
SET timestamp=UNIX_TIMESTAMP('2002-02-02 20:20:20') + 0.123456;
SET @t='00:00:01.123456'; 
CREATE TABLE t1 (
  c79 TIME(6), c80 TIME(5), c81 TIME(4),
  c82 TIME(3), c83 TIME(2), c84 TIME(1)
);
INSERT INTO t1 VALUES (@t, @t, @t, @t, @t, @t);
INSERT INTO t1 VALUES (NOW(), NOW(), NOW(), NOW(), NOW(), NOW());
INSERT INTO t1 VALUES (NOW(6), NOW(6), NOW(6), NOW(6), NOW(6), NOW(6));
DROP TABLE t1;

SET @ts='2001-01-01 00:00:00.123456';
CREATE TABLE t1 (
  c85 DATETIME(6), c86 DATETIME(5), c87 DATETIME(4),
  c88 DATETIME(3), c89 DATETIME(2), c90 DATETIME(1)
);
INSERT INTO t1 VALUES (@ts, @ts, @ts, @ts, @ts, @ts);
INSERT INTO t1 VALUES (NOW(), NOW(), NOW(), NOW(), NOW(), NOW());
INSERT INTO t1 VALUES (NOW(6), NOW(6), NOW(6), NOW(6), NOW(6), NOW(6));
DROP TABLE t1;

SET @ts='2001-01-01 00:00:00.123456';
SET sql_mode = 'NO_ENGINE_SUBSTITUTION';
CREATE TABLE t1 (
  c85 TIMESTAMP(6), c86 TIMESTAMP(5), c87 TIMESTAMP(4),
  c88 TIMESTAMP(3), c89 TIMESTAMP(2), c90 TIMESTAMP(1)
);
INSERT INTO t1 VALUES (@ts, @ts, @ts, @ts, @ts, @ts);
INSERT INTO t1 VALUES (NOW(), NOW(), NOW(), NOW(), NOW(), NOW());
INSERT INTO t1 VALUES (NOW(6), NOW(6), NOW(6), NOW(6), NOW(6), NOW(6));
DROP TABLE t1;

SET timestamp=1000000000;
SET time_zone=default;
SET sql_mode = default;
#
# End of FSP-enabled data types
#


#
# Check multi-table update
#
CREATE TABLE t1 (a int NOT NULL DEFAULT 0, b int NOT NULL DEFAULT 0);
CREATE TABLE t2 (a int NOT NULL DEFAULT 0, b int NOT NULL DEFAULT 0);
INSERT INTO t1 SET a=1;
INSERT INTO t1 SET b=1;
INSERT INTO t2 SET a=1;
INSERT INTO t2 SET b=1;
UPDATE t1, t2 SET t1.a=10, t2.a=20;
DROP TABLE t1,t2;


#
# Bug#20836250 MYSQLBINLOG --VERBOSE FOR BINARY DATATYPE NOT SKIPPING '
# (QUOTE) & \(BACKSLASH)
#
# Binary and Varbinary types in mysqlbinlog --verbose are displayed
# as string types. Single quote(0x27) and back slash (0x5c)
# should not be converted to it's string equalents (' and \ ) as
# it confuses users with bad binary data output.
#
CREATE TABLE t1(a BINARY(16), b VARBINARY(32));
INSERT INTO t1 VALUES (0x275c275c3132,0x5c78276566);
UPDATE t1 SET a= 0x5c27;
DELETE FROM t1 where b=0x5c78276566;
DROP TABLE t1;

# Since binlog content does not differntiate between binary and
# non-binary data types, even the data in string data types also
# will be affected by this patch. Now 'a''b' will now be seen
# in mysqlbinlog -v -v as 'a\x27b' instead 'a'b' and 'a\x5cb'
# instead of 'a\b'.

CREATE TABLE t1(i INT, a CHAR(16), b VARCHAR(32));
INSERT INTO t1 VALUES(1, 'a''b', 'a''b');
INSERT INTO t1 VALUES(2, 'a\\b', 'a\\b');
UPDATE t1 SET a='a\\b', b='a\\b'  WHERE i=1;
UPDATE t1 SET a='a''b', b='a''b'  WHERE i=2;
DELETE FROM t1 WHERE a='a''b' AND b='a''b';
DELETE FROM t1 WHERE a='a\\b' AND b='a\\b';
DROP TABLE t1;
# End of Testing for Bug#20836250

flush logs;

let $MYSQLD_DATADIR= `select @@datadir`;
--let $mysqlbinlog_parameters= --base64-output=decode-rows -v -v $MYSQLD_DATADIR/binlog.000001
--source include/mysqlbinlog.inc
