/*
*  qm_browser.h
*  QUIMUP library & playlist window
*  © 2008-2024 Johan Spee
*  SPDX-License-Identifier: GPL-3.0-or-later
*/

#ifndef QM_BROWSER_H
#define QM_BROWSER_H

#include <QMainWindow>
#include <QApplication>
#include <QWidget>
#include <QCloseEvent>
#include <QHideEvent>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSplitter>
#include <QSpacerItem>
#include <QPixmap>
#include <QComboBox>
#include <QToolBar>
#include "qm_config.h"
#include "qm_playlistview.h"
#include "qm_libraryview.h"
#include "qm_streamfetcher.h"


class qm_Browser : public QMainWindow
{
    Q_OBJECT

public:
    qm_Browser(qm_Config *);
    virtual ~qm_Browser();

    qm_playlistView *playlist_view;
    qm_libraryView *library_view;

public slots:
    void set_connected(qm_mpdCommand*, bool);
    void set_menu_random(bool);
    void set_menu_repeat(bool);
    void set_menu_single(bool);
    void set_menu_consume(bool);
    void set_menu_xfade(bool);
    void set_colors(QPalette);

private slots:
    void set_searchmode(int);
    void set_selectmode(int);
    void on_dbase_newmode(int);
    void search_in_library();
    void select_in_plist();
    void on_update_dbase();
    void on_update_ready();
    void set_playlist_stats(QString);
    void set_dbase_stats(QString);
    void get_the_stream();
    void splittermoved();
    void on_streamdownload_done(QStringList);
    void set_random();
    void set_repeat();
    void set_single();
    void set_consume();
    void set_xfade();
    void resize_columns();

private:
    QWidget	*main_widget;
    QVBoxLayout *vbox_all;
    QSplitter *sp_splitter;

    QLabel *lb_left_group;
    QLabel *lb_left_title;
    QVBoxLayout *vbox_lefthalf;
    QHBoxLayout *hbox_leftop;
    QComboBox *cb_dbasemode;
    QSpacerItem *spacer_left;
    QPushButton *bt_update;
    QLabel *lb_dbasestats;
    QHBoxLayout *hbox_leftbottom;
    QComboBox *cb_searchmode;
    QLineEdit *le_search;
    QPushButton *bt_search;

    QLabel *lb_right_group;
    QLabel *lb_right_title;
    QVBoxLayout *vbox_righthalf;
    QHBoxLayout *hbox_rightop;
    QPushButton *bt_stream;
    QSpacerItem *spacer_right;
    QToolBar *tb_options;
    QLabel *lb_pliststats;
    QHBoxLayout *hbox_rightbottom;
    QComboBox *cb_selectmode;
    QLineEdit *le_select;
    QPushButton *bt_select;
    QIcon
        ic_dot,
        ic_update,
        ic_busy,
        ic_expand_in,
        ic_expand_out,
        ic_bt_search,
        ic_bt_stream,
        ic_bt_select,
        ic_a_random,
        ic_a_repeat,
        ic_a_single,
        ic_a_consume,
        ic_a_xfade,
        ic_artist,
        ic_album,
        ic_timestamp,
        ic_albumyear,
        ic_titles,
        ic_genre,
        ic_playlist,
        ic_search,
        ic_dir;
    bool
        b_mpd_connected,
        b_wayland,
        b_startup;
    qm_Config *config;
    qm_mpdCommand *mpd_cmd;
    qm_streamFetcher *stream_fetcher;
    QAction
        *a_random,
        *a_repeat,
        *a_single,
        *a_consume,
        *a_xfade;
    int splitter_left,
        splitter_right,
        db_mode_initial;
    void set_themed_icons(bool);
    void setup_widgets();
    void retranslate();

protected:
    void closeEvent(QCloseEvent *);
    void hideEvent(QHideEvent *);
    void showEvent(QShowEvent *);
    void changeEvent(QEvent *);
    void keyPressEvent(QKeyEvent *);

signals:
    void signal_keypressed(QKeyEvent *);
};

#endif // QM_BROWSER_H
