# 6.2 Changelog

## [6.2.7] - 2020-07-16

### Build and Packaging Improvements

<details>

<ul>
<li>Fix Azure file copy issues in release build by fixing the path to upload directory content (#13182)</li>
<li>Update .NET Core to version 2.1.808 (Internal 12003)</li>
<li>Fix Azure file copy break in AzDevOps by updating task version to latest (#13173)</li>
</ul>

</details>

## [6.2.6] - 2020-06-11

### Engine Updates and Fixes

- Restrict loading of `amsi.dll` to `system32` folder (#12730)

### Tools

- Update the PowerShell team list to correct changelog generation (#12927)

### Tests

- Pin major Pester version to 4 to prevent breaking changes caused by upcoming release of `v5` (#12262) (Thanks @bergmeister!)

### Build and Packaging Improvements

<details>

<summary>

<p>Update to `.NET Core 2.1.807`</p>

</summary>

<ul>
<li>update to dotnet 2.1.807 (Internal 11697)</li>
<li>update hosting tests</li>
<li>Check if Azure Blob exists before overwriting (#12921)</li>
<li>Upgrade <code>APIScan</code> version (#12876)</li>
<li>Fix break in package build by pinning <code>ffi</code> version to <code>1.12</code> (#12889)</li>
<li>Update the build to sign any unsigned files as 3rd party Dlls (#12581)</li>
</ul>

</details>

## [6.2.5] - 2020-05-14

### Build and Packaging Improvements

<details>

<ul>
<li>Port back the code for new changelog format.</li>
<li>Work around <code>FPM</code> issue with a specific version on macOS</li>
<li>Update the combined package build to release the daily builds (#10449)</li>
<li>Refactor packaging pipeline (#11852)</li>
<li>Bump .NET SDK version to the version 2.1.18</li>
<li>Move to standard internal pool for building (#12119)</li>
</ul>

</details>

## [6.2.4] - 2020-01-27

### General Cmdlet Updates and Fixes

- Enable `Start-Process` to work on Windows 7 (#10417) (Thanks @iSazonov!)
- Fix global tool issues around exit code, command line parameters, and paths with spaces (#10461)
- Make `Add-Type` usable in applications that host PowerShell (#10587)

### Build and Packaging Improvements

- Update to use `TSAv2` (#9914)
- Update the dotnet SDK install script URL in `build.psm1` (#10927)
- Update dependencies needed by Azure PowerShell and patch for `Newtonsoft.Json` (Internal 10798)
- Fix path for getting reference assemblies (Internal 10792)

## [6.2.3] - 2019-09-12

### Engine Updates and Fixes

- Fix debugger performance regression in system lock down mode (#10269)

### Tests

- Remove `markdownlint` tests due to security issues (#10163)

### Build and Packaging Improvements

- Update DotNet SDK and runtime framework version (Internal 9946)
- Fix macOS build break (#10207)

## [6.2.2] - 2019-07-16

### Breaking Changes

- Disable `Enter-PSHostProcess` cmdlet when system in lock down mode (Internal 8969)

### Engine Updates and Fixes

- Create `JumpList` in STA thread as some COM APIs are strictly STA only to avoid sporadic CLR crashes (#10057, #9928) (Thanks @bergmeister!)

### Build and Packaging Improvements

- Update DotNet SDK and runtime framework version (Internal 9082, 9088, 9092)
- Make `Hashtable` case insensitivity test use current culture rather than shell to set culture (Internal 8529)
- Add automated RPM signing to release build (#10013)
- Update copyright symbol for NuGet packages (#9936)
- Bump `Microsoft.ApplicationInsights` from `2.9.1` to `2.10.0` (#9757)
- Switch from BMP to PNG for graphical MSI installer assets (#9606)
- Bump `System.Net.Http.WinHttpHandler` from `4.5.3` to `4.5.4` (#9789)
- Enable building of MSIX package (#9289, #9715)

## [6.2.1] - 2019-05-21

### Engine Updates and Fixes

- Re-enable tab completion for functions (#9383)
- Disable debugger in System Lock down mode (Internal 8428)

### Code Cleanup

- Update repo for Ubuntu 14.04 EOL (#9324)

### Tests

- Fix skipping of tests in `RemoteSession.Basic.Tests.ps1` (#9304)
- Update tests to account for when `$PSHOME` is read only (#9279)
- Mark tests in macOS CI which use `applescript` as pending/inconclusive (#9352)
- Make sure non-Windows CI fails when a test fails (#9303)

### Build and Packaging Improvements

- Partially revert "Fix the failed test and update `Publish-TestResults` to make `AzDO` fail the task when any tests failed (#9457)"
- Bump `Markdig.Signed` from `0.16.0` to `0.17.0` (#9595)
- Bump `Microsoft.PowerShell.Archive` from `1.2.2.0` to `1.2.3.0` in `/src/Modules` (#9594)
- Enable building on Kali Linux (#9471)
- Fix the failed test and update `Publish-TestResults` to make `AzDO` fail the task when any tests failed (#9457)
- Add Preview assets for `msix` (#9375)
- Create code coverage and test packages for non-windows (#9373)
- Fix publishing daily `nupkg` to MyGet (#9269)
- Bump `PackageManagement` from `1.3.1` to `1.3.2` in `/src/Modules` (#9568)
- Bump `NJsonSchema` from `9.13.27` to `9.13.37` (#9524)
- Bump `gulp` from `4.0.0` to `4.0.2` in `/test/common/markdown` (#9443)
- Bump `Newtonsoft.Json` from `12.0.1` to `12.0.2` (#9433)
- Bump `System.Net.Http.WinHttpHandler` from `4.5.2` to `4.5.3` (#9367)
- Add `AccessToken` variable to jobs that perform signing (#9351)
- Create test package for macOS on release builds (#9344)
- Add component detection to all jobs (#8964)
- Move artifacts to artifact staging directory before uploading (#9273)

## [6.2.0] - 2019-03-28

### Breaking Changes

- Fix `-NoEnumerate` behavior in `Write-Output` to be consistent with Windows PowerShell (#9069) (Thanks @vexx32!)

### Engine Updates and Fixes

- Add PowerShell remoting enable/disable cmdlet warning messages (#9203)
- Fix for `FormatTable` remote deserialization regression (#9116)
- Update the task-based `async` APIs added to PowerShell to return a Task object directly (#9079)
- Add 5 `InvokeAsync` overloads and `StopAsync` to the `PowerShell` type (#8056) (Thanks @KirkMunro!)

### General Cmdlet Updates and Fixes

- Enable `SecureString` cmdlets for non-Windows by storing the plain text (#9199)
- Add Obsolete message to `Send-MailMessage` (#9178)
- Fix `Restart-Computer` to work on `localhost` when WinRM is not present (#9160)
- Make `Start-Job` throw terminating error when PowerShell is being hosted (#9128)
- Update version for `PowerShell.Native` and hosting tests (#8983)

### Tools

- Adding `CmdletsToExport` and `AliasesToExport` to test module manifests. (#9108) (Thanks @powercode!)
- Comment cleanup in `releaseTools.psm1` (#9064) (Thanks @RDIL!)

### Tests

- Fix `Enter-PSHostProcess` tests flakiness (#9007)
- Add tests for command globbing (#9180)
- Add source for `Install-package` to install `netDumbster` (#9081) (Thanks @Geweldig!)
- Fix tab completion test to handle multiple matches (#8891)
- Refactor macOS and Linux CI so that tests run in parallel (#9056, #9209)
- Added `RequireSudoOnUnix` tags to `PowerShellGet` tests and remove `-pending` parameter (#8954) (Thanks @RDIL!)
- Pending `NamedPipeConnectionInfo` test (#9003) (Thanks @iSazonov!)
- Add test for `-WhatIf` for `New-FileCatalog` (#8966) (Thanks @mjanko5!)

### Build and Packaging Improvements

- Performance improvements for release build (#9179)
- Add `tsaVersion` property as `TsaV1` for compliance build phase (#9176)
- Publish global tool packages to `pwshtool` blob and bug fixes (#9163)
- Translate Skipped test results into something Azure DevOps does **not** understand (#9124)
- Disable Homebrew analytics in macOS VSTS builds (#9130) (Thanks @RDIL!)
- Remove AppVeyor references from packaging tools (#9117) (Thanks @RDIL!)
- Fixed Dockerfile syntax highlighting (#8991) (Thanks @RDIL!)
- Fix dependencies of NuGet build to wait on DEB uploads to finish (#9118)
- Fix artifact download issue in release build (#9095)
- Publish test package on release builds (#9063)
- Bump `Microsoft.PowerShell.Native` from `6.2.0-rc.1` to `6.2.0` (#9200)
- Bump `NJsonSchema` from `9.13.19` to `9.13.27` (#9044, #9136, #9166, #9172, #9184 #9196)
- Bump `PowerShellGet` from `2.0.4` to `2.1.2` in /src/Modules (#9110, #9145)
- Bump `SelfSignedCertificate` in `/test/tools/Modules` (#9055)

### Documentation and Help Content

- Update docs for `6.2.0-rc.1` release (#9022)

## [6.2.0-rc.1] - 2019-03-05

### Breaking Changes

- Make `Join-String -InputObject 1,2,3` result equal to `1,2,3 | Join-String` result (#8611) (Thanks @sethvs!)

### Engine Updates and Fixes

- Improve check for developer mode by checking minimum required build number (#8749)
- Simplify the declaration of new experimental features (#8726)
- Remove AMSI uninitialized assert and replace with call to uninitialized (#8713)
- Port Security bypass fixes from 6.1.3 (#8915)
- Enable discovering modules that have names same as a culture (e.g. `Az`) (#8777)
- Flatten interface hierarchy when generating properties that implement interface properties (#8382) (Thanks @IISResetMe!)
- Don't use Win32 native APIs on non-Windows for cryptography of secure string over remoting (#8746)
- Allow `.exe` files to be used as IL binary modules (#7281)
- Remove unused cached types (#9015)

### Experimental Features

- Add the experimental feature for creating `Temp:\` drive when `FileSystemProvider` initializes (#8696)
- Move `CommandNotFoundException` suggestion to an experimental feature (#8805)

### General Cmdlet Updates and Fixes

- Correctly Report impact level when `SupportsShouldProcess` is not set to 'true' (#8209) (Thanks @vexx32!)
- Fix Request Charset Issues in Web Cmdlets (#8742) (Thanks @markekraus!)
- Refactor `ConvertTo-Json` to expose `JsonObject.ConvertToJson` as a public API (#8682)
- Add `-CustomPipeName` to `pwsh` and `Enter-PSHostProcess` (#8889)
- Add configurable maximum depth in `ConvertFrom-Json` with `-Depth` (#8199) (Thanks @louistio!)
- Enable creating relative symbolic links on Windows with `New-Item` (#8783)
- Parse numeric strings as numbers again during conversions (#8681) (Thanks @vexx32!)
- Expose file attributes of `OneDrive` placeholders (#8745) (Thanks @sba923!)
- Enable `Write-Information` to accept `$null` (#8774)
- Adding parameter `ReplyTo` to `Send-MailMessage` (#8727) (Thanks @replicaJunction!)
- Fix `Get-Help` `PSTypeName` issue with `-Parameter` when only one parameter is declared (#8754) (Thanks @pougetat!)

### Code Cleanup

- Use HTTPS in URLs where available (#8622) (Thanks @xtqqczze!)
- Update code to use single method to check if path is UNC (#8680)
- Fix typo: `aganist` ➜ `against` (#8943) (Thanks @lupino3!)
- Use the `OperationCancellationException` to replace the `StoppingException` in `ConvertToJson` (#8920)
- Fix style issues in CSV cmdlets (#8894) (Thanks @iSazonov!)
- Fix `LGTM` issues (#8843) (Thanks @iSazonov!)
- Fix length check in `PSSnapinQualifiedName.GetInstance()` (#8837) (Thanks @hvitved!)
- Reduce string allocations when formatting file system objects. (#8831) (Thanks @powercode!)
- Fix many instances of CodeFactor style issue `A single-line comment must not be followed by a blank line` (#8825) (Thanks @RDIL!)
- Refactor `appveyor.psm1` to `ci.psm1` (#8733, #8854, #8709, #8756, #8867) (Thanks @RDIL!)
- Refactor `travis.ps1` into `ci.psm1` (#8822, #8888) (Thanks @RDIL!)
- Fix Markdown lint issues (#8929)
- Fix code-of-conduct linting (#8896) (Thanks @RDIL!)

### Tools

- Fix broken reference (#8753) (Thanks @RDIL!)
- Remove `GitKracken` files from `.gitignore` (#8743) (Thanks @RDIL!)
- Update path of `test\xUnit\xUnit.tests.csproj` in `PowerShell.sln` (#8730) (Thanks @markekraus!)
- Ignore files added by `SelfSignedCertificate` (#8728) (Thanks @markekraus!)
- Build Global tool for PowerShell and SDK container (#8984)
- Add Experimental Features to change log creation (#8827)
- Remove unneeded `Invoke-Expression` on unvalidated input (#8826)
- Update CLA pull request labeling info (#8820) (Thanks @RDIL!)
- Update some info in `md-link-checks` (#8757) (Thanks @RDIL!)

### Tests

- Fix `Enter-PSHostProcess` test to wait until runspace is ready before attempting to enter (#8725)
- Package validation tests updates (#8714)
- Make xUnit tests run sequentially to avoid race conditions caused by manipulating `powershell.config.json` in tests (#8945)
- Use verbatim string literals for paths (#8937) (Thanks @iSazonov!)
- Parallelize the Windows CI to enable us to run all tests all the time (#8868)
- Fixes for Scheduled release build (#8887)
- Remove references to uninitialized variable (#8849)
- Remove directory causing static analysis failure (#8812)
- Update Pester version to 4.4.4 (#8739)
- Change xUnit Runspace tests to run sequentially (#8796)
- Fix cleanup config files for the csharp xUnit tests (#8761) (Thanks @iSazonov!)
- Moved `fxdependent-dotnetsdk-latest/Dockerfile` (#8738)

### Build and Packaging Improvements

- Make every `csproj` files have its own folder (#8750)
- Update packaging script to build reference assembly targeting `netcoreapp2.1` and use actual `.csproj` files (#8729)
- Generate and deploy reference assembly for `Microsoft.PowerShell.Commands.Utility.dll` (#8716)
- Make test file result names unique (#8979)
- Add variable to control the version of the signing task we use (#8982)
- Publish test and code coverage artifacts for daily builds (#8955)
- Integrate building NuGet package in the coordinated build (#8947)
- Support release branches based on the forward slash separator (#8903)
- Port DotNet fixes from 6.1.3 (#8914)
- Start tracking release build information in an azure storage table (#8850)
- Make license a link in the MSI (#8846)
- Use `-ErrorAction Ignore` instead of `SilentlyContinue` with `Get-Command` in build.psm1 (#8832)
- Add `binskim` to coordinated build and increase timeout (#8834)
- Fix daily CI builds to publish tar package as artifacts (#8775)
- Add instrumentation for `Start-PSPackage` (#8811)
- Fix passing credential to the `SyncGalleryToAzArtifacts.psm1` script (#8808)
- Move Final artifacts from coordinated build to `finalResults` folder (#8806)
- Refactor coordinated release build (#8804)
- Add compliance to Coordinated build (#8798)
- Switch to 1.11 of FPM to fix FPM install issue (#8797)
- Update the coordinated build with framework dependent package for dotnet SDK (#8773)
- Fix MSI upgrade failure for preview builds (#9013)
- Build(deps): Bump `Microsoft.ApplicationInsights` from `2.8.1` to `2.9.1` (#8807,#8848)
- Build(deps): Bump `Microsoft.PowerShell.Native` (#8712)
- Build(deps): Bump `NJsonSchema` from `9.13.15` to `9.13.19` (#8732, #8747, #8881, #8952)
- Build(deps): Bump `PackageManagement` from `1.2.4` to `1.3.1` (#8800)
- Build(deps): Bump `XunitXml.TestLogger` from `2.0.0` to `2.1.26` (#8731)
- Build(deps): Bump `Markdig.Signed` from `0.15.7` to `0.16.0` (#8981)

### Documentation and Help Content

- Updating README.md for supported openSUSE version and updating link to OS versions supported by CoreFx (#8701) (Thanks @stknohg!)
- Add complete XML docs for `ConvertToJsonContext` constructors (#8737)
- Update README.md for ARM to include both 32-bit and 64-bit PS package links (#8677) (Thanks @slide!)
- Update issue templates with new supported values (#8718) (Thanks @RDIL!)
- Update maintainer docs about the CLA PR labels (#8734) (Thanks @RDIL!)
- Add Andrew to the maintainer list (#8722)
- Update release process template (#8711)
- Change label in doc issue template (#8895) (Thanks @iSazonov!)
- Update the `dir -recurse` example (#8939) (Thanks @vmsilvamolina!)
- Update CHANGELOG for release `6.1.3` (#8918)
- Update stable version to `6.1.3` (#8902)
- Fix broken link (#8905)
- Update Coding Guidelines (#8844) (Thanks @iSazonov!)
- Update governance documentation (#8776) (Thanks @RDIL!)
- Fix broken python method (#8821) (Thanks @RDIL!)
- Changing docs issue template to new docs repo location (#8818)
- Fix spelling in `releaseTool/README.md` (#8810)
- Update GitHub templates (#8792) (Thanks @iSazonov!)
- Fix broken link in `FAQs.md` (#8803)
- Updated `basics.md` to add a link for showing example for installing git on all package managers (#8735) (Thanks @RDIL!)
- Update `README.md` for `preview.4` (#8772)

## [6.2.0-preview.4] - 2019-01-28

### Breaking Changes

- Add `-Stable` to `Sort-Object` and related tests (#7862) (Thanks @KirkMunro!)
- Improve `Start-Sleep` cmdlet to accept fractional seconds (#8537) (Thanks @Prototyyppi!)
- Change hashtable to use `OrdinalIgnoreCase` to be case-insensitive in all Cultures (#8566)
- Fix `LiteralPath` in `Import-Csv` to bind to `Get-ChildItem` output (#8277) (Thanks @iSazonov!)

### Engine Updates and Fixes

- Allow user-specified underlying type for enums (#8329) (Thanks @IISResetMe!)
- Handle case where AppLocker test script fails to delete (#8627)
- Update `CommandNotFound` fuzzy suggestion to only return unique results (#8640)
- Add support to show suggestions on `CommandNotFound` exception (#8458)
- Make `S.M.A.PowerShell.GetSteppablePipeline` method public (#8055) (Thanks @KirkMunro!)
- Add `S.M.A.PowerShell.Create` method overload with Runspace argument (#8057) (Thanks @KirkMunro!)
- Fix mistake on deserialization (#8502)
- Fix formatting of header of table when center aligned (#8497)
- Add `-RepeatHeader` to `Format-Table` to enable repeating header for each screen full (#8481)
- Fix `Debug-Runspace` for Unix platforms and properly enable Windows identity impersonation code (#8451)
- Reset output attributes if column had `ESC` char when using `Format-Table`; Replace `...` with unicode ellipsis (#8326)

### Experimental Features

- Add the experimental feature `PSUseAbbreviationExpansion` to support tab completion on abbreviated command names (#8109)

### General Cmdlet Updates and Fixes

- Fix code page parsing issue in `Invoke-RestMethod` (#8694) (Thanks @markekraus!)
- Fix `Expect 100-continue` issue with Web Cmdlets (#8679) (Thanks @markekraus!)
- Allow 'name' as an alias key for 'label' in `ConvertTo-Html`, allow the 'width' entry to be an integer (#8426) (Thanks @mklement0!)
- Resolve `:PAGER` if its path contains spaces (#8571) (Thanks @pougetat!)
- Add support enum and char types in `Format-Hex` cmdlet (#8191) (Thanks @iSazonov!)
- Change `Get-Help` cmdlet `-Parameter` parameter so it accepts string arrays (#8454) (Thanks @sethvs!)
- Fix `FixupFileName` to not load resolved assembly during module discovery (#8634)
- Change `Clear-Host` back to using `$RAWUI` and `clear` to work over remoting (#8609)
- Fix `LiteralPath` in `Import-Csv` to bind to `Get-ChildItem` output (#8277) (Thanks @iSazonov!)
- Make scriptblock based calculated properties work again in `ConvertTo-Html` (#8427) (Thanks @mklement0!)
- Fix `Join-String` cmdlet `FormatString` parameter logic (#8449) (Thanks @sethvs!)
- Allow Windows users in developer mode to create symlinks without elevation (#8534)
- `Help` function should only pass content to pager if content was found (#8528)
- Change `Clear-Host` to simply called `[console]::clear` and remove `clear` alias from Unix (#8603)
- `help` function shouldn't use pager for `AliasHelpInfo` (#8552)
- Fix XML nesting bug in `CustomSerializer.WriteMemberInfoCollection()` (#8476) (Thanks @IISResetMe!)
- Add `-UseMinimalHeader` to `Start-Transcript` to minimize transcript header (#8402) (Thanks @lukexjeremy!)

### Code Cleanup

- Remove the no longer used `RunspaceConfigurationEntry` types (#8424)
- Remove unneeded catch/throw from `mkdir` and `oss` functions (#8425)
- Remove comments after closing brackets (#8344) (Thanks @Meir017!)
- Cleanup `Format-Hex` (#8683) (Thanks @vexx32!)
- Delete `appveyor.yml` (#8639) (Thanks @RDIL!)
- Revise use of `Start-Sleep` cmdlet (#8633) (Thanks @xtqqczze!)
- Style: Change first char to upper in summary comments (#8597) (Thanks @iSazonov!)
- Style: Use the type aliases `char` and `bool` instead of `Char` and `Boolean` (#8572) (Thanks @iSazonov!)
- Style: Use the type alias `string` instead of `String` in places that are appropriate (#8573) (Thanks @iSazonov!)
- Correctly capitalize the `ForEach` operator in `*.ps1` (#8583) (Thanks @xtqqczze!)
- Remove unnecessary trim of passed-in command line in interactive debugging (#8594)
- Style: Add a space after "//" in comments and remove unneeded comments after "}" (#8576) (Thanks @iSazonov!)
- Style: Add the ending period to the XML document texts (#8577) (Thanks @iSazonov!)
- Avoid use of `mkdir` alias in `*.ps1` and `*.psm1` (#8582) (Thanks @xtqqczze!)
- Regularize redirection operator spacing in `*.ps1` and `*.psm1` (#8581) (Thanks @xtqqczze!)
- Style: Change 'String.' to 'string.' (#8568) (Thanks @iSazonov!)
- Style:  Replace `String.IsNullOrEmpty` with `string.IsNullOrEmpty` (#8557) (Thanks @iSazonov!)
- Fix typo in AMSI test (#8561) (Thanks @iSazonov!)
- Style: Convert to upper first char in `<param>` and `<exception>` doc tags (#8556) (Thanks @iSazonov!)
- Style: Add period before `</param>` and `</exception>` doc tags (#8553) (Thanks @iSazonov!)
- Remove use of cmdlet aliases from `.\test\powershell` (#8546) (Thanks @xtqqczze!)
- Style: Remove extra spaces after `<para>` and before `</para>` docs tags (#8547) (Thanks @iSazonov!)
- Style: Remove preceding spaces from C# `preprocessor-type` keywords (#8540) (Thanks @xtqqczze!)
- Style: remove `<remarks>  </remarks>` (#8538) (Thanks @iSazonov!)
- Style: Add period before returns doc tag (#8535) (Thanks @iSazonov!)
- Style: Change `Object[]` to `object[]` (#8526) (Thanks @iSazonov!)
- Style: Change `Object` to `object` (#8522) (Thanks @iSazonov!)
- Style: Change `UInt64?` to `ulong?` (#8527) (Thanks @iSazonov!)
- Style: Change `Byte{}` to `byte[]` (#8525) (Thanks @iSazonov!)
- Code cleanup: Add space after closing brace where needed (#8530)
- Style: Change `System.Boolean` to `bool` (#8521) (Thanks @iSazonov!)
- Change `String` to `string` for simple references (#8519)
- Change `Int32` to `int` for simple references in variable declaration (#8518)
- Style: Member access symbols should be followed with member name (#8517)
- Style: Remove extra space before colon in named parameters (#8504)
- Style: Use the shorthand of the `nullable` type (#8501)
- Remove empty lines; correct space on closing square brackets, negative signs, and generic brackets (#8508)
- Remove space after new keyword in implicitly typed array allocation (#8505)
- The static keyword should be right after access modifier (#8506)
- Remove comments after closing bracket (#8503)
- Remove space character after `'!'` (#8507)
- Style: Remove extra space before colon in named parameters (#8504)

### Tools

- Recommend Azure DevOps extension inside VS-Code for better `YAML` editing. (#8403) (Thanks @bergmeister!)
- `-AddToPath` re-implementation in `install-powershell.ps1` (#8081) (Thanks @glachancecmaisonneuve!)
- Change the feed `URL` to feed name due to changes in `AzDevOps` (#8664)
- Batch merge builds together while a merge build is running (#8668)
- Fix grammar in stale bot message (#8660) (Thanks @RDIL!)
- Add macOS files to `.gitignore` (#8456) (Thanks @RDIL!)
- Name the spelling yaml something more appropriate (#8601) (Thanks @RDIL!)
- Add script to create `icns` files. (#7456) (Thanks @thezim!)
- Pass `nugetkey` as parameter (#8461)
- Add `gitkracken` files to `gitignore` (#8434) (Thanks @RDIL!)
- Create release process issue template (#8417)
- Support for `linuxmint` in `installpsh-debian.sh` (#8440) (Thanks @DarwinJS!)
- Enable `install-powershell.ps1` to use `MSI` (#8418)

### Tests

- Remove broken `HelpUri` from `CimTest` (#8688) (Thanks @xtqqczze!)
- Remove appveyor environment checks (#8669) (Thanks @RDIL!)
- Adding tests for `PSDiagnostics Module` (#8431) (Thanks @kvprasoon!)
- Increase diagnose-ability of Link Checker failures (#8667)
- Fix broken urls (#8653)
- Update fuzzy test to fix daily build (#8629)
- Create link check task (#8471) (Thanks @RDIL!)
- Add Tests for `ConfirmImpact` Ratings (#8214) (Thanks @vexx32!)
- Fix style issues in xUnit tests (#8465) (Thanks @iSazonov!)
- Move `xUnit` tests in new folder (#8356) (Thanks @iSazonov!)
- Fix environment variable test and add missing null check in `CommandHelpProvider` (#8408)
- Remove `dotnet` dependency to start WebListener (#8390)

### Build and Packaging Improvements

- Update Third Party Notices (#8415)
- Adding yaml for Windows Release builds (#8374)
- Bump `NJsonSchema` from `9.13.1` to `9.13.2` (#8422)
- Do not ship fullclr binaries of `PackageManagement` (#8700) (Thanks @bergmeister!)
- Fix the build for `fxdependent` build for `dotnet sdk` (#8670)
- Add Windows build to universal release build YAML (#8695)
- Remove `Debian 8` references as it is EOL (#8678)
- Build(deps): Bump `NJsonSchema` from `9.13.14` to `9.13.15` (#8671)
- Build package build using ubuntu 18.04 image (#8666)
- Fix a typo in `packaging.psm1` (#8647) (Thanks @sethvs!)
- Add function to create a framework dependent package `dotnet-sdk` containers (#8644)
- Build(deps): Bump `NJsonSchema` from `9.13.13` to `9.13.14` (#8648)
- Build(deps): Bump `PowerShellGet` from `2.0.3` to `2.0.4` (#8649)
- Fix installing `fpm` and `ronn` in macOS CI by avoid installing docs for them (#8656)
- Build(deps): Bump `Markdig.Signed` from `0.15.6` to `0.15.7` (#8637)
- Build(deps): Bump `System.Security.Cryptography.Pkcs` from `4.5.1` to `4.5.2` (#8614)
- Build(deps): Bump `System.Net.Http.WinHttpHandler` from `4.5.1` to `4.5.2` (#8615)
- Build(deps): Bump `NJsonSchema` from `9.13.11` to `9.13.13` (#8616)
- Build(deps): Bump `System.Text.Encoding.CodePages` from `4.5.0` to `4.5.1` (#8613)
- Enable install of Preview MSI release side-by-side with Stable release (#8513)
- Get macOS to publish daily build to nugetfeed (#8464)
- Build(deps): Bump `Markdig.Signed` from `0.15.5` to `0.15.6` (#8558)
- Build(deps): Bump `NJsonSchema` from `9.13.10` to `9.13.11` (#8569)
- Remove duplicate `Open Here` context menu item upgrading to newer Preview release (#8496)
- Bump `NJsonSchema` from `9.13.9` to `9.13.10` (#8511)
- Bump `NJsonSchema` from `9.13.7` to `9.13.9` (#8498)
- Bump `NJsonSchema` from `9.13.4` to `9.13.7` (#8493)
- Bump `NJsonSchema` from `9.13.3` to `9.13.4` (#8462)
- Fix daily NuGet publishing (#8460)
- Bump `NJsonSchema` from `9.13.2` to `9.13.3` (#8457)
- Bump `Markdig.Signed` from `0.15.4` to `0.15.5` (#8444)

### Documentation and Help Content

- Remove unused `AppVeyor` links from `README.md` (#8685) (Thanks @RDIL!)
- Update `README.md` (#8684)
- Update Package Management license to MIT (#8676) (Thanks @RDIL!)
- Create Support File (#8618) (Thanks @RDIL!)
- Update git clone URL (#8673) (Thanks @RDIL!)
- docs(contributing): add link check information (#8659) (Thanks @RDIL!)
- Update License and Third Party Notice (#8646)
- Update README, `metadata.json` and changelog for release `6.1.2` (#8658)
- Fix typo in `README.md` (#8642) (Thanks @MarkTiedemann!)
- Fix some typos in the README (#8623) (Thanks @RDIL!)
- Remove `en-us` from `docs.microsoft.com` URL (#8628) (Thanks @xtqqczze!)
- Update examples for hosting PSCore and remove old outdated examples (#8472) (Thanks @bergmeister!)
- Update the pull request template (#8624) (Thanks @RDIL!)
- Contributing guidelines: Remove references to Travis CI and AppVeyor (#8617) (Thanks @RDIL!)
- Update code coverage analysis document (#8543) (Thanks @xtqqczze!)
- Remove `en-us` from our doc links (#8602)
- Document `First-time-issue` and `Hackathon`/`Hacktoberfest` labels (#8575)
- Updated linux build link (#8579) (Thanks @jwmoss!)
- Update contributing guidelines doc to run spellchecking in English (#8473) (Thanks @RDIL!)
- Updating links to point to new VS Code docs (#8468)

## [6.2.0-preview.3] - 2018-12-10

### Breaking Changes

- `Get-ExperimentalFeature` no longer has `-ListAvailable` switch (#8318)
- `Debug` parameter now sets `DebugPreference` to `Continue` instead of `Inquire` (#8195) (Thanks @KirkMunro!)

### Engine Updates and Fixes

- Improve PowerShell startup time by 24% (#8341) (#8396)
- Remove extra newlines from formatting which resulted in unnecessary double newlines (#8247)
- Add `Enable-ExperimentalFeature` and `Disable-ExperimentalFeature` cmdlets (#8318)
- Fix `Export-ModuleMember` bug for a `ScriptBlock` having no context (#8363)
- Fix race condition to access `powershell.config.json` (#8249) (Thanks @iSazonov!)
- Add `SkipCA` and `SkipCN` check requirement to WinRM/OMI HTTPS connection (#8279)
- Add fix for `Start-Job` initialization script which should not be executed as trusted in system lockdown (#8284)

### General Cmdlet Updates and Fixes

- Add `Enable-ExperimentalFeature` and `Disable-ExperimentalFeature` cmdlets (#8318)
- Add cmdlet `Join-String` for creating text from pipeline input (#7660) (Thanks @powercode!)
- Expose all cmdlets from `PSDiagnostics` if `logman.exe` is available (#8366)
- Fix `Get-Help` for advanced functions with MAML help content (#8353)
- Conditionally mark getter/setter implementations as virtual in generated classes (#8303) (Thanks @IISResetMe!)
- Fix for `PSDrive` creation with a UNC path with a trailing backslash or forward slash when combined with `-Persist` (#8305) (Thanks @kvprasoon!)
- Remove `Persist` parameter from `New-PSDrive` on non-Windows platform (#8291) (Thanks @lukexjeremy!)
- `Test-Path`: Return `$false` when given an empty or `$null` `-Path`/`-LiteralPath` value (#8080) (Thanks @vexx32!)
- Token calculation fix for `Get-Help` executed on `ScriptBlock` for comment help. (#8238) (Thanks @hubuk!)
- Support `Get-PSHostProcessInfo` and `Enter-PSHostProcess` on Unix platforms (#8232)

### Code Cleanup

- Update `resgen`, `typegen` to use .Net Core 2.1 (#8369) (Thanks @bergmeister!)
- Change `Newtonsoft` deserializing bug comment to link to the new issue (#8377) (Thanks @louistio!)
- Cleanup `#if !CORECLR` code (#8337) (Thanks @iSazonov!)
- Cleanup `UpdatableHelpSystem` and enable XSD validation on MAML help content (#8335) (Thanks @iSazonov!)
- Remove old `customPSSnapInType` parameter from `PSSnapInInfo()` (#8333) (Thanks @iSazonov!)
- Cleanup `#if CORECLR` from some files (#8332) (Thanks @iSazonov!)
- Cleanup `AssemblyInfo` (#8190) (Thanks @iSazonov!)
- Fix `GetLocationCommand` output type parameter set and style issues (#8324) (Thanks @Meir017!)

### Tools

- Remove `dependabot` attribution and generate changelog sections using `CL-*` labels (#8386)

### Tests

- Update folder path for storing optimization profile and add test to validate loaded assemblies and libraries on startup (#8406)
- Fix an intermittent failure in macOS logging tests (#8385)
- Created a `csproj` to pin test modules and updated `build.psm1` accordingly (#8350)
- Update help content for `TabCompletion` tests only if it does not exist (#8355)
- Skip `Enter-PSHostProcess` tests on `AppVeyor` due to `PSReadline` issue (#8317)

### Build and Packaging Improvements

- Remove `AmazonLinux` Dockerfile (#8271) (Thanks @kiazhi!)
- Make `install-powershell.sh` auto-detect if it should use `wget` or `curl` (#8225) (Thanks @DarwinJS!)
- Bump `NJsonSchema` from `9.12.2` to `9.13.1` (#8319) (#8328) (#8412) (#8371) (#8384)
- Bump `Microsoft.PowerShell.Native` from `6.2.0-preview.2` to `6.2.0-preview.3` (#8411)
- Update the name of the artifact to be unique per artifact (#8405)
- Create unified release build for macOS and Linux packages (#8399)
- Add Linux `ARM64` build support (#8016) (Thanks @slide!)
- Update the timeout of CI builds (#8398)
- Bump `PackageManagement` from `1.2.2` to `1.2.4` in `/src/Modules` (#8320) (#8383)
- Bump `Newtonsoft.Json` from `11.0.2` to `12.0.1` (#8348)
- Enable pipeline to sync `PSGallery` modules to `AzArtifacts` feed (#8316)
- Build Alpine `tar.gz` package in release builds (#8340)
- Publish test package to `AppVeyor` daily build (#8273)
- Bump `Microsoft.CodeAnalysis.CSharp` from `2.9.0` to `2.10.0` (#8294)
- Bump `PowerShellGet` from `2.0.1` to `2.0.3` in `/src/Modules` (#8321)
- Enable `Open Here` context menu on Windows to work with root of a drive (#8287)
- Bump `System.Data.SqlClient` from `4.5.1` to `4.6.0` (#8266)

### Documentation and Help Content

- Merge `changelogs` from `6.1.1` and `6.0.5` into master (#8283)
- Remove all reference to `AppVeyor` and `Travis CI` from docs (#8376)
- Change default issue template to use different categories (#8203)

## [6.2.0-preview.2] - 2018-11-15

### Breaking Changes

- Honor `-OutputFormat` if specified in non-interactive, redirected, encoded command used with `pwsh` (#8115)
- Load assembly from module base path before trying to load from the `GAC` (#8073)
- Remove tilde from Linux preview packages (#8244)
- Move processing of `-WorkingDirectory` before processing of profiles (#8079)

### Known Issues

- PowerShell WSMan remoting does not work on Debian 9 due to missing symbolic links.
  For more information and a workaround see issue [#7598](https://github.com/PowerShell/PowerShell/issues/7598)

### Engine Updates and Fixes

- Enable case-insensitive tab completion for files and folders on case-sensitive filesystem (#8128)
- Experimental feature: Implicit remoting batching performance improvements (#8038)
- Add a path for checking `ZoneInformation` without throwing an exception (#8025) (Thanks @powercode!)
- Fix [CVE-2018-8256](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8256),
  issues with expanding `ZIP` files with relative paths (#8252)
- Fix [CVE-2018-8415](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8415),
  issue logging when the `scriptblock` has a null character (#8253)
- Make `PSVersionInfo.PSVersion` and `PSVersionInfo.PSEdition` public (#8054) (Thanks @KirkMunro!)
- Enable distinct `ModuleAnalysisCache` files for each installation of `pwsh` (#8174)
- Consolidation of all Windows PowerShell work ported to PowerShell Core (#8257)
- Fix incorrect name check when auto-loading required modules (#8218)
- Adding verbose output for experimental implicit remoting batching feature (#8166)
- Add Type Inference for `$_ / $PSItem in catch{ }` blocks (#8020) (Thanks @vexx32!)
- Fix static method invocation type inference (#8018) (Thanks @SeeminglyScience!)

### General Cmdlet Updates and Fixes

- Reduce allocations in `Get-Content` cmdlet (#8103) (Thanks @iSazonov!)
- Enable `Set-Location -LiteralPath` to work with folders named `-` and `+` (#8089)
- Enable `Add-Content` to share read access with other tools while writing content (#8091)
- Add new `Offset` and `Count` parameters to `Format-Hex` and refactor the cmdlet (#7877) (Thanks @iSazonov!)
- Add `-Name`, `-NoUserOverrides` and `-ListAvailable` parameters to `Get-Culture` cmdlet (#7702) (Thanks @iSazonov!)
- Allow dynamic parameter to be returned even if path does not match any provider (#7957)
- Style fixes in `Format-Hex` (#8083) (Thanks @iSazonov!)
- Fix logic to rely on PowerShell major and minor version instead of build number to determine whether to output `formatdata` (#8063)
- Fix `Rename-Item -Path` with wildcard `char` (#7398) (Thanks @kwkam!)
- When using `Start-Transcript` and file exists, empty file rather than deleting (#8131) (Thanks @paalbra!)
- Error message enhancement for `Clear-Content` cmdlet when targeting a directory (#8134) (Thanks @kvprasoon!)
- Make `Select-String` faster by not doing extra work (#7673) (Thanks @powercode!)
- Remove `ShouldProcess` from `Format-Hex` (#8178)

### Code Cleanup

- Remove clone of command-line arguments array (#7910) (Thanks @iSazonov!)
- Use `DefaultPathSeparator` `char` instead of `DefaultPathSeparatorString` (#8082) (Thanks @iSazonov!)
- Replace `StringComparision.CurrentCulture` with `StringComparision.Ordinal` (#8068) (Thanks @iSazonov!)
- Fix typo in `-icontains` description from `incase sensitive` to `case insensitive` (#7840) (Thanks @StingyJack!)
- Refactor module version/`GUID` comparison logic (#7125)

### Tools

- Update `installpsh-amazonlinux.sh` for container specific issues (#7907) (Thanks @DarwinJS!)
- Update the `codeowners` file (#8017)

### Tests

- Filter the `TestPackage` artifact upload by name to avoid other `ZIP` files being uploaded  (#8116)
- Adding `fxdependent` PowerShell package tests (#7830)
- Fix Windows Feature tests running in Azure DevOps (#8220)
- Create `$PROFILE` if it does not exist for `-WorkingDirectory` processing test  (#8152)
- Add test coverage for additional `Get-Module` parameters (#8137) (Thanks @KevinMarquette!)
- Fix conflict with `Get-AdlStoreChildItem` from `az` module in tab completion tests (#8167)
- Fix static secret in code (#8186)

### Build and Packaging Improvements

- Bump `xunit.runner.visualstudio` from `2.4.0` to `2.4.1` (#8139)
- Bump `xunit` from `2.4.0` to `2.4.1` (#8140)
- Bump `Microsoft.ApplicationInsights` from `2.8.0` to `2.8.1` (#8104)
- Bump `NJsonSchema` from `9.11.1` to `9.12.1` (#8183, #8248)
- Fix `Start-PSBuild -Output` (#7504) (Thanks @kwkam!)
- Adding `YML` for Linux builds (#8168)
- Publish test package at `AGENT_WORKFOLDER` if `TEMP` is not available (#8108)
- Fix `psmodulerestore` path when built in Visual Studio Code (#8075)
- Use approved verb instead of `Generate-CrossGenAssembly` (#8151) (Thanks @kvprasoon!)
- Add path filters to CI `YAML` (#8222)
- Update `SignType` in `signing.xml` (#8223)
- Update metadata for `6.0.5` and `6.1.1` releases (#8259)
- Port changes to allow Azure DevOps NuGet feeds for Mac build (Internal 5818)
- Update version for dependencies (Internal 5822)
- Add code to use private NuGet feeds when running in internal CI system (#8187)
- Add title to `Open Here` window for `MSI` installer (#8164)
- Remove build and documentation references to `git` submodules (#8177) (Thanks @andschwa!)
- Add function to create a new `nuget.config` file (#8170)
- Update macOS release build to create the `nuget.config` (#8185)
- Workaround for accessing Azure Artifacts (#8188)
- Fix script path for `PowerShellPackageVsts.ps1` (#8189)
- `Microsoft.PowerShell.Native` now has `MUSL` binaries for Alpine.

### Documentation and Help Content

- Fix grammar in `README.md` (#8059) (Thanks @daviddreher2!)
- Update `powershell-beginners-guide.md` to add alias for `Clear-Host` (#7912) (Thanks @aavdberg!)
- Add Microsoft Docs link to FAQ (#8133) (Thanks @vongrippen!)
- Added updated photo of Visual Studio Code due to new version of Code (#8084) (Thanks @lassehastrup!)
- Update `license.rtf` to only have major version (#8127)
- Updated Pester Syntax in Writing Tests Guide (#8039) (Thanks @markwragg!)
- Remove duplicate parts from license file (#8143) (Thanks @azkarmoulana!)
- Fix spellings in `CHANGELOG.md` (#8062)
- Update license RTF to 6.2 (#8065)
- Combine notes about `ITuple` changes in Change Log (#8077) (Thanks @Jocapear!)
- Correct typos in `powershell-beginners-guide.md` (#8088) (Thanks @nycjan!)
- Added `Learn Windows PowerShell in a Month of Lunches` as recommended reading (#8067) (Thanks @tobvil!)
- Update `README.md` for `v6.1.1` (#8255)
- Fix some typos (#8206) (Thanks @jeis2497052!)
- Promote `HTTPS` (#8160) (Thanks @RDIL!)
- Simple grammatical correction in `README.md` file (#7978) (Thanks @iGotenz!)
- Update URLs to use `HTTPS` instead of `HTTP` in the documentation (#8165) (Thanks @RDIL!)
- Remove #7633 from `v6.2.0-preview.1` `CHANGELOG.md` updates. (#8101) (Thanks @stknohg!)

## [6.2.0-preview.1] - 2018-10-18

### Breaking Changes

- Do not add `PATHEXT` environment variable on Unix (#7697) (Thanks @iSazonov!)

### Known Issues

- Remoting on Windows IOT ARM platforms has an issue loading modules.  See [#8053](https://github.com/PowerShell/PowerShell/issues/8053)

### Engine Updates and Fixes

- Add C# style type accelerators and suffixes for `ushort`, `uint`, `ulong`, and `short` literals (#7813) (Thanks @vexx32!)
- Create inferred types for `Select-Object`, `Group-Object`, `PSObject` and `Hashtable` (#7231) (Thanks @powercode!)
- Fix .NET adapter to be able to get members from `System.IntPtr` (#7808)
- Fix .NET adapter to not throw when fails to create a `PSMethod` due to `ByRef-like` type (#7788)
- Support calling method with `ByRef-like` type parameters (#7721)
- Fix perf issue in provider by using `Refresh()` to update the status rather than instantiating `ServiceController` which has a significant perf degradation from .NET Framework (#7680)
- Update PowerShell to handle the case where the Windows PowerShell module path is already in the environment's `PSModulePath` (#7727)
- Ensure the `SSHClientSessionTransportManager` stream writer and reader fields are cleared after dispose.  (#7746)
- Add unified attribute for completion for `Encoding` parameter. (#7732) (Thanks @ThreeFive-O!)
- Add support for Byte Literals (#7901) (Thanks @vexx32!)
- Fix Property and `ScriptBlock` expressions in `EntrySelectedBy` tags within custom controls (#7913) (Thanks @SeeminglyScience!)
- Fix `BeginInvoke`/`EndInvoke` to return results when `Stop` or `BeginStop`/`EndStop` was called previously (#7917)
- Allow root node of `format.ps1xml` to have attributes that are ignored (#7987)
- Use non-virtual call to invoke 'family or assembly' methods on base class from PowerShell class (#7622) (#7624) (Thanks @yurko7!)
- Make the parameter to `ImportPSModule` use `params` so that it is easier to call (#7933) (Thanks @iSazonov!)

### General Cmdlet Updates and Fixes

- Add `EscapeHandling` parameter in `ConvertTo-Json` cmdlet (#7775) (Thanks @iSazonov!)
- Make `Add-Type` open source files with `FileAccess.Read` and `FileShare.Read` explicitly (#7915) (Thanks @IISResetMe!)
- No longer skips a column without name if double quote delimiter is used in `Import-Csv` (#7899) (Thanks @Topping!)
- Add support for `cd +` (#7206) (Thanks @bergmeister!)
- Allow numeric Ids and name of registered code pages in `-Encoding` parameters (#7636) (Thanks @iSazonov!)
- Remove extra space in `LastWriteTime` format (#7810) (Thanks @iSazonov!)
- Fix `Enter-PSSession -ContainerId` for the latest Windows (#7883)
- `Get/Add-Content` throws improved error when targeting a container (#7823) (Thanks @kvprasoon!)
- Ensure `NestedModules` property gets populated by `Test-ModuleManifest` (#7859)
- Add `%F` case to `Get-Date -UFormat` (#7630) (Thanks @britishben!)
- Fix file blocking issue with web cmdlets (#7676) (Thanks @Claustn!)
- Improve error message on non-Windows when importing `clixml` with `securestring` (#7997)
- Add prompt to the use of less in the function 'help' to instruct user how to quit (#7998)
- Fix `Set-Service -Status Stopped` to stop services with dependencies  (#5525) (Thanks @zhenggu!)

### Code Cleanup

- Use `nameof()` in bound `parameters.contains key()` (#7908) (Thanks @iSazonov!)
- Cleanup all native code from repository (#7892)
- Add `XSDs` for Format and `Types.ps1xml` files (#7832) (Thanks @felixfbecker!)
- Remove unused commented out code (#7935) (Thanks @vpondala!)
- Add `.editorconfig` (#7357) (Thanks @iSazonov!)
- Remove unused stopwatch (#7878)
- Clean up `MshObject.cs` and `MshMemberInfo.cs` (#7446)
- Add `TimeToLive` and `Hops` aliases to `MaxHops` parameter of `Test-Connection` cmdlet. (#7850) (Thanks @sethvs!)
- Fix a typo in `Credential.cs` (#7696) (Thanks @sethvs!)
- Remove workaround on VSTS that is no longer needed (#7666)
- Improve code style of `Send-MailMessage` cmdlet (#7723) (Thanks @ThreeFive-O!)
- Cleanup `FileSystemProvider` from runtime checks (#7655) (Thanks @iSazonov!)
- Remove extra spaces in error messages in `Modules.resx` (#7662) (Thanks @sethvs!)
- Remove empty XML comment lines (missed in #7401) (#7641) (Thanks @kvprasoon!)
- Remove `Suspend-Job` and `Resume-Job` cmdlets from compilation (#7650)

### Tools

- Fix syntax error in `installpwsh-amazonlinux.sh` (#7905) (Thanks @DarwinJS!)
- Add tools for PowerShell perf analysis (#7595) (Thanks @lzybkr!)
- Started using [Dependabot](https://dependabot.com) to create PRs to update package and module versions

### Tests

- Add test for `$error[0]` tab completion (#7924) (Thanks @iSazonov!)
- Replace test certificates with self-signed certificate generating command (#7875)
- Standardize Pester syntax in `ReplaceOperator.Tests.ps1` (#7963) (Thanks @sethvs!)
- Updating `ModulePath.Tests` for `fxdependent` package (#7772)
- Add tests for `Import-Module -Force` (#7491)
- Updates to Docker package tests (#7667)
- Updating test gallery URL in `PackageManagement` tests (#7879)
- Add version checking tests for `Import-Module` (#7499)
- Update Markdown tests (#7838)
- Change locale of `mdspell` to `en-US` (#7671)
- Test changes needed for running in a container (#7869)
- Add daily build non-windows platforms (#7683)
- Remove workaround on VSTS that is no longer needed (#7666)
- Fix module specification `hashtable` in `ModuleSpecification.Tests.ps1` (#7663) (Thanks @sethvs!)
- Use `dotnet test` since the `dotnet xunit` test runner has been deprecated (#7980) (Thanks @bergmeister!)
- Fix pipeline test where `SmtpServer` key was set wrong in pipeline object (#7745) (Thanks @ThreeFive-O!)
- Change API to get host name to match cmdlet which is more reliable in Azure DevOps Pipelines `Hosted Windows VS2017` (#8003)
- Disable `travis-ci` (#7766)
- Make artifact upload only occur for non-PR builds (#7657)
- Change logic for downloading zip files based on job id (#7653)
- Add missing dependency for hosting xUnit tests

### Build and Packaging Improvements

- Change default of `Start-PSBuild` to include `-PSModuleRestore` (#7881)
- Specify verb, `pwsh`, for shell context menu to avoid overriding the default verb (#7932) (Thanks @bergmeister!)
- Converting aliases to cmdlets in `build.psm1` (#7964) (Thanks @kvprasoon!)
- Add dependencies for SUSE (#7938) (Thanks @Jellyfrog!)
- Wait for package manager not to be locked (#7817)
- Make `Start-PSPackage` give better message about how to fix `files.wxs` (#7841)
- Bump to .NET Core `2.1.5` with SDK `2.1.403` and latest packages (#7646, #7834, #7922, #7936) (Thanks @iSazonov!)
- Bump `Markdig.Signed` NuGet package from `0.15.3` to `0.15.4` (#7960) (Thanks @bergmeister!)
- Bump `Microsoft.ApplicationInsights` from `2.7.2` to `2.8.0` (#8002)
- Bump `Microsoft.PowerShell.Native` from `6.1.0-rc.1` to `6.1.0` (#7861)
- Bump `NJsonSchema` from `9.10.71` to `9.11.1` (#7705, #7764, #7990)
- Bump `PackageManagement` from `1.1.7.2` to `1.2.2` in /src/Modules (#8014, #8029)
- Bump `Pester` to use latest version (#8015)
- Bump `PowerShellGet` to `2.0.0` (#7831)
- Bump `PSReadLine` to `2.0.0-beta3` (#7711)
- Bump `Xunit.SkippableFact` from `1.3.6` to `1.3.12` (#7972)
- Make Windows MSI uninstallation shortcut remove work when more than one version is installed (#7701) (Thanks @bergmeister!)
- Update Docker files to use MCR (#7726)
- Update `metadata.json` in preparation for `6.1` release (#7741)
- Build and package framework dependent package (#7729)
- Make sure MSI build works when not preview (#7752)
- Remove `PDBs` from `fxdependent` package (#8006)
- Improve debugging of NuGet package generation and add type to filtering

### Documentation and Help Content

- Replace ambiguous term (#7902, #7931) (Thanks @iSazonov!)
- Updating incorrect example of `PowerShell.Create()` (#7926) (Thanks @1RedOne!)
- Update `governance.md` (#7927) (Thanks @tommymaynard!)
- Add `cURL` to the Bash users list in `README.md` (#7948) (Thanks @vmsilvamolina!)
- Optimize image assets used in documentation (#7874) (Thanks @RDIL!)
- Update build badges (#7792)
- Remove packaging, building and installation scripts for Ubuntu 17.10 (#7773)
- Remove badges for master build as it reflects last PR which is not actionable from the `README` file (#7816)
- Improve Markdown formatting of beginners guide (#7684) (Thanks @fbehrens!)
- Fix the `Basic cookbooks` link (#7934) (Thanks @vmsilvamolina!)
- Update version for PowerShell release `6.1.0` (#7751)
- Add VSTS CI build badges for master branch to `README.md` (#7691) (Thanks @bergmeister!)
- Add a paragraph on `files.wxs` updating (#7695) (Thanks @iSazonov!)
- Update `CONTRIBUTION.md` about adding an empty line after the copyright header (#7706) (Thanks @iSazonov!)
- Update docs about .NET Core version `2.0` to be about version `2.x` (#7467) (Thanks @bergmeister!)

[6.2.7]: https://github.com/PowerShell/PowerShell/compare/v6.2.6...v6.2.7
[6.2.6]: https://github.com/PowerShell/PowerShell/compare/v6.2.5...v6.2.6
[6.2.5]: https://github.com/PowerShell/PowerShell/compare/v6.2.4...v6.2.5
[6.2.4]: https://github.com/PowerShell/PowerShell/compare/v6.2.3...v6.2.4
[6.2.3]: https://github.com/PowerShell/PowerShell/compare/v6.2.2...v6.2.3
[6.2.2]: https://github.com/PowerShell/PowerShell/compare/v6.2.1...v6.2.2
[6.2.1]: https://github.com/PowerShell/PowerShell/compare/v6.2.0...v6.2.1
[6.2.0]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-rc.1...v6.2.0
[6.2.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-rc.1...v6.2.0
[6.2.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-preview.3...v6.2.0-preview.4
[6.2.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-preview.2...v6.2.0-preview.3
[6.2.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v6.2.0-preview.1...v6.2.0-preview.2
[6.2.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v6.1.0...v6.2.0-preview.1
