/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.asciidoctor.diagram.HTTPHeader;

public class HTTPHeaders {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();

    private Map.Entry<String, List<String>> findHeader(String name) {
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            if (!e.getKey().equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public void putValue(String name, String value) {
        Map.Entry<String, List<String>> header = this.findHeader(name);
        if (header != null) {
            header.getValue().add(value);
        } else {
            this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
        }
    }

    public <V> void putValue(HTTPHeader<V> h, V value) {
        this.putValue(h.name, h.formatValue(value));
    }

    public String getValue(String name) {
        List<String> values = this.getValues(name);
        return !values.isEmpty() ? values.get(0) : null;
    }

    public <V> V getValue(HTTPHeader<V> h) {
        List<V> values = this.getValues(h);
        return !values.isEmpty() ? (V)values.get(0) : null;
    }

    public List<String> getValues(String name) {
        Map.Entry<String, List<String>> header = this.findHeader(name);
        return header == null ? Collections.emptyList() : header.getValue();
    }

    public <V> List<V> getValues(HTTPHeader<V> h) {
        return this.getValues(h.name).stream().map(h::parseValue).collect(Collectors.toList());
    }

    public Iterable<String> keys() {
        return this.headers.keySet();
    }
}

