/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.project.DaysAsDates;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.core.Resource;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.lang.ComplementDate;
import net.sourceforge.plantuml.project.lang.ComplementDayOfWeek;
import net.sourceforge.plantuml.project.lang.ComplementIntervals;
import net.sourceforge.plantuml.project.lang.ComplementTask;
import net.sourceforge.plantuml.project.lang.SentenceSimple;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.Verbs;
import net.sourceforge.plantuml.project.lang.Words;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.time.DayOfWeek;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;

public class SubjectResource
implements Subject<GanttDiagram> {
    public static final Subject<GanttDiagram> ME = new SubjectResource();

    private SubjectResource() {
    }

    @Override
    public Failable<Resource> getMe(GanttDiagram gantt, RegexResult arg) {
        if (arg.get("THEY", 0) != null) {
            Resource they = gantt.getThey();
            if (they == null) {
                return Failable.error("Not sure who are you refering to?");
            }
            return Failable.ok(they);
        }
        String resource = arg.get("RESOURCE", 0);
        Resource result = gantt.getResource(resource);
        gantt.setThey(result);
        return Failable.ok(result);
    }

    @Override
    public Collection<? extends SentenceSimple<GanttDiagram>> getSentences() {
        return Arrays.asList(new IsOffDate(), new IsOffDates(), new IsOffDayOfWeek(), new IsOnDate(), new IsOnDates(), new IsOffBeforeDate(), new IsOffAfterDate(), new WorksOn());
    }

    @Override
    public IRegex toRegex() {
        return new RegexOr(new RegexLeaf("THEY", "(she|he|they)"), new RegexLeaf("RESOURCE", "\\{([^{}]+)\\}"));
    }

    public class IsOffDate
    extends SentenceSimple<GanttDiagram> {
        public IsOffDate() {
            super(SubjectResource.this, Verbs.isOff, Words.zeroOrMore("from", "on", "for", "the", "at"), ComplementDate.any());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.addCloseDay(when);
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffDates
    extends SentenceSimple<GanttDiagram> {
        public IsOffDates() {
            super(SubjectResource.this, Verbs.isOff, Words.zeroOrMore("from", "on", "for", "the", "at"), new ComplementIntervals());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            for (Day when : (DaysAsDates)complement) {
                resource.addCloseDay(when);
            }
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffDayOfWeek
    extends SentenceSimple<GanttDiagram> {
        public IsOffDayOfWeek() {
            super(SubjectResource.this, Verbs.isOff, Words.zeroOrMore("from", "on", "for", "the", "at"), new ComplementDayOfWeek());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            resource.addCloseDay((DayOfWeek)((Object)complement));
            return CommandExecutionResult.ok();
        }
    }

    public class IsOnDate
    extends SentenceSimple<GanttDiagram> {
        public IsOnDate() {
            super(SubjectResource.this, Verbs.isOn, Words.zeroOrMore("from", "on", "for", "the", "at"), ComplementDate.any());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.addForceOnDay(when);
            return CommandExecutionResult.ok();
        }
    }

    public class IsOnDates
    extends SentenceSimple<GanttDiagram> {
        public IsOnDates() {
            super(SubjectResource.this, Verbs.isOn, Words.zeroOrMore("from", "on", "for", "the", "at"), new ComplementIntervals());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            for (Day when : (DaysAsDates)complement) {
                resource.addForceOnDay(when);
            }
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffBeforeDate
    extends SentenceSimple<GanttDiagram> {
        public IsOffBeforeDate() {
            super(SubjectResource.this, Verbs.isOff, Words.concat(Words.exactly("before"), Words.zeroOrMore("the")), ComplementDate.any());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.setOffBeforeDate(when);
            return CommandExecutionResult.ok();
        }
    }

    public class IsOffAfterDate
    extends SentenceSimple<GanttDiagram> {
        public IsOffAfterDate() {
            super(SubjectResource.this, Verbs.isOff, Words.concat(Words.exactly("after"), Words.zeroOrMore("the")), ComplementDate.any());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Day when = (Day)complement;
            resource.setOffAfterDate(when);
            return CommandExecutionResult.ok();
        }
    }

    public class WorksOn
    extends SentenceSimple<GanttDiagram> {
        public WorksOn() {
            super(SubjectResource.this, Verbs.worksOn, new ComplementTask());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram gantt, Object subject, Object complement) {
            Resource resource = (Resource)subject;
            Task task = (Task)complement;
            task.addResource(resource, 100);
            return CommandExecutionResult.ok();
        }
    }
}

