// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPErrorRuleBackendOKCode is the HTTP code returned for type ReplaceHTTPErrorRuleBackendOK
const ReplaceHTTPErrorRuleBackendOKCode int = 200

/*
ReplaceHTTPErrorRuleBackendOK HTTP Error Rule replaced

swagger:response replaceHttpErrorRuleBackendOK
*/
type ReplaceHTTPErrorRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleBackendOK creates ReplaceHTTPErrorRuleBackendOK with default headers values
func NewReplaceHTTPErrorRuleBackendOK() *ReplaceHTTPErrorRuleBackendOK {

	return &ReplaceHTTPErrorRuleBackendOK{}
}

// WithPayload adds the payload to the replace Http error rule backend o k response
func (o *ReplaceHTTPErrorRuleBackendOK) WithPayload(payload *models.HTTPErrorRule) *ReplaceHTTPErrorRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule backend o k response
func (o *ReplaceHTTPErrorRuleBackendOK) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleBackendAcceptedCode is the HTTP code returned for type ReplaceHTTPErrorRuleBackendAccepted
const ReplaceHTTPErrorRuleBackendAcceptedCode int = 202

/*
ReplaceHTTPErrorRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpErrorRuleBackendAccepted
*/
type ReplaceHTTPErrorRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleBackendAccepted creates ReplaceHTTPErrorRuleBackendAccepted with default headers values
func NewReplaceHTTPErrorRuleBackendAccepted() *ReplaceHTTPErrorRuleBackendAccepted {

	return &ReplaceHTTPErrorRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http error rule backend accepted response
func (o *ReplaceHTTPErrorRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceHTTPErrorRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http error rule backend accepted response
func (o *ReplaceHTTPErrorRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http error rule backend accepted response
func (o *ReplaceHTTPErrorRuleBackendAccepted) WithPayload(payload *models.HTTPErrorRule) *ReplaceHTTPErrorRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule backend accepted response
func (o *ReplaceHTTPErrorRuleBackendAccepted) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleBackendBadRequestCode is the HTTP code returned for type ReplaceHTTPErrorRuleBackendBadRequest
const ReplaceHTTPErrorRuleBackendBadRequestCode int = 400

/*
ReplaceHTTPErrorRuleBackendBadRequest Bad request

swagger:response replaceHttpErrorRuleBackendBadRequest
*/
type ReplaceHTTPErrorRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleBackendBadRequest creates ReplaceHTTPErrorRuleBackendBadRequest with default headers values
func NewReplaceHTTPErrorRuleBackendBadRequest() *ReplaceHTTPErrorRuleBackendBadRequest {

	return &ReplaceHTTPErrorRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http error rule backend bad request response
func (o *ReplaceHTTPErrorRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http error rule backend bad request response
func (o *ReplaceHTTPErrorRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http error rule backend bad request response
func (o *ReplaceHTTPErrorRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule backend bad request response
func (o *ReplaceHTTPErrorRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPErrorRuleBackendNotFoundCode is the HTTP code returned for type ReplaceHTTPErrorRuleBackendNotFound
const ReplaceHTTPErrorRuleBackendNotFoundCode int = 404

/*
ReplaceHTTPErrorRuleBackendNotFound The specified resource was not found

swagger:response replaceHttpErrorRuleBackendNotFound
*/
type ReplaceHTTPErrorRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleBackendNotFound creates ReplaceHTTPErrorRuleBackendNotFound with default headers values
func NewReplaceHTTPErrorRuleBackendNotFound() *ReplaceHTTPErrorRuleBackendNotFound {

	return &ReplaceHTTPErrorRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http error rule backend not found response
func (o *ReplaceHTTPErrorRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http error rule backend not found response
func (o *ReplaceHTTPErrorRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http error rule backend not found response
func (o *ReplaceHTTPErrorRuleBackendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http error rule backend not found response
func (o *ReplaceHTTPErrorRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPErrorRuleBackendDefault General Error

swagger:response replaceHttpErrorRuleBackendDefault
*/
type ReplaceHTTPErrorRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPErrorRuleBackendDefault creates ReplaceHTTPErrorRuleBackendDefault with default headers values
func NewReplaceHTTPErrorRuleBackendDefault(code int) *ReplaceHTTPErrorRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPErrorRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) WithStatusCode(code int) *ReplaceHTTPErrorRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPErrorRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceHTTPErrorRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP error rule backend default response
func (o *ReplaceHTTPErrorRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPErrorRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
