// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package backend

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetBackendsOKCode is the HTTP code returned for type GetBackendsOK
const GetBackendsOKCode int = 200

/*
GetBackendsOK Successful operation

swagger:response getBackendsOK
*/
type GetBackendsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.Backends `json:"body,omitempty"`
}

// NewGetBackendsOK creates GetBackendsOK with default headers values
func NewGetBackendsOK() *GetBackendsOK {

	return &GetBackendsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get backends o k response
func (o *GetBackendsOK) WithConfigurationVersion(configurationVersion string) *GetBackendsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get backends o k response
func (o *GetBackendsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get backends o k response
func (o *GetBackendsOK) WithPayload(payload models.Backends) *GetBackendsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get backends o k response
func (o *GetBackendsOK) SetPayload(payload models.Backends) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBackendsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.Backends{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetBackendsDefault General Error

swagger:response getBackendsDefault
*/
type GetBackendsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetBackendsDefault creates GetBackendsDefault with default headers values
func NewGetBackendsDefault(code int) *GetBackendsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetBackendsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get backends default response
func (o *GetBackendsDefault) WithStatusCode(code int) *GetBackendsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get backends default response
func (o *GetBackendsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get backends default response
func (o *GetBackendsDefault) WithConfigurationVersion(configurationVersion string) *GetBackendsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get backends default response
func (o *GetBackendsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get backends default response
func (o *GetBackendsDefault) WithPayload(payload *models.Error) *GetBackendsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get backends default response
func (o *GetBackendsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetBackendsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
