/*
 * MyHashTable.h --- implementation of a hash table.
 *
 * Copyright (c) 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:23:24 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	MYHASHTABLE_H
#define	MYHASHTABLE_H

#include	"hash.h"

typedef struct hash_element_t
{
    struct hash_element_t*	next ;
    unsigned int		data ;
    char			key[ 1 ];
} hash_element_t ;

struct hash_table_t ;
#define	NilHashTable	((struct hash_table_t*)0)

#define	dhtNilElement	((hash_element_t *)0)

struct hash_table_t*	dhtCreate         (
    unsigned int	lg_key,
    unsigned long	nb_max_keys,
    unsigned long	max_memory );
unsigned long		myHash_hash_value ( const unsigned char* key );
hash_element_t*		dhtEnterElement   (
    struct hash_table_t*	hash_table,
    unsigned long		hash_value,
    const unsigned char*	key,
    unsigned int		data );
void			dhtDestroy        ( struct hash_table_t* hash_table );
hash_element_t*		dhtLookupElement  (
    struct hash_table_t*	hash_table,
    unsigned long		hash_value,
    const unsigned char*	key );
hash_element_t*		dhtGetFirstElement( struct hash_table_t* hash_table );
hash_element_t*		dhtGetNextElement ( struct hash_table_t* hash_table );
unsigned long		dhtKeyCount       (
    const struct hash_table_t* hash_table );
unsigned long		dhtCollisionCount (
    const struct hash_table_t* hash_table );

unsigned long		myHash_nb_max_elements(
    struct hash_table_t* hash_table );

void			myHash_remove_current_element(
    struct hash_table_t* hash_table );

#endif /* MYHASHTABLE */
