# Spyder Documentation

![Spyder Docs - Documentation for the Scientific Python Development Environment](./doc/_static/images/spyder_readme_banner.png)

*Copyright (c) 2009- Spyder Doc Contributors and others (see [AUTHORS.txt](https://github.com/spyder-ide/spyder-docs/blob/master/AUTHORS.txt))*


[![License](https://img.shields.io/pypi/l/spyder.svg)](./LICENSE.txt)
[![Build](https://github.com/spyder-ide/spyder-docs/actions/workflows/build.yaml/badge.svg)](https://github.com/spyder-ide/spyder-docs/actions/workflows/build.yaml)
[![Check](https://github.com/spyder-ide/spyder-docs/actions/workflows/check.yaml/badge.svg)](https://github.com/spyder-ide/spyder-docs/actions/workflows/check.yaml)
[![Lint](https://github.com/spyder-ide/spyder-docs/actions/workflows/lint.yaml/badge.svg)](https://github.com/spyder-ide/spyder-docs/actions/workflows/lint.yaml)
[![Netlify Status](https://api.netlify.com/api/v1/badges/06f113a8-c699-4171-afc6-db3a3c77d93b/deploy-status)](https://app.netlify.com/sites/spyder-docs-preview/deploys)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)
[![Nox](https://img.shields.io/badge/%F0%9F%A6%8A-Nox-D85E00.svg)](https://github.com/wntrblm/nox)
[![OpenCollective Backers](https://opencollective.com/spyder/backers/badge.svg?color=blue)](https://opencollective.com/spyder)


![Screenshot of documentation index page](./doc/_static/images/index-docs.gif)


<!-- markdownlint-disable -->
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->

- [Overview](#overview)
- [Building and Deploying](#building-and-deploying)
- [Contributing](#contributing)
- [More information](#more-information)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
<!-- markdownlint-restore -->


## Overview

This repository contains the documentation for Spyder, the Scientific Python Development Environment.
You can view the live docs for current and past Spyder versions at [docs.spyder-ide.org](https://docs.spyder-ide.org).

For more information about Spyder itself, please see our [website](https://www.spyder-ide.org/) and the [main repo](https://github.com/spyder-ide/spyder).


## Building and Deploying

The docs are built with [Sphinx](https://www.sphinx-doc.org/) and deployed with GitHub Actions to the [docs.spyder-ide.org](https://docs.spyder-ide.org/) domain.
[Nox](https://nox.thea.codes/) is used to automate setup, building and numerous other project tasks.
The ``master`` branch contains the in-development docs for Spyder 5, while the frozen ``4.x`` and ``3.x`` branches retain the docs for Spyder 4 and Spyder 3.


## Contributing

We welcome your contributions of corrections, additions and enhancements to these docs, as they are very much a work in progress, and we appreciate getting our broad community involved wherever possible.
Its easy to build a local copy in one or two steps with Nox, or you can also just check your changes with our live build previews on PRs.
Simply submit a PR with your changes and we'll be happy to review it; make sure to read our [Contributing Guide](https://github.com/spyder-ide/spyder-docs/blob/master/CONTRIBUTING.md) in mind to ensure the process of getting your revisions integrated goes smoothly.

Thanks for your interest in Spyder and its documentation, and we appreciate your support of the project!


## More information

[Main Website](https://www.spyder-ide.org/)

[Online Documentation](https://docs.spyder-ide.org/)

[Spyder GitHub](https://github.com/spyder-ide/spyder)

[Development Wiki](https://github.com/spyder-ide/spyder/wiki/Dev:-Index)

[Google Group](https://groups.google.com/group/spyderlib)

[@Spyder_IDE on Twitter](https://twitter.com/spyder_ide)

[@SpyderIDE on Facebook](https://www.facebook.com/SpyderIDE/)

[Support Spyder on OpenCollective](https://opencollective.com/spyder/)
