// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/speech/v2/cloud_speech.proto

#include "google/cloud/speech/v2/internal/speech_tracing_stub.h"
#include "google/cloud/internal/async_read_write_stream_tracing.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace speech_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SpeechTracingStub::SpeechTracingStub(std::shared_ptr<SpeechStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncCreateRecognizer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::CreateRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreateRecognizer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateRecognizer(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::CreateRecognizer(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::CreateRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreateRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateRecognizer(context, options, request));
}

StatusOr<google::cloud::speech::v2::ListRecognizersResponse>
SpeechTracingStub::ListRecognizers(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::ListRecognizersRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "ListRecognizers");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListRecognizers(context, options, request));
}

StatusOr<google::cloud::speech::v2::Recognizer>
SpeechTracingStub::GetRecognizer(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::GetRecognizerRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "GetRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetRecognizer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUpdateRecognizer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UpdateRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdateRecognizer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateRecognizer(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UpdateRecognizer(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UpdateRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdateRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateRecognizer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncDeleteRecognizer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::DeleteRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeleteRecognizer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteRecognizer(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::DeleteRecognizer(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::DeleteRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeleteRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteRecognizer(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUndeleteRecognizer(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UndeleteRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeleteRecognizer");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUndeleteRecognizer(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UndeleteRecognizer(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UndeleteRecognizerRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeleteRecognizer");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UndeleteRecognizer(context, options, request));
}

StatusOr<google::cloud::speech::v2::RecognizeResponse>
SpeechTracingStub::Recognize(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::RecognizeRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "Recognize");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->Recognize(context, options, request));
}

std::unique_ptr<AsyncStreamingReadWriteRpc<
    google::cloud::speech::v2::StreamingRecognizeRequest,
    google::cloud::speech::v2::StreamingRecognizeResponse>>
SpeechTracingStub::AsyncStreamingRecognize(
    CompletionQueue const& cq, std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "StreamingRecognize");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto stream =
      child_->AsyncStreamingRecognize(cq, context, std::move(options));
  return std::make_unique<internal::AsyncStreamingReadWriteRpcTracing<
      google::cloud::speech::v2::StreamingRecognizeRequest,
      google::cloud::speech::v2::StreamingRecognizeResponse>>(
      std::move(context), std::move(stream), std::move(span));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncBatchRecognize(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::BatchRecognizeRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "BatchRecognize");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncBatchRecognize(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::BatchRecognize(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::BatchRecognizeRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "BatchRecognize");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->BatchRecognize(context, options, request));
}

StatusOr<google::cloud::speech::v2::Config> SpeechTracingStub::GetConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::GetConfigRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "GetConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetConfig(context, options, request));
}

StatusOr<google::cloud::speech::v2::Config> SpeechTracingStub::UpdateConfig(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::UpdateConfigRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "UpdateConfig");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateConfig(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncCreateCustomClass(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::CreateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreateCustomClass");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateCustomClass(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::CreateCustomClass(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::CreateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateCustomClass(context, options, request));
}

StatusOr<google::cloud::speech::v2::ListCustomClassesResponse>
SpeechTracingStub::ListCustomClasses(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::ListCustomClassesRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "ListCustomClasses");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListCustomClasses(context, options, request));
}

StatusOr<google::cloud::speech::v2::CustomClass>
SpeechTracingStub::GetCustomClass(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::GetCustomClassRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "GetCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetCustomClass(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUpdateCustomClass(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UpdateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdateCustomClass");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdateCustomClass(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UpdateCustomClass(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UpdateCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdateCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateCustomClass(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncDeleteCustomClass(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::DeleteCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeleteCustomClass");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteCustomClass(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::DeleteCustomClass(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::DeleteCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeleteCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->DeleteCustomClass(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUndeleteCustomClass(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UndeleteCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeleteCustomClass");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncUndeleteCustomClass(cq, context, std::move(options),
                                            request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UndeleteCustomClass(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UndeleteCustomClassRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeleteCustomClass");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UndeleteCustomClass(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncCreatePhraseSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::CreatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreatePhraseSet");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreatePhraseSet(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::CreatePhraseSet(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::CreatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "CreatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreatePhraseSet(context, options, request));
}

StatusOr<google::cloud::speech::v2::ListPhraseSetsResponse>
SpeechTracingStub::ListPhraseSets(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::ListPhraseSetsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "ListPhraseSets");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListPhraseSets(context, options, request));
}

StatusOr<google::cloud::speech::v2::PhraseSet> SpeechTracingStub::GetPhraseSet(
    grpc::ClientContext& context, Options const& options,
    google::cloud::speech::v2::GetPhraseSetRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.cloud.speech.v2.Speech", "GetPhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetPhraseSet(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUpdatePhraseSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UpdatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdatePhraseSet");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUpdatePhraseSet(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UpdatePhraseSet(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UpdatePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UpdatePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdatePhraseSet(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncDeletePhraseSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::DeletePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeletePhraseSet");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeletePhraseSet(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::DeletePhraseSet(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::DeletePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "DeletePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeletePhraseSet(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncUndeletePhraseSet(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::speech::v2::UndeletePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeletePhraseSet");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncUndeletePhraseSet(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation> SpeechTracingStub::UndeletePhraseSet(
    grpc::ClientContext& context, Options options,
    google::cloud::speech::v2::UndeletePhraseSetRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.speech.v2.Speech",
                                     "UndeletePhraseSet");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UndeletePhraseSet(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
SpeechTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> SpeechTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<SpeechStub> MakeSpeechTracingStub(
    std::shared_ptr<SpeechStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<SpeechTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace speech_v2_internal
}  // namespace cloud
}  // namespace google
