// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/developerconnect/v1/developer_connect.proto

#include "google/cloud/developerconnect/v1/internal/developer_connect_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/developerconnect/v1/developer_connect.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace developerconnect_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DeveloperConnectMetadata::DeveloperConnectMetadata(
    std::shared_ptr<DeveloperConnectStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::developerconnect::v1::ListConnectionsResponse>
DeveloperConnectMetadata::ListConnections(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListConnectionsRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListConnections(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::Connection>
DeveloperConnectMetadata::GetConnection(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetConnectionRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncCreateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateConnection(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectMetadata::CreateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateConnectionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncUpdateConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("connection.name=",
                           internal::UrlEncode(request.connection().name())));
  return child_->AsyncUpdateConnection(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectMetadata::UpdateConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::UpdateConnectionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("connection.name=",
                           internal::UrlEncode(request.connection().name())));
  return child_->UpdateConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncDeleteConnection(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteConnection(cq, std::move(context),
                                       std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectMetadata::DeleteConnection(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteConnectionRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteConnection(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncCreateGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->AsyncCreateGitRepositoryLink(cq, std::move(context),
                                              std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectMetadata::CreateGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::CreateGitRepositoryLinkRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateGitRepositoryLink(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncDeleteGitRepositoryLink(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncDeleteGitRepositoryLink(cq, std::move(context),
                                              std::move(options), request);
}

StatusOr<google::longrunning::Operation>
DeveloperConnectMetadata::DeleteGitRepositoryLink(
    grpc::ClientContext& context, Options options,
    google::cloud::developerconnect::v1::DeleteGitRepositoryLinkRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteGitRepositoryLink(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::ListGitRepositoryLinksResponse>
DeveloperConnectMetadata::ListGitRepositoryLinks(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::ListGitRepositoryLinksRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListGitRepositoryLinks(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::GitRepositoryLink>
DeveloperConnectMetadata::GetGitRepositoryLink(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::GetGitRepositoryLinkRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetGitRepositoryLink(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadWriteTokenResponse>
DeveloperConnectMetadata::FetchReadWriteToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadWriteTokenRequest const&
        request) {
  SetMetadata(context, options,
              absl::StrCat("git_repository_link=",
                           internal::UrlEncode(request.git_repository_link())));
  return child_->FetchReadWriteToken(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchReadTokenResponse>
DeveloperConnectMetadata::FetchReadToken(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchReadTokenRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("git_repository_link=",
                           internal::UrlEncode(request.git_repository_link())));
  return child_->FetchReadToken(context, options, request);
}

StatusOr<
    google::cloud::developerconnect::v1::FetchLinkableGitRepositoriesResponse>
DeveloperConnectMetadata::FetchLinkableGitRepositories(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::
        FetchLinkableGitRepositoriesRequest const& request) {
  SetMetadata(
      context, options,
      absl::StrCat("connection=", internal::UrlEncode(request.connection())));
  return child_->FetchLinkableGitRepositories(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitHubInstallationsResponse>
DeveloperConnectMetadata::FetchGitHubInstallations(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitHubInstallationsRequest const&
        request) {
  SetMetadata(
      context, options,
      absl::StrCat("connection=", internal::UrlEncode(request.connection())));
  return child_->FetchGitHubInstallations(context, options, request);
}

StatusOr<google::cloud::developerconnect::v1::FetchGitRefsResponse>
DeveloperConnectMetadata::FetchGitRefs(
    grpc::ClientContext& context, Options const& options,
    google::cloud::developerconnect::v1::FetchGitRefsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("git_repository_link=",
                           internal::UrlEncode(request.git_repository_link())));
  return child_->FetchGitRefs(context, options, request);
}

future<StatusOr<google::longrunning::Operation>>
DeveloperConnectMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncGetOperation(cq, std::move(context), std::move(options),
                                   request);
}

future<Status> DeveloperConnectMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  SetMetadata(*context, *options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->AsyncCancelOperation(cq, std::move(context),
                                      std::move(options), request);
}

void DeveloperConnectMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options,
                                           std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void DeveloperConnectMetadata::SetMetadata(grpc::ClientContext& context,
                                           Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace developerconnect_v1_internal
}  // namespace cloud
}  // namespace google
