// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/subnetworks/v1/subnetworks.proto

#include "google/cloud/compute/subnetworks/v1/internal/subnetworks_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_subnetworks_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SubnetworksRestMetadata::SubnetworksRestMetadata(
    std::shared_ptr<SubnetworksRestStub> child, std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::cpp::compute::v1::SubnetworkAggregatedList>
SubnetworksRestMetadata::AggregatedListSubnetworks(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::
        AggregatedListSubnetworksRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->AggregatedListSubnetworks(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncDeleteSubnetwork(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::subnetworks::v1::DeleteSubnetworkRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteSubnetwork(cq, std::move(rest_context),
                                       std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SubnetworksRestMetadata::DeleteSubnetwork(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::DeleteSubnetworkRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->DeleteSubnetwork(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncExpandIpCidrRange(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::subnetworks::v1::
        ExpandIpCidrRangeRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncExpandIpCidrRange(cq, std::move(rest_context),
                                        std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SubnetworksRestMetadata::ExpandIpCidrRange(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::
        ExpandIpCidrRangeRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->ExpandIpCidrRange(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Subnetwork>
SubnetworksRestMetadata::GetSubnetwork(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::GetSubnetworkRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetSubnetwork(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SubnetworksRestMetadata::GetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::GetIamPolicyRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetIamPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncInsertSubnetwork(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::subnetworks::v1::InsertSubnetworkRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertSubnetwork(cq, std::move(rest_context),
                                       std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SubnetworksRestMetadata::InsertSubnetwork(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::InsertSubnetworkRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->InsertSubnetwork(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::SubnetworkList>
SubnetworksRestMetadata::ListSubnetworks(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::ListSubnetworksRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->ListSubnetworks(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::UsableSubnetworksAggregatedList>
SubnetworksRestMetadata::ListUsable(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::ListUsableRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->ListUsable(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncPatchSubnetwork(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::subnetworks::v1::PatchSubnetworkRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchSubnetwork(cq, std::move(rest_context),
                                      std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SubnetworksRestMetadata::PatchSubnetwork(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::PatchSubnetworkRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->PatchSubnetwork(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SubnetworksRestMetadata::SetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::SetIamPolicyRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->SetIamPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncSetPrivateIpGoogleAccess(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::subnetworks::v1::
        SetPrivateIpGoogleAccessRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetPrivateIpGoogleAccess(cq, std::move(rest_context),
                                               std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SubnetworksRestMetadata::SetPrivateIpGoogleAccess(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::
        SetPrivateIpGoogleAccessRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->SetPrivateIpGoogleAccess(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
SubnetworksRestMetadata::TestIamPermissions(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::subnetworks::v1::
        TestIamPermissionsRequest const& request) {
  SetMetadata(rest_context, options);
  return child_->TestIamPermissions(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SubnetworksRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> SubnetworksRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void SubnetworksRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_subnetworks_v1_internal
}  // namespace cloud
}  // namespace google
