// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/model_service.proto

#include "google/cloud/aiplatform/v1/internal/model_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ModelServiceTracingConnection::ModelServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::ModelServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>
ModelServiceTracingConnection::UploadModel(
    google::cloud::aiplatform::v1::UploadModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::UploadModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UploadModel(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::UploadModel(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UploadModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::UploadModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UploadModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::UploadModelResponse>>
ModelServiceTracingConnection::UploadModel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::UploadModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UploadModel(operation));
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceTracingConnection::GetModel(
    google::cloud::aiplatform::v1::GetModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::GetModel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetModel(request));
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceTracingConnection::ListModels(
    google::cloud::aiplatform::v1::ListModelsRequest request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::ListModels");
  internal::OTelScope scope(span);
  auto sr = child_->ListModels(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::aiplatform::v1::Model>(
      std::move(span), std::move(sr));
}

StreamRange<google::cloud::aiplatform::v1::Model>
ModelServiceTracingConnection::ListModelVersions(
    google::cloud::aiplatform::v1::ListModelVersionsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::ListModelVersions");
  internal::OTelScope scope(span);
  auto sr = child_->ListModelVersions(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::aiplatform::v1::Model>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceTracingConnection::UpdateModel(
    google::cloud::aiplatform::v1::UpdateModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::UpdateModel");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateModel(request));
}

future<
    StatusOr<google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>
ModelServiceTracingConnection::UpdateExplanationDataset(
    google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::UpdateExplanationDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateExplanationDataset(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::UpdateExplanationDataset(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateExplanationDatasetRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::UpdateExplanationDataset");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->UpdateExplanationDataset(NoAwaitTag{}, request));
}

future<
    StatusOr<google::cloud::aiplatform::v1::UpdateExplanationDatasetResponse>>
ModelServiceTracingConnection::UpdateExplanationDataset(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::UpdateExplanationDataset");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateExplanationDataset(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceTracingConnection::DeleteModel(
    google::cloud::aiplatform::v1::DeleteModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::DeleteModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteModel(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::DeleteModel(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::DeleteModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceTracingConnection::DeleteModel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::DeleteModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteModel(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceTracingConnection::DeleteModelVersion(
    google::cloud::aiplatform::v1::DeleteModelVersionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::DeleteModelVersion");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteModelVersion(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::DeleteModelVersion(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteModelVersionRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::DeleteModelVersion");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteModelVersion(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
ModelServiceTracingConnection::DeleteModelVersion(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::DeleteModelVersion");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteModelVersion(operation));
}

StatusOr<google::cloud::aiplatform::v1::Model>
ModelServiceTracingConnection::MergeVersionAliases(
    google::cloud::aiplatform::v1::MergeVersionAliasesRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::MergeVersionAliases");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->MergeVersionAliases(request));
}

future<StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>
ModelServiceTracingConnection::ExportModel(
    google::cloud::aiplatform::v1::ExportModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::ExportModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportModel(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::ExportModel(
    NoAwaitTag,
    google::cloud::aiplatform::v1::ExportModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::ExportModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ExportModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::ExportModelResponse>>
ModelServiceTracingConnection::ExportModel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::ExportModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ExportModel(operation));
}

future<StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>
ModelServiceTracingConnection::CopyModel(
    google::cloud::aiplatform::v1::CopyModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::CopyModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CopyModel(request));
}

StatusOr<google::longrunning::Operation>
ModelServiceTracingConnection::CopyModel(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CopyModelRequest const& request) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::CopyModel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CopyModel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::aiplatform::v1::CopyModelResponse>>
ModelServiceTracingConnection::CopyModel(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("aiplatform_v1::ModelServiceConnection::CopyModel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CopyModel(operation));
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceTracingConnection::ImportModelEvaluation(
    google::cloud::aiplatform::v1::ImportModelEvaluationRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::ImportModelEvaluation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ImportModelEvaluation(request));
}

StatusOr<
    google::cloud::aiplatform::v1::BatchImportModelEvaluationSlicesResponse>
ModelServiceTracingConnection::BatchImportModelEvaluationSlices(
    google::cloud::aiplatform::v1::
        BatchImportModelEvaluationSlicesRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::"
      "BatchImportModelEvaluationSlices");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->BatchImportModelEvaluationSlices(request));
}

StatusOr<google::cloud::aiplatform::v1::BatchImportEvaluatedAnnotationsResponse>
ModelServiceTracingConnection::BatchImportEvaluatedAnnotations(
    google::cloud::aiplatform::v1::BatchImportEvaluatedAnnotationsRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::BatchImportEvaluatedAnnotations");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->BatchImportEvaluatedAnnotations(request));
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceTracingConnection::GetModelEvaluation(
    google::cloud::aiplatform::v1::GetModelEvaluationRequest const& request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::GetModelEvaluation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetModelEvaluation(request));
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluation>
ModelServiceTracingConnection::ListModelEvaluations(
    google::cloud::aiplatform::v1::ListModelEvaluationsRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::ListModelEvaluations");
  internal::OTelScope scope(span);
  auto sr = child_->ListModelEvaluations(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::ModelEvaluation>(std::move(span),
                                                      std::move(sr));
}

StatusOr<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceTracingConnection::GetModelEvaluationSlice(
    google::cloud::aiplatform::v1::GetModelEvaluationSliceRequest const&
        request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::GetModelEvaluationSlice");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetModelEvaluationSlice(request));
}

StreamRange<google::cloud::aiplatform::v1::ModelEvaluationSlice>
ModelServiceTracingConnection::ListModelEvaluationSlices(
    google::cloud::aiplatform::v1::ListModelEvaluationSlicesRequest request) {
  auto span = internal::MakeSpan(
      "aiplatform_v1::ModelServiceConnection::ListModelEvaluationSlices");
  internal::OTelScope scope(span);
  auto sr = child_->ListModelEvaluationSlices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::aiplatform::v1::ModelEvaluationSlice>(std::move(span),
                                                           std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<aiplatform_v1::ModelServiceConnection>
MakeModelServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::ModelServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<ModelServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google
