// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_MOCKS_MOCK_VMWARE_ENGINE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_MOCKS_MOCK_VMWARE_ENGINE_CONNECTION_H

#include "google/cloud/vmwareengine/v1/vmware_engine_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace vmwareengine_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `VmwareEngineConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `VmwareEngineClient`. To do so,
 * construct an object of type `VmwareEngineClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockVmwareEngineConnection
    : public vmwareengine_v1::VmwareEngineConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>),
      ListPrivateClouds,
      (google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>, GetPrivateCloud,
      (google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreatePrivateCloud(Matcher<google::cloud::vmwareengine::v1::CreatePrivateCloudRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              CreatePrivateCloud,
              (google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreatePrivateCloud(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, CreatePrivateCloud,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreatePrivateCloud(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              CreatePrivateCloud,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdatePrivateCloud(Matcher<google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              UpdatePrivateCloud,
              (google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdatePrivateCloud(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, UpdatePrivateCloud,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdatePrivateCloud(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              UpdatePrivateCloud,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeletePrivateCloud(Matcher<google::cloud::vmwareengine::v1::DeletePrivateCloudRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              DeletePrivateCloud,
              (google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeletePrivateCloud(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, DeletePrivateCloud,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeletePrivateCloud(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              DeletePrivateCloud,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UndeletePrivateCloud(Matcher<google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
      UndeletePrivateCloud,
      (google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UndeletePrivateCloud(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UndeletePrivateCloud,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UndeletePrivateCloud(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              UndeletePrivateCloud,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::Cluster>),
              ListClusters,
              (google::cloud::vmwareengine::v1::ListClustersRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::Cluster>, GetCluster,
      (google::cloud::vmwareengine::v1::GetClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateCluster(Matcher<google::cloud::vmwareengine::v1::CreateClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>, CreateCluster,
      (google::cloud::vmwareengine::v1::CreateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateCluster,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, CreateCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>,
              CreateCluster, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateCluster(Matcher<google::cloud::vmwareengine::v1::UpdateClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>, UpdateCluster,
      (google::cloud::vmwareengine::v1::UpdateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateCluster,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>,
              UpdateCluster, (google::longrunning::Operation const& operation),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteCluster(Matcher<google::cloud::vmwareengine::v1::DeleteClusterRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteCluster,
      (google::cloud::vmwareengine::v1::DeleteClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteCluster(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteCluster,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteClusterRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DeleteCluster(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteCluster, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::Node>), ListNodes,
              (google::cloud::vmwareengine::v1::ListNodesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::vmwareengine::v1::Node>, GetNode,
              (google::cloud::vmwareengine::v1::GetNodeRequest const& request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>),
      ListExternalAddresses,
      (google::cloud::vmwareengine::v1::ListExternalAddressesRequest request),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>),
              FetchNetworkPolicyExternalAddresses,
              (google::cloud::vmwareengine::v1::
                   FetchNetworkPolicyExternalAddressesRequest request),
              (override));

  MOCK_METHOD(StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>,
              GetExternalAddress,
              (google::cloud::vmwareengine::v1::GetExternalAddressRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateExternalAddress(Matcher<google::cloud::vmwareengine::v1::CreateExternalAddressRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>,
      CreateExternalAddress,
      (google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateExternalAddress(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateExternalAddress,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateExternalAddress(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>,
      CreateExternalAddress, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateExternalAddress(Matcher<google::cloud::vmwareengine::v1::UpdateExternalAddressRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>,
      UpdateExternalAddress,
      (google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateExternalAddress(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateExternalAddress,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateExternalAddress(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>,
      UpdateExternalAddress, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteExternalAddress(Matcher<google::cloud::vmwareengine::v1::DeleteExternalAddressRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteExternalAddress,
      (google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteExternalAddress(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteExternalAddress,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteExternalAddress(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteExternalAddress, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::Subnet>),
              ListSubnets,
              (google::cloud::vmwareengine::v1::ListSubnetsRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::Subnet>, GetSubnet,
      (google::cloud::vmwareengine::v1::GetSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateSubnet(Matcher<google::cloud::vmwareengine::v1::UpdateSubnetRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>, UpdateSubnet,
      (google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateSubnet(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateSubnet,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, UpdateSubnet(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>,
              UpdateSubnet, (google::longrunning::Operation const& operation),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::ExternalAccessRule>),
      ListExternalAccessRules,
      (google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>,
      GetExternalAccessRule,
      (google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateExternalAccessRule(Matcher<google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>,
      CreateExternalAccessRule,
      (google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateExternalAccessRule(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateExternalAccessRule,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateExternalAccessRule(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>,
      CreateExternalAccessRule,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateExternalAccessRule(Matcher<google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>,
      UpdateExternalAccessRule,
      (google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateExternalAccessRule(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateExternalAccessRule,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateExternalAccessRule(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>,
      UpdateExternalAccessRule,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteExternalAccessRule(Matcher<google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteExternalAccessRule,
      (google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteExternalAccessRule(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteExternalAccessRule,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteExternalAccessRule(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteExternalAccessRule,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::LoggingServer>),
      ListLoggingServers,
      (google::cloud::vmwareengine::v1::ListLoggingServersRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::LoggingServer>,
      GetLoggingServer,
      (google::cloud::vmwareengine::v1::GetLoggingServerRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLoggingServer(Matcher<google::cloud::vmwareengine::v1::CreateLoggingServerRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>,
      CreateLoggingServer,
      (google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateLoggingServer(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateLoggingServer,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateLoggingServer(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>,
              CreateLoggingServer,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLoggingServer(Matcher<google::cloud::vmwareengine::v1::UpdateLoggingServerRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>,
      UpdateLoggingServer,
      (google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateLoggingServer(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateLoggingServer,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateLoggingServer(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>,
              UpdateLoggingServer,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLoggingServer(Matcher<google::cloud::vmwareengine::v1::DeleteLoggingServerRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteLoggingServer,
      (google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteLoggingServer(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteLoggingServer,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteLoggingServer(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteLoggingServer, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::NodeType>),
              ListNodeTypes,
              (google::cloud::vmwareengine::v1::ListNodeTypesRequest request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::NodeType>, GetNodeType,
      (google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request),
      (override));

  MOCK_METHOD(StatusOr<google::cloud::vmwareengine::v1::Credentials>,
              ShowNsxCredentials,
              (google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const&
                   request),
              (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::Credentials>,
      ShowVcenterCredentials,
      (google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ResetNsxCredentials(Matcher<google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
      ResetNsxCredentials,
      (google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ResetNsxCredentials(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ResetNsxCredentials,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ResetNsxCredentials(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              ResetNsxCredentials,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ResetVcenterCredentials(Matcher<google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
      ResetVcenterCredentials,
      (google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, ResetVcenterCredentials(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, ResetVcenterCredentials,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// ResetVcenterCredentials(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>,
              ResetVcenterCredentials,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>,
      GetDnsForwarding,
      (google::cloud::vmwareengine::v1::GetDnsForwardingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateDnsForwarding(Matcher<google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>,
      UpdateDnsForwarding,
      (google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateDnsForwarding(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateDnsForwarding,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateDnsForwarding(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>,
              UpdateDnsForwarding,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>,
              GetNetworkPeering,
              (google::cloud::vmwareengine::v1::GetNetworkPeeringRequest const&
                   request),
              (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::NetworkPeering>),
      ListNetworkPeerings,
      (google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateNetworkPeering(Matcher<google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>,
      CreateNetworkPeering,
      (google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateNetworkPeering(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateNetworkPeering,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateNetworkPeering(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>,
              CreateNetworkPeering,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteNetworkPeering(Matcher<google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteNetworkPeering,
      (google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteNetworkPeering(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteNetworkPeering,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteNetworkPeering(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteNetworkPeering, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateNetworkPeering(Matcher<google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>,
      UpdateNetworkPeering,
      (google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateNetworkPeering(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateNetworkPeering,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateNetworkPeering(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>,
              UpdateNetworkPeering,
              (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>),
      ListPeeringRoutes,
      (google::cloud::vmwareengine::v1::ListPeeringRoutesRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateHcxActivationKey(Matcher<google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>,
      CreateHcxActivationKey,
      (google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateHcxActivationKey(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateHcxActivationKey,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateHcxActivationKey(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>,
      CreateHcxActivationKey, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>),
      ListHcxActivationKeys,
      (google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>,
      GetHcxActivationKey,
      (google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const&
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>,
      GetNetworkPolicy,
      (google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>),
      ListNetworkPolicies,
      (google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateNetworkPolicy(Matcher<google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>,
      CreateNetworkPolicy,
      (google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateNetworkPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateNetworkPolicy,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateNetworkPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>,
              CreateNetworkPolicy,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateNetworkPolicy(Matcher<google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>,
      UpdateNetworkPolicy,
      (google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateNetworkPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateNetworkPolicy,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateNetworkPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>,
              UpdateNetworkPolicy,
              (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteNetworkPolicy(Matcher<google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteNetworkPolicy,
      (google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteNetworkPolicy(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteNetworkPolicy,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteNetworkPolicy(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteNetworkPolicy, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>),
      ListManagementDnsZoneBindings,
      (google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsRequest
           request),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>,
      GetManagementDnsZoneBinding,
      (google::cloud::vmwareengine::v1::
           GetManagementDnsZoneBindingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateManagementDnsZoneBinding(Matcher<google::cloud::vmwareengine::v1::CreateManagementDnsZoneBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      CreateManagementDnsZoneBinding,
      (google::cloud::vmwareengine::v1::
           CreateManagementDnsZoneBindingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateManagementDnsZoneBinding(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              CreateManagementDnsZoneBinding,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::
                   CreateManagementDnsZoneBindingRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateManagementDnsZoneBinding(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      CreateManagementDnsZoneBinding,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateManagementDnsZoneBinding(Matcher<google::cloud::vmwareengine::v1::UpdateManagementDnsZoneBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      UpdateManagementDnsZoneBinding,
      (google::cloud::vmwareengine::v1::
           UpdateManagementDnsZoneBindingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateManagementDnsZoneBinding(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              UpdateManagementDnsZoneBinding,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::
                   UpdateManagementDnsZoneBindingRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateManagementDnsZoneBinding(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      UpdateManagementDnsZoneBinding,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteManagementDnsZoneBinding(Matcher<google::cloud::vmwareengine::v1::DeleteManagementDnsZoneBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteManagementDnsZoneBinding,
      (google::cloud::vmwareengine::v1::
           DeleteManagementDnsZoneBindingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteManagementDnsZoneBinding(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              DeleteManagementDnsZoneBinding,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::
                   DeleteManagementDnsZoneBindingRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteManagementDnsZoneBinding(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteManagementDnsZoneBinding,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RepairManagementDnsZoneBinding(Matcher<google::cloud::vmwareengine::v1::RepairManagementDnsZoneBindingRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      RepairManagementDnsZoneBinding,
      (google::cloud::vmwareengine::v1::
           RepairManagementDnsZoneBindingRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RepairManagementDnsZoneBinding(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>,
              RepairManagementDnsZoneBinding,
              (NoAwaitTag,
               google::cloud::vmwareengine::v1::
                   RepairManagementDnsZoneBindingRequest const& request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RepairManagementDnsZoneBinding(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>,
      RepairManagementDnsZoneBinding,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateVmwareEngineNetwork(Matcher<google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>,
      CreateVmwareEngineNetwork,
      (google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreateVmwareEngineNetwork(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreateVmwareEngineNetwork,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreateVmwareEngineNetwork(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>,
      CreateVmwareEngineNetwork,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateVmwareEngineNetwork(Matcher<google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>,
      UpdateVmwareEngineNetwork,
      (google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdateVmwareEngineNetwork(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdateVmwareEngineNetwork,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdateVmwareEngineNetwork(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>,
      UpdateVmwareEngineNetwork,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteVmwareEngineNetwork(Matcher<google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteVmwareEngineNetwork,
      (google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeleteVmwareEngineNetwork(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeleteVmwareEngineNetwork,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeleteVmwareEngineNetwork(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeleteVmwareEngineNetwork,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>,
      GetVmwareEngineNetwork,
      (google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>),
      ListVmwareEngineNetworks,
      (google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreatePrivateConnection(Matcher<google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>,
      CreatePrivateConnection,
      (google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, CreatePrivateConnection(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, CreatePrivateConnection,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// CreatePrivateConnection(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>,
      CreatePrivateConnection,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>,
      GetPrivateConnection,
      (google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const&
           request),
      (override));

  MOCK_METHOD(
      (StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>),
      ListPrivateConnections,
      (google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdatePrivateConnection(Matcher<google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>,
      UpdatePrivateConnection,
      (google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, UpdatePrivateConnection(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, UpdatePrivateConnection,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// UpdatePrivateConnection(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>,
      UpdatePrivateConnection,
      (google::longrunning::Operation const& operation), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeletePrivateConnection(Matcher<google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeletePrivateConnection,
      (google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DeletePrivateConnection(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DeletePrivateConnection,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DeletePrivateConnection(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>,
      DeletePrivateConnection,
      (google::longrunning::Operation const& operation), (override));

  MOCK_METHOD((StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>),
              ListPrivateConnectionPeeringRoutes,
              (google::cloud::vmwareengine::v1::
                   ListPrivateConnectionPeeringRoutesRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// GrantDnsBindPermission(Matcher<google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>,
      GrantDnsBindPermission,
      (google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, GrantDnsBindPermission(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, GrantDnsBindPermission,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// GrantDnsBindPermission(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>,
      GrantDnsBindPermission, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>,
      GetDnsBindPermission,
      (google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RevokeDnsBindPermission(Matcher<google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>,
      RevokeDnsBindPermission,
      (google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, RevokeDnsBindPermission(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, RevokeDnsBindPermission,
      (NoAwaitTag,
       google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// RevokeDnsBindPermission(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>,
      RevokeDnsBindPermission,
      (google::longrunning::Operation const& operation), (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VMWAREENGINE_V1_MOCKS_MOCK_VMWARE_ENGINE_CONNECTION_H
