// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/videointelligence/v1/video_intelligence.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEOINTELLIGENCE_V1_VIDEO_INTELLIGENCE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEOINTELLIGENCE_V1_VIDEO_INTELLIGENCE_CLIENT_H

#include "google/cloud/videointelligence/v1/video_intelligence_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace videointelligence_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service that implements the Video Intelligence API.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class VideoIntelligenceServiceClient {
 public:
  explicit VideoIntelligenceServiceClient(
      std::shared_ptr<VideoIntelligenceServiceConnection> connection,
      Options opts = {});
  ~VideoIntelligenceServiceClient();

  ///@{
  /// @name Copy and move support
  VideoIntelligenceServiceClient(VideoIntelligenceServiceClient const&) =
      default;
  VideoIntelligenceServiceClient& operator=(
      VideoIntelligenceServiceClient const&) = default;
  VideoIntelligenceServiceClient(VideoIntelligenceServiceClient&&) = default;
  VideoIntelligenceServiceClient& operator=(VideoIntelligenceServiceClient&&) =
      default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(VideoIntelligenceServiceClient const& a,
                         VideoIntelligenceServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(VideoIntelligenceServiceClient const& a,
                         VideoIntelligenceServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Performs asynchronous video annotation. Progress and results can be
  /// retrieved through the `google.longrunning.Operations` interface.
  /// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
  /// `Operation.response` contains `AnnotateVideoResponse` (results).
  ///
  /// @param input_uri  Input video location. Currently, only
  ///  [Cloud Storage](https://cloud.google.com/storage/) URIs are
  ///  supported. URIs must be specified in the following format:
  ///  `gs://bucket-id/object-id` (other URI formats return
  ///  [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
  ///  more information, see [Request
  ///  URIs](https://cloud.google.com/storage/docs/request-endpoints). To identify
  ///  multiple videos, a video URI may include wildcards in the `object-id`.
  ///  Supported wildcards: '*' to match 0 or more characters;
  ///  '?' to match 1 character. If unset, the input video should be embedded
  ///  in the request as `input_content`. If set, `input_content` must be unset.
  /// @param features  Required. Requested video annotation features.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.videointelligence.v1.AnnotateVideoResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.videointelligence.v1.AnnotateVideoRequest]: @googleapis_reference_link{google/cloud/videointelligence/v1/video_intelligence.proto#L60}
  /// [google.cloud.videointelligence.v1.AnnotateVideoResponse]: @googleapis_reference_link{google/cloud/videointelligence/v1/video_intelligence.proto#L602}
  ///
  // clang-format on
  future<StatusOr<google::cloud::videointelligence::v1::AnnotateVideoResponse>>
  AnnotateVideo(
      std::string const& input_uri,
      std::vector<google::cloud::videointelligence::v1::Feature> const&
          features,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AnnotateVideo
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> AnnotateVideo(
      NoAwaitTag, std::string const& input_uri,
      std::vector<google::cloud::videointelligence::v1::Feature> const&
          features,
      Options opts = {});

  // clang-format off
  ///
  /// Performs asynchronous video annotation. Progress and results can be
  /// retrieved through the `google.longrunning.Operations` interface.
  /// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
  /// `Operation.response` contains `AnnotateVideoResponse` (results).
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.videointelligence.v1.AnnotateVideoRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.videointelligence.v1.AnnotateVideoResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.videointelligence.v1.AnnotateVideoRequest]: @googleapis_reference_link{google/cloud/videointelligence/v1/video_intelligence.proto#L60}
  /// [google.cloud.videointelligence.v1.AnnotateVideoResponse]: @googleapis_reference_link{google/cloud/videointelligence/v1/video_intelligence.proto#L602}
  ///
  // clang-format on
  future<StatusOr<google::cloud::videointelligence::v1::AnnotateVideoResponse>>
  AnnotateVideo(
      google::cloud::videointelligence::v1::AnnotateVideoRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AnnotateVideo
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> AnnotateVideo(
      NoAwaitTag,
      google::cloud::videointelligence::v1::AnnotateVideoRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief AnnotateVideo
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::videointelligence::v1::AnnotateVideoResponse>>
  AnnotateVideo(google::longrunning::Operation const& operation,
                Options opts = {});

 private:
  std::shared_ptr<VideoIntelligenceServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace videointelligence_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_VIDEOINTELLIGENCE_V1_VIDEO_INTELLIGENCE_CLIENT_H
