// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/video/transcoder/v1/services.proto

#include "google/cloud/video/transcoder/v1/transcoder_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace video_transcoder_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TranscoderServiceClient::TranscoderServiceClient(
    std::shared_ptr<TranscoderServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TranscoderServiceClient::~TranscoderServiceClient() = default;

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::CreateJob(
    std::string const& parent,
    google::cloud::video::transcoder::v1::Job const& job, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::CreateJobRequest request;
  request.set_parent(parent);
  *request.mutable_job() = job;
  return connection_->CreateJob(request);
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::CreateJob(
    google::cloud::video::transcoder::v1::CreateJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateJob(request);
}

StreamRange<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::ListJobs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::ListJobsRequest request;
  request.set_parent(parent);
  return connection_->ListJobs(request);
}

StreamRange<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::ListJobs(
    google::cloud::video::transcoder::v1::ListJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListJobs(std::move(request));
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::GetJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::GetJobRequest request;
  request.set_name(name);
  return connection_->GetJob(request);
}

StatusOr<google::cloud::video::transcoder::v1::Job>
TranscoderServiceClient::GetJob(
    google::cloud::video::transcoder::v1::GetJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJob(request);
}

Status TranscoderServiceClient::DeleteJob(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::DeleteJobRequest request;
  request.set_name(name);
  return connection_->DeleteJob(request);
}

Status TranscoderServiceClient::DeleteJob(
    google::cloud::video::transcoder::v1::DeleteJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJob(request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::CreateJobTemplate(
    std::string const& parent,
    google::cloud::video::transcoder::v1::JobTemplate const& job_template,
    std::string const& job_template_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::CreateJobTemplateRequest request;
  request.set_parent(parent);
  *request.mutable_job_template() = job_template;
  request.set_job_template_id(job_template_id);
  return connection_->CreateJobTemplate(request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::CreateJobTemplate(
    google::cloud::video::transcoder::v1::CreateJobTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateJobTemplate(request);
}

StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::ListJobTemplates(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::ListJobTemplatesRequest request;
  request.set_parent(parent);
  return connection_->ListJobTemplates(request);
}

StreamRange<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::ListJobTemplates(
    google::cloud::video::transcoder::v1::ListJobTemplatesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListJobTemplates(std::move(request));
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::GetJobTemplate(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::GetJobTemplateRequest request;
  request.set_name(name);
  return connection_->GetJobTemplate(request);
}

StatusOr<google::cloud::video::transcoder::v1::JobTemplate>
TranscoderServiceClient::GetJobTemplate(
    google::cloud::video::transcoder::v1::GetJobTemplateRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetJobTemplate(request);
}

Status TranscoderServiceClient::DeleteJobTemplate(std::string const& name,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::video::transcoder::v1::DeleteJobTemplateRequest request;
  request.set_name(name);
  return connection_->DeleteJobTemplate(request);
}

Status TranscoderServiceClient::DeleteJobTemplate(
    google::cloud::video::transcoder::v1::DeleteJobTemplateRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteJobTemplate(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace video_transcoder_v1
}  // namespace cloud
}  // namespace google
